/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.google.common.collect.Lists;
import com.mimvista.dicom.devices.dump.gui.DumpMenuItemHandler;
import com.mimvista.dicom.devices.dump.gui.DumpPopupMenu;
import com.mimvista.gui.util.MIMSwingUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TableCopyHandler {
    private JTable jtable;
    private DumpPopupMenu menu = new DumpPopupMenu();
    List<DumpMenuItemHandler> menuItemHandlerList = new ArrayList<DumpMenuItemHandler>();

    public TableCopyHandler(JTable jTable) {
        this.jtable = jTable;
        this.jtable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (MIMSwingUtils.a(mouseEvent)) {
                    Point point = mouseEvent.getPoint();
                    int n2 = TableCopyHandler.this.jtable.rowAtPoint(point);
                    int n3 = TableCopyHandler.this.jtable.columnAtPoint(point);
                    if (!TableCopyHandler.this.jtable.isCellSelected(n2, n3)) {
                        TableCopyHandler.this.jtable.clearSelection();
                        TableCopyHandler.this.jtable.setRowSelectionInterval(n2, n2);
                        TableCopyHandler.this.jtable.setColumnSelectionInterval(n3, n3);
                    }
                    TableCopyHandler.this.menu.setSelectRow(n2);
                    TableCopyHandler.this.menu.setSelectedColumn(n3);
                    TableCopyHandler.this.menu.show(TableCopyHandler.this.jtable, point.x, point.y);
                }
            }
        });
        this.menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                this.removeAllItems();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                this.removeAllItems();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                if (TableCopyHandler.this.jtable.getSelectedColumnCount() != 0 && TableCopyHandler.this.jtable.getSelectedRowCount() != 0) {
                    for (DumpMenuItemHandler dumpMenuItemHandler : TableCopyHandler.this.menuItemHandlerList) {
                        if (!dumpMenuItemHandler.accept(TableCopyHandler.this.jtable)) continue;
                        TableCopyHandler.this.menu.add(dumpMenuItemHandler.getMenuItem());
                    }
                } else {
                    this.removeAllItems();
                }
            }

            private void removeAllItems() {
                ArrayList arrayList = Lists.newArrayList();
                for (Component component : TableCopyHandler.this.menu.getComponents()) {
                    if (!(component instanceof JMenuItem)) continue;
                    arrayList.add(component);
                }
                for (Component component : arrayList) {
                    TableCopyHandler.this.menu.remove(component);
                }
            }
        });
    }

    public void addMenuItemHandler(DumpMenuItemHandler dumpMenuItemHandler) {
        dumpMenuItemHandler.addMenu(this.menu);
        this.menuItemHandlerList.add(dumpMenuItemHandler);
    }
}

