/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpCopyMenuItemHandler;
import com.mimvista.dicom.devices.dump.gui.DumpShowFullValueMenuItemHandler;
import com.mimvista.dicom.devices.dump.gui.DumpTableCellRenderer;
import com.mimvista.dicom.devices.dump.gui.TableColumnAdjuster;
import com.mimvista.dicom.devices.dump.gui.TableCopyHandler;
import com.mimvista.dicom.devices.dump.gui.TablePanel;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributePath;
import com.mimvista.dicom.devices.dump.newDump.TableItem;
import com.mimvista.proui.MIMLookAndFeel;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public abstract class TableManager {
    protected JTable jtable;
    protected DefaultTableModel model;
    protected boolean isPrivateHidden = false;
    protected TablePanel tablePanel;
    private final String INDENT = "    ";

    public JTable getJTable() {
        return this.jtable;
    }

    public abstract void setCollapsed(boolean var1);

    public void filter(String string, boolean bl2) {
        this.tablePanel.setFilterString(string);
        this.tablePanel.setFilteringName(bl2);
        this.populateTable();
    }

    public void setPrivateVisible(boolean bl2) {
        this.isPrivateHidden = bl2;
        this.populateTable();
    }

    public AttributePath getScrollPos() {
        Rectangle rectangle = this.jtable.getVisibleRect();
        int n2 = rectangle.y;
        int n3 = n2 / this.jtable.getRowHeight();
        if (this.model.getRowCount() <= n3) {
            return null;
        }
        TableItem tableItem = (TableItem)this.model.getValueAt(n3, 0);
        Attribute attribute = tableItem.getAttribute();
        AttributePath attributePath = attribute.getPath();
        return attributePath;
    }

    public void setScrollPos(AttributePath attributePath) {
        if (attributePath == null) {
            return;
        }
        for (int i2 = 0; i2 < this.model.getRowCount(); ++i2) {
            TableItem tableItem = (TableItem)this.model.getValueAt(i2, 0);
            Attribute attribute = tableItem.getAttribute();
            AttributePath attributePath2 = attribute.getPath();
            if (attributePath2.compareTo(attributePath) != 0) continue;
            this.jtable.scrollRectToVisible(new Rectangle(0, this.jtable.getRowHeight() * i2, 2, 2));
            return;
        }
    }

    public abstract boolean isSavable();

    public abstract File getFile();

    public abstract File[] getFiles();

    protected void adjustColumnWidth() {
        this.jtable.setAutoResizeMode(0);
        TableColumnAdjuster tableColumnAdjuster = new TableColumnAdjuster(this.jtable);
        tableColumnAdjuster.setLastColumnAdjusted(true);
        tableColumnAdjuster.setOnlyAdjustLarger(false);
        tableColumnAdjuster.adjustColumns();
    }

    protected String getIndentStr(int n2) {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + "    ";
        }
        return string;
    }

    protected void clearTable() {
        this.model.setRowCount(0);
    }

    protected void build() {
        this.createModel();
        this.createTable();
        this.addTableListener();
    }

    protected void createTable() {
        this.jtable = new JTable(this.model){
            private static final long serialVersionUID = -3834112425050014886L;

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return this.getPreferredSize().width < this.getParent().getWidth();
            }
        };
        this.jtable.setCellSelectionEnabled(true);
        this.jtable.setSelectionBackground(MIMLookAndFeel.a());
        this.jtable.setDefaultRenderer(Object.class, new DumpTableCellRenderer());
        this.jtable.setAutoscrolls(false);
        TableCopyHandler tableCopyHandler = new TableCopyHandler(this.jtable);
        tableCopyHandler.addMenuItemHandler(new DumpCopyMenuItemHandler(this.jtable));
        tableCopyHandler.addMenuItemHandler(new DumpShowFullValueMenuItemHandler(this.jtable, this.tablePanel.getOwnerFrame()));
    }

    protected abstract void addTableListener();

    protected abstract void createModel();

    protected abstract void populateTable();
}

