/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.ImageInternalFrame;
import com.mimvista.dicom.devices.dump.gui.SingleFileTable;
import com.mimvista.dicom.devices.dump.gui.TableManager;
import com.mimvista.dicom.devices.dump.gui.TwoFilesTable;
import com.mimvista.dicom.devices.dump.gui.UpdateInterface;
import com.mimvista.dicom.devices.dump.newDump.AttributePath;
import com.mimvista.dicom.devices.dump.util.DcmFileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import javax.swing.JDesktopPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class TablePanel
extends JPanel
implements UpdateInterface {
    boolean imageFirstTimeShow = true;
    private DumpGuiFrame ownerFrame;
    private JDesktopPane layeredPane;
    private GridBagConstraints gs = new GridBagConstraints();
    private File[] files;
    private TableManager tableManager;
    private ImageInternalFrame imageInternalFrame;
    private JScrollPane scroll;
    private boolean imageOn;
    protected boolean filteringName = true;
    protected String filterString = "";

    public TablePanel(DumpGuiFrame dumpGuiFrame) {
        this.ownerFrame = dumpGuiFrame;
        this.ownerFrame.add(this);
        this.layeredPane = new JDesktopPane();
        this.setLayout(new GridBagLayout());
        this.gs.fill = 1;
        this.gs.weighty = 100.0;
        this.gs.weightx = 100.0;
        this.add((Component)this.layeredPane, this.gs);
        this.setBackground(Color.WHITE);
    }

    public TableManager getTableManager() {
        return this.tableManager;
    }

    public DumpGuiFrame getOwnerFrame() {
        return this.ownerFrame;
    }

    @Override
    public void updateFiles(File[] fileArray) {
        AttributePath attributePath = null;
        if (this.tableManager != null) {
            attributePath = this.tableManager.getScrollPos();
        }
        this.files = fileArray;
        if (fileArray.length == 1) {
            File file = fileArray[0];
            if (!DcmFileUtil.isDcmFile(file)) {
                file = null;
            }
            this.tableManager = new SingleFileTable(file, this);
        } else {
            this.tableManager = new TwoFilesTable(fileArray, this);
        }
        this.reload();
        this.tableManager.setScrollPos(attributePath);
    }

    private void reload() {
        if (this.scroll != null && this.scroll.getParent() == this.layeredPane) {
            this.layeredPane.remove(this.scroll);
        }
        this.scroll = new JScrollPane(this.tableManager.getJTable());
        this.layeredPane.add((Component)this.scroll, new Integer(1));
        if (this.imageInternalFrame == null) {
            this.imageInternalFrame = new ImageInternalFrame(this.files);
            this.layeredPane.add((Component)this.imageInternalFrame, new Integer(2));
        } else {
            this.imageInternalFrame.updateFiles(this.files);
        }
        this.imageInternalFrame.toFront();
        this.imageInternalFrame.setVisible(this.imageOn);
        this.ownerFrame.validate();
    }

    public void setImageVisible(boolean bl2) {
        if (this.imageFirstTimeShow) {
            this.setImagePos();
            this.imageFirstTimeShow = false;
        }
        this.imageOn = bl2;
        this.imageInternalFrame.setVisible(bl2);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.setScrollBounds();
    }

    public void setFilterString(String string) {
        this.filterString = string;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilteringName(boolean bl2) {
        this.filteringName = bl2;
    }

    public boolean isFilteringName() {
        return this.filteringName;
    }

    private void setScrollBounds() {
        this.scroll.setBounds(this.getBounds());
        this.scroll.setLocation(0, 0);
        this.scroll.validate();
    }

    private void setImagePos() {
        this.imageInternalFrame.setLocation(0, this.getHeight() - this.imageInternalFrame.getHeight());
    }
}

