/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.gui;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.TableManager;
import com.mimvista.dicom.devices.dump.gui.TablePanel;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeExtractor;
import com.mimvista.dicom.devices.dump.newDump.CompareAttribute;
import com.mimvista.dicom.devices.dump.newDump.TableItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.dcm4che2.util.StringUtils;

public class TwoFilesTable
extends TableManager {
    private String[] COLUMN_NAMES = new String[]{DumpGuiFrame.props.getProperty("COMPARISONTABLE_TAG"), DumpGuiFrame.props.getProperty("COMPARISONTABLE_VR"), DumpGuiFrame.props.getProperty("COMPARISONTABLE_VM"), DumpGuiFrame.props.getProperty("COMPARISONTABLE_NAME"), "", ""};
    private File[] files = new File[2];
    private ArrayList<Attribute> attrList1;
    private ArrayList<Attribute> attrList2;
    private ArrayList<CompareAttribute> aggregateAttrList = new ArrayList();
    private ArrayList<CompareAttribute> visibleAggregateAttrList;
    private boolean isIdenticalValueRowHidden = false;

    public TwoFilesTable(File[] fileArray, TablePanel tablePanel) {
        this.tablePanel = tablePanel;
        this.files = fileArray;
        this.build();
        this.extract();
        this.populateTable();
    }

    @Override
    public File getFile() {
        return this.files[0];
    }

    @Override
    public File[] getFiles() {
        return this.files;
    }

    @Override
    public void setCollapsed(boolean bl2) {
        this.isIdenticalValueRowHidden = bl2;
        this.populateTable();
    }

    @Override
    public boolean isSavable() {
        return false;
    }

    @Override
    protected void populateTable() {
        if (this.aggregateAttrList == null) {
            return;
        }
        this.clearTable();
        this.visibleAggregateAttrList = this.aggregateAttrList;
        this.filter();
        this.updateColumnNames();
        for (CompareAttribute compareAttribute : this.visibleAggregateAttrList) {
            this.addItem(compareAttribute);
        }
        this.adjustColumnWidth();
    }

    private void updateColumnNames() {
        this.jtable.getColumnModel().getColumn(this.COLUMN_NAMES.length - 2).setHeaderValue(this.files[0].getName());
        this.jtable.getColumnModel().getColumn(this.COLUMN_NAMES.length - 1).setHeaderValue(this.files[1].getName());
    }

    private void addItem(CompareAttribute compareAttribute) {
        Vector<TableItem> vector = new Vector<TableItem>();
        int n2 = compareAttribute.getPath().getLevel();
        vector.add(new TableItem(this.getIndentStr(n2) + compareAttribute.getTag(), compareAttribute.getId(), (Attribute)compareAttribute));
        vector.add(new TableItem(compareAttribute.getVrName(), compareAttribute.getId(), (Attribute)compareAttribute));
        vector.add(new TableItem("   " + compareAttribute.getVm(), compareAttribute.getId(), (Attribute)compareAttribute));
        vector.add(new TableItem(this.getIndentStr(n2 - 1) + compareAttribute.getName(), compareAttribute.getId(), (Attribute)compareAttribute));
        vector.add(new TableItem(compareAttribute.getValues(0), compareAttribute.getId(), compareAttribute.getAttribute(0), compareAttribute.getReadableUid(0), null, compareAttribute));
        vector.add(new TableItem(compareAttribute.getValues(1), compareAttribute.getId(), compareAttribute.getAttribute(1), compareAttribute.getReadableUid(1), null, compareAttribute));
        this.model.addRow(vector);
    }

    private void filter() {
        if (this.tablePanel.getFilterString().trim().length() == 0) {
            if (this.isPrivateHidden) {
                this.filterPrivate();
            }
            if (this.isIdenticalValueRowHidden) {
                this.filterIdentical();
            }
        } else {
            this.filterSpecific();
        }
    }

    private void filterSpecific() {
        ArrayList<CompareAttribute> arrayList = new ArrayList<CompareAttribute>();
        for (CompareAttribute compareAttribute : this.aggregateAttrList) {
            if (this.tablePanel.isFilteringName()) {
                if (!compareAttribute.getName().toLowerCase().contains(this.tablePanel.getFilterString().toLowerCase())) continue;
                arrayList.add(compareAttribute);
                continue;
            }
            if (compareAttribute.getValues(0).length == 0 || !StringUtils.join((String[])compareAttribute.getValues(0), (char)'\\').toLowerCase().contains(this.tablePanel.getFilterString().toLowerCase()) || compareAttribute.getValues(1).length == 0 || !StringUtils.join((String[])compareAttribute.getValues(1), (char)'\\').toLowerCase().contains(this.tablePanel.getFilterString().toLowerCase())) continue;
            arrayList.add(compareAttribute);
        }
        this.visibleAggregateAttrList = arrayList;
    }

    private void filterPrivate() {
        ArrayList<CompareAttribute> arrayList = new ArrayList<CompareAttribute>();
        for (CompareAttribute compareAttribute : this.visibleAggregateAttrList) {
            if (compareAttribute.getPrivate()) continue;
            arrayList.add(compareAttribute);
        }
        this.visibleAggregateAttrList = arrayList;
    }

    private void filterIdentical() {
        ArrayList<CompareAttribute> arrayList = new ArrayList<CompareAttribute>();
        for (CompareAttribute compareAttribute : this.visibleAggregateAttrList) {
            if (!compareAttribute.hasDifferentValues()) continue;
            arrayList.add(compareAttribute);
        }
        this.visibleAggregateAttrList = arrayList;
    }

    @Override
    protected void addTableListener() {
    }

    private void extract() {
        AttributeExtractor attributeExtractor = new AttributeExtractor(this.files[0], true);
        this.attrList1 = attributeExtractor.extractAttributeList();
        AttributeExtractor attributeExtractor2 = new AttributeExtractor(this.files[1], true);
        this.attrList2 = attributeExtractor2.extractAttributeList();
        this.combine();
    }

    private void combine() {
        Iterator<Attribute> iterator = this.attrList1.iterator();
        Iterator<Attribute> iterator2 = this.attrList2.iterator();
        boolean bl2 = true;
        boolean bl3 = true;
        Attribute attribute = null;
        Attribute attribute2 = null;
        CompareAttribute compareAttribute = null;
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (bl2) {
                attribute = iterator.next();
            }
            if (bl3) {
                attribute2 = iterator2.next();
            }
            if (attribute.getPath().compareTo(attribute2.getPath()) < 0) {
                compareAttribute = new CompareAttribute(attribute, null);
                bl2 = true;
                bl3 = false;
            } else if (attribute.getPath().compareTo(attribute2.getPath()) > 0) {
                compareAttribute = new CompareAttribute(null, attribute2);
                bl2 = false;
                bl3 = true;
            } else {
                compareAttribute = new CompareAttribute(attribute, attribute2);
                bl2 = true;
                bl3 = true;
            }
            this.aggregateAttrList.add(compareAttribute);
        }
        while (iterator.hasNext()) {
            compareAttribute = new CompareAttribute(iterator.next(), null);
            this.aggregateAttrList.add(compareAttribute);
        }
        while (iterator2.hasNext()) {
            compareAttribute = new CompareAttribute(null, iterator2.next());
            this.aggregateAttrList.add(compareAttribute);
        }
    }

    @Override
    protected void createModel() {
        this.model = new DefaultTableModel(this.COLUMN_NAMES, 0){

            @Override
            public boolean isCellEditable(int n2, int n3) {
                return false;
            }
        };
    }
}

