/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.newDump;

import com.mimvista.archive.Parser;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeNameQuerier;
import com.mimvista.dicom.devices.dump.newDump.AttributePath;
import com.mimvista.dicom.devices.dump.newDump.TagSiblingOrderPair;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.ReadableUidLookup;
import com.mimvista.dicom.util.ReadableValuesLookup;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.SpecificCharacterSet;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.TagUtils;

public class AttributeExtractor {
    private static final int VALUE_TRUNCATED_LIMIT = 100;
    private static final SpecificCharacterSet DEFAULT_SPECIFIC_CHARSET = SpecificCharacterSet.valueOf((String[])new String[]{Parser.getDefaultSpecificCharacterSet()});
    private ArrayList<Attribute> attributeList;
    private File file;
    private boolean pixelIncluded;
    private String model;
    private SpecificCharacterSet fileCharset;

    public AttributeExtractor(File file, boolean bl2) {
        this.file = file;
        this.pixelIncluded = bl2;
        this.attributeList = new ArrayList();
    }

    public ArrayList<Attribute> extractAttributeList() {
        DicomObject dicomObject = null;
        if (this.file != null) {
            DicomObject dicomObject2 = dicomObject = this.pixelIncluded ? DicomReader.readFileIntoDicomObject(this.file) : DicomReader.readFileIntoDicomObject(this.file, 2145386512);
        }
        if (dicomObject == null) {
            return null;
        }
        this.fileCharset = dicomObject.getSpecificCharacterSet();
        if (this.fileCharset == null) {
            this.fileCharset = DEFAULT_SPECIFIC_CHARSET;
        }
        this.extractDicomObject(dicomObject, null, 0);
        this.setAttributeIds();
        this.setAttributeReadableUID();
        this.setAttributeReadableValues();
        return this.attributeList;
    }

    public static String[] getFullValues(DicomElement dicomElement) {
        if (dicomElement.hasItems()) {
            return AttributeExtractor.getFullValuesFromFragments(dicomElement);
        }
        if (dicomElement.vr() == VR.AT) {
            return new String[]{AttributeExtractor.getFullAT(dicomElement)};
        }
        try {
            return AttributeExtractor.safeTruncatedGetStrings(dicomElement, 100);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string = dicomElement.getString(null, true);
            return new String[]{string == null ? "" : string};
        }
    }

    public String getModel() {
        if (this.model == null) {
            for (Attribute attribute : this.attributeList) {
                if (!attribute.getTag().equals("(0008,0060)")) continue;
                this.model = attribute.getValues()[0];
                break;
            }
        }
        return this.model;
    }

    private void extractDicomObject(DicomObject dicomObject, AttributePath attributePath, int n2) {
        Iterator iterator = dicomObject.iterator();
        while (iterator.hasNext()) {
            this.extractDicomElement((DicomElement)iterator.next(), attributePath, n2);
        }
    }

    private void setAttributeIds() {
        for (int i2 = 0; i2 < this.attributeList.size(); ++i2) {
            this.attributeList.get(i2).setId(i2);
        }
    }

    private void setAttributeReadableUID() {
        for (Attribute attribute : this.attributeList) {
            String string;
            if (attribute.getVr() == null || attribute.getVr() != VR.UI || attribute.getValue().length() <= 0 || (string = ReadableUidLookup.translate(attribute.getValues()[0])) == null || string.length() == 0) continue;
            attribute.setReadableUid(string);
        }
    }

    private void setAttributeReadableValues() {
        ReadableValuesLookup readableValuesLookup = new ReadableValuesLookup(this);
        for (Attribute attribute : this.attributeList) {
            String string;
            if (attribute.getVr() == null || attribute.getVr() == VR.UI || (string = readableValuesLookup.translate(attribute.getTag(), attribute.getValues())) == null || string.length() == 0) continue;
            attribute.setReadableValues(string);
        }
    }

    private void extractDicomElement(DicomElement dicomElement, AttributePath attributePath, int n2) {
        AttributePath attributePath2 = attributePath == null ? new AttributePath() : (AttributePath)attributePath.clone();
        attributePath2.add(new TagSiblingOrderPair(TagUtils.toString((int)dicomElement.tag()), n2));
        this.attributeList.add(this.extractNewAttribute(dicomElement, attributePath2));
        if (dicomElement.vr() == VR.SQ) {
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                this.extractDelimitItem((AttributePath)attributePath2.clone(), i2, true);
                this.extractDicomObject(dicomElement.getDicomObject(i2), attributePath2, i2);
                this.extractDelimitItem((AttributePath)attributePath2.clone(), i2, false);
            }
        }
    }

    private Attribute extractNewAttribute(DicomElement dicomElement, AttributePath attributePath) {
        Attribute attribute = new Attribute(this.file);
        attribute.setVr(dicomElement.vr());
        attribute.setVm(dicomElement.vm(null));
        attribute.setName(AttributeNameQuerier.queryName(dicomElement.tag()));
        attribute.setPrivate(TagUtils.isPrivateDataElement((int)dicomElement.tag()));
        attribute.setUid(dicomElement.vr() == VR.UI);
        attribute.setDcmElement(dicomElement);
        attribute.setPath(attributePath);
        attribute.setSq(dicomElement.vr() == VR.SQ);
        if (dicomElement.vr() != VR.SQ) {
            attribute.setValues(this.splitValues(this.getTruncatedValues(dicomElement, attribute)));
            attribute.setLengthString(this.getTotalBytesPrefix(dicomElement));
        }
        return attribute;
    }

    private static String[] getFullValuesFromFragments(DicomElement dicomElement) {
        String[] stringArray = new String[dicomElement.countItems()];
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            stringArray[i2] = AttributeExtractor.getString(dicomElement, dicomElement.getFragment(i2));
        }
        return stringArray;
    }

    private String[] getTruncatedValues(DicomElement dicomElement, Attribute attribute) {
        if (dicomElement.hasItems()) {
            return AttributeExtractor.getTruncatedValuesFromFragments(dicomElement, attribute);
        }
        if (dicomElement.vr() == VR.AT) {
            return new String[]{AttributeExtractor.getTruncatedAT(dicomElement, attribute)};
        }
        try {
            try {
                String[] stringArray = AttributeExtractor.safeTruncatedGetStrings(dicomElement, this.fileCharset, 100);
                attribute.setValueTruncated(stringArray.length >= 100);
                String[] stringArray2 = new String[Math.min(100, stringArray.length)];
                for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                    stringArray2[i2] = stringArray[i2];
                }
                return stringArray2;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                String string = dicomElement.getString(null, true);
                if (string == null) {
                    string = "";
                }
                attribute.setValueTruncated(string.length() >= 100);
                return new String[]{string.substring(0, Math.min(string.length(), 100))};
            }
        }
        catch (Exception exception) {
            try {
                attribute.setValueValid(false);
                StringBuffer stringBuffer = new StringBuffer();
                for (int i3 = 0; i3 < Math.min(dicomElement.getBytes().length, 2048); ++i3) {
                    String string = Integer.toHexString(0xFF & dicomElement.getBytes()[i3]);
                    if (string.length() == 1) {
                        stringBuffer.append("0");
                    }
                    stringBuffer.append(string);
                }
                return new String[]{stringBuffer.toString()};
            }
            catch (Exception exception2) {
                attribute.setValueValid(false);
                return new String[]{""};
            }
        }
    }

    private static String[] safeTruncatedGetStrings(DicomElement dicomElement, int n2) throws UnsupportedOperationException {
        return AttributeExtractor.safeTruncatedGetStrings(dicomElement, DEFAULT_SPECIFIC_CHARSET, n2);
    }

    private static String[] safeTruncatedGetStrings(DicomElement dicomElement, SpecificCharacterSet specificCharacterSet, int n2) throws UnsupportedOperationException {
        String[] stringArray;
        VR vR = dicomElement.vr();
        if (dicomElement.length() > n2 * 32) {
            int n3;
            byte[] byArray = dicomElement.getBytes();
            byte[] byArray2 = new byte[n2 * 8];
            for (n3 = 0; n3 < n2; ++n3) {
                byArray2[n3] = byArray[n3];
            }
            if (VR.OB.equals(vR)) {
                stringArray = new String[byArray2.length];
                for (n3 = 0; n3 < byArray2.length; ++n3) {
                    stringArray[n3] = Integer.toHexString(byArray2[n3]);
                }
            } else {
                stringArray = vR.toStrings(byArray2, dicomElement.bigEndian(), null);
            }
        } else {
            stringArray = dicomElement.getStrings(specificCharacterSet, true);
        }
        return stringArray;
    }

    private static String[] getTruncatedValuesFromFragments(DicomElement dicomElement, Attribute attribute) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 100;
        for (int i2 = 0; i2 < dicomElement.countItems() && n2 > 0; ++i2) {
            String string = AttributeExtractor.getString(dicomElement, dicomElement.getFragment(i2));
            if (n2 > string.length()) {
                arrayList.add(string);
                n2 -= string.length();
                continue;
            }
            arrayList.add(string.substring(0, n2));
            n2 = 0;
            attribute.setValueTruncated(true);
        }
        return arrayList.toArray(new String[0]);
    }

    private static String getString(DicomElement dicomElement, byte[] byArray) {
        String string = "";
        try {
            string = StringUtils.join((String[])dicomElement.vr().toStrings(byArray, dicomElement.bigEndian(), null), (char)'\\');
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            try {
                string = dicomElement.vr().toString(byArray, dicomElement.bigEndian(), null);
            }
            catch (Exception exception) {
                string = "";
            }
        }
        return string == null ? "" : string;
    }

    private void extractDelimitItem(AttributePath attributePath, int n2, boolean bl2) {
        Attribute attribute = new Attribute(this.file);
        attribute.setName("");
        String string = "";
        for (int i2 = 0; i2 < attributePath.getLevel(); ++i2) {
            string = string + ">";
        }
        AttributePath attributePath2 = (AttributePath)attributePath.clone();
        attributePath2.add(new TagSiblingOrderPair(string + (bl2 ? "BEGIN ITEM" : "END ITEM") + " " + n2, n2));
        attribute.setPath(attributePath2);
        this.attributeList.add(attribute);
    }

    private String[] splitValues(String[] stringArray) {
        int n2;
        int n3 = 0;
        String[][] stringArrayArray = new String[stringArray.length][];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArrayArray[n2] = stringArray[n2].split("\\\\");
            n3 += stringArrayArray[n2].length;
        }
        n2 = 0;
        String[] stringArray2 = new String[n3];
        for (int i2 = 0; i2 < stringArrayArray.length; ++i2) {
            System.arraycopy(stringArrayArray[i2], 0, stringArray2, n2, stringArrayArray[i2].length);
            n2 += stringArrayArray[i2].length;
        }
        return stringArray2;
    }

    private String getTotalBytesPrefix(DicomElement dicomElement) {
        if (dicomElement.vr() != VR.OB && dicomElement.vr() != VR.OW && dicomElement.vr() != VR.OF) {
            return "";
        }
        if (dicomElement.hasItems()) {
            int n2 = 0;
            for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                n2 += dicomElement.getFragment(i2).length;
            }
            return n2 + " Bytes";
        }
        return dicomElement.getBytes().length + " Bytes";
    }

    private static String getFullAT(DicomElement dicomElement) {
        StringBuffer stringBuffer = new StringBuffer();
        dicomElement.vr().promptValue(dicomElement.getBytes(), dicomElement.bigEndian(), null, new char[dicomElement.getBytes().length * 9 / 4 + 1], -1, stringBuffer);
        return stringBuffer.toString();
    }

    private static String getTruncatedAT(DicomElement dicomElement, Attribute attribute) {
        String string = AttributeExtractor.getFullAT(dicomElement);
        attribute.setValueTruncated(string.length() > 100);
        return string.substring(0, Math.min(string.length(), 100));
    }
}

