/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.newDump;

import com.mimvista.dicom.util.TagUtils;
import java.util.regex.Pattern;

public class AttributeNameQuerier {
    private static final Pattern wordPattern = Pattern.compile("([A-Z][a-z]+)");
    private static final Pattern emptyParenPattern = Pattern.compile("( +)");

    public static String queryName(int n2) {
        String string = TagUtils.getTagName(AttributeNameQuerier.convert(n2));
        if (string == null) {
            return "UNKNOWN";
        }
        return AttributeNameQuerier.split(string);
    }

    public static String split(String string) {
        String string2 = wordPattern.matcher(string).replaceAll(" $1 ");
        String string3 = emptyParenPattern.matcher(string2).replaceAll(" ");
        return string3.trim();
    }

    private static int convert(int n2) {
        int n3 = n2 >> 16 & 0xFFFF;
        if (n3 % 2 == 0) {
            return AttributeNameQuerier.convertTag(n2);
        }
        return n2;
    }

    private static int convertTag(int n2) {
        if (n2 >= 2109696 && n2 <= 2109951) {
            return 2109696;
        }
        int n3 = n2 >> 24 & 0xFF;
        if (n3 == 96 || n3 == 80) {
            return n2 & 0xFF00FFFF;
        }
        return n2;
    }
}

