/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.newDump;

import com.google.common.collect.Maps;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeExtractor;
import com.mimvista.dicom.util.VRUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;

public class SeriesDifferenceExtractor {
    private String seriesPath;

    public SeriesDifferenceExtractor(String string) {
        this.seriesPath = string;
    }

    public ArrayList<ArrayList<Attribute>> extract() {
        File file = new File(this.seriesPath);
        ArrayList<ArrayList<Attribute>> arrayList = new ArrayList<ArrayList<Attribute>>();
        for (File file2 : file.listFiles()) {
            AttributeExtractor attributeExtractor = new AttributeExtractor(file2, false);
            ArrayList<Attribute> arrayList2 = attributeExtractor.extractAttributeList();
            if (arrayList2 == null) continue;
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public static ArrayList<ArrayList<Attribute>> filterTopLevel(ArrayList<ArrayList<Attribute>> arrayList) {
        ArrayList<ArrayList<Attribute>> arrayList2 = new ArrayList<ArrayList<Attribute>>();
        for (ArrayList<Attribute> arrayList3 : arrayList) {
            ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>();
            for (Attribute attribute : arrayList3) {
                if (attribute.getPath().getLevel() != 1) continue;
                arrayList4.add(attribute);
            }
            arrayList2.add(arrayList4);
        }
        return arrayList2;
    }

    public static TreeSet<String> allTags(ArrayList<ArrayList<Attribute>> arrayList) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (ArrayList<Attribute> arrayList2 : arrayList) {
            for (Attribute attribute : arrayList2) {
                if (treeSet.contains(attribute.getTag())) continue;
                treeSet.add(attribute.getTag());
            }
        }
        return treeSet;
    }

    public static TreeSet<String> diffTags(ArrayList<ArrayList<Attribute>> arrayList) {
        HashMap hashMap = Maps.newHashMap();
        ArrayList<Attribute> arrayList2 = arrayList.get(0);
        for (Attribute object2 : arrayList2) {
            String string = object2.getTag();
            String string2 = object2.getValue();
            hashMap.put(string, string2);
        }
        TreeSet treeSet = new TreeSet();
        for (ArrayList<Attribute> arrayList3 : arrayList) {
            for (Attribute attribute : arrayList3) {
                if (hashMap.containsKey(attribute.getTag()) && ((String)hashMap.get(attribute.getTag())).equals(attribute.getValue())) continue;
                treeSet.add(attribute.getTag());
            }
        }
        return treeSet;
    }

    public static ArrayList<ArrayList<Attribute>> filterDiff(ArrayList<ArrayList<Attribute>> arrayList, TreeSet<String> treeSet) {
        ArrayList<ArrayList<Attribute>> arrayList2 = new ArrayList<ArrayList<Attribute>>();
        for (ArrayList<Attribute> arrayList3 : arrayList) {
            ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>();
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                Attribute attribute = arrayList3.get(i2);
                if (!treeSet.contains(attribute.getTag())) continue;
                arrayList4.add(attribute);
            }
            arrayList2.add(arrayList4);
        }
        return arrayList2;
    }

    public static ArrayList<ArrayList<Attribute>> filterPrivate(ArrayList<ArrayList<Attribute>> arrayList) {
        ArrayList<ArrayList<Attribute>> arrayList2 = new ArrayList<ArrayList<Attribute>>();
        for (ArrayList<Attribute> arrayList3 : arrayList) {
            ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>();
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                Attribute attribute = arrayList3.get(i2);
                if (attribute.getPrivate()) continue;
                arrayList4.add(attribute);
            }
            arrayList2.add(arrayList4);
        }
        return arrayList2;
    }

    public static ArrayList<ArrayList<Attribute>> filterGroupTag(ArrayList<ArrayList<Attribute>> arrayList) {
        ArrayList<ArrayList<Attribute>> arrayList2 = new ArrayList<ArrayList<Attribute>>();
        for (ArrayList<Attribute> arrayList3 : arrayList) {
            ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>();
            for (int i2 = 0; i2 < arrayList3.size(); ++i2) {
                Attribute attribute = arrayList3.get(i2);
                if (attribute.isGroupTag()) continue;
                arrayList4.add(attribute);
            }
            arrayList2.add(arrayList4);
        }
        return arrayList2;
    }

    public static ArrayList<ArrayList<Attribute>> reorderTags(ArrayList<ArrayList<Attribute>> arrayList) {
        ArrayList<ArrayList<Attribute>> arrayList2 = new ArrayList<ArrayList<Attribute>>();
        for (ArrayList<Attribute> arrayList3 : arrayList) {
            Attribute attribute;
            int n2;
            ArrayList<Attribute> arrayList4 = new ArrayList<Attribute>();
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                attribute = arrayList3.get(n2);
                if (attribute.getTag().equals("(0020,0013)")) {
                    arrayList4.add(0, attribute);
                    continue;
                }
                if (attribute.isUid()) continue;
                arrayList4.add(attribute);
            }
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                attribute = arrayList3.get(n2);
                if (!attribute.isUid()) continue;
                arrayList4.add(attribute);
            }
            arrayList2.add(arrayList4);
        }
        Collections.sort(arrayList2, new Comparator<ArrayList<Attribute>>(){

            @Override
            public int compare(ArrayList<Attribute> arrayList, ArrayList<Attribute> arrayList2) {
                Attribute attribute = arrayList.get(0);
                Attribute attribute2 = arrayList2.get(0);
                if (attribute.getVr() != null && attribute.getVr().equals(attribute2.getVr())) {
                    String[] stringArray = attribute.getValues();
                    String[] stringArray2 = attribute2.getValues();
                    for (int i2 = 0; i2 < stringArray.length && i2 < stringArray2.length; ++i2) {
                        int n2;
                        Comparable comparable = VRUtils.parseUserInputValue(attribute.getVr(), stringArray[i2]);
                        Comparable comparable2 = VRUtils.parseUserInputValue(attribute2.getVr(), stringArray2[i2]);
                        if (comparable == null || (n2 = comparable.compareTo(comparable2)) == 0) continue;
                        return n2;
                    }
                }
                return attribute.getValue().compareTo(attribute2.getValue());
            }
        });
        return arrayList2;
    }
}

