/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.newDump;

import com.mimvista.dicom.devices.dump.gui.DumpGuiFrame;
import com.mimvista.dicom.devices.dump.gui.DumpTableCellInterface;
import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.CompareAttribute;
import java.awt.Color;
import org.dcm4che2.util.StringUtils;

public class TableItem
implements DumpTableCellInterface {
    Attribute attribute;
    CompareAttribute compareAttribute;
    String text = "";
    String[] values;
    String highlightText = "";
    int id = -1;
    String readableUid;
    String readableValues;
    boolean isValueItem;
    boolean htmlOn = false;
    int foundBegin = -1;
    int foundEnd = -1;
    private final String seperator = "<font color=\"#7CFC00\"><B>\\</B></font>";
    private String yellowLeft = "<font color=\"yellow\">";
    private String yellowRight = "</font>";
    private String redLeft = "<font color=\"red\">";
    private String redRight = "</font>";
    private final Color COLLAPSED_SQ_COLOR = new Color(0, 50, 0);

    public TableItem(String string, int n2, Attribute attribute) {
        this(new String[]{string}, n2, attribute);
    }

    private TableItem(String[] stringArray, int n2, Attribute attribute) {
        this.values = stringArray;
        this.id = n2;
        this.attribute = attribute;
    }

    public TableItem(String[] stringArray, int n2, Attribute attribute, String string, String string2, CompareAttribute compareAttribute) {
        this(stringArray, n2, attribute);
        this.readableUid = string;
        this.readableValues = string2;
        this.compareAttribute = compareAttribute;
        this.isValueItem = true;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public void highlight(int n2, int n3) {
        this.foundBegin = n2;
        this.foundEnd = this.foundBegin + n3;
    }

    public void dehighlight() {
        this.foundBegin = -1;
        this.foundEnd = -1;
    }

    public String getText() {
        if (this.values == null) {
            return "";
        }
        String string = StringUtils.join((String[])this.values, (char)'\\');
        if (string == null) {
            return "";
        }
        return string;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setHighlightText(String string) {
        this.highlightText = string;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        String string = "";
        string = this.foundBegin == -1 ? this.getUnHighlighted() : this.getHighlighted();
        return string;
    }

    private String getPixelNumberPrifix() {
        if (this.attribute == null) {
            return "";
        }
        if (!this.attribute.isValueValid()) {
            return "<font color = \"darkgoldenrod\"><i>" + DumpGuiFrame.props.getProperty("SABOTAGED") + "</i></font>";
        }
        return this.attribute.getLengthString().length() == 0 ? "" : "<font color = \"darkgoldenrod\"><i>(" + this.attribute.getLengthString() + ")</i></font>";
    }

    private String getReadable(String string) {
        String string2 = "";
        if (this.readableUid != null && this.readableUid.trim().length() != 0) {
            string2 = "<font color = \"darkgoldenrod\"><i>  (" + this.readableUid + ")</i></font>";
            this.htmlOn = true;
        } else if (this.readableValues != null && this.readableValues.trim().length() != 0) {
            string2 = "<font color = \"darkgoldenrod\"><i>  (" + this.readableValues + ")</i></font>";
            this.htmlOn = true;
        }
        return string2;
    }

    public String getReadableAsPlainText() {
        if (this.readableValues != null) {
            return this.readableValues;
        }
        if (this.readableUid != null) {
            return this.readableUid;
        }
        return "";
    }

    @Override
    public Color getBackgroundColor() {
        if (this.compareAttribute != null) {
            if (this.compareAttribute.hasDifferentValues()) {
                return this.COLLAPSED_SQ_COLOR;
            }
            return null;
        }
        if (this.attribute != null && this.attribute.isCollapsed()) {
            return this.COLLAPSED_SQ_COLOR;
        }
        return null;
    }

    private String getSwitchedColorValue() {
        int n2;
        String string = "";
        String[] stringArray = new String[this.values.length];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = this.values[n2];
        }
        for (n2 = 1; n2 < stringArray.length; n2 += 2) {
            stringArray[n2] = this.yellowLeft + stringArray[n2] + this.yellowRight;
            this.htmlOn = true;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            string = string + stringArray[n2];
            if (n2 >= stringArray.length - 1) continue;
            string = string + "<font color=\"#7CFC00\"><B>\\</B></font>";
        }
        return string;
    }

    private String getUnHighlighted() {
        if (!this.isValueItem) {
            if (this.values.length == 1) {
                return this.values[0];
            }
            return "";
        }
        String string = "";
        if (this.values.length == 1) {
            string = this.values[0];
            string = string + this.getReadable(string);
        } else {
            string = this.getSwitchedColorValue();
            string = string + this.getReadable(string);
        }
        if (this.htmlOn || this.attribute != null && !this.attribute.isValueValid()) {
            string = "<html><p style=\"white-space: nowrap\">" + this.getPixelNumberPrifix() + string + "</p></html>";
        }
        return string;
    }

    @Override
    public String getPlainText() {
        return this.getText() + this.getReadableAsPlainText();
    }

    private String getHighlighted() {
        String string = "<html><p style=\"white-space: nowrap\">" + this.getPixelNumberPrifix() + this.getHead() + this.getBody() + this.getTail() + "</p></html>";
        return string;
    }

    private String getBody() {
        String string = StringUtils.join((String[])this.values, (char)'\\');
        String string2 = string.substring(this.foundBegin, this.foundEnd);
        return this.redLeft + string2 + this.redRight;
    }

    private String getHead() {
        boolean bl2 = false;
        int n2 = this.foundBegin;
        int n3 = 0;
        String string = "";
        while (n2 > 0) {
            if (n2 - this.values[n3].length() <= 0) {
                string = string + this.getYellow(this.values[n3], 0, n2, bl2);
                return string;
            }
            string = string + this.getYellow(this.values[n3], 0, this.values[n3].length(), bl2);
            if ((n2 -= this.values[n3].length()) - 1 <= 0) {
                string = string + "<font color=\"#7CFC00\"><B>\\</B></font>";
                return string;
            }
            string = string + "<font color=\"#7CFC00\"><B>\\</B></font>";
            --n2;
            bl2 = !bl2;
            ++n3;
        }
        return string;
    }

    private String getTail() {
        boolean bl2 = false;
        int n2 = this.foundEnd;
        int n3 = 0;
        String string = "";
        while (n2 > 0) {
            if (n2 - this.values[n3].length() <= 0) {
                string = this.getYellow(this.values[n3], n2, this.values[n3].length() - n2, bl2);
                bl2 = !bl2;
                ++n3;
                break;
            }
            n2 -= this.values[n3].length();
            --n2;
            bl2 = !bl2;
            ++n3;
        }
        while (n3 < this.values.length) {
            string = string + "<font color=\"#7CFC00\"><B>\\</B></font>";
            string = string + this.getYellow(this.values[n3], 0, this.values[n3].length(), bl2);
            bl2 = !bl2;
            ++n3;
        }
        return string;
    }

    private String getYellow(String string, int n2, int n3, boolean bl2) {
        if (bl2) {
            return this.yellowLeft + string.substring(n2, n2 + n3) + this.yellowRight;
        }
        return string.substring(n2, n2 + n3);
    }

    @Override
    public String getTip() {
        return null;
    }

    @Override
    public boolean hasTip() {
        return false;
    }
}

