/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.dump.util;

import com.mimvista.dicom.devices.dump.newDump.Attribute;
import com.mimvista.dicom.devices.dump.newDump.AttributeExtractor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Dump2FileUtil {
    private static String blank = " ";
    private static int INDENT_UNIT = 2;
    private String dest;
    private File dcmFile;
    private int maxTagCharNum = "(0000,0000)".length();
    private int maxVrCharNum = 2;
    private int maxNameCharNum = 1;
    private int maxValueCharNum = 1;
    private int maxVmNum = 1;

    public static boolean saveToFile(String string, File file) {
        return new Dump2FileUtil(string, file).saveToFile();
    }

    private Dump2FileUtil(String string, File file) {
        this.dest = string;
        this.dcmFile = file;
    }

    private boolean saveToFile() {
        AttributeExtractor attributeExtractor = new AttributeExtractor(this.dcmFile, true);
        ArrayList<Attribute> arrayList = attributeExtractor.extractAttributeList();
        this.computeCharNums(arrayList);
        return this.dump(arrayList);
    }

    private void computeCharNums(ArrayList<Attribute> arrayList) {
        int n2 = 0;
        for (Attribute attribute : arrayList) {
            this.maxTagCharNum = Math.max(attribute.getTag().length(), this.maxTagCharNum);
            this.maxNameCharNum = Math.max(attribute.getName().length(), this.maxNameCharNum);
            this.maxVmNum = Math.max(new Integer(attribute.getVm()).toString().length(), this.maxVmNum);
            this.maxValueCharNum = Math.max(attribute.getValue().length(), this.maxValueCharNum);
            n2 = Math.max(attribute.getPath().getLevel(), n2);
        }
        this.maxTagCharNum += n2 * INDENT_UNIT;
        this.maxNameCharNum += n2 * INDENT_UNIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dump(ArrayList<Attribute> arrayList) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(new File(this.dest)));
            for (Attribute attribute : arrayList) {
                int n2 = attribute.getPath().getLevel() * INDENT_UNIT;
                bufferedWriter.write(Dump2FileUtil.blankString(n2));
                bufferedWriter.write(attribute.getTag());
                bufferedWriter.write(Dump2FileUtil.blankString(this.maxTagCharNum - attribute.getTag().length() - n2));
                bufferedWriter.write(blank);
                String string = attribute.getVrName() == null ? "" : attribute.getVrName();
                bufferedWriter.write(string);
                bufferedWriter.write(Dump2FileUtil.blankString(this.maxVrCharNum - string.length()));
                bufferedWriter.write(blank);
                String string2 = attribute.getVm() == 0 ? "" : new Integer(attribute.getVm()).toString();
                bufferedWriter.write(string2);
                bufferedWriter.write(Dump2FileUtil.blankString(this.maxVmNum - string2.length()));
                bufferedWriter.write(blank);
                bufferedWriter.write(Dump2FileUtil.blankString(n2));
                String string3 = attribute.getName() == null ? "" : attribute.getName();
                bufferedWriter.write(string3);
                bufferedWriter.write(Dump2FileUtil.blankString(this.maxNameCharNum - string3.length() + n2));
                bufferedWriter.write(blank);
                bufferedWriter.write(attribute.getValue());
                if (attribute.getVrName() != null && (attribute.getVrName().equalsIgnoreCase("OB") || attribute.getVrName().equalsIgnoreCase("OW") || attribute.getVrName().equalsIgnoreCase("OF") || attribute.getVrName().equalsIgnoreCase("UN"))) {
                    bufferedWriter.write("...");
                }
                bufferedWriter.newLine();
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static String blankString(int n2) {
        String string = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + blank;
        }
        return string;
    }
}

