/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.printer;

import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.config.Configuration;
import com.mimvista.dicom.devices.printer.DicomPrinter;
import com.mimvista.dicom.devices.printer.PrinterControl;
import com.mimvista.file.Path;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.pdu.AAssociateRJ;

public class DcmPrint {
    public static Messages props = Messages.a("Printer");
    private boolean success = false;
    private static final String[] DEF_TS = new String[]{"1.2.840.10008.1.2"};
    private String presentationContextToUse;
    private MIMDcmUrl url = null;
    private Association association;
    private int acTimeout = 5000;
    private int dimseTimeout = 0;
    private boolean packPDVs = false;
    public boolean finished = false;
    private String printerStatus;
    private String printerStatusInfo;
    private DicomPrinter printer;
    private DicomObject[] imageDataSets;
    private String filmBoxInstanceUID;
    private int imageIndex;
    private String status;
    private List<ActionListener> statusListeners = new ArrayList<ActionListener>();
    private boolean useGrayscale = false;
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection connection = new NetworkConnection();
    private NetworkConnection remoteNetworkConnection = new NetworkConnection();
    private Device device = new Device();
    private JDialog statDialog;

    public DcmPrint() {
    }

    public DcmPrint(Progress progress) {
    }

    public void addStatusListener(ActionListener actionListener) {
        this.statusListeners.add(actionListener);
    }

    private Association openAssociation() throws DcmPrintException {
        this.updateStatusLabel("Setting up association");
        try {
            Association association = this.ae.connect(this.remoteAE, (Executor)new NewThreadExecutor("DCMPRINT"));
            TransferCapability transferCapability = association.getTransferCapabilityAsSCU("1.2.840.10008.5.1.1.9");
            TransferCapability transferCapability2 = association.getTransferCapabilityAsSCU("1.2.840.10008.5.1.1.18");
            if (transferCapability2 != null) {
                ay.a((Object)"We have color presentation context", this);
                this.presentationContextToUse = "1.2.840.10008.5.1.1.18";
            } else if (transferCapability != null) {
                ay.a((Object)"We only have grayscale", this);
                this.presentationContextToUse = "1.2.840.10008.5.1.1.9";
                this.useGrayscale = true;
            }
            if (this.printer != null && this.printer.isForceBW()) {
                ay.a((Object)"Forcing grayscale", this);
                this.useGrayscale = true;
                this.presentationContextToUse = "1.2.840.10008.5.1.1.9";
            }
            if (transferCapability2 == null && transferCapability == null) {
                throw new DcmPrintException("This DICOM device does not support Color or Grayscale modes. Cannot print. Color: " + String.valueOf(transferCapability2) + ", Grayscale: " + String.valueOf(transferCapability));
            }
            return association;
        }
        catch (AAssociateRJ aAssociateRJ) {
            String string = "Unknown";
            if (aAssociateRJ.getResult() == 1) {
                switch (aAssociateRJ.getReason()) {
                    case 1: {
                        string = "No Reason Given";
                        break;
                    }
                    case 2: {
                        string = "Application Context Name Not Supported";
                        break;
                    }
                    case 3: {
                        string = "Calling AE Title Not Recognized";
                        break;
                    }
                    case 7: {
                        string = "Called AE Title Not Recognized";
                    }
                }
            } else if (aAssociateRJ.getResult() == 2) {
                switch (aAssociateRJ.getReason()) {
                    case 1: {
                        string = "Temporary Congestion";
                        break;
                    }
                    case 2: {
                        string = "Local Limit Exceeded";
                    }
                }
            }
            throw new DcmPrintException("Cannot create association: " + string, (Exception)((Object)aAssociateRJ));
        }
        catch (ConfigurationException configurationException) {
            throw new DcmPrintException("Cannot connect: " + configurationException.getMessage());
        }
        catch (IOException iOException) {
            throw new DcmPrintException("Cannot connect: " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DicomObject getInfo(MIMDcmUrl mIMDcmUrl) {
        this.url = mIMDcmUrl;
        Configuration configuration = new Configuration("bin/lib/printer.cfg");
        this.packPDVs = "true".equalsIgnoreCase(configuration.getProperty("pack-pdvs", "false"));
        this.association = null;
        try {
            this.setupAssociationParameters(configuration, this.url);
            this.association = this.openAssociation();
            if (this.association == null) {
                DicomObject dicomObject = null;
                return dicomObject;
            }
            ay.a((Object)("Association for Info: " + this.association), this);
            DicomObject dicomObject = this.getPrinterInfo();
            return dicomObject;
        }
        catch (DcmPrintException dcmPrintException) {
            ay.d((Object)dcmPrintException, this);
            this.notifyMessage(dcmPrintException.getMessage());
        }
        finally {
            this.releaseAssoc(false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int performPrint(DicomPrinter dicomPrinter, DicomObject[] dicomObjectArray) {
        this.association = null;
        try {
            this.imageDataSets = dicomObjectArray;
            int n2 = this.printDatasets(dicomPrinter);
            return n2;
        }
        catch (DcmPrintException dcmPrintException) {
            ay.d((Object)dcmPrintException, this);
            this.notifyMessage(dcmPrintException.getMessage());
        }
        finally {
            this.releaseAssoc(true);
        }
        return -1;
    }

    private int printDatasets(DicomPrinter dicomPrinter) throws DcmPrintException {
        this.printer = dicomPrinter;
        this.url = this.printer.toUrl();
        Configuration configuration = new Configuration(Path.getClassesPath("printer.cfg"));
        this.packPDVs = "true".equalsIgnoreCase(configuration.getProperty("pack-pdvs", "false"));
        this.setupAssociationParameters(configuration, this.url);
        this.association = this.openAssociation();
        if (this.association == null) {
            this.notifyMessage("Trouble with association");
            return -1;
        }
        ay.a((Object)("Association for Print: " + this.association), this);
        this.updateStatusLabel("Checking Printer Status");
        DicomObject dicomObject = this.getPrinterInfo();
        if (dicomObject == null) {
            throw new DcmPrintException("Unable to retrieve printer status.");
        }
        this.checkStatusCodes();
        String string = null;
        try {
            String string2;
            Object object;
            int n2;
            string = this.setupBasicFilmSession();
            this.imageIndex = n2 = 0;
            while (this.imageIndex < this.imageDataSets.length) {
                object = this.setupFilmBox(string);
                if (dicomPrinter.isBurnAnnotation()) {
                    PrinterControl.writeAllTextOntoDicomObject(this.imageDataSets[this.imageIndex], ((String[])object).length);
                }
                for (int i2 = 0; i2 < ((String[])object).length; ++i2) {
                    DicomObject dicomObject2 = this.imageDataSets[this.imageIndex++];
                    if (i2 > 0 && dicomPrinter.isBurnAnnotation()) {
                        PrinterControl.writeMinimalTextOntoDicomObject(dicomObject2, ((String[])object).length);
                    }
                    this.setupImagebox(object[i2], dicomObject2, i2 + 1);
                    if (this.imageIndex == this.imageDataSets.length) break;
                }
                if (dicomPrinter.getCollated()) continue;
                this.updateStatusLabel("Performing PRINT Action");
                string2 = "1.2.840.10008.5.1.1.2";
                this.runPrintAction(string2, this.filmBoxInstanceUID);
            }
            if (dicomPrinter.getCollated()) {
                object = string;
                string2 = "1.2.840.10008.5.1.1.1";
                this.runPrintAction(string2, (String)object);
            }
            this.updateStatusLabel("Releasing Association");
            this.success = true;
            if (this.statDialog != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DcmPrint.this.statDialog.dispose();
                        DcmPrint.this.statDialog = null;
                    }
                });
            }
        }
        catch (InterruptedException interruptedException) {
            throw new DcmPrintException(interruptedException);
        }
        catch (IOException iOException) {
            throw new DcmPrintException(iOException);
        }
        finally {
            this.releaseAssoc(true);
        }
        return 1;
    }

    private void runPrintAction(String string, String string2) throws InterruptedException, IOException {
        DimseRSP dimseRSP = this.association.naction(this.presentationContextToUse, string, string2, 1, null, "1.2.840.10008.1.2");
        dimseRSP.next();
        DicomObject dicomObject = dimseRSP.getCommand();
        StringBuilder stringBuilder = new StringBuilder("RunPrintAction Result:");
        stringBuilder.append("\nResponse Object: ");
        stringBuilder.append(dicomObject);
        stringBuilder.append("\nSOP Instance UID: ");
        stringBuilder.append(dicomObject.getString(4096));
        stringBuilder.append("\nStatus: ");
        stringBuilder.append(dicomObject.getInt(2304, -1));
        ay.a((Object)stringBuilder, this);
    }

    private void checkStatusCodes() throws DcmPrintException {
        String string;
        int n2;
        if (!(("NORMAL".equals(this.printerStatus) || "NO_INFO".equals(this.printerStatus)) && ("STANDARD".equals(this.printerStatusInfo) || "NORMAL".equals(this.printerStatusInfo) || "NO_INFO".equals(this.printerStatusInfo)) || (n2 = JOptionPane.showConfirmDialog(this.statDialog, string = MIMFormat.a(props.getProperty("DCMPRINT_STATUS"), this.printerStatus, this.printerStatusInfo), props.getProperty("DCMPRINT_ABNORMAL_STATUS"), 0)) == 0)) {
            throw new DcmPrintException("Print failed.\n\nPrinter Status is: " + this.printerStatus + "\nStatus Info is: " + this.printerStatusInfo);
        }
    }

    private void releaseAssoc(boolean bl2) {
        if (this.association != null) {
            try {
                this.association.release(bl2);
            }
            catch (InterruptedException interruptedException) {
                ay.d((Object)"InterruptedException while releasing association", (Throwable)interruptedException, this);
            }
        }
    }

    private void setupImagebox(String string, DicomObject dicomObject, int n2) throws InterruptedException, IOException, DcmPrintException {
        boolean bl2;
        int n3;
        String string2;
        if (this.useGrayscale) {
            string2 = "1.2.840.10008.5.1.1.4";
            n3 = 0x20200110;
            bl2 = false;
            ay.d((Object)("Converting image " + n2 + " to grayscale"), this);
            PrinterControl.convertToGrayscale(dicomObject);
        } else {
            string2 = "1.2.840.10008.5.1.1.4.1";
            n3 = 0x20200111;
            bl2 = true;
        }
        dicomObject = PrinterControl.removeExcessData(dicomObject);
        this.updateStatusLabel("Creating ImageBox " + this.imageIndex + " of " + this.imageDataSets.length);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putInt(0x20200010, VR.US, n2);
        basicDicomObject.putString(537919584, VR.CS, this.printer.getMagType().getStringForPrefs());
        basicDicomObject.putString(537919616, VR.CS, this.printer.getSmoothing().getStringForPrefs());
        if (!bl2) {
            if (this.printer.getMaxDensity().length() > 0) {
                basicDicomObject.putString(537919792, VR.US, this.printer.getMaxDensity());
            }
            if (this.printer.getMinDensity().length() > 0) {
                basicDicomObject.putString(0x20100120, VR.US, this.printer.getMinDensity());
            }
        }
        DicomElement dicomElement = null;
        dicomElement = basicDicomObject.putSequence(n3);
        dicomElement.addDicomObject(dicomObject);
        DimseRSP dimseRSP = this.association.nset(this.presentationContextToUse, string2, string, (DicomObject)basicDicomObject, "1.2.840.10008.1.2");
        dimseRSP.next();
        DicomObject dicomObject2 = dimseRSP.getCommand();
        int n4 = dicomObject2.getInt(2304, -1);
        ay.a((Object)("Setup ImageBox, SOP Instance UID: " + dicomObject2.getString(4096)), this);
        if (n4 != 0) {
            ay.d((Object)("ImageBoxResponseCommand: " + dicomObject2), this);
            if (n4 != 263) {
                if (bl2) {
                    throw new DcmPrintException("Printer does not support color: status code " + Integer.toHexString(n4));
                }
                throw new DcmPrintException("Printer does not support grayscale: status code " + Integer.toHexString(n4));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] setupFilmBox(String string) throws InterruptedException, IOException, DcmPrintException {
        this.updateStatusLabel("Creating Film Box");
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putString(0x20100010, VR.ST, this.printer.getSheetFormat().getStringForPrefs());
        basicDicomObject.putString(537919552, VR.CS, this.printer.getFilmOrientation().getStringForPrefs());
        basicDicomObject.putString(537919568, VR.CS, this.printer.getFilmSize().getStringForPrefs());
        basicDicomObject.putString(537919584, VR.CS, this.printer.getMagType().getStringForPrefs());
        basicDicomObject.putString(537919824, VR.ST, this.printer.getConfig());
        basicDicomObject.putString(537919616, VR.CS, this.printer.getSmoothing().getStringForPrefs());
        basicDicomObject.putString(0x20100100, VR.CS, this.printer.getBorder().getStringForPrefs());
        basicDicomObject.putString(0x20100110, VR.CS, this.printer.getEmptyDensity());
        basicDicomObject.putString(537919808, VR.CS, this.printer.getTrim().getStringForPrefs());
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        DicomElement dicomElement = basicDicomObject.putSequence(537920768);
        basicDicomObject2.putString(528720, VR.UI, "1.2.840.10008.5.1.1.1");
        basicDicomObject2.putString(528725, VR.UI, string);
        dicomElement.addDicomObject((DicomObject)basicDicomObject2);
        StringBuilder stringBuilder = new StringBuilder("Create Film Box");
        try {
            DimseRSP dimseRSP = this.association.ncreate(this.presentationContextToUse, "1.2.840.10008.5.1.1.2", "", (DicomObject)basicDicomObject, "1.2.840.10008.1.2");
            dimseRSP.next();
            DicomObject dicomObject = dimseRSP.getCommand();
            this.filmBoxInstanceUID = dicomObject.getString(4096);
            stringBuilder.append("\nSOP Instance Box: " + this.filmBoxInstanceUID);
            int n2 = dicomObject.getInt(2304, -1);
            String string2 = Integer.toHexString(n2);
            stringBuilder.append("\nCommand Status: " + string2);
            if (n2 != 0 && n2 != 263) {
                throw new DcmPrintException("Unable to continue printing. Error code " + string2 + ".");
            }
            DicomObject dicomObject2 = dimseRSP.getDataset();
            DicomElement dicomElement2 = dicomObject2.get(537920784);
            stringBuilder.append("\nDSRCV: " + dicomElement2);
            int n3 = dicomElement2.countItems();
            stringBuilder.append("\nnumImageBoxes: " + n3);
            String[] stringArray = new String[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                String string3;
                DicomObject dicomObject3 = dicomElement2.getDicomObject(i2);
                stringArray[i2] = string3 = dicomObject3.getString(528725);
                stringBuilder.append("\nimageBoxUID[" + i2 + "]:" + stringArray[i2]);
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
        finally {
            ay.a((Object)stringBuilder, this);
        }
    }

    private DicomObject getPrinterInfo() throws DcmPrintException {
        DicomObject dicomObject;
        DimseRSP dimseRSP = null;
        try {
            dimseRSP = this.association.nget("1.2.840.10008.5.1.1.9", "1.2.840.10008.5.1.1.16", "1.2.840.10008.5.1.1.17", null);
        }
        catch (IllegalStateException illegalStateException) {
            ay.d((Object)illegalStateException, this);
            this.notifyMessage(illegalStateException.toString());
            return null;
        }
        catch (IOException iOException) {
            throw new DcmPrintException(iOException);
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)interruptedException, this);
            return null;
        }
        try {
            dimseRSP.next();
            dicomObject = dimseRSP.getDataset();
        }
        catch (InterruptedException interruptedException) {
            throw new DcmPrintException(interruptedException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new DcmPrintException(iOException);
        }
        String string = dicomObject.getString(554696752);
        this.printerStatus = dicomObject.getString(0x21100010);
        this.printerStatusInfo = dicomObject.getString(0x21100020);
        StringBuilder stringBuilder = new StringBuilder("GetPrinterInfo");
        stringBuilder.append("\nResponseObject: ");
        stringBuilder.append(dicomObject);
        stringBuilder.append("\nPrinterName: ");
        stringBuilder.append(string);
        stringBuilder.append("\nPrinterStatus: ");
        stringBuilder.append(this.printerStatus);
        stringBuilder.append("\nPrinter Status Info: ");
        stringBuilder.append(this.printerStatusInfo);
        ay.a((Object)stringBuilder, this);
        return dicomObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String setupBasicFilmSession() throws InterruptedException, IOException {
        this.updateStatusLabel("Creating Film Session");
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putString(0x20000010, VR.IS, this.printer.getCopies() + "");
        basicDicomObject.putString(0x20000020, VR.CS, this.printer.getJobPriority().getStringForPrefs());
        basicDicomObject.putString(0x20000040, VR.CS, this.printer.getDestination().getStringForPrefs());
        basicDicomObject.putString(0x20000030, VR.CS, this.printer.getMedium().getStringForPrefs());
        StringBuilder stringBuilder = new StringBuilder("Setup Basic Film Session");
        try {
            DimseRSP dimseRSP = this.association.ncreate(this.presentationContextToUse, "1.2.840.10008.5.1.1.1", "", (DicomObject)basicDicomObject, "1.2.840.10008.1.2");
            dimseRSP.next();
            DicomObject dicomObject = dimseRSP.getDataset();
            stringBuilder.append("\nDSRCV: " + dicomObject);
            DicomObject dicomObject2 = dimseRSP.getCommand();
            stringBuilder.append("\nbasicFilmSessionResponseCommand: " + dicomObject2);
            int n2 = dicomObject2.getInt(2304);
            if (n2 != 0) {
                stringBuilder.append("\nStatus is nonzero - problem with film session: " + n2);
            }
            String string = dicomObject2.getString(4096);
            stringBuilder.append("\nSOP Instance Session: " + string);
            String string2 = string;
            return string2;
        }
        finally {
            ay.a((Object)stringBuilder, this);
        }
    }

    private static String maskNull(String string) {
        return string != null ? string : "DCMPRINT";
    }

    private void setupAssociationParameters(Configuration configuration, MIMDcmUrl mIMDcmUrl) throws DcmPrintException {
        this.ae.setAETitle(DcmPrint.maskNull(mIMDcmUrl.getCallingAET()));
        this.ae.setNetworkConnection(this.connection);
        this.ae.setAssociationInitiator(true);
        this.ae.setTransferCapability(new TransferCapability[]{new TransferCapability("1.2.840.10008.1.1", DEF_TS, "SCU"), new TransferCapability("1.2.840.10008.5.1.1.9", DEF_TS, "SCU"), new TransferCapability("1.2.840.10008.5.1.1.18", DEF_TS, "SCU")});
        this.remoteAE.setAETitle(mIMDcmUrl.getCalledAET());
        this.remoteAE.setInstalled(true);
        this.remoteAE.setNetworkConnection(this.remoteNetworkConnection);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteNetworkConnection.setHostname(mIMDcmUrl.getHost());
        this.remoteNetworkConnection.setPort(mIMDcmUrl.getPort());
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.connection);
        this.acTimeout = Integer.parseInt(configuration.getProperty("ac-timeout", "50000"));
        this.dimseTimeout = Integer.parseInt(configuration.getProperty("dimse-timeout", "50000"));
        this.connection.setAcceptTimeout(this.acTimeout);
        this.ae.setDimseRspTimeout(this.dimseTimeout);
        this.ae.setPackPDV(this.packPDVs);
    }

    private int print(DicomPrinter dicomPrinter, DicomObject[] dicomObjectArray) {
        if (dicomObjectArray.length == 0) {
            return -1;
        }
        return this.performPrint(dicomPrinter, dicomObjectArray);
    }

    public boolean printWithDialog(DicomPrinter dicomPrinter, DicomObject[] dicomObjectArray, Window window) {
        this.initStatusDialog(window);
        new PrintThread(dicomPrinter, dicomObjectArray).start();
        this.showStatusDialog();
        return this.success;
    }

    public boolean printWithoutDialog(DicomPrinter dicomPrinter, DicomObject[] dicomObjectArray) {
        new PrintThread(dicomPrinter, dicomObjectArray).run();
        return this.success;
    }

    private void initStatusDialog(Window window) {
        this.statDialog = new JDialog(window, props.getProperty("DCMPRINT_PRINT_STATUS"), Dialog.ModalityType.APPLICATION_MODAL);
        this.statDialog.setLayout(new GridLayout(1, 1));
        final JLabel jLabel = new JLabel(props.getProperty("DCMPRINT_PRINTING"), 0);
        this.statDialog.add(jLabel);
        this.statDialog.pack();
        this.addStatusListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jLabel.setText(DcmPrint.this.getStatus());
            }
        });
    }

    private void showStatusDialog() {
        this.statDialog.setVisible(true);
    }

    public String getStatus() {
        return this.status;
    }

    private void updateStatusLabel(String string) {
        this.status = string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ActionListener actionListener : DcmPrint.this.statusListeners) {
                    actionListener.actionPerformed(new ActionEvent(this, 0, "StatusChange"));
                }
            }
        });
    }

    private void notifyMessage(String string) {
        this.updateStatusLabel(string);
        if (this.statDialog != null) {
            JOptionPane.showMessageDialog(this.statDialog, string, props.getProperty("DCMPRINT_PRINT_ERROR"), 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DcmPrint.this.statDialog.dispose();
                    DcmPrint.this.statDialog = null;
                }
            });
        }
    }

    class PrintThread
    extends Thread {
        private DicomPrinter p;
        private DicomObject[] datasets;

        public PrintThread(DicomPrinter dicomPrinter, DicomObject[] dicomObjectArray) {
            super("PrintThread");
            this.datasets = dicomObjectArray;
            this.p = dicomPrinter;
        }

        @Override
        public void run() {
            DcmPrint.this.print(this.p, this.datasets);
        }
    }

    static class DcmPrintException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DcmPrintException(String string) {
            super(string);
        }

        public DcmPrintException(Exception exception) {
            super(exception);
        }

        public DcmPrintException(String string, Exception exception) {
            super(string, exception);
        }
    }
}

