/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.printer;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.mimvista.MimJsonSerializable;
import com.mimvista.dicom.GenericTestJDialog;
import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.devices.printer.DcmPrint;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.preferences.al;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.DicomPrintersPrefs;
import com.mimvista.preferencesNew.e;
import com.mimvista.util.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.dcm4che2.data.DicomObject;

@MimJsonSerializable
public class DicomPrinter
implements e {
    @JsonIgnore
    public static Messages props = Messages.a("Printer");
    private String description;
    private String aeTitle;
    private String host;
    private String port;
    private int copies;
    private DicomPrintersPrefs.Priority jobPriority;
    private DicomPrintersPrefs.Orientation filmOrientation;
    private DicomPrintersPrefs.SheetFormat sheetFormat;
    private DicomPrintersPrefs.Medium medium;
    private DicomPrintersPrefs.Destination destination;
    private DicomPrintersPrefs.MagType magType;
    private DicomPrintersPrefs.Trim trim;
    private DicomPrintersPrefs.Size filmSize;
    private DicomPrintersPrefs.Resolution resolution;
    private DicomPrintersPrefs.SmoothingType smoothing;
    private String config;
    private String minDensity;
    private String maxDensity;
    private String emptyDensity;
    private DicomPrintersPrefs.Border border;
    private boolean collated;
    private boolean burnAnnotation;
    private boolean forceBW;
    private String uniqueId;
    public static Map<Class<? extends al>, Boolean> editableMap = new HashMap<Class<? extends al>, Boolean>();

    public DicomPrinter() {
    }

    public DicomPrinter(String string) {
        this.uniqueId = string;
    }

    public String toString() {
        return this.getDescription();
    }

    public void setCollated(boolean bl2) {
        this.collated = bl2;
    }

    public boolean isForceBW() {
        return this.forceBW;
    }

    @JsonIgnore
    public static MIMDcmUrl toUrl(String string, String string2, int n2) {
        return new MIMDcmUrl(string, DicomLocationsPrefs.a.getServerHost().getAeTitle(), string2, n2);
    }

    @JsonIgnore
    public MIMDcmUrl toUrl() {
        return new MIMDcmUrl(this.aeTitle, DicomLocationsPrefs.a.getServerHost().getAeTitle(), this.host, Integer.valueOf(this.port));
    }

    public boolean isBurnAnnotation() {
        return this.burnAnnotation;
    }

    public void setBurnAnnotation(boolean bl2) {
        this.burnAnnotation = bl2;
    }

    public void applyDefaults() {
        this.setAeTitle("AE_PRINTER");
        this.setPort("104");
        this.setDescription("DICOM Printer");
    }

    public void setForceBW(boolean bl2) {
        this.forceBW = bl2;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String string) {
        this.config = string;
    }

    public String getMinDensity() {
        return this.minDensity;
    }

    public void setMinDensity(String string) {
        this.minDensity = string;
    }

    public String getMaxDensity() {
        return this.maxDensity;
    }

    public void setMaxDensity(String string) {
        this.maxDensity = string;
    }

    public String getEmptyDensity() {
        return this.emptyDensity;
    }

    public void setEmptyDensity(String string) {
        this.emptyDensity = string;
    }

    public String getAeTitle() {
        return this.aeTitle;
    }

    public void setAeTitle(String string) {
        this.aeTitle = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public int getCopies() {
        return this.copies;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public static ArrayList<DicomPrinter> loadPrinters() {
        return DicomPrintersPrefs.allDicomPrinters.getValue();
    }

    public DicomObject getInfo() {
        DcmPrint dcmPrint = new DcmPrint();
        return dcmPrint.getInfo(this.toUrl());
    }

    public static String getNameFromInfo(DicomObject dicomObject) {
        String string = dicomObject.getString(554696752);
        if (string == null || string.equals("")) {
            string = "Unknown";
        }
        return string;
    }

    public static String getStatusFromInfo(DicomObject dicomObject) {
        String string = dicomObject.getString(0x21100010);
        if (string == null || string.equals("")) {
            string = "Unknown";
        }
        return string;
    }

    public static String getStatusDescFromInfo(DicomObject dicomObject) {
        String string = dicomObject.getString(0x21100020);
        if (string == null || string.equals("")) {
            string = "Unknown";
        }
        return string;
    }

    public static JComponent runTest(final String string, final String string2, final int n2, String string3, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(props.getProperty("DCM_PRINT_PING"), 4);
        final JLabel jLabel2 = new JLabel(props.getProperty("DCM_PRINT_PENDING"));
        JLabel jLabel3 = new JLabel(props.getProperty("DCM_PRINT_CONNECT"), 4);
        final JLabel jLabel4 = new JLabel(props.getProperty("DCM_PRINT_PENDING"));
        JLabel jLabel5 = new JLabel(props.getProperty("DCM_PRINT_NAME"), 4);
        final JLabel jLabel6 = new JLabel(props.getProperty("DCM_PRINT_PENDING"));
        JLabel jLabel7 = new JLabel(props.getProperty("DCM_PRINT_STATUS"), 4);
        final JLabel jLabel8 = new JLabel(props.getProperty("DCM_PRINT_PENDING"));
        JLabel jLabel9 = new JLabel(props.getProperty("DCM_PRINT_EXPL"), 4);
        final JLabel jLabel10 = new JLabel(props.getProperty("DCM_PRINT_PENDING"));
        JButton jButton = new JButton(string3, ImageManipulator.c("x_red", 16));
        jButton.addActionListener(actionListener);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridy -= 4;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel10, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jButton, gridBagConstraints);
        Thread thread = new Thread(){

            @Override
            public void run() {
                boolean bl2;
                InetAddress inetAddress;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jLabel2.setText(props.getProperty("DCM_PRINT_TESTING"));
                    }
                });
                try {
                    inetAddress = InetAddress.getByName(string);
                    bl2 = DicomPrinter.testPing(string);
                }
                catch (UnknownHostException unknownHostException) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jLabel2.setText(props.getProperty("DCM_PRINT_UNKNOWN_HOST"));
                            jLabel2.setForeground(Color.RED);
                            jLabel4.setText(props.getProperty("DCM_PRINT_FAIL"));
                            jLabel4.setForeground(Color.RED);
                            jLabel6.setText(props.getProperty("DCM_PRINT_RETRIEVE_FAIL"));
                            jLabel6.setForeground(Color.RED);
                            jLabel8.setText(props.getProperty("DCM_PRINT_RETRIEVE_FAIL"));
                            jLabel8.setForeground(Color.RED);
                            jLabel10.setText(props.getProperty("DCM_PRINT_RETRIEVE_FAIL"));
                            jLabel10.setForeground(Color.RED);
                        }
                    });
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (bl2) {
                            jLabel2.setText(props.getProperty("DCM_PRINT_SUCCESS"));
                            jLabel2.setForeground(Color.GREEN);
                        } else {
                            jLabel2.setText(props.getProperty("DCM_PRINT_HOST_FAIL"));
                            jLabel2.setForeground(Color.RED);
                        }
                        jLabel4.setText(props.getProperty("DCM_PRINT_TESTING"));
                    }
                });
                final DcmPrint dcmPrint = new DcmPrint();
                dcmPrint.addStatusListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        jLabel4.setText("<html>" + dcmPrint.getStatus() + "</html>");
                    }
                });
                MIMDcmUrl mIMDcmUrl = DicomPrinter.toUrl(string2, inetAddress.getHostName(), n2);
                final DicomObject dicomObject = dcmPrint.getInfo(mIMDcmUrl);
                if (dicomObject == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jLabel4.setForeground(Color.RED);
                            jLabel6.setText(props.getProperty("DCM_PRINT_RETRIEVE_FAIL"));
                            jLabel6.setForeground(Color.RED);
                            jLabel8.setText(props.getProperty("DCM_PRINT_RETRIEVE_FAIL"));
                            jLabel8.setForeground(Color.RED);
                            jLabel10.setText(props.getProperty("DCM_PRINT_RETRIEVE_FAIL"));
                            jLabel10.setForeground(Color.RED);
                        }
                    });
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = DicomPrinter.getNameFromInfo(dicomObject);
                        String string2 = DicomPrinter.getStatusFromInfo(dicomObject);
                        String string3 = DicomPrinter.getStatusDescFromInfo(dicomObject);
                        jLabel4.setText(props.getProperty("DCM_PRINT_SUCCESS"));
                        jLabel4.setForeground(Color.GREEN);
                        jLabel6.setText(string);
                        jLabel8.setText(string2);
                        jLabel8.setForeground(Color.RED);
                        if (jLabel8.getText().equalsIgnoreCase("NORMAL")) {
                            jLabel8.setForeground(Color.GREEN);
                        }
                        jLabel10.setText(string3);
                    }
                });
            }
        };
        thread.start();
        return jPanel;
    }

    private static boolean testPing(String string) {
        return GenericTestJDialog.testPing(string);
    }

    public static void savePrinters(List<DicomPrinter> list) {
        DicomPrintersPrefs.allDicomPrinters.setValue(list);
    }

    public boolean getCollated() {
        return this.collated;
    }

    public boolean validate() {
        return true;
    }

    public String getDescription() {
        return this.description;
    }

    public static Messages getProps() {
        return props;
    }

    public static void setProps(Messages messages) {
        props = messages;
    }

    public static Map<Class<? extends al>, Boolean> getEditablemap() {
        return editableMap;
    }

    public static void setEditablemap(Map<Class<? extends al>, Boolean> map) {
        editableMap = map;
    }

    public void setCopies(int n2) {
        this.copies = n2;
    }

    public void setJobPriority(DicomPrintersPrefs.Priority priority) {
        this.jobPriority = priority;
    }

    public void setFilmOrientation(DicomPrintersPrefs.Orientation orientation) {
        this.filmOrientation = orientation;
    }

    public void setSheetFormat(DicomPrintersPrefs.SheetFormat sheetFormat) {
        this.sheetFormat = sheetFormat;
    }

    public void setMedium(DicomPrintersPrefs.Medium medium) {
        this.medium = medium;
    }

    public void setDestination(DicomPrintersPrefs.Destination destination) {
        this.destination = destination;
    }

    public void setMagType(DicomPrintersPrefs.MagType magType) {
        this.magType = magType;
    }

    public void setTrim(DicomPrintersPrefs.Trim trim) {
        this.trim = trim;
    }

    public void setFilmSize(DicomPrintersPrefs.Size size) {
        this.filmSize = size;
    }

    public void setResolution(DicomPrintersPrefs.Resolution resolution) {
        this.resolution = resolution;
    }

    public void setSmoothing(DicomPrintersPrefs.SmoothingType smoothingType) {
        this.smoothing = smoothingType;
    }

    public void setBorder(DicomPrintersPrefs.Border border) {
        this.border = border;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.aeTitle == null ? 0 : this.aeTitle.hashCode());
        n3 = 31 * n3 + (this.border == null ? 0 : this.border.hashCode());
        n3 = 31 * n3 + (this.burnAnnotation ? 1231 : 1237);
        n3 = 31 * n3 + (this.collated ? 1231 : 1237);
        n3 = 31 * n3 + (this.config == null ? 0 : this.config.hashCode());
        n3 = 31 * n3 + this.copies;
        n3 = 31 * n3 + (this.description == null ? 0 : this.description.hashCode());
        n3 = 31 * n3 + (this.destination == null ? 0 : this.destination.hashCode());
        n3 = 31 * n3 + (this.emptyDensity == null ? 0 : this.emptyDensity.hashCode());
        n3 = 31 * n3 + (this.filmOrientation == null ? 0 : this.filmOrientation.hashCode());
        n3 = 31 * n3 + (this.filmSize == null ? 0 : this.filmSize.hashCode());
        n3 = 31 * n3 + (this.forceBW ? 1231 : 1237);
        n3 = 31 * n3 + (this.host == null ? 0 : this.host.hashCode());
        n3 = 31 * n3 + (this.jobPriority == null ? 0 : this.jobPriority.hashCode());
        n3 = 31 * n3 + (this.magType == null ? 0 : this.magType.hashCode());
        n3 = 31 * n3 + (this.maxDensity == null ? 0 : this.maxDensity.hashCode());
        n3 = 31 * n3 + (this.medium == null ? 0 : this.medium.hashCode());
        n3 = 31 * n3 + (this.minDensity == null ? 0 : this.minDensity.hashCode());
        n3 = 31 * n3 + (this.port == null ? 0 : this.port.hashCode());
        n3 = 31 * n3 + (this.resolution == null ? 0 : this.resolution.hashCode());
        n3 = 31 * n3 + (this.sheetFormat == null ? 0 : this.sheetFormat.hashCode());
        n3 = 31 * n3 + (this.smoothing == null ? 0 : this.smoothing.hashCode());
        n3 = 31 * n3 + (this.trim == null ? 0 : this.trim.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DicomPrinter dicomPrinter = (DicomPrinter)object;
        if (this.aeTitle == null ? dicomPrinter.aeTitle != null : !this.aeTitle.equals(dicomPrinter.aeTitle)) {
            return false;
        }
        if (this.border != dicomPrinter.border) {
            return false;
        }
        if (this.burnAnnotation != dicomPrinter.burnAnnotation) {
            return false;
        }
        if (this.collated != dicomPrinter.collated) {
            return false;
        }
        if (this.config == null ? dicomPrinter.config != null : !this.config.equals(dicomPrinter.config)) {
            return false;
        }
        if (this.copies != dicomPrinter.copies) {
            return false;
        }
        if (this.description == null ? dicomPrinter.description != null : !this.description.equals(dicomPrinter.description)) {
            return false;
        }
        if (this.destination != dicomPrinter.destination) {
            return false;
        }
        if (this.emptyDensity == null ? dicomPrinter.emptyDensity != null : !this.emptyDensity.equals(dicomPrinter.emptyDensity)) {
            return false;
        }
        if (this.filmOrientation != dicomPrinter.filmOrientation) {
            return false;
        }
        if (this.filmSize != dicomPrinter.filmSize) {
            return false;
        }
        if (this.forceBW != dicomPrinter.forceBW) {
            return false;
        }
        if (this.host == null ? dicomPrinter.host != null : !this.host.equals(dicomPrinter.host)) {
            return false;
        }
        if (this.jobPriority != dicomPrinter.jobPriority) {
            return false;
        }
        if (this.magType != dicomPrinter.magType) {
            return false;
        }
        if (this.maxDensity == null ? dicomPrinter.maxDensity != null : !this.maxDensity.equals(dicomPrinter.maxDensity)) {
            return false;
        }
        if (this.medium != dicomPrinter.medium) {
            return false;
        }
        if (this.minDensity == null ? dicomPrinter.minDensity != null : !this.minDensity.equals(dicomPrinter.minDensity)) {
            return false;
        }
        if (this.port == null ? dicomPrinter.port != null : !this.port.equals(dicomPrinter.port)) {
            return false;
        }
        if (this.resolution != dicomPrinter.resolution) {
            return false;
        }
        if (this.sheetFormat != dicomPrinter.sheetFormat) {
            return false;
        }
        if (this.smoothing != dicomPrinter.smoothing) {
            return false;
        }
        return this.trim == dicomPrinter.trim;
    }

    public DicomPrintersPrefs.Priority getJobPriority() {
        return this.jobPriority;
    }

    public DicomPrintersPrefs.Orientation getFilmOrientation() {
        return this.filmOrientation;
    }

    public DicomPrintersPrefs.SheetFormat getSheetFormat() {
        return this.sheetFormat;
    }

    public DicomPrintersPrefs.Medium getMedium() {
        return this.medium;
    }

    public DicomPrintersPrefs.Destination getDestination() {
        return this.destination;
    }

    public DicomPrintersPrefs.MagType getMagType() {
        return this.magType;
    }

    public DicomPrintersPrefs.Trim getTrim() {
        return this.trim;
    }

    public DicomPrintersPrefs.Size getFilmSize() {
        return this.filmSize;
    }

    public DicomPrintersPrefs.Resolution getResolution() {
        return this.resolution;
    }

    public DicomPrintersPrefs.SmoothingType getSmoothing() {
        return this.smoothing;
    }

    public DicomPrintersPrefs.Border getBorder() {
        return this.border;
    }

    @Override
    public String getUniqueId() {
        return this.uniqueId;
    }

    static {
        editableMap.put(DicomPrintersPrefs.Orientation.class, false);
        editableMap.put(DicomPrintersPrefs.Priority.class, false);
        editableMap.put(DicomPrintersPrefs.Border.class, false);
        editableMap.put(DicomPrintersPrefs.Trim.class, false);
        editableMap.put(DicomPrintersPrefs.SmoothingType.class, false);
        editableMap.put(DicomPrintersPrefs.MagType.class, false);
        editableMap.put(DicomPrintersPrefs.Resolution.class, false);
        editableMap.put(DicomPrintersPrefs.Destination.class, true);
        editableMap.put(DicomPrintersPrefs.Size.class, true);
        editableMap.put(DicomPrintersPrefs.Medium.class, false);
        editableMap.put(DicomPrintersPrefs.SheetFormat.class, true);
    }
}

