/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.printer;

import com.google.common.collect.Lists;
import com.mimvista.dicom.devices.printer.DicomPrinter;
import com.mimvista.dicom.devices.printer.PrinterConfigPane;
import com.mimvista.gui.util.c;
import com.mimvista.preferencesNew.DicomPrintersPrefs;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;

public class PrinterConfigDialog {
    public static Messages props = Messages.a("Printer");
    private DicomPrinter printer;
    private PrinterConfigPane printerConfigPane;
    private List<ActionListener> saveListeners = new ArrayList<ActionListener>();
    private JDialog dialog;

    public PrinterConfigDialog(Window window, DicomPrinter dicomPrinter) {
        this.dialog = new JDialog(window, props.getProperty("PRINT_CONFIG_DIA_TITLE"), Dialog.ModalityType.APPLICATION_MODAL);
        this.printer = dicomPrinter;
        this.build();
    }

    private void build() {
        this.dialog.setLayout(new GridBagLayout());
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setResizable(false);
        JButton jButton = c.c(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrinterConfigDialog.this.printerConfigPane.validateCurrent()) {
                    PrinterConfigDialog.this.printerConfigPane.save();
                    DicomPrintersPrefs.allDicomPrinters.setValue(Lists.newArrayList((Object[])new DicomPrinter[]{PrinterConfigDialog.this.printer}));
                    PrinterConfigDialog.this.fireSaveEvent();
                    PrinterConfigDialog.this.dialog.dispose();
                }
            }
        }, props.getProperty("PRINT_CONFIG_DIA_SAVE_SETTINGS"));
        JButton jButton2 = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterConfigDialog.this.dialog.dispose();
            }
        }, props.getProperty("PRINT_CONFIG_DIA_DISCARD"));
        this.printerConfigPane = new PrinterConfigPane();
        this.printerConfigPane.load(this.printer);
        JComponent jComponent = this.printerConfigPane.getPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.dialog.add((Component)jComponent, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        this.dialog.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.dialog.add((Component)jButton2, gridBagConstraints);
    }

    private void fireSaveEvent() {
        for (ActionListener actionListener : this.saveListeners) {
            actionListener.actionPerformed(new ActionEvent(this, 1001, props.getProperty("PRINT_CONFIG_DIA_SAVE")));
        }
    }

    public void addSaveListener(ActionListener actionListener) {
        this.saveListeners.add(actionListener);
    }

    public void show() {
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public static void main(String[] stringArray) {
        new PrinterConfigDialog(null, new DicomPrinter("")).show();
    }
}

