/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.printer;

import com.mimvista.dicom.devices.printer.DicomPrinter;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.preferencesNew.DicomPrintersPrefs;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PrinterConfigPane {
    public static Messages props = Messages.a("Printer");
    private DicomPrinter printer = null;
    private JComponent panel;
    private JTextField descFld;
    private JTextField aeFld;
    private JTextField hostFld;
    private JTextField portFld;
    private JComboBox destCombo;
    private JComboBox trimCombo;
    private JComboBox rezCombo;
    private JComboBox magCombo;
    private JComboBox smoothCombo;
    private JTextField configFld;
    private JComboBox borderCombo;
    private JComboBox sizeCombo;
    private JComboBox mediumCombo;
    private JTextField minDFld;
    private JTextField maxDFld;
    private JTextField emptyDFld;
    private JCheckBox grayChk;

    public void clear() {
        this.descFld.setText("");
        this.aeFld.setText("");
        this.hostFld.setText("");
        this.portFld.setText("");
        this.printer = null;
    }

    public void save() {
        if (this.printer == null) {
            return;
        }
        this.printer.setDescription(this.descFld.getText());
        this.printer.setAeTitle(this.aeFld.getText());
        this.printer.setHost(this.hostFld.getText());
        this.printer.setPort(this.portFld.getText());
        this.printer.setMedium((DicomPrintersPrefs.Medium)this.mediumCombo.getSelectedItem());
        this.printer.setDestination((DicomPrintersPrefs.Destination)this.destCombo.getSelectedItem());
        this.printer.setFilmSize((DicomPrintersPrefs.Size)this.sizeCombo.getSelectedItem());
        this.printer.setMagType((DicomPrintersPrefs.MagType)this.magCombo.getSelectedItem());
        this.printer.setTrim((DicomPrintersPrefs.Trim)this.trimCombo.getSelectedItem());
        this.printer.setResolution((DicomPrintersPrefs.Resolution)this.rezCombo.getSelectedItem());
        this.printer.setSmoothing((DicomPrintersPrefs.SmoothingType)this.smoothCombo.getSelectedItem());
        this.printer.setBorder((DicomPrintersPrefs.Border)this.borderCombo.getSelectedItem());
        this.printer.setConfig(this.configFld.getText());
        this.printer.setMinDensity(this.minDFld.getText());
        this.printer.setMaxDensity(this.maxDFld.getText());
        this.printer.setEmptyDensity(this.emptyDFld.getText());
        this.printer.setForceBW(this.grayChk.isSelected());
    }

    public void load(DicomPrinter dicomPrinter) {
        this.printer = dicomPrinter;
        this.descFld.setText(this.printer.getDescription());
        this.aeFld.setText(this.printer.getAeTitle());
        this.hostFld.setText(this.printer.getHost());
        this.portFld.setText(this.printer.getPort());
        this.mediumCombo.setSelectedItem(this.printer.getMedium());
        this.destCombo.setSelectedItem(this.printer.getDestination());
        this.sizeCombo.setSelectedItem(this.printer.getFilmSize());
        this.magCombo.setSelectedItem(this.printer.getMagType());
        this.trimCombo.setSelectedItem(this.printer.getTrim());
        this.rezCombo.setSelectedItem(this.printer.getResolution());
        this.smoothCombo.setSelectedItem(this.printer.getSmoothing());
        this.configFld.setText(this.printer.getConfig());
        this.minDFld.setText(this.printer.getMinDensity());
        this.maxDFld.setText(this.printer.getMaxDensity());
        this.emptyDFld.setText(this.printer.getEmptyDensity());
        this.grayChk.setSelected(this.printer.isForceBW());
        this.borderCombo.setSelectedItem(this.printer.getBorder());
    }

    public PrinterConfigPane() {
        this.build();
    }

    public JComponent getPanel() {
        return this.panel;
    }

    private void populateCombos() {
        for (DicomPrintersPrefs.Destination enum_ : DicomPrintersPrefs.Destination.values()) {
            this.destCombo.addItem(enum_);
            this.destCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Destination.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.Trim.values()) {
            this.trimCombo.addItem(enum_);
            this.trimCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Trim.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.Resolution.values()) {
            this.rezCombo.addItem(enum_);
            this.rezCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Resolution.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.MagType.values()) {
            this.magCombo.addItem(enum_);
            this.magCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.MagType.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.SmoothingType.values()) {
            this.smoothCombo.addItem(enum_);
            this.smoothCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.SmoothingType.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.Border.values()) {
            this.borderCombo.addItem(enum_);
            this.borderCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Border.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.Size.values()) {
            this.sizeCombo.addItem(enum_);
            this.sizeCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Size.class));
        }
        for (Enum enum_ : DicomPrintersPrefs.Medium.values()) {
            this.mediumCombo.addItem(enum_);
            this.mediumCombo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Medium.class));
        }
    }

    private void build() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.panel = jTabbedPane;
        final JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jTabbedPane.addTab(props.getProperty("PRINT_CONFIG_PANE_BASIC"), jPanel);
        jTabbedPane.addTab(props.getProperty("PRINT_CONFIG_PANE_ADVANCED"), jPanel2);
        JLabel jLabel = new JLabel(props.getProperty("PRINT_CONFIG_PANE_DESCRIPTION"), 4);
        this.descFld = new JTextField(10);
        JLabel jLabel2 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_AE"), 4);
        this.aeFld = new JTextField(10);
        JLabel jLabel3 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_HOST_OR_IP"), 4);
        this.hostFld = new JTextField(10);
        JLabel jLabel4 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_PORT"), 4);
        this.portFld = new JTextField(5);
        JLabel jLabel5 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_DESTINATION"), 4);
        this.destCombo = new JComboBox();
        JLabel jLabel6 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_RES"), 4);
        this.rezCombo = new JComboBox();
        JLabel jLabel7 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_MAG"), 4);
        this.magCombo = new JComboBox();
        JLabel jLabel8 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_SMOOTHING"), 4);
        this.smoothCombo = new JComboBox();
        JLabel jLabel9 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_TRIM"), 4);
        this.trimCombo = new JComboBox();
        JLabel jLabel10 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_CONFIG"), 4);
        this.configFld = new JTextField(10);
        JLabel jLabel11 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_BORDER"), 4);
        this.borderCombo = new JComboBox();
        JLabel jLabel12 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_FILM"), 4);
        this.sizeCombo = new JComboBox();
        JLabel jLabel13 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_MED_TYPE"), 4);
        this.mediumCombo = new JComboBox();
        this.grayChk = new JCheckBox(props.getProperty("PRINT_CONFIG_PANE_GRAY"));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(props.getProperty("PRINT_CONFIG_PANE_DENSITY")));
        JLabel jLabel14 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_UNIT"));
        JLabel jLabel15 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_MIN"), 4);
        JLabel jLabel16 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_MAX"), 4);
        JLabel jLabel17 = new JLabel(props.getProperty("PRINT_CONFIG_PANE_EMPTY"), 4);
        this.minDFld = new JTextField(5);
        this.maxDFld = new JTextField(5);
        this.emptyDFld = new JTextField(5);
        final JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel3.add((Component)jLabel14, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)jLabel15, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)this.minDFld, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)jLabel16, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)this.maxDFld, gridBagConstraints);
        gridBagConstraints.gridx -= 3;
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)jLabel17, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel3.add((Component)this.emptyDFld, gridBagConstraints);
        this.populateCombos();
        JButton jButton = new JButton(props.getProperty("PRINT_CONFIG_PANE_TEST"), ImageManipulator.c("monitor_network", 16));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrinterConfigPane.this.validateCurrent()) {
                    jScrollPane.setViewportView(DicomPrinter.runTest(PrinterConfigPane.this.hostFld.getText(), PrinterConfigPane.this.aeFld.getText(), Integer.valueOf(PrinterConfigPane.this.portFld.getText()), props.getProperty("PRINT_CONFIG_PANE_CLOSE"), new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jScrollPane.setVisible(false);
                            jScrollPane.setViewportView(null);
                        }
                    }));
                    jScrollPane.setVisible(true);
                    jPanel.revalidate();
                    jScrollPane.revalidate();
                }
            }
        });
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        jPanel.add((Component)jLabel, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 1.0;
        jPanel.add((Component)this.descFld, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 1.0;
        jPanel.add((Component)this.aeFld, gridBagConstraints2);
        gridBagConstraints2.gridx -= 3;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weightx = 0.0;
        jPanel.add((Component)jLabel3, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.hostFld, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)jLabel4, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.portFld, gridBagConstraints2);
        gridBagConstraints2.gridx -= 3;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.fill = 0;
        jPanel.add((Component)jButton, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.fill = 1;
        jPanel.add((Component)jScrollPane, gridBagConstraints2);
        jPanel.add(Box.createVerticalGlue(), gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridwidth = 1;
        gridBagConstraints2.weighty = 0.0;
        jPanel2.add((Component)jLabel5, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.destCombo, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)jLabel6, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.rezCombo, gridBagConstraints2);
        gridBagConstraints2.gridx -= 3;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)jLabel7, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.magCombo, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)jLabel8, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.smoothCombo, gridBagConstraints2);
        gridBagConstraints2.gridx -= 3;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)jLabel9, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.trimCombo, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)jLabel10, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.configFld, gridBagConstraints2);
        gridBagConstraints2.gridx -= 3;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)jLabel11, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.borderCombo, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)jLabel12, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.sizeCombo, gridBagConstraints2);
        gridBagConstraints2.gridx -= 3;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)jLabel13, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        jPanel2.add((Component)this.mediumCombo, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.gridwidth = 2;
        jPanel2.add((Component)this.grayChk, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.gridx -= 2;
        gridBagConstraints2.gridwidth = 4;
        gridBagConstraints2.fill = 0;
        jPanel2.add((Component)jPanel3, gridBagConstraints2);
    }

    public boolean validateCurrent() {
        try {
            int n2 = Integer.valueOf(this.portFld.getText());
            if (n2 < 1) {
                throw new Exception("Bad port");
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.panel, props.getProperty("PRINT_CONFIG_PANE_POS"));
            return false;
        }
        return true;
    }
}

