/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.devices.printer;

import com.mimvista.archive.Parser;
import com.mimvista.dicom.DicomImageConverter;
import com.mimvista.dicom.devices.printer.DcmPrint;
import com.mimvista.dicom.devices.printer.DicomPrinter;
import com.mimvista.dicom.devices.printer.PrinterConfigDialog;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.MIMFile;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.c;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.DicomPrintersPrefs;
import com.mimvista.preferencesNew.PrintPrefs;
import com.mimvista.properties.ab;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.ProgressPanel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.color.ColorSpace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class PrinterControl {
    public static Messages props = Messages.a("Printer");
    private boolean singleFile = true;
    private List<DicomPrinter> printers;
    public static final String TITLE = "Print DICOM";
    private DicomObject[] datasets;
    private boolean askAnnotate = false;
    private JDialog dialog;
    private JComboBox printerCmbo;
    private JButton configBtn;
    private JCheckBox collateChk;
    private JTextField copiesFld;
    private JComboBox prioCmbo;
    private JComboBox orientCmbo;
    private JCheckBox annotateChk;
    private JComboBox formCmbo;
    private JLabel statusTxt;
    private JLabel typeTxt;
    private JButton deleteBtn;
    private JButton printBtn;
    private FuncUtils.m<Boolean> printCallback;
    private ArrayList<Runnable> callBacks = new ArrayList();
    InputNotification inputNoti;

    public PrinterControl(Window window, MIMFile[] mIMFileArray, boolean bl2) {
        this.datasets = PrinterControl.loadDicomObjectsFromFiles(window, mIMFileArray);
        if (bl2) {
            for (int i2 = 0; i2 < mIMFileArray.length; ++i2) {
                if (mIMFileArray[i2] == null) continue;
                mIMFileArray[i2].delete();
            }
        }
        this.init(window, this.datasets);
    }

    public PrinterControl(Window window, DicomObject[] dicomObjectArray) {
        this.init(window, dicomObjectArray);
    }

    public void addCallback(Runnable runnable) {
        this.callBacks.add(runnable);
    }

    public void setPrintCallback(FuncUtils.m<Boolean> m2) {
        this.printCallback = m2;
    }

    private void init(Window window, DicomObject[] dicomObjectArray) {
        this.dialog = new JDialog(window);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (PrinterControl.this.printerCmbo.getSelectedItem() != null) {
                    PrinterControl.this.loadFieldsIntoPrinter((DicomPrinter)PrinterControl.this.printerCmbo.getSelectedItem());
                    DicomPrinter.savePrinters(PrinterControl.this.printers);
                }
            }
        });
        this.datasets = dicomObjectArray;
        if (this.datasets.length > 1) {
            this.singleFile = false;
        }
        this.checkForAnnotate();
        this.build();
    }

    private void checkForAnnotate() {
        for (DicomObject dicomObject : this.datasets) {
            if (PrinterControl.hasAnnotation(dicomObject)) continue;
            this.askAnnotate = true;
            return;
        }
    }

    private void runCallbacks() {
        for (Runnable runnable : this.callBacks) {
            runnable.run();
        }
    }

    private void build() {
        this.printCallback = null;
        this.dialog.setLayout(new GridBagLayout());
        this.dialog.setTitle(props.getProperty("PRINTER_CTRL_TITLE"));
        this.dialog.setDefaultCloseOperation(2);
        JLabel jLabel = new JLabel(this.datasets.length + (this.datasets.length == 1 ? " " + props.getProperty("PRINTER_CTRL_READY") : " " + props.getProperty("PRINTER_CTRL_READY_PL")), 0);
        JLabel jLabel2 = new JLabel(props.getProperty("PRINTER_CTRL_DESCRIPTION"));
        JLabel jLabel3 = new JLabel(props.getProperty("PRINTER_CTRL_STATUS"));
        JLabel jLabel4 = new JLabel(props.getProperty("PRINTER_CTRL_TYPE"));
        this.statusTxt = new JLabel("");
        this.typeTxt = new JLabel("");
        this.printerCmbo = new JComboBox();
        this.printerCmbo.setPrototypeDisplayValue("Awesome DICOM Printer");
        this.printerCmbo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PrinterControl.this.printerCmbo.getSelectedItem() != null) {
                    PrinterControl.this.printerCmbo.setEnabled(true);
                    PrinterControl.this.configBtn.setEnabled(true);
                    PrinterControl.this.deleteBtn.setEnabled(true);
                    PrinterControl.this.printBtn.setEnabled(true);
                } else {
                    PrinterControl.this.printerCmbo.setEnabled(false);
                    PrinterControl.this.configBtn.setEnabled(false);
                    PrinterControl.this.deleteBtn.setEnabled(false);
                    PrinterControl.this.printBtn.setEnabled(false);
                }
                PrinterControl.this.refreshData();
            }
        });
        this.configBtn = new JButton(props.getProperty("PRINTER_CTRL_CONFIG"), ImageManipulator.c("ui_settings", 16));
        this.configBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DicomPrinter dicomPrinter = PrinterControl.this.getCurrentSelectedPrinter();
                Messages messages = Messages.a("PropertyCollectionFactory");
                if (MIMContext.j()) {
                    ab.a(dicomPrinter.getDescription(), true);
                } else if (MIMContext.h()) {
                    ab.a(messages.getProperty("PROPERTYCOLL_FACT_DICOM_PRINTERS"), dicomPrinter.getDescription(), true);
                } else {
                    PrinterControl.this.setupSinglePrinter();
                }
                PrinterControl.this.loadPrinters();
                PrinterControl.this.refreshData();
            }
        });
        JButton jButton = new JButton(props.getProperty("PRINTER_CTRL_NEW"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Messages messages = Messages.a("PropertyCollectionFactory");
                if (MIMContext.j()) {
                    ab.a(messages.getProperty("PROPERTYCOLL_FACT_DICOM_PRINTERS"), true);
                } else {
                    ab.b(messages.getProperty("PROPERTYCOLL_FACT_DICOM_PRINTERS"), true);
                }
                PrinterControl.this.loadPrinters();
                PrinterControl.this.refreshData();
            }
        });
        this.deleteBtn = new JButton(props.getProperty("PRINTER_CTRL_DELETE"), ImageManipulator.c("subtract", 18));
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n2 = JOptionPane.showConfirmDialog(PrinterControl.this.dialog, props.getProperty("PRINTER_CTRL_DELETE_CONFIRM"), props.getProperty("PRINTER_CTRL_DELETE_TITLE"), 0);
                if (n2 == 0) {
                    PrinterControl.this.deletePrinter((DicomPrinter)PrinterControl.this.printerCmbo.getSelectedItem());
                }
            }
        });
        JLabel jLabel5 = new JLabel(props.getProperty("PRINTER_CTRL_NUM"));
        this.copiesFld = new JTextField(3);
        this.copiesFld.setText("1");
        this.collateChk = new JCheckBox(props.getProperty("PRINTER_CTRL_COLLATE"), false);
        this.collateChk.setEnabled(false);
        this.copiesFld.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (Integer.valueOf(PrinterControl.this.copiesFld.getText()) > 1 && !PrinterControl.this.singleFile) {
                        PrinterControl.this.collateChk.setEnabled(true);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PrinterControl.this.collateChk.setEnabled(false);
            }
        });
        JLabel jLabel6 = new JLabel(props.getProperty("PRINTER_CTRL_ORIENT"));
        JLabel jLabel7 = new JLabel(props.getProperty("PRINTER_CTRL_SHEET"));
        JLabel jLabel8 = new JLabel(props.getProperty("PRINTER_CTRL_PRIORITY"));
        this.orientCmbo = new JComboBox();
        this.formCmbo = new JComboBox();
        this.prioCmbo = new JComboBox();
        this.populateCombos();
        if (this.singleFile) {
            this.formCmbo.setEnabled(false);
            this.formCmbo.setSelectedIndex(1);
        }
        this.annotateChk = new JCheckBox(props.getProperty("PRINTER_CTRL_ANNOTATE"), true);
        if (!this.askAnnotate) {
            this.annotateChk.setEnabled(false);
            this.annotateChk.setSelected(false);
        }
        this.printBtn = new JButton(props.getProperty("PRINTER_CTRL_PRINT"), ImageManipulator.c("printer", 18));
        this.printBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterControl.this.doPrint();
                PrinterControl.this.runCallbacks();
            }
        });
        JButton jButton2 = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PrinterControl.this.dialog.dispose();
                PrinterControl.this.runCallbacks();
            }
        }, props.getProperty("PRINTER_CTRL_CANCEL"));
        this.loadPrinters();
        if (this.printerCmbo.getItemCount() > 0) {
            this.printerCmbo.setSelectedItem(DicomPrintersPrefs.lastPrinterUsed.getValue());
        } else {
            this.printerCmbo.setEnabled(false);
            this.configBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.printBtn.setEnabled(false);
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(props.getProperty("PRINTER_CTRL_PRINTER")));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(props.getProperty("PRINTER_CTRL_COPIES")));
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(props.getProperty("PRINTER_CTRL_OPTIONS")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        jPanel2.add((Component)jLabel5, gridBagConstraints);
        jPanel3.add((Component)jLabel6, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        jPanel2.add((Component)this.collateChk, gridBagConstraints);
        jPanel3.add((Component)jLabel7, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        jPanel3.add((Component)jLabel8, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel3.add((Component)this.annotateChk, gridBagConstraints);
        gridBagConstraints.gridy -= 3;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.printerCmbo, gridBagConstraints);
        jPanel2.add((Component)this.copiesFld, gridBagConstraints);
        jPanel3.add((Component)this.orientCmbo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.statusTxt, gridBagConstraints);
        jPanel3.add((Component)this.formCmbo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.typeTxt, gridBagConstraints);
        jPanel3.add((Component)this.prioCmbo, gridBagConstraints);
        gridBagConstraints.gridy -= 2;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.configBtn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.deleteBtn, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        --gridBagConstraints.gridy;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 3;
        this.dialog.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.dialog.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        this.dialog.add((Component)jPanel3, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.dialog.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.gridwidth = 1;
        this.dialog.add((Component)this.printBtn, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.dialog.add((Component)jButton2, gridBagConstraints);
        this.dialog.pack();
    }

    private void populateCombos() {
        for (DicomPrintersPrefs.Priority enum_ : DicomPrintersPrefs.Priority.values()) {
            this.prioCmbo.addItem(enum_);
        }
        this.prioCmbo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Priority.class));
        for (Enum enum_ : DicomPrintersPrefs.Orientation.values()) {
            this.orientCmbo.addItem(enum_);
        }
        this.orientCmbo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.Orientation.class));
        for (Enum enum_ : DicomPrintersPrefs.SheetFormat.values()) {
            this.formCmbo.addItem(enum_);
        }
        this.formCmbo.setEditable(DicomPrinter.editableMap.get(DicomPrintersPrefs.SheetFormat.class));
    }

    public void show() {
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
        this.dialog.setVisible(true);
        this.updateFields(this.getCurrentSelectedPrinter());
    }

    private void doPrint() {
        int n2;
        DicomPrinter dicomPrinter = this.getCurrentSelectedPrinter();
        if (dicomPrinter == null) {
            return;
        }
        if (!this.validate()) {
            return;
        }
        this.loadFieldsIntoPrinter(dicomPrinter);
        DicomPrinter.savePrinters(this.printers);
        if (this.datasets.length > 8 && dicomPrinter.getSheetFormat().getStringForPrefs().equals("STANDARD\\1,1") && (n2 = JOptionPane.showConfirmDialog(this.dialog, MIMFormat.a(props.getProperty("PRINTER_CTRL_CONFIRM"), this.datasets.length), props.getProperty("PRINTER_CTRL_LOTS"), 0)) != 0) {
            return;
        }
        DicomPrintersPrefs.lastPrinterUsed.setValue((DicomPrinter)this.printerCmbo.getSelectedItem());
        n2 = new DcmPrint().printWithDialog(dicomPrinter, this.datasets, this.dialog);
        if (n2 != 0) {
            this.dialog.dispose();
            if (this.inputNoti != null) {
                u.b().d(this.inputNoti);
            }
        }
        if (this.printCallback != null) {
            this.printCallback.doIt(n2 != 0);
        }
    }

    public void setExitDismiss(InputNotification inputNotification) {
        this.inputNoti = inputNotification;
    }

    private boolean validate() {
        boolean bl2 = false;
        try {
            int n2 = Integer.parseInt(this.copiesFld.getText());
            if (n2 < 1) {
                bl2 = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = true;
        }
        if (bl2) {
            JOptionPane.showMessageDialog(this.dialog, props.getProperty("PRINTER_CTRL_SPECIFY"), props.getProperty("PRINTER_CTRL_INVALID"), 0);
        }
        return !bl2;
    }

    private void loadFieldsIntoPrinter(DicomPrinter dicomPrinter) {
        dicomPrinter.setCopies(Integer.parseInt(this.copiesFld.getText()));
        dicomPrinter.setJobPriority((DicomPrintersPrefs.Priority)this.prioCmbo.getSelectedItem());
        dicomPrinter.setFilmOrientation((DicomPrintersPrefs.Orientation)this.orientCmbo.getSelectedItem());
        if (this.singleFile) {
            dicomPrinter.setSheetFormat(DicomPrintersPrefs.SheetFormat.b);
        } else {
            dicomPrinter.setCollated(this.collateChk.isSelected());
            dicomPrinter.setSheetFormat((DicomPrintersPrefs.SheetFormat)this.formCmbo.getSelectedItem());
        }
        dicomPrinter.setBurnAnnotation(this.annotateChk.isSelected());
    }

    private void refreshData() {
        DicomPrinter dicomPrinter = this.getCurrentSelectedPrinter();
        this.updateFields(dicomPrinter);
    }

    private void updateFields(final DicomPrinter dicomPrinter) {
        if (dicomPrinter == null) {
            this.statusTxt.setText("");
            this.typeTxt.setText("");
        } else {
            this.statusTxt.setText(props.getProperty("PRINTER_CTRL_CHECK"));
            this.typeTxt.setText("");
            this.copiesFld.setText(dicomPrinter.getCopies() + "");
            this.orientCmbo.setSelectedItem(dicomPrinter.getFilmOrientation());
            this.formCmbo.setSelectedItem(dicomPrinter.getSheetFormat());
            this.prioCmbo.setSelectedItem(dicomPrinter.getJobPriority());
            this.collateChk.setSelected(dicomPrinter.getCollated());
            this.annotateChk.setSelected(dicomPrinter.isBurnAnnotation());
            if (!this.dialog.isVisible()) {
                return;
            }
            new Thread(){

                @Override
                public void run() {
                    final DicomObject dicomObject = dicomPrinter.getInfo();
                    final boolean bl2 = dicomObject == null;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (bl2) {
                                PrinterControl.this.statusTxt.setText(props.getProperty("PRINTER_CTRL_CONTACT_FAIL"));
                            } else {
                                PrinterControl.this.statusTxt.setText(DicomPrinter.getStatusFromInfo(dicomObject) + ": " + DicomPrinter.getStatusDescFromInfo(dicomObject));
                                PrinterControl.this.typeTxt.setText(DicomPrinter.getNameFromInfo(dicomObject));
                            }
                        }
                    });
                }
            }.start();
        }
    }

    private DicomPrinter getCurrentSelectedPrinter() {
        return (DicomPrinter)this.printerCmbo.getSelectedItem();
    }

    private void setupSinglePrinter() {
        DicomPrinter dicomPrinter = this.getCurrentSelectedPrinter();
        if (dicomPrinter == null) {
            System.out.println("Can't setup a null printer...");
            return;
        }
        int n2 = this.printerCmbo.getSelectedIndex();
        PrinterConfigDialog printerConfigDialog = new PrinterConfigDialog(this.dialog, dicomPrinter);
        printerConfigDialog.show();
        this.loadPrinters();
        this.printerCmbo.setSelectedIndex(n2);
    }

    private void deletePrinter(DicomPrinter dicomPrinter) {
        this.printers.remove(dicomPrinter);
        DicomPrinter.savePrinters(this.printers);
        this.loadPrinters();
    }

    private void loadPrinters() {
        this.printerCmbo.removeAllItems();
        this.printers = DicomPrinter.loadPrinters();
        for (DicomPrinter dicomPrinter : this.printers) {
            this.printerCmbo.addItem(dicomPrinter);
        }
    }

    public static DicomObject removeExcessData(DicomObject dicomObject) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putNull(0x280002, VR.US);
        basicDicomObject.putNull(2621444, VR.CS);
        basicDicomObject.putNull(2621456, VR.US);
        basicDicomObject.putNull(2621457, VR.US);
        basicDicomObject.putNull(2621492, VR.IS);
        basicDicomObject.putNull(2621696, VR.US);
        basicDicomObject.putNull(2621697, VR.US);
        basicDicomObject.putNull(2621698, VR.US);
        basicDicomObject.putNull(2621699, VR.US);
        basicDicomObject.putNull(0x20200020, VR.CS);
        basicDicomObject.putNull(537919584, VR.CS);
        basicDicomObject.putNull(537919616, VR.CS);
        basicDicomObject.putNull(2145386512, VR.OW);
        basicDicomObject.putNull(2621446, VR.US);
        DicomObject dicomObject2 = dicomObject.subSet((DicomObject)basicDicomObject);
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        dicomObject2.copyTo((DicomObject)basicDicomObject2, false);
        return basicDicomObject2;
    }

    public static DicomObject readFileIntoDicomObjectAndScaleDataAppropriately(File file) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file);
        if (dicomObject != null) {
            PrinterControl.scalePixelDataTo12Bits(dicomObject);
        }
        return dicomObject;
    }

    public static DicomObject[] loadDicomObjectsFromFiles(Window window, MIMFile[] mIMFileArray) {
        Vector<File> vector = new Vector<File>();
        for (MIMFile mIMFile : mIMFileArray) {
            vector.addAll(mIMFile.b());
        }
        ProgressPanel progressPanel = new ProgressPanel();
        ProgressQueueNotification.a(progressPanel);
        progressPanel.b_(props.getProperty("PRINTER_CTRL_LOAD"));
        progressPanel.a(vector.size());
        DicomObject[] dicomObjectArray = new DicomObject[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            dicomObjectArray[i2] = PrinterControl.readFileIntoDicomObjectAndScaleDataAppropriately((File)vector.get(i2));
            progressPanel.b(i2);
            if (dicomObjectArray[i2] != null) continue;
            progressPanel.b();
            return null;
        }
        progressPanel.b(mIMFileArray.length);
        progressPanel.b();
        return dicomObjectArray;
    }

    public static void main(String[] stringArray) {
        new PrinterControl(null, new DicomObject[0]).show();
    }

    private static double scaleUpData(DicomObject dicomObject) {
        if (dicomObject.getInt(2621457, 0) >= 256 && dicomObject.getInt(2621456, 0) >= 256) {
            return 1.0;
        }
        BufferedImage bufferedImage = DicomImageConverter.toBufferedImage(dicomObject);
        int n2 = dicomObject.getInt(2621457, 1);
        double d2 = 512.0 / (double)n2;
        System.out.println("Scaling up data by " + d2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.scale(d2, d2);
        BufferedImage bufferedImage2 = new AffineTransformOp(affineTransform, 1).filter(bufferedImage, null);
        int[] nArray = PrinterControl.getPixels(bufferedImage2);
        PrinterControl.setPixels(nArray, dicomObject);
        dicomObject.putInt(2621457, VR.US, bufferedImage2.getWidth());
        dicomObject.putInt(2621456, VR.US, bufferedImage2.getHeight());
        return d2;
    }

    public static void writeMinimalTextOntoDicomObject(DicomObject dicomObject, int n2) {
        double d2 = PrinterControl.scaleUpData(dicomObject);
        System.out.println("Writing text");
        BufferedImage bufferedImage = DicomImageConverter.toBufferedImage(dicomObject);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        PrinterControl.setCorrectFont(bufferedImage, graphics2D, n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        PrinterControl.writeMinimalText(n3, dicomObject, graphics2D, bufferedImage, fontMetrics, d2);
        graphics2D.dispose();
        String string = dicomObject.getString(2621444);
        if (PrinterControl.isMonochrome(string)) {
            int[] nArray = PrinterControl.fixHighPixels(bufferedImage);
            PrinterControl.setPixels(nArray, dicomObject);
        } else {
            DicomImageConverter.putBufferedImage(dicomObject, bufferedImage);
        }
    }

    public static boolean hasAnnotation(DicomObject dicomObject) {
        boolean bl2 = false;
        if ("1.2.840.10008.5.1.4.1.1.7".equals(dicomObject.getString(524310))) {
            System.out.println("JA");
            String string = dicomObject.getString(2622209);
            if (string == null) {
                bl2 = true;
            } else if (!"no".equals(string.toLowerCase())) {
                bl2 = true;
            }
        }
        return bl2;
    }

    private static void writeMinimalText(int n2, DicomObject dicomObject, Graphics2D graphics2D, BufferedImage bufferedImage, FontMetrics fontMetrics, double d2) {
        int n3 = bufferedImage.getHeight() - fontMetrics.getDescent();
        int n4 = bufferedImage.getWidth();
        n3 = PrinterControl.drawTextRight(PrinterControl.createSlicePosString(dicomObject), graphics2D, n4, n3, -n2);
        n3 = PrinterControl.drawTextRight(PrinterControl.createInstanceString(dicomObject), graphics2D, n4, n3, -n2);
        PrinterControl.drawRuler(dicomObject, graphics2D, n3, bufferedImage.getWidth(), d2, bufferedImage.getHeight());
    }

    private static String createInstanceString(DicomObject dicomObject) {
        String string = dicomObject.getString(2097171);
        if (string == null) {
            return null;
        }
        return "i: " + string;
    }

    private static String createSlicePosString(DicomObject dicomObject) {
        String string = dicomObject.getString(2101313);
        if (string == null) {
            return null;
        }
        return "Im. No. " + string;
    }

    public static void writeAllTextOntoDicomObject(DicomObject dicomObject, int n2) {
        double d2 = PrinterControl.scaleUpData(dicomObject);
        System.out.println("Writing text");
        BufferedImage bufferedImage = DicomImageConverter.toBufferedImage(dicomObject);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        PrinterControl.setCorrectFont(bufferedImage, graphics2D, n2);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        PrinterControl.writeAllText(n3, dicomObject, graphics2D, bufferedImage, fontMetrics, d2);
        graphics2D.dispose();
        String string = dicomObject.getString(2621444);
        if (PrinterControl.isMonochrome(string)) {
            int[] nArray = PrinterControl.fixHighPixels(bufferedImage);
            PrinterControl.setPixels(nArray, dicomObject);
        } else {
            DicomImageConverter.putBufferedImage(dicomObject, bufferedImage);
        }
    }

    private static void writeAllText(int n2, DicomObject dicomObject, Graphics2D graphics2D, BufferedImage bufferedImage, FontMetrics fontMetrics, double d2) {
        AffineTransform affineTransform = PrinterControl.rotate90(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight());
        int n3 = bufferedImage.getHeight();
        int n4 = n2;
        String string = "";
        String string2 = dicomObject.getString(0x100010, (String)null);
        if (string2 != null) {
            string = Parser.formatName(string2);
        }
        if ((string2 = dicomObject.getString(0x100020, (String)null)) != null) {
            string = string + " " + string2;
        }
        if ((string2 = dicomObject.getString(0x100040, (String)null)) != null) {
            string = string + " " + string2;
        }
        PrinterControl.drawTextRight(string, graphics2D, n3, n4, -n2);
        n4 = bufferedImage.getWidth() - fontMetrics.getDescent();
        int n5 = bufferedImage.getWidth();
        n4 = PrinterControl.drawTagRight(dicomObject, graphics2D, n3, n4, -n2, 524416);
        n4 = PrinterControl.drawTextRight(PrinterControl.createModalityString(dicomObject), graphics2D, n3, n4, -n2);
        graphics2D.setTransform(affineTransform);
        n4 = bufferedImage.getHeight() - fontMetrics.getDescent();
        n4 = PrinterControl.drawTextLeft(PrinterControl.createWindowLevelString(dicomObject), graphics2D, n4, -n2);
        n4 = PrinterControl.drawTagLeft(dicomObject, graphics2D, n4, -n2, 524320);
        n4 = PrinterControl.drawTagLeft(dicomObject, graphics2D, n4, -n2, 528446);
        n4 = bufferedImage.getHeight() - fontMetrics.getDescent();
        n4 = PrinterControl.drawTextRight(PrinterControl.createSlicePosString(dicomObject), graphics2D, n5, n4, -n2);
        n4 = PrinterControl.drawTextRight(PrinterControl.createSeriesNumberString(dicomObject), graphics2D, n5, n4, -n2);
        PrinterControl.drawRuler(dicomObject, graphics2D, n4, bufferedImage.getWidth(), d2, bufferedImage.getHeight());
    }

    private static void drawRuler(DicomObject dicomObject, Graphics2D graphics2D, int n2, int n3, double d2, int n4) {
        float[] fArray = dicomObject.getFloats(2621488);
        if (fArray == null || fArray.length == 0) {
            System.out.println("No voxel size info");
            return;
        }
        int n5 = 0;
        while (n5 < fArray.length) {
            int n6 = n5++;
            fArray[n6] = (float)((double)fArray[n6] / d2);
        }
        double d3 = fArray[0];
        double d4 = 10.0 / d3;
        int n7 = 10;
        float f2 = 10.0f;
        while ((double)n7 * d4 > (double)(n2 / 2)) {
            d4 /= 2.0;
            f2 /= 2.0f;
        }
        while ((double)n7 * d4 < (double)(n2 / 4)) {
            d4 *= 2.0;
            f2 *= 2.0f;
        }
        PrinterControl.drawTextRightRotated(String.valueOf(f2) + " cm", graphics2D, (int)((double)n3 - d4 - 3.0), n2, n4, n3);
        double d5 = n2;
        int n8 = 2;
        if ((n3 -= 2) > 800 || n2 > 800) {
            n8 = 4;
        }
        graphics2D.setStroke(new BasicStroke(n8));
        graphics2D.drawLine(n3, (int)d5, (int)((double)n3 - d4), (int)d5);
        for (int i2 = 1; i2 < 11; ++i2) {
            graphics2D.drawLine(n3, (int)d5, n3, (int)(d5 - d4));
            d5 -= d4;
            if (i2 % 5 == 0) {
                graphics2D.drawLine(n3, (int)d5, (int)((double)n3 - d4), (int)d5);
                continue;
            }
            graphics2D.drawLine(n3, (int)d5, (int)((double)n3 - d4 / 3.0), (int)d5);
        }
    }

    private static void setCorrectFont(BufferedImage bufferedImage, Graphics2D graphics2D, int n2) {
        graphics2D.setXORMode(Color.black);
        int n3 = PrintPrefs.fontSize.getValue();
        if (bufferedImage.getWidth() > 800 || bufferedImage.getHeight() > 800) {
            n3 *= 2;
        }
        if (n2 > 6) {
            n3 += 4;
        }
        if (bufferedImage.getWidth() < 512) {
            n3 /= 2;
        }
        graphics2D.setFont(new Font("Dialog", 0, n3));
    }

    private static String createModalityString(DicomObject dicomObject) {
        String string = dicomObject.getString(524384);
        string = string != null ? string + " " : "";
        String string2 = dicomObject.getString(528400);
        if (string2 != null) {
            string = string + string2;
        }
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private static String createWindowLevelString(DicomObject dicomObject) {
        String string = dicomObject.getString(2625616);
        string = string != null ? "c: " + string + " " : "";
        String string2 = dicomObject.getString(2625617);
        string2 = string2 != null ? "w: " + string2 : "";
        String string3 = string + string2;
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    private static String createSeriesNumberString(DicomObject dicomObject) {
        String string = dicomObject.getString(0x200011);
        string = string != null ? "s: " + string + " " : "";
        String string2 = dicomObject.getString(2097171);
        string2 = string2 != null ? "i: " + string2 : "";
        String string3 = string + string2;
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    private static int drawTagRight(DicomObject dicomObject, Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        String string = dicomObject.getString(n5);
        return PrinterControl.drawTextRight(string, graphics2D, n2, n3, n4);
    }

    private static int drawTextRight(String string, Graphics2D graphics2D, int n2, int n3, int n4) {
        if (string != null) {
            int n5 = graphics2D.getFontMetrics().stringWidth(string) + 5;
            graphics2D.drawString(string, n2 - n5, n3);
            n3 += n4;
        }
        return n3;
    }

    private static AffineTransform rotate90(Graphics2D graphics2D, int n2, int n3) {
        AffineTransform affineTransform = graphics2D.getTransform();
        double d2 = -1.5707963267948966;
        graphics2D.rotate(d2, n3 / 2, n2 / 2);
        return affineTransform;
    }

    private static void drawTextRightRotated(String string, Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        AffineTransform affineTransform = PrinterControl.rotate90(graphics2D, n4, n5);
        graphics2D.drawString(string, n4 - n3 + 2, n2 - 5);
        graphics2D.setTransform(affineTransform);
    }

    private static int drawTagLeft(DicomObject dicomObject, Graphics2D graphics2D, int n2, int n3, int n4) {
        String string = dicomObject.getString(n4);
        return PrinterControl.drawTextLeft(string, graphics2D, n2, n3);
    }

    private static int drawTextLeft(String string, Graphics2D graphics2D, int n2, int n3) {
        if (string != null) {
            graphics2D.drawString(string, 5, n2);
            n2 += n3;
        }
        return n2;
    }

    private static int[] fixHighPixels(BufferedImage bufferedImage) {
        int[] nArray = PrinterControl.getPixels(bufferedImage);
        int n2 = 8191;
        boolean bl2 = false;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] > n2) {
                nArray[i2] = n2;
            }
            if (bl2) continue;
            System.out.println("Fixing pixel");
            bl2 = true;
        }
        return nArray;
    }

    private static int[] getPixels(BufferedImage bufferedImage) {
        Rectangle rectangle = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        int[] nArray = bufferedImage.getRaster().getPixels(rectangle.x, rectangle.y, n2, n3, (int[])null);
        return nArray;
    }

    private static void setPixels(int[] nArray, DicomObject dicomObject) {
        byte[] byArray = new byte[nArray.length * 2];
        int n2 = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            byArray[n2++] = (byte)(nArray[i2] >> 8 & 0xFF);
            byArray[n2++] = (byte)(nArray[i2] & 0xFF);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        dicomObject.putBytes(2145386512, VR.OW, byteBuffer.array());
    }

    public static void scalePixelDataTo12Bits(DicomObject dicomObject) {
        String string = dicomObject.getString(2621444, (String)null);
        if (PrinterControl.isMonochrome(string)) {
            int n2;
            int n3;
            if (dicomObject.getInt(2621697, 12) == 12) {
                return;
            }
            BufferedImage bufferedImage = DicomImageConverter.toBufferedImage(dicomObject);
            int[] nArray = PrinterControl.getPixels(bufferedImage);
            int n4 = n3 = nArray[0];
            for (n2 = 1; n2 < nArray.length; ++n2) {
                int n5 = nArray[n2];
                if (n5 > n3) {
                    n3 = n5;
                    continue;
                }
                if (n5 >= n4) continue;
                n4 = n5;
            }
            n2 = 4095;
            if (n3 > 4095) {
                float f2 = 4095.0f / (float)n3;
                int n6 = 0;
                while (n6 < nArray.length) {
                    int n7 = n6++;
                    nArray[n7] = (int)((float)nArray[n7] * f2);
                }
                n6 = nArray[0];
                for (int i2 = 1; i2 < nArray.length; ++i2) {
                    int n8 = nArray[i2];
                    if (n8 <= n6) continue;
                    n6 = n8;
                }
                PrinterControl.setPixels(nArray, dicomObject);
                dicomObject.putInt(2621699, VR.US, 0);
                dicomObject.putInt(2621697, VR.US, 12);
                dicomObject.putInt(2621698, VR.US, 11);
                dicomObject.putInt(2621703, VR.US, 4095);
                dicomObject.putInt(2621702, VR.US, (int)((float)n4 * f2));
            }
        }
    }

    private static boolean isMonochrome(String string) {
        return "MONOCHROME1".equals(string) || "MONOCHROME2".equals(string);
    }

    public static void convertToGrayscale(DicomObject dicomObject) {
        if ("RGB".equals(dicomObject.getString(2621444, ""))) {
            BufferedImage bufferedImage = DicomImageConverter.toBufferedImage(dicomObject);
            ColorConvertOp colorConvertOp = new ColorConvertOp(ColorSpace.getInstance(1003), null);
            bufferedImage = colorConvertOp.filter(bufferedImage, null);
            PrinterControl.putBufferedImageGrayscale(dicomObject, bufferedImage);
        }
    }

    private static void putBufferedImageGrayscale(DicomObject dicomObject, BufferedImage bufferedImage) {
        int n2;
        byte[] byArray;
        int n3;
        int n4;
        Rectangle rectangle = null;
        boolean bl2 = true;
        Rectangle rectangle2 = new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle3 = rectangle == null ? rectangle2 : rectangle2.intersection(rectangle);
        if (rectangle3.isEmpty()) {
            throw new IllegalArgumentException("Source region is empty." + dicomObject);
        }
        int n5 = bufferedImage.getType();
        int n6 = rectangle3.width;
        int n7 = rectangle3.height;
        boolean bl3 = false;
        int n8 = n4 = n5 == 10 ? 8 : 16;
        int n9 = n8 - 1;
        dicomObject.putInt(0x280002, VR.US, 1);
        if (bl2) {
            dicomObject.putString(2621444, VR.CS, "MONOCHROME2");
        } else {
            dicomObject.putString(2621444, VR.CS, "MONOCHROME1");
        }
        dicomObject.putInt(2621456, VR.US, n7);
        dicomObject.putInt(2621457, VR.US, n6);
        dicomObject.putInt(2621696, VR.US, n4);
        dicomObject.putInt(2621697, VR.US, n8);
        dicomObject.putInt(2621698, VR.US, n9);
        dicomObject.putInt(2621699, VR.US, bl3 ? 1 : 0);
        dicomObject.putInts(2621492, VR.IS, new int[]{1, 1});
        int[] nArray = bufferedImage.getRaster().getPixels(rectangle3.x, rectangle3.y, n6, n7, (int[])null);
        int n10 = n3 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n11 = nArray[i2];
            if (n11 > n3) {
                n3 = n11;
                continue;
            }
            if (n11 >= n10) continue;
            n10 = n11;
        }
        if (n4 == 8) {
            byArray = new byte[nArray.length];
            for (n2 = 1; n2 < nArray.length; ++n2) {
                byArray[n2] = (byte)(nArray[n2 % 2 == 0 ? n2 + 1 : n2 - 1] & 0xFF);
            }
        } else {
            byArray = new byte[nArray.length * 2];
            n2 = 1;
            while (n2 < nArray.length) {
                byArray[n2++] = (byte)(nArray[n2] >> 8 & 0xFF);
                byArray[n2++] = (byte)(nArray[n2] & 0xFF);
            }
        }
        dicomObject.putBytes(2145386512, VR.OW, byArray);
        dicomObject.putInt(2621702, VR.SS, n10);
        dicomObject.putInt(2621703, VR.SS, n3);
        if (dicomObject.contains(2625619)) {
            float f2 = dicomObject.getFloat(2625619, 0.0f);
            float f3 = dicomObject.getFloat(2625618, 0.0f);
            if (!dicomObject.contains(2625618)) {
                dicomObject.putFloat(2625618, VR.DS, f3);
                dicomObject.putFloat(2625619, VR.DS, f2);
                dicomObject.putString(2625620, VR.LO, "PIXELVALUE");
            }
            if (!dicomObject.contains(2625616)) {
                String[] stringArray = new String[]{Float.toString(f2 * (float)(n3 + n10) / 2.0f + f3)};
                dicomObject.putStrings(2625616, VR.DS, stringArray);
                String[] stringArray2 = new String[]{Float.toString(f2 * (float)(n3 - n10) / 2.0f)};
                dicomObject.putStrings(2625617, VR.DS, stringArray2);
            }
        }
    }
}

