/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.factories;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mimvista.archive.Parser;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmSeriesReference;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.SeriesStatusInfo;
import com.mimvista.dicom.SimpleSeriesReferenceCodec;
import com.mimvista.dicom.factories.DcmStudyFactory;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.FileExcluder;
import com.mimvista.dicom.util.DicomDataHelper;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.event.Event;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.i;
import com.mimvista.metabase.p;
import com.mimvista.metabase.r;
import com.mimvista.metabase.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMDateFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.Tag;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.StopTagInputHandler;

public class DcmSeriesFactory {
    private static final Map<String, Integer> crazyQueryResultAttributeNameToDicomTag = new ImmutableMap.Builder().put((Object)"rtplanname", (Object)0x300A0003).put((Object)"rtplanlabel", (Object)805961730).put((Object)"rtplandesc", (Object)805961732).put((Object)"dosecomment", (Object)805568518).put((Object)"rtimagename", (Object)0x30020003).put((Object)"rtimagelabel", (Object)0x30020002).put((Object)"rtimagedesc", (Object)805437444).put((Object)"frameofreferenceuid", (Object)0x200052).put((Object)"label", (Object)805699586).put((Object)"name", (Object)805699588).put((Object)"creator", (Object)528496).put((Object)"desc", (Object)528446).put((Object)"seriesinstanceuid", (Object)0x20000E).put((Object)"sopinstanceuid", (Object)524312).build();

    public static DcmSeries getDcmSeriesFromArchiveDicomObject(String string, DicomObject dicomObject) {
        DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromDicomObject(dicomObject);
        dcmSeries.setLastResortImageCount(Parser.getNumSeriesRelatedInstances(string));
        dcmSeries.setArchiveDir(string);
        return dcmSeries;
    }

    public static DcmSeries getDcmSeriesFromArchiveDirectory(String string) {
        DicomObject dicomObject = null;
        try {
            dicomObject = DcmSeriesFactory.getDicomObjectFromArchive(string);
        }
        catch (NullPointerException nullPointerException) {
            dicomObject = null;
        }
        if (dicomObject != null) {
            return DcmSeriesFactory.getDcmSeriesFromArchiveDicomObject(string, dicomObject);
        }
        return DcmSeriesFactory.getDcmSeriesFromFolderName(string);
    }

    @Deprecated
    public static DcmSeries getDcmSeriesFromFolderName(String string) {
        Map<String, Object> map = DcmSeriesFactory.getJsonFromFolderName(string);
        DcmSeries dcmSeries = new DcmSeries(map);
        dcmSeries.setArchiveDir(string);
        dcmSeries.setLocalDir(string);
        return dcmSeries;
    }

    private static Map<String, Object> getJsonFromFolderName(String string) {
        Parser.b b2 = Parser.parse(string);
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        linkedHashMap.put(MetabaseKeys.fromTag(528446), b2.f());
        linkedHashMap.put(MetabaseKeys.fromTag(524384), b2.d());
        linkedHashMap.put(MetabaseKeys.fromTag(2101769), b2.l());
        linkedHashMap.put(MetabaseKeys.fromTag(524337), DateUtils.j(b2.j()));
        linkedHashMap.put(MetabaseKeys.fromTag(524320), DateUtils.e(b2.i()));
        linkedHashMap.put(MetabaseKeys.fromTag(524321), DateUtils.e(b2.i()));
        linkedHashMap.put(MetabaseKeys.fromTag(528432), b2.e());
        linkedHashMap.put(MetabaseKeys.fromTag(0x100010), b2.a());
        linkedHashMap.put(MetabaseKeys.fromTag(0x100020), b2.c());
        return linkedHashMap;
    }

    public static DcmSeries getDcmSeriesFromDicomObject(DicomObject dicomObject) {
        DcmSeries dcmSeries = new DcmSeries(dicomObject);
        dcmSeries.setReferencedSeries(DcmSeriesReference.extractSeriesReferences(dicomObject));
        return dcmSeries;
    }

    public static DicomObject getDicomObjectFromArchive(String string) {
        return DcmSeriesFactory.getDicomObjectFromArchive(string, (DicomInputHandler)new StopTagInputHandler(2145386512));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DicomObject getDicomObjectFromArchive(String string, DicomInputHandler dicomInputHandler) {
        try {
            File[] fileArray;
            File file = new File(string);
            for (File file2 : fileArray = file.listFiles(new FileExcluder().getFilenameFilter())) {
                DicomObject dicomObject = null;
                DicomInputStream dicomInputStream = null;
                try {
                    dicomInputStream = new DicomInputStream(file2);
                    dicomInputStream.setHandler(dicomInputHandler);
                    dicomObject = dicomInputStream.readDicomObject();
                }
                catch (IOException iOException) {
                }
                finally {
                    if (dicomInputStream != null) {
                        try {
                            dicomInputStream.close();
                        }
                        catch (IOException iOException) {
                            ay.d((Object)iOException, DcmSeriesFactory.class);
                        }
                    }
                }
                if (dicomObject.size() <= 4) continue;
                return dicomObject;
            }
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return null;
    }

    public static SeriesDirManifest getSeriesDirManifest(File file) {
        if (!file.exists()) {
            ay.d((Object)("Dir doesn't exist cannot gen manifest: " + file), DcmSeriesFactory.class);
            return null;
        }
        if (!file.isDirectory()) {
            ay.d((Object)("Not a dir, cannot gen manifest: " + file), DcmSeriesFactory.class);
            return null;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            ay.d((Object)("Bad permissions on dir? Cannot generate manifest: " + file), DcmSeriesFactory.class);
            return null;
        }
        if (fileArray.length == 0) {
            ay.d((Object)("Empty dir? Cannot generate manifest: " + file), DcmSeriesFactory.class);
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        DicomObject dicomObject = null;
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                ay.a((Object)("Shouldn't be a dir in here: " + file2.getAbsolutePath()), DcmSeriesFactory.class);
                continue;
            }
            arrayList.add(file2);
            if (dicomObject != null) continue;
            dicomObject = DicomReader.readFileIntoDicomObject(file2, new DicomReader.StopBeforeContentInputHandler(2145386512));
        }
        if (dicomObject == null) {
            ay.d((Object)("No valid DICOM files? Cannot generate manifest: " + file + " ~ " + arrayList.isEmpty()), DcmSeriesFactory.class);
            return null;
        }
        return new SeriesDirManifest(file, arrayList, dicomObject);
    }

    public static List<DcmSeries> getDcmSeriesFromSeriesFolders(List<? extends File> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (File file : list) {
            DicomObject dicomObject = DicomReader.getFirstDicomObjectFromSeriesFolder(file.getAbsolutePath());
            if (dicomObject == null) continue;
            DcmStudy dcmStudy = DcmStudyFactory.getDcmStudyFromDicomObject(dicomObject);
            DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromDicomObject(dicomObject);
            dcmSeries.setStudy(dcmStudy);
            dcmSeries.setArchiveDir(file.getAbsolutePath());
            dcmSeries.setLocalDir(file.getAbsolutePath());
            dcmSeries.setFiles(Arrays.asList(file.listFiles()));
            arrayList.add(dcmSeries);
        }
        return arrayList;
    }

    public static DcmSeries getDcmSeriesFromMetabaseSeries(Series series) {
        Object object;
        List<u> list2;
        DcmSeries dcmSeries = new DcmSeries(series.asJsonMap(1));
        dcmSeries.setPrimaryKey(series.getPk());
        Set<String> set = series.getFolders();
        if (set != null && !set.isEmpty()) {
            dcmSeries.setArchiveDir((String)Iterables.get(set, (int)0));
        }
        if ((list2 = series.getStatuses()) != null && !list2.isEmpty()) {
            Collections.sort(list2, Collections.reverseOrder(u.a));
            for (u list3 : list2) {
                if (!"workflow".equalsIgnoreCase(list3.getType())) continue;
                dcmSeries.setWorkflowStatus(new SeriesStatusInfo(list3.getId(), list3.getUser(), list3.getTime().getTimeInMillis(), list3.getName()));
                break;
            }
            object = Lists.newArrayList();
            for (u u2 : list2) {
                if (!"view".equalsIgnoreCase(u2.getType())) continue;
                object.add(new SeriesStatusInfo(u2.getId(), u2.getUser(), u2.getTime().getTimeInMillis(), u2.getName()));
            }
            dcmSeries.setViewStatus((List<SeriesStatusInfo>)object);
        }
        object = ArrayListMultimap.create();
        List<? extends r> list = series.getEmbeddedReferences();
        if (!list.isEmpty()) {
            for (r r2 : list) {
                DcmSeriesReference dcmSeriesReference = new DcmSeriesReference(r2.getSource());
                for (p p2 : r2.getUids()) {
                    dcmSeriesReference.addReference(DcmSeriesReference.ReferenceUidType.fromTag(p2.b()), p2.a());
                }
                ArrayList arrayList = Lists.newArrayList();
                List<? extends Series> list3 = r2.getReferencedSeries(null);
                if (list3 != null && !list3.isEmpty()) {
                    arrayList.add(DcmSeriesFactory.getDcmSeriesFromMetabaseSeries(list3.get(0)));
                }
                dcmSeriesReference.setReferencedDcmSeries(arrayList);
                object.put((Object)r2.getSource(), (Object)dcmSeriesReference);
            }
        } else {
            for (r r3 : series.getSeriesReferences(null)) {
                DcmSeriesReference dcmSeriesReference = new DcmSeriesReference(r3.getSource());
                for (p p3 : r3.getUids()) {
                    dcmSeriesReference.addReference(DcmSeriesReference.ReferenceUidType.fromTag(p3.b()), p3.a());
                }
                object.put((Object)r3.getSource(), (Object)dcmSeriesReference);
            }
        }
        dcmSeries.setReferencedSeries((Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference>)object);
        return dcmSeries;
    }

    public static DcmSeries getDcmSeriesWithInfoAdded(SearchSource searchSource, QueryResult queryResult) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        Object object2;
        Object object3;
        Object object4;
        Map.Entry<String, String> entry32;
        Object object5;
        String string5;
        Map.Entry<String, Integer> entry222;
        Map<String, Object> map = DcmSeriesFactory.getJsonFromFolderName(queryResult.path);
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        linkedHashMap.put("version", 1);
        map.put("mimdata", linkedHashMap);
        for (Map.Entry<String, Integer> entry222 : crazyQueryResultAttributeNameToDicomTag.entrySet()) {
            string5 = queryResult.attributes.get(entry222.getKey());
            if (string5 == null) continue;
            map.put(MetabaseKeys.fromTag((Integer)entry222.getValue()), string5);
        }
        String string6 = queryResult.attributes.get("primarykey");
        entry222 = null;
        if (string6 != null && !"".equals(string6)) {
            entry222 = Long.parseLong(string6);
            map.put("_id", (Long)((Object)entry222));
        }
        if ((string5 = queryResult.attributes.get("sopinstanceuid")) != null) {
            map.put(MetabaseKeys.fromTag(524312), string5);
            object5 = Lists.newArrayList((Object[])new String[]{string5});
            linkedHashMap.put("sopInstanceUids", object5);
        }
        for (Map.Entry<String, String> entry32 : queryResult.attributes.entrySet()) {
            object4 = entry32.getKey();
            if (!((String)object4).startsWith("#tag")) continue;
            object3 = ((String)object4).replaceAll(Pattern.quote("#tag"), "");
            map.put(MetabaseKeys.fromTag(Integer.valueOf((String)object3, 16)), entry32.getValue());
        }
        object5 = queryResult.attributes.get("when");
        if (object5 != null) {
            try {
                entry32 = new MIMDateFormat("yyyy-MM-dd HH:mm:ss");
                object4 = ((DateFormat)((Object)entry32)).parse((String)object5);
                object3 = DateUtils.f((Date)object4);
                object2 = DateUtils.b(null, (Date)object4);
                map.put(MetabaseKeys.fromTag(805699592), object3);
                map.put(MetabaseKeys.fromTag(805699593), object2);
            }
            catch (Throwable throwable) {
                ay.d((Object)throwable, DcmSeriesFactory.class);
            }
        }
        if (!cn.h((String)((Object)(entry32 = queryResult.attributes.get("seriesdate"))))) {
            map.put(MetabaseKeys.fromTag(524321), DateUtils.i((String)((Object)entry32)));
        }
        if (!cn.h((String)(object4 = queryResult.attributes.get("seriestime")))) {
            map.put(MetabaseKeys.fromTag(524337), DateUtils.j((String)object4));
        }
        object3 = new DcmSeries(i.a(map));
        if (entry222 != null) {
            ((DcmSeries)object3).setPrimaryKey((Long)((Object)entry222));
        }
        ((DcmSeries)object3).setSearchSource(searchSource);
        ((DcmSeries)object3).setArchiveDir(queryResult.path);
        ((DcmSeries)object3).setLocalDir(queryResult.path);
        ((DcmSeries)object3).setViewStatus(queryResult.attributes.get("viewstatus"));
        ((DcmSeries)object3).setWorkflowStatus(queryResult.attributes.get("workflowstatus"));
        object2 = queryResult.attributes.get("embedindex");
        if (object2 != null && ((String)object2).length() > 0) {
            try {
                linkedHashMap.put("embedIdx", Long.valueOf((String)object2));
            }
            catch (NumberFormatException numberFormatException) {
                ay.d((Object)"Error.", (Throwable)numberFormatException, DcmSeriesFactory.class);
            }
        }
        if ((string4 = queryResult.attributes.get("newlyreceived")) != null) {
            ((DcmSeries)object3).setNewlyReceived(string4);
        }
        if ((string3 = queryResult.attributes.get("recentlyviewed")) != null) {
            ((DcmSeries)object3).setRecentlyViewed(string3);
        }
        if ((string2 = queryResult.attributes.get("archivealias")) != null) {
            ((DcmSeries)object3).setRplName(string2);
        }
        if ((string = queryResult.attributes.get("childIds")) != null && string.length() > 0) {
            object = Lists.newArrayList();
            for (String string7 : string.split("~")) {
                try {
                    object.add(Long.valueOf(string7));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            linkedHashMap.put("childIds", object);
        }
        object = LinkedHashMultimap.create();
        for (DcmSeriesReference.ReferenceSource referenceSource : DcmSeriesReference.ReferenceSource.values()) {
            Collection<DcmSeriesReference> collection;
            String string8 = queryResult.attributes.get(referenceSource.toString().toLowerCase());
            if (string8 == null || (collection = SimpleSeriesReferenceCodec.decodeSeriesReferenceCollectionString(searchSource, string8)) == null) continue;
            for (DcmSeriesReference dcmSeriesReference : collection) {
                dcmSeriesReference.setSource(referenceSource);
            }
            object.putAll((Object)referenceSource, collection);
        }
        if (!object.isEmpty()) {
            ((DcmSeries)object3).setReferencedSeries((Multimap<DcmSeriesReference.ReferenceSource, DcmSeriesReference>)object);
        }
        return object3;
    }

    public static DcmSeries createEmptyDicomSearchPlaceholder() {
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMap();
        linkedHashMap.put(MetabaseKeys.fromTag(528446), Messages.a("Archive", "DCM_SEARCH_SERIES_LEVEL_QUERY_NOT_AVAILABLE"));
        return new DcmSeries(linkedHashMap);
    }

    public static List<DcmSeries> getSeriesWithMatchingPatientName(List<DcmSeries> list, String string) {
        if (list == null || string == null) {
            return Lists.newArrayList();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (DcmSeries dcmSeries : list) {
            if (!SeriesIdentifier.comparePatientNames(dcmSeries.getPatientName(), string)) continue;
            arrayList.add(dcmSeries);
        }
        return arrayList;
    }

    public static NavigableMap<TagPath, Object> dicomDumpPro(DicomObject dicomObject) {
        TreeMap treeMap = Maps.newTreeMap();
        DcmSeriesFactory.dicomDumpProRecurse(dicomObject, treeMap, new TagPath());
        return treeMap;
    }

    public static NavigableMap<TagPath, Object> dicomDumpPro(String string) {
        DicomObject dicomObject = DcmSeriesFactory.getDicomObjectFromArchive(string);
        if (dicomObject == null) {
            ay.d((Object)("Failed to read DICOM information for series " + string), "auditlog");
            return null;
        }
        return DcmSeriesFactory.dicomDumpPro(dicomObject);
    }

    private static void dicomDumpProRecurse(DicomObject dicomObject, Map<TagPath, Object> map, TagPath tagPath) {
        final Iterator iterator = dicomObject.iterator();
        Iterable<DicomElement> iterable = new Iterable<DicomElement>(){

            @Override
            public Iterator<DicomElement> iterator() {
                return iterator;
            }
        };
        for (DicomElement dicomElement : iterable) {
            if (dicomElement.vr() == VR.SQ) {
                for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                    DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                    DcmSeriesFactory.dicomDumpProRecurse(dicomObject2, map, tagPath.newPathByAddingTag(dicomElement.tag(), i2));
                }
                continue;
            }
            Object object = DicomDataHelper.getValue(dicomObject, dicomElement);
            if (object == null) continue;
            map.put(tagPath.newPathByAddingTag(dicomElement.tag(), -1), object);
        }
    }

    public static TreeMap<Integer, String> dicomDump(String string) {
        DicomObject dicomObject = DcmSeriesFactory.getDicomObjectFromArchive(string);
        if (dicomObject == null) {
            ay.d((Object)("Failed to read DICOM information for series " + string), "auditlog");
            return null;
        }
        return DcmSeriesFactory.getTreeMapFromDicom(dicomObject);
    }

    public static TreeMap<Integer, String> getTreeMapFromDicom(DicomObject dicomObject) {
        Field[] fieldArray;
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        for (Field field : fieldArray = Tag.class.getFields()) {
            try {
                int n2 = Tag.forName((String)field.getName());
                String string = null;
                DicomElement dicomElement = dicomObject.get(n2);
                if (dicomElement.vm(null) > 1) {
                    String[] stringArray = dicomObject.getStrings(n2);
                    string = cn.a("\\", stringArray);
                } else {
                    string = dicomObject.getString(n2);
                }
                if (string == null) continue;
                treeMap.put(n2, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return treeMap;
    }

    public static boolean updateSeriesStatus(Event event, List<DcmSeries> list) {
        long l2 = Long.valueOf(event.a("PrimaryKey"));
        DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesByPrimaryKey(l2, list);
        if (dcmSeries == null) {
            ay.b((Object)"The series is not in current Patient Data Source", DcmSeriesFactory.class);
            return false;
        }
        dcmSeries.setViewStatus(event.a("ViewStatus"));
        dcmSeries.setWorkflowStatus(event.a("WorkflowStatus"));
        return true;
    }

    private static DcmSeries getDcmSeriesByPrimaryKey(long l2, List<DcmSeries> list) {
        if (l2 == -1L) {
            ay.c((Object)"The series' primary key is invalid", DcmSeriesFactory.class);
            return null;
        }
        DcmSeries dcmSeries = null;
        for (DcmSeries dcmSeries2 : list) {
            if (l2 != dcmSeries2.getPrimaryKey()) continue;
            dcmSeries = dcmSeries2;
            break;
        }
        return dcmSeries;
    }

    public static class SeriesDirManifest {
        public final File seriesDir;
        public final List<File> dcmFilesInDir;
        public final DicomObject representativeDicom;

        public SeriesDirManifest(File file, List<File> list, DicomObject dicomObject) {
            this.seriesDir = file;
            this.dcmFilesInDir = list;
            this.representativeDicom = dicomObject;
        }
    }
}

