/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.factories;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mimvista.archive.NameFormatter;
import com.mimvista.archive.Parser;
import com.mimvista.archive.gui.StudyGroupingType;
import com.mimvista.archive.remote.QueryResult;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.cloud.crypto.common.a.e;
import com.mimvista.cloud.shared.common.mim.StudyDetails;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.DcmStudyGrouping;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.file.PathUtils;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dcm4che2.data.DicomObject;

public class DcmStudyFactory {
    public static Messages props = Messages.a("Dicom");
    private static List<Integer> dcmStudyFields = new ArrayList<Integer>();
    public static String xmlVersion;

    public static DcmStudy getDcmStudyFromDicomObject(DicomObject dicomObject) {
        DcmStudy dcmStudy = new DcmStudy();
        for (Integer n2 : dcmStudyFields) {
            dcmStudy.setStringProperty(n2, DcmStudyFactory.getDataString(dicomObject, (int)n2));
        }
        dcmStudy.setStringProperty(0x100010, NameFormatter.a(dicomObject.getString(0x100010, ""), dicomObject, false));
        return dcmStudy;
    }

    public static DcmStudy getDcmStudyFromDCMSeries(DcmSeries dcmSeries) {
        DcmStudy dcmStudy = new DcmStudy();
        for (Integer n2 : dcmStudyFields) {
            dcmStudy.setStringProperty(n2, DcmStudyFactory.getDataString(dcmSeries, n2));
        }
        return dcmStudy;
    }

    public static List<DcmStudy> getDcmStudiesFromDicomObjectList(List<DicomObject> list) {
        if (list == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (DicomObject dicomObject : list) {
            DcmStudy dcmStudy = DcmStudyFactory.getDcmStudyFromDicomObject(dicomObject);
            DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromDicomObject(dicomObject);
            dcmSeries.setStudy(dcmStudy);
            dcmStudy.addSeries(dcmSeries);
            arrayList.add(dcmStudy);
        }
        return arrayList;
    }

    public static DcmStudy getDcmStudyFromArchiveDirectory(String string) {
        DcmStudy dcmStudy = new DcmStudy();
        Parser.b b2 = Parser.parse(string);
        block7: for (Integer n2 : dcmStudyFields) {
            switch (n2) {
                case 0x100010: {
                    dcmStudy.setStringProperty(n2, b2.a());
                    continue block7;
                }
                case 0x100020: {
                    dcmStudy.setStringProperty(n2, b2.c());
                    continue block7;
                }
                case 524320: {
                    dcmStudy.setStringProperty(n2, DateUtils.d(b2.i()));
                    continue block7;
                }
                case 524336: {
                    dcmStudy.setStringProperty(n2, b2.j());
                    continue block7;
                }
                case 528432: {
                    dcmStudy.setStringProperty(n2, b2.e());
                    continue block7;
                }
            }
            dcmStudy.setStringProperty(n2, "");
        }
        return dcmStudy;
    }

    public static DcmStudy updateDcmStudyForCloudGrouping(DcmSeries dcmSeries) {
        DcmStudy dcmStudy = dcmSeries.getStudy();
        DcmStudy dcmStudy2 = DcmStudy.shallowCopy(dcmStudy);
        e e2 = dcmStudy2.getCloudStudyItem();
        if (e2 == null) {
            return dcmStudy2;
        }
        StudyDetails.DecryptedStudyDetails decryptedStudyDetails = e2.a().s();
        if (decryptedStudyDetails == null) {
            return dcmStudy2;
        }
        String string = decryptedStudyDetails.a();
        String string2 = PathUtils.safeFilename(decryptedStudyDetails.b(), true);
        dcmStudy2.setStringProperty(0x100010, string);
        dcmStudy2.setStringProperty(0x100020, string2);
        return dcmStudy2;
    }

    public static List<DcmStudy> getDcmStudiesFromArchiveResults(List<QueryResult> list, Progress progress, SearchSource searchSource) {
        return DcmStudyFactory.getDcmStudiesFromArchiveResults(list, progress, searchSource, false);
    }

    public static List<DcmStudy> getDcmStudiesFromDcmSeries(Collection<DcmSeries> collection, Progress progress, boolean bl2, Searchable.a a2) {
        if (collection == null) {
            return new ArrayList<DcmStudy>();
        }
        StudyGroupingType studyGroupingType = StudyGroupingType.f();
        progress.a(Messages.a("PatientList", "GROUPING_RESULTS_BY") + " " + studyGroupingType.b());
        progress.b_(MIMFormat.a(props.getProperty("DCM_STUDY_SORT"), Iterables.size(collection)));
        progress.a();
        DcmStudyGrouping dcmStudyGrouping = bl2 ? studyGroupingType.a(null) : StudyGroupingType.a.a(null);
        List<DcmStudy> list = dcmStudyGrouping.formStudyGroups(collection, progress, a2);
        progress.b();
        return list;
    }

    public static List<DcmStudy> getDcmStudiesFromArchiveResults(List<QueryResult> list, Progress progress, SearchSource searchSource, boolean bl2) {
        return DcmStudyFactory.getDcmStudiesFromArchiveResults(list, progress, searchSource, bl2, new Searchable.b());
    }

    public static List<DcmStudy> getDcmStudiesFromArchiveResults(List<QueryResult> list, Progress progress, SearchSource searchSource, boolean bl2, Searchable.a a2) {
        if (list == null) {
            return new ArrayList<DcmStudy>();
        }
        if (searchSource == null) {
            ay.d((Object)"Might not be a good idea to pass in a null SearchSource...make sure the DcmSeries won't need to know about it...", DcmStudyFactory.class);
        }
        progress.b_(MIMFormat.a(props.getProperty("DCM_STUDY_SORT"), list.size()));
        progress.a();
        DcmStudyGrouping dcmStudyGrouping = bl2 ? StudyGroupingType.f().a(null) : StudyGroupingType.a.a(null);
        List<DcmStudy> list2 = dcmStudyGrouping.formStudyGroups(list, progress, searchSource, a2);
        progress.b();
        return list2;
    }

    private static String getDataString(DicomObject dicomObject, int n2) {
        String string = dicomObject.getString(n2);
        if (string == null) {
            return "";
        }
        return string;
    }

    private static String getDataString(DcmSeries dcmSeries, Integer n2) {
        Object t2 = dcmSeries.getTagValue(n2);
        if (t2 == null) {
            return "";
        }
        if (t2 instanceof Date) {
            if (VRUtils.isTimeTypeVR(TagUtils.vrOfTag(n2))) {
                return DateUtils.a((Date)t2, "HHmmss");
            }
            return DateUtils.a((Date)t2, "yyyyMMdd");
        }
        return t2.toString();
    }

    static {
        dcmStudyFields.add(0x100010);
        dcmStudyFields.add(0x100020);
        dcmStudyFields.add(0x100040);
        dcmStudyFields.add(0x100030);
        dcmStudyFields.add(524320);
        dcmStudyFields.add(524336);
        dcmStudyFields.add(0x200010);
        dcmStudyFields.add(0x20000D);
        dcmStudyFields.add(528432);
        dcmStudyFields.add(524368);
        dcmStudyFields.add(524385);
        xmlVersion = "1.0a";
    }
}

