/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.archive.remote.c.b;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.network.DcmQueryClient;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.logging.a.c;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.s;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observer;
import javax.swing.JOptionPane;

public class DcmPullTransfer
extends b {
    private c log = DcmPullTransfer.getInLog();
    private static Messages props = Messages.a("Dicom");
    private static final int CANCEL = 0;
    private static final int RETRY = 1;
    private int cancelAction = 0;
    private boolean finished = false;
    private boolean iserror = false;
    private boolean warning = false;
    private String error;
    private DcmQueryClient dcmQueryClient;
    private List<DcmSeries> seriesList;
    private List<DcmStudy> studyList;
    private QueryRetrieveLevel level;
    private DicomLocationsPrefs.a resultHost;
    private String toName;
    private ArrayList<Observer> pendingClientObservers = new ArrayList();

    public DcmPullTransfer(DicomSearchSource.a a2, DicomLocationsPrefs.a a3, String string) {
        this.seriesList = a2.c;
        this.studyList = a2.b;
        this.level = a2.a;
        this.resultHost = a3;
        this.toName = string;
    }

    @Override
    public void doTransferInternal() {
        this.notifier.a(true);
        this.executeJob();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeJob() {
        this.notifier.b_(props.getProperty("DCMPULL_START"));
        try {
            Object object;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string = "DCMPULL_RESULT_ITEM_SERIES_";
            if (this.level == QueryRetrieveLevel.STUDY) {
                string = "DCMPULL_RESULT_ITEM_STUDY_";
                for (DcmStudy object22 : this.studyList) {
                    this.dcmQueryClient = new DcmQueryClient(this.resultHost);
                    this.dcmQueryClient.setDest(this.toName);
                    object = new ArrayList<String>();
                    if (!this.isCancelled()) {
                        object.add("StudyInstanceUID:" + object22.getStringProperty(0x20000D));
                        this.dcmQueryClient.setProgress(this.notifier);
                        if (this.dcmQueryClient.open()) {
                            for (Observer observer : this.pendingClientObservers) {
                                this.dcmQueryClient.addObserver(observer);
                            }
                            this.dcmQueryClient.move(this.dcmQueryClient.query(QueryRetrieveLevel.STUDY, (List<String>)object));
                            this.dcmQueryClient.close();
                        }
                        n2 += this.dcmQueryClient.getStatus().b();
                        n3 += this.dcmQueryClient.getStatus().c();
                        n4 += this.dcmQueryClient.getStatus().a();
                        continue;
                    }
                    break;
                }
            } else if (this.level == QueryRetrieveLevel.SERIES) {
                string = "DCMPULL_RESULT_ITEM_SERIES_";
                for (int i2 = 0; i2 < this.seriesList.size(); ++i2) {
                    this.dcmQueryClient = new DcmQueryClient(this.resultHost);
                    this.dcmQueryClient.setDest(this.toName);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (!this.isCancelled()) {
                        object = this.studyList.get(i2);
                        DcmSeries dcmSeries = this.seriesList.get(i2);
                        this.notifier.b_(MIMFormat.a(props.getProperty("DCMPULL_RECEIVE"), i2 + 1, this.seriesList.size()));
                        arrayList.add("StudyInstanceUID:" + ((DcmStudy)object).getStringProperty(0x20000D));
                        arrayList.add("SeriesInstanceUID:" + dcmSeries.getSeriesInstanceUID());
                        if (this.dcmQueryClient.open()) {
                            for (Observer observer : this.pendingClientObservers) {
                                this.dcmQueryClient.addObserver(observer);
                            }
                            this.dcmQueryClient.move(this.dcmQueryClient.query(QueryRetrieveLevel.SERIES, arrayList));
                            this.dcmQueryClient.close();
                        }
                        n2 += this.dcmQueryClient.getStatus().b();
                        n3 += this.dcmQueryClient.getStatus().c();
                        n4 += this.dcmQueryClient.getStatus().a();
                        continue;
                    }
                    break;
                }
            }
            if (!this.isCancelled()) {
                String string2 = string + (n2 == 1 ? "SINGLE" : "PLURAL");
                String string3 = MIMFormat.a(props.getProperty("DCMPULL_RESULT_SUCCESS"), n2, props.b(string2));
                object = MIMFormat.a(props.getProperty("DCMPULL_RESULT_ERRORS"), n4, n3);
                if (n4 > 0) {
                    this.errorProgress((String)object);
                } else if (n3 > 0) {
                    this.problemProgress((String)object);
                } else if (n2 > 0) {
                    this.successProgress(string3);
                } else {
                    throw new RuntimeException("No successes, no failures, no warnings, unknown state.");
                }
                if (this.level == QueryRetrieveLevel.SERIES && this.seriesList.isEmpty()) {
                    this.setError(props.getProperty("DCMPULL_NO_SERIES"));
                }
                if (this.level == QueryRetrieveLevel.STUDY && this.studyList.isEmpty()) {
                    this.setError(props.getProperty("DCMPULL_NO_STUDIES"));
                }
            }
        }
        catch (ConnectException connectException) {
            ay.d((Object)"Error performing DICOM C-MOVE", (Throwable)connectException, this);
            this.errorProgress(MIMFormat.a(props.getProperty("DCMPULL_CONNECT_FAIL"), this.resultHost));
        }
        catch (NoRouteToHostException noRouteToHostException) {
            ay.d((Object)"Error performing DICOM C-MOVE", (Throwable)noRouteToHostException, this);
            this.errorProgress(MIMFormat.a(props.getProperty("DCMPULL_HOST_FAIL"), this.resultHost));
        }
        catch (IllegalStateException illegalStateException) {
            ay.d((Object)"Error performing DICOM C-MOVE", (Throwable)illegalStateException, this);
            this.errorProgress(MIMFormat.a(props.getProperty("DCMPULL_QUERY_FAIL"), this.resultHost));
        }
        catch (Exception exception) {
            ay.d((Object)"Error performing DICOM C-MOVE", (Throwable)exception, this);
            this.errorProgress(MIMFormat.a(props.getProperty("DCMPULL_UNKNOWN_FAIL"), this.resultHost));
        }
        finally {
            try {
                this.dcmQueryClient.close();
            }
            catch (Exception exception) {
                this.log.c("error closing mvstudy session: " + exception);
            }
        }
        this.finished = true;
    }

    public void errorProgress(String string) {
        this.notifier.k();
        this.log.c(string);
        this.notifier.b_(string);
        this.cancelAction = 1;
        this.iserror = true;
    }

    public void successProgress(String string) {
        this.notifier.b();
        this.log.a(string);
        this.notifier.b_(string);
    }

    public void problemProgress(String string) {
        this.notifier.l();
        this.log.b(string);
        this.notifier.b_(string);
        this.warning = true;
    }

    private void setError(String string) {
        this.error = string;
        this.log.c(string);
    }

    public String getError() {
        return this.error;
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        this.pendingClientObservers.add(observer);
    }

    @Override
    public void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        this.pendingClientObservers.remove(observer);
    }

    @Override
    public void deleteObservers() {
        super.deleteObservers();
        this.pendingClientObservers.clear();
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public String getClassName() {
        return "DicomPull";
    }

    @Override
    public String getRemoteLocation() {
        return this.resultHost.toDcmUrl().toString();
    }

    @Override
    public void setNotifier(final s s2) {
        this.notifier = s2;
        this.notifier.c(false);
        s2.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        if (DcmPullTransfer.this.dcmQueryClient != null) {
                            DcmPullTransfer.this.dcmQueryClient.getCancelLock().lock();
                            int n2 = 0;
                            if (s2 instanceof g) {
                                n2 = JOptionPane.showConfirmDialog(((g)((Object)s2)).d(), props.getProperty("DCMPULL_CANCEL_QUESTION"), props.getProperty("DCMPULL_CONFIRM_CANCEL"), 0, 0);
                            }
                            if (n2 == 0) {
                                DcmPullTransfer.this.dcmQueryClient.cancel();
                                DcmPullTransfer.this.cancelTransfer();
                            }
                            DcmPullTransfer.this.dcmQueryClient.getCancelLock().unlock();
                        }
                    }
                }.start();
            }
        });
    }

    @Override
    public String getTransferTitle() {
        return MIMFormat.a(props.getProperty("DCMPULL_RETRIEVE"), this.resultHost.getAeTitle(), this.toName);
    }

    public static enum QueryRetrieveLevel {
        STUDY,
        SERIES,
        IMAGE;

    }
}

