/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.archive.Archiver;
import com.mimvista.archive.Parser;
import com.mimvista.archive.remote.c.c;
import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.network.DcmSnd;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.Path;
import com.mimvista.file.l;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.s;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.math.BigDecimal;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.dcm4che2.data.DicomObject;

public class DcmPushTransfer
extends c {
    private static Messages props = Messages.a("Dicom");
    String[] files;
    private DicomLocationsPrefs.a host;
    private int[] fileLocks = new int[]{1};
    private DcmSnd dcm;

    public DcmPushTransfer(String[] stringArray, boolean bl2, DicomLocationsPrefs.a a2, int[] nArray) {
        this(stringArray, bl2, a2);
        this.fileLocks = nArray;
    }

    public DcmPushTransfer(String[] stringArray, boolean bl2, DicomLocationsPrefs.a a2) {
        this.files = stringArray;
        this.deleteWhenDone = bl2;
        this.host = a2;
    }

    @Override
    protected String getHostDescription() {
        return "";
    }

    @Override
    public String getClassName() {
        return "DicomPush";
    }

    @Override
    public String getRemoteLocation() {
        return this.host.getHost();
    }

    @Override
    public void doTransferInternal() {
        MIMDcmUrl mIMDcmUrl = this.host.toDcmUrl();
        long l2 = DcmPushTransfer.getTransferSize(this.files);
        String string = MIMFormat.a(props.getProperty("DCMPUSH_TO"), DcmPushTransfer.getPatientInfo(this.files), mIMDcmUrl.getCalledAET());
        this.dcm = new DcmSnd(mIMDcmUrl);
        this.dcm.setTotalSize(l2);
        this.dcm.setProgress(this.notifier);
        String string2 = MIMFormat.a(props.getProperty("DCMPUSH_SEND"), string, l.a(l2), this.files.length);
        this.notifier.a(string2);
        String string3 = string + ": Sending " + l.a(l2) + " in " + this.files.length + " files.";
        ay.b((Object)string3, this);
        if (this.files.length == 0) {
            this.notifier.b_(props.getProperty("DCMPUSH_NO_FILES"));
            this.notifier.k();
            return;
        }
        try {
            boolean bl2 = false;
            while (!bl2) {
                this.notifier.b_(props.getProperty("DCMPUSH_STARTING"));
                this.dcm.send(this.files, this.host.isAllowCommit());
                if (this.dcm.getErrorMsg().length() > 0 && this.dcm.getSentBytes() == 0L) {
                    this.errorProgress(this.dcm.getErrorMsg(), this.notifier);
                    bl2 = true;
                    continue;
                }
                if (this.dcm.isCongested()) {
                    int n2;
                    for (int i2 = n2 = DicomPrefs.sendRetryDelay.getValue().intValue(); i2 != 0; --i2) {
                        if (this.isCancelled()) {
                            return;
                        }
                        this.warnProgress(MIMFormat.a(props.getProperty("DCMPUSH_RETRY"), String.valueOf(i2)), this.notifier, false);
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    this.notifier.a();
                    continue;
                }
                if (this.dcm.getSentBytes() > 0L) {
                    BigDecimal bigDecimal = new BigDecimal((double)this.dcm.getSentBytes() / ((double)this.dcm.getTransferTime() / 1000.0));
                    if (this.isCancelled()) {
                        this.notifier.b_(MIMFormat.a(props.getProperty("DCMPUSH_TRANSFER_A"), l.a(this.dcm.getSentBytes()), l.a(bigDecimal.longValue())));
                    } else if (this.dcm.getErrorMsg().length() > 0) {
                        this.errorProgress(MIMFormat.a(props.getProperty("DCMPUSH_TRANSFER_B"), l.a(this.dcm.getSentBytes()), l.a(bigDecimal.longValue())), this.notifier);
                    } else {
                        this.successProgress(MIMFormat.a(props.getProperty("DCMPUSH_TRANSFER_C"), l.a(this.dcm.getSentBytes()), l.a(bigDecimal.longValue())), this.notifier);
                    }
                    bl2 = true;
                    continue;
                }
                bl2 = true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            this.errorProgress(props.getProperty("DCMPUSH_INTERRUPTED"), this.notifier);
            ay.b((Object)"Sending", (Throwable)illegalStateException, this);
        }
        catch (Exception exception) {
            this.errorProgress(props.getProperty("DCMPUSH_GENERAL_ERROR"), this.notifier);
            ay.b((Object)"Sending: ", (Throwable)exception, this);
        }
        this.notifier.c_(true);
        this.dcm = null;
    }

    private static long getTransferSize(String[] stringArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            File file = new File(string);
            if (file.isDirectory()) {
                l2 += DcmPushTransfer.getTransferSize(file.listFiles());
                continue;
            }
            l2 += file.length();
        }
        return l2;
    }

    private static long getTransferSize(File[] fileArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            File file = fileArray[i2];
            if (file.isDirectory()) {
                l2 += DcmPushTransfer.getTransferSize(file.listFiles());
                continue;
            }
            l2 += file.length();
        }
        return l2;
    }

    private static String getPatientInfo(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            DicomObject dicomObject;
            if (!new File(string).isFile() || (dicomObject = DicomReader.readFileIntoDicomObject(new File(string), 2145386512)) == null) continue;
            stringBuilder.append(dicomObject.getString(524384));
            stringBuilder.append(": ");
            stringBuilder.append(Parser.formatName(dicomObject.getString(0x100010, "")));
            break;
        }
        return stringBuilder.toString();
    }

    public void errorProgress(final String string, final s s2) {
        ay.d((Object)(this.getTransferTitle() + ": " + string), this);
        DcmPushTransfer.getOutLog().c(this.getTransferTitle() + ": " + string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                s2.k();
                s2.b_(string);
            }
        });
    }

    public void successProgress(final String string, final s s2) {
        ay.b((Object)(this.getTransferTitle() + ": " + string), this);
        DcmPushTransfer.getOutLog().a(this.getTransferTitle() + ": " + string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                s2.b();
                s2.b_(string);
            }
        });
    }

    public void warnProgress(final String string, final s s2, final boolean bl2) {
        ay.c((Object)(this.getTransferTitle() + ": " + string), this);
        DcmPushTransfer.getOutLog().b(this.getTransferTitle() + ": " + string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                s2.l();
                s2.b_(string);
                s2.a(true, !bl2);
            }
        });
    }

    @Override
    public void cleanUp() {
        this.fileLocks[0] = this.fileLocks[0] - 1;
        if (this.deleteWhenDone && this.fileLocks[0] == 0) {
            if (Archiver.cleanTempDirForEmbeddedSeries(new File(this.files[0]).getAbsolutePath())) {
                return;
            }
            File file = new File(this.files[0]).getParentFile();
            for (String string : this.files) {
                new File(string).delete();
            }
            if (file != null && file.isDirectory() && file.list().length == 0 && (file.getAbsolutePath().indexOf(Path.getTempPath()) == 0 || file.getAbsolutePath().indexOf(Path.getImporterTempPath()) == 0)) {
                file.delete();
            }
        }
    }

    @Override
    public void setNotifier(final s s2) {
        this.notifier = s2;
        s2.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        if (DcmPushTransfer.this.dcm != null) {
                            if (DcmPushTransfer.this.dcm.getCancelLock().tryLock()) {
                                int n2 = 0;
                                if (s2 instanceof g) {
                                    n2 = JOptionPane.showConfirmDialog(((g)((Object)s2)).d(), props.getProperty("DCMPUSH_STOP_TRANSFERS"), props.getProperty("DCMPUSH_CONFIRM_CANCEL"), 0, 0);
                                }
                                if (n2 == 0) {
                                    DcmPushTransfer.this.cancelTransfer();
                                }
                                DcmPushTransfer.this.dcm.getCancelLock().unlock();
                            }
                        } else {
                            DcmPushTransfer.this.cancelTransfer();
                        }
                    }
                }.start();
            }
        });
    }

    @Override
    public void cancelInternal() {
        super.cancelInternal();
        this.dcm.cancel();
    }

    @Override
    public String getTransferTitle() {
        String string = MIMFormat.a(props.getProperty("DCMPUSH_TO"), DcmPushTransfer.getPatientInfo(this.files), this.host.getAeTitle());
        return string;
    }
}

