/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.google.common.collect.Lists;
import com.mimvista.archive.SeriesOpener;
import com.mimvista.archive.remote.SeriesQuery;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.internals.b;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public abstract class DicomObjectSelectionDialog<DataType>
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static Messages props = Messages.a("Dicom");
    protected HiddenDataTableModel model = new HiddenDataTableModel();
    protected JTable table = new JTable(this.model);
    protected List<DataType> foundSeries = null;
    protected DataType selection = null;
    protected List<Runnable> finishedOpeningListeners = null;
    private JButton open;

    public DicomObjectSelectionDialog(Window window, String string, List<DataType> list) {
        this.foundSeries = list;
        this.finishedOpeningListeners = new ArrayList<Runnable>();
        this.setDefaultCloseOperation(2);
        this.build(string);
    }

    protected DicomObjectSelectionDialog(Window window) {
        super(window);
    }

    protected void build(String string) {
        JComponent jComponent;
        JComponent jComponent2;
        Box box = new Box(3);
        box.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        if (string != null) {
            jComponent2 = new Box(2);
            jComponent2.add(Box.createHorizontalStrut(10));
            jComponent2.add(new JLabel("Select Series For: "));
            jComponent2.add(Box.createHorizontalStrut(10));
            jComponent = new JLabel(cn.p(string.replace("\n", "<br/>")));
            jComponent2.add(jComponent);
            jComponent2.add(Box.createHorizontalGlue());
            jComponent2.add(Box.createHorizontalStrut(10));
            box.add(jComponent2);
            box.add(Box.createVerticalStrut(15));
        }
        this.table.setPreferredScrollableViewportSize(new Dimension(this.getDefaultWidth(), 400));
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> this.setSelection());
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    DicomObjectSelectionDialog.this.getOpenListener().actionPerformed(new ActionEvent(mouseEvent.getSource(), mouseEvent.getID(), ""));
                }
            }
        });
        this.addTableColumns();
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.model.getHiddenColumnPosition()));
        this.setColumnWidths();
        this.fillTable();
        jComponent2 = new JScrollPane(this.table);
        box.add(jComponent2);
        this.open = new JButton(props.getProperty("DCM_OBJ_OPEN"));
        this.open.addActionListener(this.getOpenListener());
        this.open.setEnabled(false);
        jComponent = new JButton(props.getProperty("DCM_OBJ_CANCEL"));
        ((AbstractButton)jComponent).addActionListener(actionEvent -> this.setVisible(false));
        Box box2 = new Box(2);
        box2.add(Box.createHorizontalGlue());
        box2.add(this.open);
        box2.add(Box.createHorizontalStrut(10));
        box2.add(jComponent);
        box.add(Box.createVerticalStrut(10));
        box.add(box2);
        this.add(box);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void open() {
        this.setVisible(true);
        if (this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
    }

    public void addFinishedLoadingRunnable(Runnable runnable) {
        this.finishedOpeningListeners.add(runnable);
    }

    private void setSelection() {
        int n2 = this.table.getSelectedRow();
        int n3 = this.table.convertRowIndexToModel(n2);
        this.selection = n3 != -1 ? this.model.getHiddenDataAt(n3) : null;
        this.open.setEnabled(this.selection != null);
    }

    protected DataType getDicomObjectFromSelection() {
        return this.selection;
    }

    protected void fillTable() {
        if (this.foundSeries == null || this.foundSeries.isEmpty()) {
            return;
        }
        for (DataType DataType2 : this.foundSeries) {
            this.addTableItem(DataType2);
        }
        this.model.fireTableDataChanged();
    }

    protected int getDefaultWidth() {
        return 750;
    }

    protected ActionListener getOpenListener() {
        return actionEvent -> {
            DataType DataType2 = this.getDicomObjectFromSelection();
            this.performOpen(DataType2);
            for (Runnable runnable : Lists.newArrayList(this.finishedOpeningListeners)) {
                try {
                    runnable.run();
                }
                catch (Exception exception) {
                    ay.d((Object)"Error running finished opening listener", (Throwable)exception, this);
                }
            }
            this.dispose();
        };
    }

    public DataType getSeriesFromSelection() {
        return this.getDicomObjectFromSelection();
    }

    protected abstract void addTableColumns();

    protected abstract void setColumnWidths();

    protected abstract void addTableItem(DataType var1);

    protected abstract void performOpen(DataType var1);

    public class HiddenDataTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;

        public HiddenDataTableModel() {
            this.addColumn("Hidden Data");
        }

        public int getHiddenColumnPosition() {
            return 0;
        }

        public Object getHiddenDataAt(int n2) {
            return this.getValueAt(n2, 0);
        }

        @Override
        public void addRow(Object[] objectArray) {
            if (objectArray == null) {
                super.addRow(new Object[0]);
                return;
            }
            this.addRow(null, objectArray);
        }

        public void addRow(Object object, Object[] objectArray) {
            if (objectArray == null) {
                this.addRow(new Object[]{object});
                return;
            }
            Vector<Object> vector = new Vector<Object>(objectArray.length);
            vector.addElement(object);
            for (Object object2 : objectArray) {
                vector.addElement(object2);
            }
            this.addRow(vector);
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }
    }

    public static abstract class DcmSeriesObjectSelectionDialog
    extends DicomObjectSelectionDialog<DcmSeries> {
        private static final long serialVersionUID = 1L;

        public DcmSeriesObjectSelectionDialog(Window window, SeriesQuery seriesQuery) {
            super(window);
            this.foundSeries = seriesQuery.getSearchResults();
            this.finishedOpeningListeners = new ArrayList();
            this.build(null);
        }

        public DcmSeriesObjectSelectionDialog(Window window, List<DcmSeries> list) {
            super(window, null, list);
        }

        @Override
        protected void performOpen(DcmSeries dcmSeries) {
            SeriesOpener seriesOpener = new SeriesOpener(dcmSeries.getSearchSource());
            SeriesOpener.b b2 = new SeriesOpener.b();
            b2.a = false;
            seriesOpener.a(b.a(new DcmSeries[]{dcmSeries}), b2);
        }
    }
}

