/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.atlas.management.AtlasDBManager;
import com.mimvista.cloud.shared.common.UniqueSeriesPointer;
import com.mimvista.commands.workflow.DicomSaveCommand;
import com.mimvista.commands.workflow.TransformContourCommand;
import com.mimvista.d;
import com.mimvista.dicom.SeriesEqualityHasher;
import com.mimvista.dicom.gui.DicomSaveInputNotification;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.dicom.write.rtst.DicomRtStructCreator;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.internals.DynamicVolumeRef3D;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.iphone.IPhoneBundleDestination;
import com.mimvista.mui.ak;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.RemoteAbstractContourOverlay;
import com.mimvista.preferencesNew.ContourPrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DicomRtStructSaveInputFactory {
    public static void showDialog(ViewController3D viewController3D, SendToDestination sendToDestination) {
        DicomRtStructSaveInputFactory.showDialog(viewController3D, sendToDestination, null, null);
    }

    public static void showDialog(ViewController3D viewController3D, SendToDestination sendToDestination, String string, @d Consumer<UniqueSeriesPointer> consumer) {
        DicomRtStructSaveInputFactory.showDialog(viewController3D, sendToDestination, null, string, false, false, consumer);
    }

    public static void showDialog(ViewController3D viewController3D, SendToDestination sendToDestination, String string, String string2, boolean bl2, boolean bl3) {
        DicomRtStructSaveInputFactory.showDialog(viewController3D, sendToDestination, string, string2, bl2, bl3, null);
    }

    public static void showDialog(ViewController3D viewController3D, SendToDestination sendToDestination, String string, String string2, boolean bl2, boolean bl3, @d Consumer<UniqueSeriesPointer> consumer) {
        DicomRtStructSaveInputFactory.showDialog(DicomRtStructSaveInputFactory.getOptions(viewController3D, sendToDestination, string, string2, bl2, bl3, null, consumer));
    }

    public static void showDialogSecondary(ViewController3D viewController3D, SendToDestination sendToDestination, String string, @d Consumer<UniqueSeriesPointer> consumer) {
        DicomRtStructSaveNotificationOptions dicomRtStructSaveNotificationOptions = DicomRtStructSaveInputFactory.getOptions(viewController3D, sendToDestination, null, string, false, false, null, consumer);
        dicomRtStructSaveNotificationOptions.isNotSelectedVC = true;
        DicomRtStructSaveInputFactory.showDialog(dicomRtStructSaveNotificationOptions);
    }

    public static RtStructSaveNotification createDialog(ViewController3D viewController3D, SendToDestination sendToDestination, Notification.a a2) {
        return DicomRtStructSaveInputFactory.createDialog(DicomRtStructSaveInputFactory.getOptions(viewController3D, sendToDestination, null, null, false, false, a2, null));
    }

    public static void showDialog(final DicomRtStructSaveNotificationOptions dicomRtStructSaveNotificationOptions) {
        if (AtlasDBManager.d(dicomRtStructSaveNotificationOptions.viewState)) {
            AtlasDBManager.a(dicomRtStructSaveNotificationOptions.viewState);
            ay.c((Object)"Not saving atlas contours.", DicomRtStructSaveInputFactory.class);
            if (dicomRtStructSaveNotificationOptions.dismissedListener != null) {
                dicomRtStructSaveNotificationOptions.dismissedListener.accept(null);
            }
            return;
        }
        RtStructSaveNotification rtStructSaveNotification = DicomRtStructSaveInputFactory.createDialog(dicomRtStructSaveNotificationOptions);
        rtStructSaveNotification.addToGrandNotifier();
        rtStructSaveNotification.setDismissActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (dicomRtStructSaveNotificationOptions.dismissedListener != null) {
                    dicomRtStructSaveNotificationOptions.dismissedListener.accept(null);
                }
                dicomRtStructSaveNotificationOptions.viewState.k(false);
            }
        });
        dicomRtStructSaveNotificationOptions.viewState.k(true);
    }

    public static DicomRtStructSaveNotificationOptions getOptions(ViewController3D viewController3D, SendToDestination sendToDestination, String string, String string2, boolean bl2, boolean bl3, Notification.a a2, @d Consumer<UniqueSeriesPointer> consumer) {
        DicomRtStructSaveNotificationOptions dicomRtStructSaveNotificationOptions = new DicomRtStructSaveNotificationOptions(viewController3D);
        dicomRtStructSaveNotificationOptions.defaultDest = sendToDestination;
        dicomRtStructSaveNotificationOptions.sopInstanceUID = string;
        dicomRtStructSaveNotificationOptions.defaultSeriesDesc = string2;
        dicomRtStructSaveNotificationOptions.canSaveEmptyContours = bl2;
        dicomRtStructSaveNotificationOptions.ignoreGhosts = bl3;
        dicomRtStructSaveNotificationOptions.dismissedListener = consumer;
        if (a2 != null) {
            dicomRtStructSaveNotificationOptions.scope = a2;
        }
        return dicomRtStructSaveNotificationOptions;
    }

    private static boolean handleGhosts(final RtStructSaveNotification rtStructSaveNotification, final RtstSaveInfo rtstSaveInfo, final List<RemoteAbstractContourOverlay> list, final @d Consumer<UniqueSeriesPointer> consumer) {
        int n2 = !rtStructSaveNotification.isNotSelectedVC && ContourPrefs.transferGhosts.getValue().equals((Object)ContourPrefs.TransferGhostsOptions.a) ? JOptionPane.showConfirmDialog(ak.b().O(), Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_TRANSFER_DESC"), Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_TRANSFER_TITLE"), 0) : 0;
        if (n2 == 0) {
            rtStructSaveNotification.setErrorText(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_TRANSFORMING"));
            rtStructSaveNotification.transforming = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HashMap hashMap = Maps.newHashMap();
                    for (RemoteAbstractContourOverlay object : list) {
                        AbstractContourOverlayish abstractContourOverlayish = (AbstractContourOverlayish)object.R();
                        ViewController viewController = abstractContourOverlayish.au();
                        List list2 = (List)hashMap.get(viewController);
                        if (list2 == null) {
                            hashMap.put(viewController, Lists.newArrayList((Object[])new AbstractContourOverlayish[]{abstractContourOverlayish}));
                            continue;
                        }
                        list2.add(abstractContourOverlayish);
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        TransformContourCommand.staticExecute((ViewController)entry.getKey(), rtstSaveInfo.ref.e(), (List)entry.getValue());
                    }
                    rtStructSaveNotification.transforming = false;
                    rtStructSaveNotification.setErrorText(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DicomRtStructSaveInputFactory.okPressedInNoti(rtStructSaveNotification, rtstSaveInfo, consumer, true);
                        }
                    });
                }
            });
            return false;
        }
        return true;
    }

    private static void okPressedInNoti(final RtStructSaveNotification rtStructSaveNotification, RtstSaveInfo rtstSaveInfo, @d Consumer<UniqueSeriesPointer> consumer, boolean bl2) {
        rtStructSaveNotification.setEnabled(false);
        try {
            int n2;
            if (rtStructSaveNotification.transforming) {
                rtStructSaveNotification.setErrorText("Please wait...");
                return;
            }
            ImageVolumeShort imageVolumeShort = rtstSaveInfo.ref.e().cw();
            ArrayList<RemoteAbstractContourOverlay> arrayList = new ArrayList<RemoteAbstractContourOverlay>();
            for (RemoteAbstractContourOverlay remoteAbstractContourOverlay : imageVolumeShort.n().I()) {
                if (remoteAbstractContourOverlay.an() || !remoteAbstractContourOverlay.bO_()) continue;
                arrayList.add(remoteAbstractContourOverlay);
            }
            if (!(bl2 || rtstSaveInfo.ignoreGhosts || arrayList.size() <= 0 || ContourPrefs.transferGhosts.getValue().equals((Object)ContourPrefs.TransferGhostsOptions.c) && !rtStructSaveNotification.isNotSelectedVC || DicomRtStructSaveInputFactory.handleGhosts(rtStructSaveNotification, rtstSaveInfo, arrayList, consumer))) {
                return;
            }
            if (!rtstSaveInfo.canSaveEmpty && imageVolumeShort.n().D().size() == 0 && imageVolumeShort.n().H().size() == 0) {
                rtStructSaveNotification.setErrorText(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_NATIVE_FAIL"));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        rtStructSaveNotification.setOkButtonEnabled(true);
                    }
                });
                return;
            }
            if (!rtstSaveInfo.ignoreGhosts && arrayList.size() > 0 && (n2 = JOptionPane.showConfirmDialog(ak.b().O(), MIMFormat.a(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_GHOST_DESC"), arrayList.size()), Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_GHOST_TITLE"), 0)) != 0) {
                return;
            }
            if (rtstSaveInfo.shouldShowVolExport) {
                u.b().a((Notification)null, false);
                DicomSaveCommand.get(rtstSaveInfo.ref.e()).executeWithGUI(actionEvent -> {}, () -> m.e.a(() -> DicomRtStructSaveInputFactory.doRtStSaveOnCurrentThread(rtStructSaveNotification, rtstSaveInfo, consumer), "RTST Save"));
            } else {
                m.e.a(() -> DicomRtStructSaveInputFactory.doRtStSaveOnCurrentThread(rtStructSaveNotification, rtstSaveInfo, consumer), "RTST Save");
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception, DicomRtStructSaveInputFactory.class);
            rtStructSaveNotification.setErrorText(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_FAIL"));
            rtStructSaveNotification.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRtStSaveOnCurrentThread(RtStructSaveNotification rtStructSaveNotification, RtstSaveInfo rtstSaveInfo, @d Consumer<UniqueSeriesPointer> consumer) {
        ProgressPanel progressPanel = new ProgressPanel();
        ProgressQueueNotification.a(progressPanel);
        DicomRtStructCreator.setLastOperatorName(rtstSaveInfo.operatorName);
        ArrayList arrayList = Lists.newArrayList();
        ViewController3D viewController3D = rtstSaveInfo.ref.e();
        boolean bl2 = false;
        if (rtstSaveInfo.saveDynamicAsSingleFrames) {
            if (viewController3D.bl()) {
                o o2 = viewController3D.cE();
                arrayList.addAll(o2.l());
                bl2 = true;
            } else {
                ay.b((Object)"Save dynamic RTstruct as multiple single-frame was enabled on series that is not 4D; saving normal type instead.", DicomRtStructSaveInputFactory.class);
                arrayList.add(viewController3D.cw());
            }
        } else {
            arrayList.add(viewController3D.cw());
        }
        try {
            int n2 = 1000 * arrayList.size();
            if (rtstSaveInfo.simplify) {
                n2 <<= 1;
            }
            progressPanel.a(n2);
            boolean bl3 = true;
            for (ImageVolumeShort imageVolumeShort : arrayList) {
                com.mimvista.util.progress.u u2 = new com.mimvista.util.progress.u((Progress)progressPanel, 1000);
                DicomRtStructCreator dicomRtStructCreator = DicomRtStructSaveInputFactory.get(viewController3D, imageVolumeShort, rtstSaveInfo.sopiUid, rtstSaveInfo.seriesDescription, rtstSaveInfo.structureSetName, rtstSaveInfo.operatorName, rtstSaveInfo.canSaveEmpty, bl2, rtstSaveInfo.saveVisibleContoursOnly);
                if (!(bl3 &= dicomRtStructCreator.writeTo(rtstSaveInfo.dest, (Progress)u2))) continue;
                if (consumer != null) {
                    consumer.accept(new UniqueSeriesPointer(dicomRtStructCreator.getSeriesInstanceUID(), SeriesEqualityHasher.hashSopUidStrings(Arrays.asList(dicomRtStructCreator.getSopInstanceUID())).toString()));
                }
                if (!rtstSaveInfo.simplify) continue;
                com.mimvista.util.progress.u u3 = new com.mimvista.util.progress.u((Progress)progressPanel, 1000);
                dicomRtStructCreator = DicomRtStructSaveInputFactory.get(viewController3D, imageVolumeShort, rtstSaveInfo.sopiUid, rtstSaveInfo.seriesDescription, rtstSaveInfo.structureSetName, rtstSaveInfo.operatorName, rtstSaveInfo.canSaveEmpty, bl2, rtstSaveInfo.saveVisibleContoursOnly);
                dicomRtStructCreator.setSimplifyContours(true);
                bl3 &= dicomRtStructCreator.writeTo(rtstSaveInfo.dest, (Progress)u3);
            }
            if (!bl3) {
                rtStructSaveNotification.setErrorText(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_FAIL"));
                rtStructSaveNotification.setEnabled(true);
            } else {
                u.b().d(rtStructSaveNotification);
            }
        }
        finally {
            progressPanel.b();
            if (rtStructSaveNotification.saveFinished != null) {
                rtStructSaveNotification.saveFinished.run();
            }
        }
    }

    public static RtStructSaveNotification createDialog(final DicomRtStructSaveNotificationOptions dicomRtStructSaveNotificationOptions) {
        l<Boolean> l2;
        l<String> l3;
        l<String> l4;
        Object object;
        l<SendToDestination> l5;
        final DynamicVolumeRef3D dynamicVolumeRef3D = DynamicVolumeRef3D.a(dicomRtStructSaveNotificationOptions.viewState);
        ImageVolumeShort imageVolumeShort = dicomRtStructSaveNotificationOptions.viewState.cw();
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        boolean bl2 = imageVolumeShort.getUncopiedMutableInfo().mimDerivedVolume && !imageVolumeShort.getUncopiedMutableInfo().volumeHasBeenSaved ? 0 == JOptionPane.showConfirmDialog(ak.b().O(), Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE_DERIVED"), Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE_DERIVED_TITLE"), 0, 3) : false;
        final RtStructSaveNotification rtStructSaveNotification = new RtStructSaveNotification(dicomRtStructSaveNotificationOptions.scope);
        rtStructSaveNotification.isNotSelectedVC = dicomRtStructSaveNotificationOptions.isNotSelectedVC;
        rtStructSaveNotification.setScrollBarType(AbstractInputContainer.ScrollBarType.b);
        rtStructSaveNotification.addTitle(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE"));
        rtStructSaveNotification.addLabel(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_ASSOC"));
        com.mimvista.gui.util.m m2 = rtStructSaveNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_PATIENT"), null, 0);
        m2.b(seriesInfo.patientName);
        com.mimvista.gui.util.m m3 = rtStructSaveNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_MODALITY"), null, 0);
        m3.b(seriesInfo.modality);
        com.mimvista.gui.util.m m4 = rtStructSaveNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DATE"), null, 0);
        Date date = seriesInfo.g();
        String string = "";
        if (date != null) {
            string = DateUtils.a().format(date);
        }
        m4.b(string);
        com.mimvista.gui.util.m m5 = rtStructSaveNotification.addCollection(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DESC"), null, 0);
        m5.b(seriesInfo.seriesDesc);
        if (!MIMContext.k()) {
            l5 = rtStructSaveNotification.addSendToCombo(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DEST"), sendToDestination -> !(sendToDestination instanceof IPhoneBundleDestination));
            object = dicomRtStructSaveNotificationOptions.defaultDest != null ? dicomRtStructSaveNotificationOptions.defaultDest : DicomSaveInputNotification.getBestDestForVc(dicomRtStructSaveNotificationOptions.viewState);
            l5.a((SendToDestination)object);
        } else {
            l5 = null;
        }
        object = rtStructSaveNotification.addTextField(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_DESCRIPTION"));
        ((l)object).a((String)dicomRtStructSaveNotificationOptions.defaultSeriesDesc);
        final String string2 = DicomRtStructCreator.getLastOperatorName();
        if (dicomRtStructSaveNotificationOptions.inputOperatorName) {
            l4 = rtStructSaveNotification.addTextField(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_OPERATOR"));
            l4.a(string2);
        } else {
            l4 = null;
        }
        if (dicomRtStructSaveNotificationOptions.inputStructSetName) {
            l3 = rtStructSaveNotification.addTextField(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_STRUCTURE"));
            l3.a(dicomRtStructSaveNotificationOptions.defaultStructSetName);
        } else {
            l3 = null;
        }
        if (dicomRtStructSaveNotificationOptions.inputSimplifiedSave) {
            l2 = rtStructSaveNotification.addCheckBox(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SIMPLIFY"));
            l2.a(DicomPrefs.saveSimplifiedRtst.getValue());
        } else {
            l2 = null;
        }
        l<Boolean> l6 = rtStructSaveNotification.addCheckBox(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_VISIBLE_CONTOURS"));
        l6.a(DicomPrefs.saveVisibleContoursOnly.getValue());
        l<Boolean> l7 = rtStructSaveNotification.addCheckBox(Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE_DYNAMIC_AS_SINGLE_FRAMES"));
        l7.a(Boolean.FALSE);
        l7.b((Boolean)(dicomRtStructSaveNotificationOptions.viewState.bl() && !dicomRtStructSaveNotificationOptions.viewState.ci() && !dicomRtStructSaveNotificationOptions.viewState.getModality().equalsIgnoreCase("NM") ? 1 : 0));
        rtStructSaveNotification.setOkActionListener(new ActionListener((l)object, l3, bl2, l7, l6, rtStructSaveNotification){
            final /* synthetic */ l val$seriesDescIv;
            final /* synthetic */ l val$structSetNameIv;
            final /* synthetic */ boolean val$shouldShowVolExport;
            final /* synthetic */ l val$saveDynamicAsSingleFrames;
            final /* synthetic */ l val$saveVisible;
            final /* synthetic */ RtStructSaveNotification val$inputNot;
            {
                this.val$seriesDescIv = l52;
                this.val$structSetNameIv = l6;
                this.val$shouldShowVolExport = bl2;
                this.val$saveDynamicAsSingleFrames = l7;
                this.val$saveVisible = l8;
                this.val$inputNot = rtStructSaveNotification;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RtstSaveInfo rtstSaveInfo = new RtstSaveInfo();
                rtstSaveInfo.canSaveEmpty = dicomRtStructSaveNotificationOptions.canSaveEmptyContours;
                if (l5 != null) {
                    rtstSaveInfo.dest = (SendToDestination)l5.b();
                }
                rtstSaveInfo.ref = dynamicVolumeRef3D;
                String string = l4 != null ? (String)l4.b() : string2;
                boolean bl2 = false;
                if (l2 != null) {
                    bl2 = (Boolean)l2.b();
                }
                String string22 = (String)this.val$seriesDescIv.b();
                if (this.val$structSetNameIv != null) {
                    string22 = (String)this.val$structSetNameIv.b();
                }
                rtstSaveInfo.operatorName = DcmWriterFactory.getPNString(string);
                rtstSaveInfo.seriesDescription = (String)this.val$seriesDescIv.b();
                rtstSaveInfo.shouldShowVolExport = this.val$shouldShowVolExport;
                rtstSaveInfo.simplify = bl2;
                DicomPrefs.saveSimplifiedRtst.setValue(rtstSaveInfo.simplify);
                rtstSaveInfo.sopiUid = dicomRtStructSaveNotificationOptions.sopInstanceUID;
                rtstSaveInfo.structureSetName = string22;
                rtstSaveInfo.ignoreGhosts = dicomRtStructSaveNotificationOptions.ignoreGhosts;
                rtstSaveInfo.saveDynamicAsSingleFrames = (Boolean)this.val$saveDynamicAsSingleFrames.b();
                rtstSaveInfo.saveVisibleContoursOnly = (Boolean)this.val$saveVisible.b();
                DicomPrefs.saveVisibleContoursOnly.setValue(rtstSaveInfo.saveVisibleContoursOnly);
                DicomRtStructSaveInputFactory.okPressedInNoti(this.val$inputNot, rtstSaveInfo, dicomRtStructSaveNotificationOptions.dismissedListener, false);
            }
        });
        rtStructSaveNotification.setCancelActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (rtStructSaveNotification.canceledSave != null) {
                    rtStructSaveNotification.canceledSave.run();
                }
            }
        });
        if (dicomRtStructSaveNotificationOptions.dismissedListener != null) {
            rtStructSaveNotification.setDismissActionListener(actionEvent -> dicomRtStructSaveNotificationOptions.dismissedListener.accept(null));
        }
        return rtStructSaveNotification;
    }

    public static DicomRtStructCreator get(ViewController3D viewController3D, String string, String string2, String string3, String string4, boolean bl2) {
        return DicomRtStructSaveInputFactory.get(viewController3D, viewController3D.cw(), string, string2, string3, string4, bl2, false, false);
    }

    public static DicomRtStructCreator get(ViewController3D viewController3D, ImageVolumeShort imageVolumeShort, String string, String string2, String string3, String string4, boolean bl2, boolean bl3, boolean bl4) {
        DicomRtStructCreator dicomRtStructCreator = new DicomRtStructCreator(viewController3D, imageVolumeShort, string);
        dicomRtStructCreator.setSeriesDescription(string2);
        dicomRtStructCreator.setOperatorName(string4);
        dicomRtStructCreator.setCanSaveEmptyContours(bl2);
        dicomRtStructCreator.setStructureSetName(string3);
        dicomRtStructCreator.setSaveSingleFrameFromDynamic(bl3);
        dicomRtStructCreator.setSaveVisibleContoursOnly(bl4);
        return dicomRtStructCreator;
    }

    public static String getDefaultStructureSetName(SeriesInfo seriesInfo) {
        return seriesInfo.patientName + " " + seriesInfo.patientId;
    }

    public static class DicomRtStructSaveNotificationOptions {
        public ViewController3D viewState = null;
        public SendToDestination defaultDest = null;
        public String sopInstanceUID = null;
        public String defaultSeriesDesc = null;
        public String defaultStructSetName = null;
        public boolean canSaveEmptyContours = false;
        public boolean ignoreGhosts = true;
        public boolean inputOperatorName = true;
        public boolean inputSimplifiedSave = true;
        public boolean inputStructSetName = false;
        public Notification.a scope = new Notification.a();
        @d
        public Consumer<UniqueSeriesPointer> dismissedListener = null;
        public boolean isNotSelectedVC = false;

        public DicomRtStructSaveNotificationOptions() {
        }

        public DicomRtStructSaveNotificationOptions(ViewController3D viewController3D) {
            this.viewState = viewController3D;
            this.scope = new Notification.a(viewController3D);
        }
    }

    private static class RtstSaveInfo {
        public DynamicVolumeRef3D ref;
        public String seriesDescription;
        public String structureSetName;
        public String operatorName;
        public boolean simplify;
        public SendToDestination dest;
        public boolean shouldShowVolExport;
        public String sopiUid;
        public boolean canSaveEmpty;
        public boolean ignoreGhosts;
        public boolean saveDynamicAsSingleFrames;
        public boolean saveVisibleContoursOnly;

        private RtstSaveInfo() {
        }
    }

    public static class RtStructSaveNotification
    extends InputNotification {
        boolean transforming = false;
        Runnable saveFinished = null;
        Runnable canceledSave = null;
        boolean isNotSelectedVC = false;

        RtStructSaveNotification(Notification.a a2) {
            super(a2, Messages.a("Dicom", "DCM_RT_STRUCT_CREATOR_SAVE"), "save");
        }

        public void setSaveFinishedRunnable(Runnable runnable) {
            this.saveFinished = runnable;
        }

        public void setUserCanceledSave(Runnable runnable) {
            this.canceledSave = runnable;
        }
    }
}

