/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.commands.f;
import com.mimvista.commands.keyboard.bg;
import com.mimvista.commands.workflow.DicomSaveCommand;
import com.mimvista.d;
import com.mimvista.dicom.gui.DicomSaveInputNotification;
import com.mimvista.dicom.write.DcmRegWriter;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.dicom.write.deformable.DcmSaveListener;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.mui.ao;
import com.mimvista.mui.bm;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.preferencesNew.DicomsavePrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ag;
import com.mimvista.util.progress.g;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.util.work.m;
import com.mimvista.viewer.SeriesInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DicomSaveInputFactory {
    public static Messages props = Messages.a("Dicom");

    public static InputNotification getFusionTypeSelectNotification(s s2, final FusionTypeSelectCallback fusionTypeSelectCallback, ActionListener actionListener) {
        int n2;
        Notification.a a2 = new Notification.a(s2);
        final InputNotification inputNotification = new InputNotification(a2, f.b(DicomSaveCommand.class).c(), "save");
        int n3 = FusionSaveType.values().length;
        if (!s2.ae().b()) {
            --n3;
        }
        String[] stringArray = new String[n3];
        String[] stringArray2 = new String[n3];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2] = FusionSaveType.values()[n2].getExternalizedString();
            stringArray2[n2] = FusionSaveType.values()[n2].getTooltip();
        }
        if (s2.B().u().t()) {
            stringArray = new String[]{FusionSaveType.SECONDARY_CAPTURE.getExternalizedString()};
        }
        if ((n2 = DicomsavePrefs.fusionSaveDefaultType.getValue().intValue()) >= n3) {
            n2 = n3 - 1;
        }
        final l<Integer> l2 = inputNotification.addRadioButtons(null, stringArray, stringArray2, 1);
        l2.a(n2);
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                inputNotification.setDismissActionListener(null);
                int n2 = (Integer)l2.b();
                DicomsavePrefs.fusionSaveDefaultType.setValue(n2);
                fusionTypeSelectCallback.type = FusionSaveType.values()[n2];
                u.b().d(inputNotification);
                SwingUtilities.invokeLater(fusionTypeSelectCallback);
            }
        });
        inputNotification.setDismissActionListener(actionListener);
        return inputNotification;
    }

    public static String[] formModalityChoices(DicomSaveType dicomSaveType, Pair<String, String> pair, boolean bl2) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = DcmSecondaryCapturePrefs.secondaryDicomModality.getValue();
        if ("ORIGINAL".equalsIgnoreCase(string2)) {
            string2 = bl2 ? ("Primary".equalsIgnoreCase(string = DcmSecondaryCapturePrefs.fusionOriginal.getValue()) ? (String)pair.x : (String)pair.y) : (String)pair.x;
        }
        string = DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE + " - " + string2;
        if ("RTDOSE".equals(pair.x)) {
            arrayList.add("RTDOSE");
        } else if ("US".equals(pair.x)) {
            arrayList.add("US");
            arrayList.add("NM");
            if (dicomSaveType == DicomSaveType.FUSION_ALIGNED_SECONDARY) {
                arrayList.add((String)pair.y);
            }
        } else if (dicomSaveType == DicomSaveType.NORMAL) {
            arrayList.add("CT");
            arrayList.add("PT");
            arrayList.add("MR");
            arrayList.add("NM");
            arrayList.add(string);
        } else if (dicomSaveType == DicomSaveType.NORMAL_EXTENT) {
            arrayList.add("CT");
            arrayList.add("PT");
            arrayList.add("MR");
            arrayList.add("NM");
            arrayList.add(string);
        } else if (dicomSaveType == DicomSaveType.FUSION_SECONDARY_CAPTURE || dicomSaveType == DicomSaveType.MIP_SECONDARY_CAPTURE) {
            arrayList.add(string);
        } else {
            arrayList.add("CT");
            arrayList.add("PT");
            arrayList.add("MR");
            arrayList.add("NM");
        }
        if ("RTIMAGE".equals(pair.x)) {
            arrayList.add("RTIMAGE");
        }
        boolean bl3 = false;
        if (dicomSaveType == DicomSaveType.FUSION_SECONDARY_CAPTURE || dicomSaveType == DicomSaveType.FUSION_ALIGNED_SECONDARY) {
            if (((String)pair.y).contains("PT") || ((String)pair.y).contains("CT")) {
                bl3 = true;
            } else if (((String)pair.y).contains("MR")) {
                arrayList.remove("NM");
            } else if (((String)pair.y).contains("NM")) {
                arrayList.remove("MR");
            }
        } else if ("PT".equals(pair.x) || "CT".equals(pair.x) || "PT".equals(pair.y) || "CT".equals(pair.y)) {
            bl3 = true;
        }
        if (bl3) {
            arrayList.remove("NM");
            arrayList.remove("MR");
        }
        return arrayList.toArray(new String[0]);
    }

    public static DicomSaveCallback getDefaultSaveCallback(ViewController viewController) {
        return DicomSaveInputFactory.getDefaultSaveCallback(viewController, null, false);
    }

    public static DicomSaveCallback getDefaultSaveCallback(ViewController viewController, FuncUtils.m<Boolean> m2) {
        return DicomSaveInputFactory.getDefaultSaveCallback(viewController, m2, false);
    }

    public static DicomSaveCallback getDefaultSaveCallback(final ViewController viewController, final FuncUtils.m<Boolean> m2, boolean bl2) {
        if (viewController.bl() && bl2) {
            return DicomSaveInputFactory.getDynamicSaveCallback(viewController.bh(), m2);
        }
        return new DicomSaveCallback(){

            @Override
            public void run() {
                this.write(viewController, m2, false);
            }
        };
    }

    public static DicomSaveCallback getDynamicSaveCallback(final ViewController3D viewController3D, final FuncUtils.m<Boolean> m2) {
        return new DicomSaveCallback(){

            @Override
            public void run() {
                final String string = this.options.seriesDescription;
                DcmWriter.DcmSaveOptions dcmSaveOptions = this.options;
                List<ImageVolumeShort> list = viewController3D.cE().l();
                if ("PT".equalsIgnoreCase(viewController3D.getModality()) || "NM".equalsIgnoreCase(viewController3D.getModality())) {
                    DicomSaveCallback dicomSaveCallback = new DicomSaveCallback(){

                        @Override
                        public void run() {
                            this.options.seriesDescription = string + " " + viewController3D.getUncopiedMutableInfo().seriesDesc;
                            this.write(viewController3D, new FuncUtils.m<Boolean>(){

                                @Override
                                public void doIt(Boolean bl2) {
                                }
                            }, true);
                        }
                    };
                    dicomSaveCallback.modality = this.modality;
                    dicomSaveCallback.destination = this.destination;
                    dicomSaveCallback.saveAxial = this.saveAxial;
                    dicomSaveCallback.saveSagittal = this.saveSagittal;
                    dicomSaveCallback.saveCoronal = this.saveCoronal;
                    dicomSaveCallback.rez = this.rez;
                    dicomSaveCallback.extent = this.extent;
                    dicomSaveCallback.frmIdx = this.frmIdx;
                    dicomSaveCallback.saveType = this.saveType;
                    dicomSaveCallback.block = this.block;
                    dicomSaveCallback.options = dcmSaveOptions.clone();
                    dicomSaveCallback.onWriteFinished = this.onWriteFinished;
                    dicomSaveCallback.run();
                } else {
                    AtomicInteger atomicInteger = new AtomicInteger(list.size());
                    for (int i2 = 0; i2 < list.size(); ++i2) {
                        final ImageVolumeShort imageVolumeShort = list.get(i2);
                        DicomSaveCallback dicomSaveCallback = new DicomSaveCallback(){

                            @Override
                            public void run() {
                                String string2;
                                SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
                                this.options.seriesDescription = string2 = string + " " + (seriesInfo.binnedInMIM ? seriesInfo.binDesc : seriesInfo.seriesDesc);
                                final ViewController3D viewController3D = (ViewController3D)viewController3D.aQ();
                                viewController3D.d(imageVolumeShort);
                                this.write(viewController3D, new FuncUtils.m<Boolean>(){

                                    @Override
                                    public void doIt(Boolean bl2) {
                                        viewController3D.ac();
                                    }
                                }, false);
                            }
                        };
                        dicomSaveCallback.modality = this.modality;
                        dicomSaveCallback.destination = this.destination;
                        dicomSaveCallback.saveAxial = this.saveAxial;
                        dicomSaveCallback.saveSagittal = this.saveSagittal;
                        dicomSaveCallback.saveCoronal = this.saveCoronal;
                        dicomSaveCallback.rez = this.rez;
                        dicomSaveCallback.extent = this.extent;
                        dicomSaveCallback.frmIdx = this.frmIdx;
                        dicomSaveCallback.saveType = this.saveType;
                        dicomSaveCallback.options = dcmSaveOptions.clone();
                        dicomSaveCallback.onWriteFinished = () -> {
                            if (atomicInteger.decrementAndGet() == 0) {
                                this.onWriteFinished.run();
                            }
                        };
                        dicomSaveCallback.run();
                    }
                }
                if (m2 != null) {
                    m2.doIt(true);
                }
            }
        };
    }

    public static InputNotification getDynamicSaveSelectNotification(ViewController viewController, final InputNotification inputNotification, final InputNotification inputNotification2, final ActionListener actionListener) {
        Notification.a a2 = new Notification.a(viewController);
        final InputNotification inputNotification3 = new InputNotification(a2, f.b(DicomSaveCommand.class).c(), "save");
        String[] stringArray = new String[]{DicomSaveType.NORMAL.getExternalizedString(), props.getProperty("DICOM_SAVE_AS_DYNAMIC")};
        final l<Integer> l2 = inputNotification3.addRadioButtons((String)null, stringArray, 1);
        l2.a(0);
        inputNotification3.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                inputNotification3.setDismissActionListener(null);
                int n2 = (Integer)l2.b();
                InputNotification inputNotification4 = n2 == 0 ? inputNotification : inputNotification2;
                inputNotification4.setDismissActionListener(actionListener);
                u.b().c(inputNotification4);
                u.b().d(inputNotification3);
            }
        });
        inputNotification3.setDismissActionListener(actionListener);
        return inputNotification3;
    }

    public static InputNotification getWarpSaveSelectNotification(final ViewController viewController, final InputNotification inputNotification, final ActionListener actionListener) {
        Notification.a a2 = new Notification.a(viewController);
        final InputNotification inputNotification2 = new InputNotification(a2, f.b(DicomSaveCommand.class).c(), "save");
        String[] stringArray = new String[]{DicomSaveType.NORMAL.getExternalizedString(), props.getProperty("DICOM_SAVE_AS_DEFORMABLE")};
        final l<Integer> l2 = inputNotification2.addRadioButtons((String)null, stringArray, 1);
        l2.a(0);
        inputNotification2.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                inputNotification2.setDismissActionListener(null);
                int n2 = (Integer)l2.b();
                u.b().d(inputNotification2);
                if (n2 == 0) {
                    inputNotification.setDismissActionListener(actionListener);
                    u.b().c(inputNotification);
                } else {
                    bg bg2 = new bg();
                    bg2.a(viewController, actionListener);
                }
            }
        });
        inputNotification2.setDismissActionListener(actionListener);
        return inputNotification2;
    }

    public static class FusionTypeSelectCallback
    extends BaseDicomSaveCallback
    implements Runnable {
        public FusionSaveType type;
        protected s vc;
        private ActionListener dismissedListener;

        public FusionTypeSelectCallback(s s2, ActionListener actionListener) {
            this.vc = s2;
            this.dismissedListener = actionListener;
        }

        @Override
        public void run() {
            if (this.type.equals(FusionSaveType.REGISTRATION)) {
                ArrayList<WarpTransform> arrayList = new ArrayList<WarpTransform>();
                arrayList.add(bg.b(this.vc.V()));
                arrayList.add(bg.b(this.vc.W()));
                for (WarpTransform warpTransform : arrayList) {
                    if (warpTransform == null) continue;
                    if (warpTransform.b().equals(this.vc.V().aE()) && warpTransform.x().equals(this.vc.W().aE())) {
                        bg bg2 = new bg();
                        bg2.a(this.vc.V(), this.dismissedListener, new DcmSaveListener(){

                            @Override
                            public void saveFinished(boolean bl2, String string) {
                                if (onWriteFinished != null) {
                                    onWriteFinished.run();
                                }
                            }
                        });
                        return;
                    }
                    if (!warpTransform.b().equals(this.vc.W().aE()) || !warpTransform.x().equals(this.vc.V().aE())) continue;
                    bg bg3 = new bg();
                    bg3.a(this.vc.W(), this.dismissedListener, new DcmSaveListener(){

                        @Override
                        public void saveFinished(boolean bl2, String string) {
                            if (onWriteFinished != null) {
                                onWriteFinished.run();
                            }
                        }
                    });
                    return;
                }
                InputNotification inputNotification = new DcmRegWriter(this.vc).createNotification(ao.Q().O(), this.dismissedListener, this.onWriteFinished);
                inputNotification.setDismissActionListener(this.dismissedListener);
                u.b().c(inputNotification);
            } else if (this.type.equals(FusionSaveType.SECONDARY_CAPTURE)) {
                DicomSaveCallback dicomSaveCallback = DicomSaveInputFactory.getDefaultSaveCallback(this.vc);
                dicomSaveCallback.saveAxial = this.saveAxial;
                dicomSaveCallback.saveSagittal = this.saveSagittal;
                dicomSaveCallback.saveCoronal = this.saveCoronal;
                dicomSaveCallback.onWriteFinished = this.onWriteFinished;
                DicomSaveInputNotification dicomSaveInputNotification = new DicomSaveInputNotification(DicomSaveType.FUSION_SECONDARY_CAPTURE, this.vc, dicomSaveCallback, null, null);
                dicomSaveInputNotification.setDismissActionListener(this.dismissedListener);
                u.b().c(dicomSaveInputNotification);
            } else {
                DicomSaveCallback dicomSaveCallback = new DicomSaveCallback(){

                    @Override
                    public void run() {
                        ViewLoadState.LoadFromFusionVolumeState loadFromFusionVolumeState = type == FusionSaveType.COMPOSITE ? new ViewLoadState.LoadFromFusionVolumeState(type, vc, null) : new ViewLoadState.LoadFromFusionVolumeState(type, vc, this.rez);
                        loadFromFusionVolumeState.a(vc);
                        final ViewLoadState.LoadFromFusionVolumeState loadFromFusionVolumeState2 = loadFromFusionVolumeState;
                        ProgressQueueNotification.a(new ProgressQueueNotification.b(){

                            @Override
                            public void run(g g2) {
                                loadFromFusionVolumeState2.a(g2);
                                Session session = bm.g();
                                loadFromFusionVolumeState2.setSession(session);
                                loadFromFusionVolumeState2.stamp();
                                if (loadFromFusionVolumeState2.a() != -1L) {
                                    this.write(session.b(loadFromFusionVolumeState2.a()), null, false);
                                }
                            }
                        });
                    }
                };
                dicomSaveCallback.saveAxial = this.saveAxial;
                dicomSaveCallback.saveSagittal = this.saveSagittal;
                dicomSaveCallback.saveCoronal = this.saveCoronal;
                dicomSaveCallback.onWriteFinished = this.onWriteFinished;
                DicomSaveType dicomSaveType = this.type == FusionSaveType.COMPOSITE ? DicomSaveType.FUSION_COMPOSITE : DicomSaveType.FUSION_ALIGNED_SECONDARY;
                DicomSaveInputNotification dicomSaveInputNotification = new DicomSaveInputNotification(dicomSaveType, this.vc, dicomSaveCallback, null, null);
                dicomSaveInputNotification.setDismissActionListener(this.dismissedListener);
                u.b().c(dicomSaveInputNotification);
            }
        }
    }

    public static abstract class DicomSaveCallback
    extends BaseDicomSaveCallback
    implements Runnable {
        public String modality;
        public AlignedSecondaryResolutionOption rez = null;
        public int[] extent = null;
        public int frmIdx = -1;
        public DicomSaveType saveType = DicomSaveType.NORMAL;
        public boolean block = false;

        @Override
        public abstract void run();

        protected void write(ViewController viewController, FuncUtils.m<Boolean> m2, boolean bl2) {
            Object object;
            final ArrayList<Object> arrayList = new ArrayList<Object>(3);
            if (this.saveAxial) {
                object = this.getWriteJob(viewController, PresentationType.a, m2, bl2);
                if (object != null) {
                    arrayList.add(object);
                } else {
                    this.showErrorMsg();
                    return;
                }
            }
            if (this.saveSagittal) {
                object = this.getWriteJob(viewController, PresentationType.b, m2, bl2);
                if (object != null) {
                    arrayList.add(object);
                } else {
                    this.showErrorMsg();
                    return;
                }
            }
            if (this.saveCoronal) {
                object = this.getWriteJob(viewController, PresentationType.c, m2, bl2);
                if (object != null) {
                    arrayList.add(object);
                } else {
                    this.showErrorMsg();
                    return;
                }
            }
            if (arrayList.size() > 0) {
                object = new Runnable(){

                    @Override
                    public void run() {
                        FuncUtils.k<?> k2 = ProgressQueueNotification.a(arrayList, true);
                        k2.get();
                        if (onWriteFinished != null) {
                            m.e.submit(onWriteFinished);
                        }
                    }
                };
                if (this.block) {
                    object.run();
                } else {
                    m.e.submit((Runnable)object);
                }
            }
        }

        private ProgressQueueNotification.b getWriteJob(ViewController viewController, PresentationType presentationType, FuncUtils.m<Boolean> m2, boolean bl2) {
            final DcmWriter dcmWriter = (this.saveType == DicomSaveType.FUSION_SECONDARY_CAPTURE || this.saveType == DicomSaveType.MIP_SECONDARY_CAPTURE) && !DcmWriterFactory.SCREEN_CAPTURE_OT.equals(this.modality) ? DcmWriterFactory.getWriterForModality(viewController, DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE, presentationType) : DcmWriterFactory.getWriterForModality(viewController, this.modality, presentationType);
            if (dcmWriter != null) {
                dcmWriter.setSaveDynamic(bl2);
                dcmWriter.setPlane(presentationType);
                dcmWriter.setDestination(this.destination);
                dcmWriter.setSaveOptions(this.options);
                if (m2 != null) {
                    dcmWriter.addCallback(m2);
                }
                if (this.extent != null) {
                    dcmWriter.setSavingExtent(this.extent);
                }
                dcmWriter.setFrmIdx(this.frmIdx);
                dcmWriter.setSliceSampleFrequency(this.options.sliceSampleFreq);
                dcmWriter.setBlocking(true);
                return new ProgressQueueNotification.b(){

                    @Override
                    public void run(g g2) {
                        dcmWriter.setProgressUI(g2);
                        dcmWriter.writeFiles();
                    }
                };
            }
            return null;
        }

        private void showErrorMsg() {
            JOptionPane.showMessageDialog(ak.b().O(), props.getProperty("DICOM_SAVE_FAIL_MSG"), props.getProperty("DICOM_SAVE_FAIL"), 0);
        }
    }

    public static class BaseDicomSaveCallback {
        public boolean saveAxial = true;
        public boolean saveSagittal = false;
        public boolean saveCoronal = false;
        public SendToDestination destination;
        @d
        public Runnable onWriteFinished = null;
        public DcmWriter.DcmSaveOptions options = new DcmWriter.DcmSaveOptions();
    }

    public static enum AlignedSecondaryResolutionOption implements ag
    {
        PRIMARY_RESOLUTION,
        SECONDARY_RESOLUTION,
        AT_512x512,
        AT_256x256,
        AT_128x128;


        @Override
        public String getExternalizedString() {
            return props.getProperty("DICOM_SAVE_FUSION_" + FusionSaveType.ALIGNED_SECONDARY.toString() + "_" + this.toString());
        }
    }

    public static enum FusionSaveType implements ag
    {
        SECONDARY_CAPTURE,
        REGISTRATION,
        ALIGNED_SECONDARY,
        COMPOSITE;


        @Override
        public String getExternalizedString() {
            return props.getProperty("DICOM_SAVE_FUSION_" + this.name());
        }

        public String getTooltip() {
            return props.getProperty("DICOM_SAVE_FUSION_TIP_" + this.name());
        }
    }

    public static enum DicomSaveType implements ag
    {
        NORMAL,
        NORMAL_EXTENT,
        DICOM_CINE,
        FUSION_COMPOSITE,
        FUSION_ALIGNED_SECONDARY,
        FUSION_SECONDARY_CAPTURE,
        MIP_SECONDARY_CAPTURE;

        private static final String DICOM_SAVE_TYPE_ = "DICOM_SAVE_TYPE_";

        @Override
        public String getExternalizedString() {
            return props.getProperty(DICOM_SAVE_TYPE_ + this.name());
        }
    }
}

