/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.google.common.collect.HashBiMap;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.keyboard.bg;
import com.mimvista.commands.workflow.DicomSaveCommand;
import com.mimvista.dicom.gui.DicomSaveInputFactory;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.dicom.write.FusionVolumeDeriver;
import com.mimvista.dicom.write.deformable.DcmDeformableRegWriter;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.l;
import com.mimvista.gui.util.m;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.ab;
import com.mimvista.internals.fusionmode.FusionMode;
import com.mimvista.internals.fusionmode.FusionModeSubValue;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.internals.linking.WarpTransform;
import com.mimvista.internals.s;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.presenters.ProtocolMenu;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.preferencesNew.DicomsavePrefs;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.cn;
import com.mimvista.util.extents.a;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.f;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DicomSaveInputNotification
extends InputNotification {
    public static Messages props = Messages.a("Dicom");
    protected DicomSaveInputFactory.DicomSaveCallback cb;
    private DicomSaveInputFactory.DicomSaveType saveType;
    private a extentInfo;
    private Pair<String, String> origModalities;
    private l<SendToDestination> destination;
    private l<String> modality;
    private l<String> resolution;
    private String[] resOptions;
    private l<Boolean> saveAxial;
    private l<Boolean> saveSagittal;
    private l<Boolean> saveCoronal;
    private com.mimvista.gui.util.u<Float> sliceSampleFrequency;
    private l<String> dicomName;
    private l<String> patientID;
    private l<String> studyID;
    private l<String> accession;
    private l<String> referringLast;
    private l<String> referringFirst;
    private l<String> ownerName;
    private l<String> studyDesc;
    private l<ViewController> secCapAssociatedWith;
    protected l<String> seriesDesc;
    private l<Boolean> saveSUV = null;
    private l<Boolean> squareVoxels;
    private l<Boolean> keepAssociation;
    private l<Boolean> applyGantryTilt;
    private l<Boolean> applyViewingRotation;
    private l<Boolean> saveOrthogonal;
    private JLabel slabString;
    private String defaultSeriesDescription = "";
    protected final WeakReference<ViewController> vc;
    private ActionListener planeLabelUpdator;

    public DicomSaveInputNotification(DicomSaveInputFactory.DicomSaveType dicomSaveType, ViewController viewController, DicomSaveInputFactory.DicomSaveCallback dicomSaveCallback, a a2, SendToDestination sendToDestination) {
        this(dicomSaveType, viewController, dicomSaveCallback, a2, sendToDestination, new Notification.a(viewController), true);
    }

    public DicomSaveInputNotification(DicomSaveInputFactory.DicomSaveType dicomSaveType, ViewController viewController, DicomSaveInputFactory.DicomSaveCallback dicomSaveCallback, a a2, SendToDestination sendToDestination, Notification.a a3) {
        this(dicomSaveType, viewController, dicomSaveCallback, a2, sendToDestination, a3, true);
    }

    public DicomSaveInputNotification(DicomSaveInputFactory.DicomSaveType dicomSaveType, ViewController viewController, DicomSaveInputFactory.DicomSaveCallback dicomSaveCallback, a a2, SendToDestination sendToDestination, Notification.a a3, boolean bl2) {
        super(a3, com.mimvista.commands.f.b(DicomSaveCommand.class).c(), "save");
        this.cb = dicomSaveCallback;
        this.saveType = dicomSaveType;
        this.extentInfo = a2;
        this.setScrollBarType(AbstractInputContainer.ScrollBarType.b);
        this.vc = new WeakReference<ViewController>(viewController);
        if (bl2) {
            this.build(viewController, sendToDestination);
        }
    }

    @Override
    public void didShow() {
        boolean bl2 = DicomPrefs.warnIfClosingSessionWithSaveDialog.getValue();
        if (bl2) {
            ((ViewController)this.vc.get()).k(true);
        }
    }

    @Override
    protected void handleBeingDismissed() {
        super.handleBeingDismissed();
        ((ViewController)this.vc.get()).k(false);
    }

    protected void build(final ViewController viewController, SendToDestination sendToDestination) {
        this.addTitle(this.makeTitle());
        final SeriesInfo seriesInfo = viewController.U() && this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_ALIGNED_SECONDARY ? ((s)viewController).C().I() : viewController.aP();
        if (this.cb.options.seriesDescription != null) {
            seriesInfo.seriesDesc = this.cb.options.seriesDescription;
        }
        if (this.cb.options.studyDescription != null) {
            seriesInfo.studyDesc = this.cb.options.studyDescription;
        }
        this.buildDestination(viewController, sendToDestination);
        this.buildModalityOptions(viewController, seriesInfo);
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_ALIGNED_SECONDARY && viewController instanceof s) {
            this.buildAlignedSecondaryResolutionOptions(viewController);
        } else {
            this.resOptions = null;
            this.resolution = null;
        }
        if (this.saveType != DicomSaveInputFactory.DicomSaveType.DICOM_CINE && this.saveType != DicomSaveInputFactory.DicomSaveType.MIP_SECONDARY_CAPTURE) {
            this.buildPlaneOptions(viewController);
        } else {
            this.saveAxial = null;
            this.saveSagittal = null;
            this.saveCoronal = null;
        }
        this.buildDemographicOptions(viewController, seriesInfo);
        this.buildWriteOptions(viewController, seriesInfo);
        final JComboBox jComboBox = (JComboBox)this.modality.g();
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)jComboBox.getSelectedItem();
                if (DicomSaveInputNotification.this.saveAxial != null && DicomSaveInputNotification.this.saveCoronal != null && DicomSaveInputNotification.this.saveSagittal != null) {
                    if (DicomSaveInputNotification.this.extentInfo == null || DicomSaveInputNotification.this.saveType != DicomSaveInputFactory.DicomSaveType.NORMAL_EXTENT) {
                        if (string.contains(DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE) && DicomSaveInputNotification.this.extentInfo != null) {
                            DicomSaveInputNotification.this.saveAxial.a(false);
                            DicomSaveInputNotification.this.saveSagittal.a(false);
                            DicomSaveInputNotification.this.saveCoronal.a(false);
                            ((JCheckBox)DicomSaveInputNotification.this.saveAxial.g()).setSelected(((DicomSaveInputNotification)DicomSaveInputNotification.this).extentInfo.a == PresentationType.a);
                            ((JCheckBox)DicomSaveInputNotification.this.saveSagittal.g()).setSelected(((DicomSaveInputNotification)DicomSaveInputNotification.this).extentInfo.a == PresentationType.b);
                            ((JCheckBox)DicomSaveInputNotification.this.saveCoronal.g()).setSelected(((DicomSaveInputNotification)DicomSaveInputNotification.this).extentInfo.a == PresentationType.c);
                        } else {
                            DicomSaveInputNotification.this.saveAxial.a(true);
                            DicomSaveInputNotification.this.saveSagittal.a(true);
                            DicomSaveInputNotification.this.saveCoronal.a(true);
                        }
                    }
                    if (DicomSaveInputNotification.this.slabString != null) {
                        if (string.contains(DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE)) {
                            DicomSaveInputNotification.this.slabString.setVisible(DicomSaveInputNotification.this.doAnyPresentationsHaveSlabbingEnabled(viewController));
                        } else {
                            DicomSaveInputNotification.this.slabString.setVisible(false);
                        }
                    }
                }
                DicomSaveInputNotification.this.updateSeriesDescription(false);
                if (DicomSaveInputNotification.this.saveSUV != null) {
                    boolean bl2 = "PT".equals(string);
                    DicomSaveInputNotification.this.saveSUV.a(bl2);
                    ((JCheckBox)DicomSaveInputNotification.this.saveSUV.g()).setSelected(bl2 && DcmWriter.shouldDefaultToSaveAsSUV(seriesInfo));
                }
            }
        });
        this.refreshPlaneOptions();
        this.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DicomSaveInputNotification.this.setupAndRunCallback();
            }
        });
        this.updateSeriesDescription(true);
    }

    private void updateSeriesDescription(boolean bl2) {
        Object object;
        boolean bl3 = false;
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_SECONDARY_CAPTURE || this.saveType == DicomSaveInputFactory.DicomSaveType.MIP_SECONDARY_CAPTURE) {
            bl3 = true;
        } else {
            object = (JComboBox)this.modality.g();
            String string = (String)((JComboBox)object).getSelectedItem();
            if (string == null) {
                return;
            }
            if (string.contains(DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE)) {
                bl3 = true;
            }
        }
        object = DcmSecondaryCapturePrefs.captureDefaultDescription.getValue();
        if (bl3) {
            if (!((String)object).isEmpty()) {
                if (bl2) {
                    if (this.getBuildField(this.seriesDesc.g()).h().equals(this.defaultSeriesDescription)) {
                        this.seriesDesc.a((String)object);
                    }
                } else if (this.seriesDesc.b().equals(this.defaultSeriesDescription)) {
                    this.seriesDesc.b((String)object);
                }
            }
        } else if (bl2) {
            if (this.getBuildField(this.seriesDesc.g()).h().equals(object)) {
                this.seriesDesc.a(this.defaultSeriesDescription);
            }
        } else if (this.seriesDesc.b().equals(object)) {
            this.seriesDesc.b(this.defaultSeriesDescription);
        }
    }

    protected String makeTitle() {
        return this.saveType.getExternalizedString();
    }

    protected void setupAndRunCallback() {
        Object object;
        this.cb.destination = this.destination.b();
        this.cb.modality = this.modality.b();
        this.cb.saveType = this.saveType;
        if (this.extentInfo != null) {
            object = this.extentInfo.e();
            int[] nArray = new int[]{0, object[0] - 1, 0, object[1] - 1, 0, object[2] - 1};
            int[] nArray2 = this.extentInfo.d();
            nArray[this.extentInfo.a.a()[2] * 2] = nArray2[0];
            nArray[this.extentInfo.a.a()[2] * 2 + 1] = nArray2[1];
            this.cb.extent = nArray;
            this.cb.frmIdx = this.extentInfo.f().a();
        }
        if (this.cb.modality != null && this.cb.modality.contains(DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE)) {
            this.cb.options.modality = DcmSecondaryCapturePrefs.secondaryDicomModality.getValue();
            if ("ORIGINAL".equalsIgnoreCase(this.cb.options.modality)) {
                this.cb.options.modality = this.vc.get() != null && ((ViewController)this.vc.get()).U() ? ("Primary".equalsIgnoreCase((String)(object = (Object)DcmSecondaryCapturePrefs.fusionOriginal.getValue())) ? (String)this.origModalities.x : (String)this.origModalities.y) : (String)this.origModalities.x;
            }
        } else {
            this.cb.options.modality = this.cb.modality;
        }
        this.cb.options.dicomName = this.dicomName.b();
        this.cb.options.patientID = this.patientID.b();
        this.cb.options.studyID = this.studyID.b();
        this.cb.options.accession = this.accession.b();
        this.cb.options.referringLast = this.referringLast.b();
        this.cb.options.referringFirst = this.referringFirst.b();
        this.cb.options.studyDescription = this.studyDesc.b();
        this.cb.options.seriesDescription = this.seriesDesc.b();
        this.cb.options.keepAssociation = this.keepAssociation.b();
        this.cb.options.saveSUV = this.saveSUV == null ? false : this.saveSUV.b();
        this.cb.options.squareVoxels = this.squareVoxels == null ? true : this.squareVoxels.b();
        this.cb.options.applyViewingRotation = this.applyViewingRotation != null ? this.applyViewingRotation.b() : true;
        this.cb.options.saveAsOrthogonal = this.saveOrthogonal != null ? this.saveOrthogonal.b() : false;
        if (this.secCapAssociatedWith != null) {
            this.cb.options.savedAssociatedUID = this.secCapAssociatedWith.b().getUncopiedMutableInfo().studyUID;
        }
        if ((object = (Object)((Float)this.sliceSampleFrequency.b())) == null) {
            object = Float.valueOf(0.0f);
        }
        if (((Float)object).floatValue() < 0.0f) {
            object = Float.valueOf(0.0f);
        }
        this.cb.options.sliceSampleFreq = ((Float)object).floatValue();
        this.cb.options.applyGantryTilt = this.applyGantryTilt != null ? this.applyGantryTilt.b() : false;
        if (this.saveAxial != null && this.saveSagittal != null && this.saveCoronal != null) {
            this.cb.saveCoronal = this.saveCoronal.b();
            this.cb.saveSagittal = this.saveSagittal.b();
            this.cb.saveAxial = this.saveAxial.b();
        }
        if (this.resolution != null && this.resOptions != null) {
            for (int i2 = 0; i2 < this.resOptions.length; ++i2) {
                if (!this.resOptions[i2].equals(this.resolution.b())) continue;
                this.cb.rez = DicomSaveInputFactory.AlignedSecondaryResolutionOption.values()[i2];
                break;
            }
        }
        u.b().d(this);
        SwingUtilities.invokeLater(this.cb);
    }

    private void buildDemographicOptions(ViewController viewController, SeriesInfo seriesInfo) {
        this.dicomName = this.addTextField(props.getProperty("DICOM_SAVE_DICOM_NAME"));
        this.patientID = this.addTextField(props.getProperty("DICOM_SAVE_PATIENT_ID"));
        this.studyID = this.addTextField(props.getProperty("DICOM_SAVE_STUDY_ID"));
        this.accession = this.addTextField(props.getProperty("DICOM_SAVE_ACCESSION_NUMBER"));
        this.referringLast = this.addTextField(props.getProperty("DICOM_SAVE_REFERRING_LAST"));
        this.referringFirst = this.addTextField(props.getProperty("DICOM_SAVE_REFERRING_FIRST"));
        this.studyDesc = this.addTextField(props.getProperty("DICOM_SAVE_STUDY_DESCRIPTION"));
        this.seriesDesc = this.addTextField(props.getProperty("DICOM_SAVE_SERIES_DESCRIPTION"));
        this.fillDemographicOptions(viewController, seriesInfo, true);
    }

    private void fillDemographicOptions(ViewController viewController, SeriesInfo seriesInfo, boolean bl2) {
        Cloneable cloneable;
        SeriesInfo seriesInfo2 = this.usePrimaryPatientNameAndPatientIDAndStudyIDIfNecessary(viewController, seriesInfo);
        if (bl2) {
            this.dicomName.a(seriesInfo2.patientNameRaw);
        } else {
            this.dicomName.b(seriesInfo2.patientNameRaw);
        }
        if (bl2) {
            this.patientID.a(seriesInfo2.patientId);
            this.studyID.a(seriesInfo2.studyID);
            this.accession.a(seriesInfo2.accession);
            this.studyDesc.a(seriesInfo2.studyDesc);
        } else {
            this.patientID.b(seriesInfo2.patientId);
            this.studyID.b(seriesInfo2.studyID);
            this.accession.b(seriesInfo2.accession);
            this.studyDesc.b(seriesInfo2.studyDesc);
        }
        String string = seriesInfo2.referringPhys;
        String[] stringArray = string.split(",");
        if (stringArray.length > 0) {
            if (bl2) {
                this.referringLast.a(stringArray[0]);
            } else {
                this.referringLast.b(stringArray[0]);
            }
        }
        if (stringArray.length > 1) {
            if (bl2) {
                this.referringFirst.a(stringArray[1]);
            } else {
                this.referringFirst.b(stringArray[1]);
            }
        }
        String string2 = seriesInfo2.seriesDesc;
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.DICOM_CINE) {
            string2 = "MIP MOVIE: " + seriesInfo2.seriesDesc;
        }
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_ALIGNED_SECONDARY) {
            cloneable = ((s)viewController).V().getUncopiedMutableInfo();
            SeriesInfo seriesInfo3 = ((s)viewController).B();
            string2 = FusionVolumeDeriver.makeAlignedSecondarySeriesDescription((SeriesInfo)cloneable, seriesInfo3);
        }
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_COMPOSITE) {
            cloneable = ((s)viewController).ae();
            string2 = ((FusionMode)cloneable).getExternalizedString();
            if (cloneable instanceof FusionModeSubValue) {
                string2 = string2 + " diff";
            }
            string2 = string2 + ": " + seriesInfo2.seriesDesc;
        }
        this.defaultSeriesDescription = string2;
        if (bl2) {
            this.seriesDesc.a(string2);
        } else {
            this.seriesDesc.b(string2);
        }
    }

    private SeriesInfo usePrimaryPatientNameAndPatientIDAndStudyIDIfNecessary(ViewController viewController, SeriesInfo seriesInfo) {
        SeriesInfo seriesInfo2 = null;
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_ALIGNED_SECONDARY && viewController.U()) {
            seriesInfo2 = seriesInfo.m();
            seriesInfo2.patientName = ((s)viewController).V().getUncopiedMutableInfo().patientName;
            seriesInfo2.patientNameRaw = ((s)viewController).V().getUncopiedMutableInfo().patientNameRaw;
            seriesInfo2.patientId = ((s)viewController).V().getUncopiedMutableInfo().patientId;
            seriesInfo2.studyID = ((s)viewController).V().getUncopiedMutableInfo().studyID;
        } else if (this.saveType == DicomSaveInputFactory.DicomSaveType.NORMAL && bg.b(viewController) != null) {
            WarpTransform warpTransform = bg.b(viewController);
            DcmDeformableRegWriter.DeformableSaveHelper deformableSaveHelper = warpTransform.O();
            seriesInfo2 = seriesInfo.m();
            if (!cn.h(deformableSaveHelper.getDestPatientName())) {
                seriesInfo2.patientName = deformableSaveHelper.getDestPatientName();
                seriesInfo2.patientNameRaw = deformableSaveHelper.getDestPatientName();
            }
            if (!cn.h(deformableSaveHelper.getDestSeriesUid())) {
                seriesInfo2.patientId = deformableSaveHelper.getDestPatientId();
            }
        } else {
            seriesInfo2 = seriesInfo;
        }
        return seriesInfo2;
    }

    private void buildModalityOptions(ViewController viewController, SeriesInfo seriesInfo) {
        this.origModalities = Pair.get(null, null);
        if (viewController.U()) {
            s s2 = (s)viewController;
            ViewController3D viewController3D = s2.V();
            seriesInfo = viewController3D.getUncopiedMutableInfo();
            this.origModalities.x = viewController3D.getUncopiedMutableInfo().modality;
            this.origModalities.y = s2.B().modality;
        } else {
            this.origModalities.x = seriesInfo.modality;
        }
        if (this.origModalities.y == null && seriesInfo.modality == "PT" && seriesInfo.u().v()) {
            this.origModalities.x = "RTDOSE";
        }
        this.modality = this.addComboBox(props.getProperty("DICOM_SAVE_MODALITY"), DicomSaveInputFactory.formModalityChoices(this.saveType, this.origModalities, viewController.U()));
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.DICOM_CINE) {
            this.modality.a(viewController.getModality());
        } else if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_COMPOSITE) {
            this.modality.a("PT");
        } else {
            this.modality.a(viewController.getModality());
        }
    }

    public static SendToDestination getBestDestForVc(ViewController viewController) {
        if (ag.d() != null) {
            return ag.d();
        }
        SearchSource searchSource = viewController.U() ? ((s)viewController).V().bK() : viewController.bK();
        return ag.a(searchSource);
    }

    private void buildDestination(ViewController viewController, SendToDestination sendToDestination) {
        this.destination = this.addSendToCombo(props.getProperty("DICOM_SAVE_DESTINATION"));
        SendToDestination sendToDestination2 = sendToDestination;
        if (sendToDestination2 == null) {
            sendToDestination2 = DicomSaveInputNotification.getBestDestForVc(viewController);
        }
        this.destination.a(sendToDestination2);
    }

    private void buildAlignedSecondaryResolutionOptions(ViewController viewController) {
        Object object;
        s s2 = (s)viewController;
        DicomSaveInputFactory.AlignedSecondaryResolutionOption[] alignedSecondaryResolutionOptionArray = DicomSaveInputFactory.AlignedSecondaryResolutionOption.values();
        this.resOptions = new String[alignedSecondaryResolutionOptionArray.length];
        final HashBiMap hashBiMap = HashBiMap.create((int)alignedSecondaryResolutionOptionArray.length);
        for (int i2 = 0; i2 < this.resOptions.length; ++i2) {
            String string;
            this.resOptions[i2] = alignedSecondaryResolutionOptionArray[i2].getExternalizedString();
            if (alignedSecondaryResolutionOptionArray[i2] == DicomSaveInputFactory.AlignedSecondaryResolutionOption.PRIMARY_RESOLUTION) {
                object = s2.cw().a();
                string = "(" + object[PresentationType.a.a()[0]] + "x" + object[PresentationType.a.a()[1]] + ")";
                int n2 = i2;
                this.resOptions[n2] = this.resOptions[n2] + " " + string;
            } else if (alignedSecondaryResolutionOptionArray[i2] == DicomSaveInputFactory.AlignedSecondaryResolutionOption.SECONDARY_RESOLUTION) {
                object = s2.C().a();
                string = "(" + object[PresentationType.a.a()[0]] + "x" + object[PresentationType.a.a()[1]] + ")";
                int n3 = i2;
                this.resOptions[n3] = this.resOptions[n3] + " " + string;
            }
            hashBiMap.put((Object)this.resOptions[i2], (Object)alignedSecondaryResolutionOptionArray[i2]);
        }
        this.resolution = this.addComboBox(props.getProperty("DICOM_SAVE_FUSION_ALIGNED_SECONDARY_RESOLUTION") + ":", this.resOptions);
        this.addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DicomsavePrefs.alignedSecResolution.setValue((DicomSaveInputFactory.AlignedSecondaryResolutionOption)hashBiMap.get(DicomSaveInputNotification.this.resolution.b()));
            }
        });
        DicomSaveInputFactory.AlignedSecondaryResolutionOption alignedSecondaryResolutionOption = DicomsavePrefs.alignedSecResolution.getValue();
        if (alignedSecondaryResolutionOption != null) {
            object = (String)hashBiMap.inverse().get((Object)alignedSecondaryResolutionOption);
            this.resolution.a((String)object);
        }
        this.modality.a(s2.B().modality);
    }

    private void buildPlaneOptions(ViewController viewController) {
        m m2 = this.addHorizontalCollection(props.getProperty("DICOM_SAVE_SAVE_PLANE"), null);
        this.saveAxial = m2.d("");
        this.saveSagittal = m2.d("");
        this.saveCoronal = m2.d("");
        this.planeLabelUpdator = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DicomSaveInputNotification.this.refreshPlaneOptions();
            }
        };
        viewController.a(this.planeLabelUpdator, true, ViewLink.ViewEvent.e);
        this.saveAxial.a((Boolean)this.cb.saveAxial);
        this.saveSagittal.a((Boolean)this.cb.saveSagittal);
        this.saveCoronal.a((Boolean)this.cb.saveCoronal);
        if (this.extentInfo != null) {
            this.saveAxial.a((Boolean)(this.extentInfo.a == PresentationType.a ? 1 : 0));
            this.saveSagittal.a((Boolean)(this.extentInfo.a == PresentationType.b ? 1 : 0));
            this.saveCoronal.a((Boolean)(this.extentInfo.a == PresentationType.c ? 1 : 0));
        }
        if (!(EnumSet.of(DicomSaveInputFactory.DicomSaveType.NORMAL, DicomSaveInputFactory.DicomSaveType.FUSION_ALIGNED_SECONDARY, DicomSaveInputFactory.DicomSaveType.FUSION_COMPOSITE).contains(this.saveType) || this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_SECONDARY_CAPTURE && this.extentInfo == null)) {
            this.saveAxial.a(false);
            this.saveSagittal.a(false);
            this.saveCoronal.a(false);
        }
    }

    private void refreshPlaneOptions() {
        if (this.saveAxial == null) {
            return;
        }
        this.refreshPlaneOptions(this.getClosestAnatomicalPlaneToLogicalPlane(PresentationType.a), (JCheckBox)this.saveAxial.g());
        this.refreshPlaneOptions(this.getClosestAnatomicalPlaneToLogicalPlane(PresentationType.b), (JCheckBox)this.saveSagittal.g());
        this.refreshPlaneOptions(this.getClosestAnatomicalPlaneToLogicalPlane(PresentationType.c), (JCheckBox)this.saveCoronal.g());
    }

    private void refreshPlaneOptions(PresentationType presentationType, JCheckBox jCheckBox) {
        jCheckBox.setText(DicomSaveInputNotification.getPlaneLabel(presentationType));
    }

    private PresentationType getClosestAnatomicalPlaneToLogicalPlane(PresentationType presentationType) {
        ViewController viewController = (ViewController)this.vc.get();
        if (viewController == null) {
            return PresentationType.a;
        }
        boolean bl2 = false;
        if (this.applyViewingRotation != null) {
            bl2 = this.applyViewingRotation.b();
        }
        return ab.a(viewController, presentationType, bl2);
    }

    public static String getPlaneLabel(PresentationType presentationType) {
        if (presentationType == PresentationType.c) {
            return props.getProperty("DICOM_SAVE_CORONAL");
        }
        if (presentationType == PresentationType.b) {
            return props.getProperty("DICOM_SAVE_SAGITTAL");
        }
        return props.getProperty("DICOM_SAVE_AXIAL");
    }

    public static String getPlaneLabel(ViewController viewController, PresentationType presentationType) {
        PresentationType presentationType2 = ab.b(viewController, presentationType);
        return DicomSaveInputNotification.getPlaneLabel(presentationType2);
    }

    private void buildWriteOptions(ViewController viewController, SeriesInfo seriesInfo) {
        Object object;
        Object object2;
        boolean bl2 = false;
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_COMPOSITE) {
            bl2 = false;
        } else if (seriesInfo.modality.equals("PT") && seriesInfo.u().x() && seriesInfo.modInfo instanceof PTSeriesInfo) {
            String string = ((PTSeriesInfo)seriesInfo.modInfo).origUnits;
            if (!seriesInfo.u().c(string)) {
                bl2 = true;
            }
        }
        if (bl2) {
            this.saveSUV = this.addCollection(props.getProperty("DICOM_SAVE_SAVE_SUV"), null, 0).d("");
            this.saveSUV.a((Boolean)DcmWriter.shouldDefaultToSaveAsSUV(seriesInfo));
        }
        float f2 = DcmSecondaryCapturePrefs.captureDefaultSliceSpacing.getValue().floatValue();
        if (viewController != null && viewController.ao_() != null) {
            f2 = this.extentInfo != null && this.extentInfo.a != null ? viewController.ao_()[this.extentInfo.a.a()[2]] : viewController.ao_()[PresentationType.a.a()[2]];
        }
        this.sliceSampleFrequency = this.addFloatField(props.getProperty("DICOM_SAVE_SAMPLE_RATE"));
        this.sliceSampleFrequency.c(Float.valueOf(f2));
        this.sliceSampleFrequency.c(props.getProperty("DICOM_SAVE_SAMPLE_RATE_TOOLTIP"));
        if (viewController != null && !viewController.U() && viewController.bi()) {
            this.slabString = this.addCollection("", null, 0).b(Messages.a("GeneralPreferencesCollectionFactory", "SAVE_SLAB_SLICE_RES_WARNING"));
            this.slabString.setForeground(Color.RED);
            boolean bl3 = ((String)((JComboBox)this.modality.g()).getSelectedItem()).contains(DcmWriterFactory.SECONDARY_CAPTURE_SINGLE_PLANE);
            this.slabString.setVisible(bl3 &= this.doAnyPresentationsHaveSlabbingEnabled(viewController));
        } else {
            this.slabString = null;
        }
        if (!EnumSet.of(DicomSaveInputFactory.DicomSaveType.MIP_SECONDARY_CAPTURE, DicomSaveInputFactory.DicomSaveType.FUSION_SECONDARY_CAPTURE).contains(this.saveType)) {
            this.squareVoxels = this.addCollection(props.getProperty("DICOM_SAVE_SQUARE_VOXELS"), null, 0).d("").a((Boolean)false);
        }
        if (viewController != null && viewController.bi() && (this.saveType == DicomSaveInputFactory.DicomSaveType.NORMAL || this.saveType == DicomSaveInputFactory.DicomSaveType.NORMAL_EXTENT) && viewController.getUncopiedMutableInfo().H() != null) {
            this.applyGantryTilt = this.addCheckBox(props.b("DICOM_SAVE_APPLY_GANTRY_TILT_CORRECTION"));
            this.applyGantryTilt.a((Boolean)true);
        } else {
            this.applyGantryTilt = null;
        }
        if (viewController != null && viewController.bi() && (this.saveType == DicomSaveInputFactory.DicomSaveType.NORMAL || this.saveType == DicomSaveInputFactory.DicomSaveType.NORMAL_EXTENT)) {
            this.applyViewingRotation = this.addCollection(props.getProperty("DICOM_SAVE_APPLY_VIEWING"), null, 0).d("").a((Boolean)true);
            this.saveOrthogonal = this.addCollection(props.getProperty("DICOM_SAVE_SAVE_ORTHOGONAL"), null, 0).d("").a((Boolean)false);
        }
        this.keepAssociation = this.addCollection(props.getProperty("DICOM_SAVE_KEEP_ASSOCIATION"), null, 0).d("");
        this.keepAssociation.a((Boolean)true);
        final JCheckBox jCheckBox = (JCheckBox)this.keepAssociation.g();
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (DicomSaveInputNotification.this.secCapAssociatedWith != null) {
                    if (jCheckBox.isSelected()) {
                        DicomSaveInputNotification.this.secCapAssociatedWith.a(true);
                    } else {
                        DicomSaveInputNotification.this.secCapAssociatedWith.a(false);
                    }
                }
            }
        });
        if (this.saveType == DicomSaveInputFactory.DicomSaveType.FUSION_SECONDARY_CAPTURE && viewController.U()) {
            object2 = (s)viewController;
            object = new ViewController[]{((s)object2).c, ((s)object2).d};
            this.secCapAssociatedWith = this.addComboBox("", (ItemType[])object);
            this.secCapAssociatedWith.a(object[0]);
            final JComboBox jComboBox = (JComboBox)this.secCapAssociatedWith.g();
            jComboBox.setRenderer(new SeriesListCellRenderer());
            jComboBox.setPreferredSize(new Dimension(250, 55));
            jComboBox.addItemListener(new ItemListener((s)object2){
                final /* synthetic */ s val$fusVC;
                {
                    this.val$fusVC = s2;
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    ViewController viewController = (ViewController)jComboBox.getSelectedItem();
                    DicomSaveInputNotification.this.fillDemographicOptions(this.val$fusVC, viewController.getUncopiedMutableInfo(), false);
                }
            });
        }
        if (this.applyViewingRotation != null) {
            object2 = (JCheckBox)this.applyViewingRotation.g();
            ((AbstractButton)object2).addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DicomSaveInputNotification.this.refreshPlaneOptions();
                }
            });
        }
        if (this.applyGantryTilt != null) {
            object2 = (JCheckBox)this.applyGantryTilt.g();
            object = (ViewController[])this.applyViewingRotation.g();
            ((AbstractButton)object2).addChangeListener(new ChangeListener((JCheckBox)object2, (JCheckBox)object){
                final /* synthetic */ JCheckBox val$chkGantry;
                final /* synthetic */ JCheckBox val$chkView;
                {
                    this.val$chkGantry = jCheckBox;
                    this.val$chkView = jCheckBox2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (!this.val$chkGantry.isSelected()) {
                        this.val$chkView.setSelected(false);
                    }
                }
            });
            ((AbstractButton)object).addChangeListener(new ChangeListener((JCheckBox)object, (JCheckBox)object2){
                final /* synthetic */ JCheckBox val$chkView;
                final /* synthetic */ JCheckBox val$chkGantry;
                {
                    this.val$chkView = jCheckBox;
                    this.val$chkGantry = jCheckBox2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.val$chkView.isSelected()) {
                        this.val$chkGantry.setSelected(true);
                    }
                }
            });
        }
        if (this.saveOrthogonal != null) {
            object2 = (JCheckBox)this.saveOrthogonal.g();
            object = (JCheckBox)this.keepAssociation.g();
            ((AbstractButton)object2).addChangeListener(new ChangeListener((JCheckBox)object2, (JCheckBox)object){
                final /* synthetic */ JCheckBox val$chkOrtho;
                final /* synthetic */ JCheckBox val$chkAssoc;
                {
                    this.val$chkOrtho = jCheckBox;
                    this.val$chkAssoc = jCheckBox2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.val$chkOrtho.isSelected()) {
                        this.val$chkAssoc.setSelected(false);
                    }
                }
            });
            ((AbstractButton)object).addChangeListener(new ChangeListener((JCheckBox)object, (JCheckBox)object2){
                final /* synthetic */ JCheckBox val$chkAssoc;
                final /* synthetic */ JCheckBox val$chkOrtho;
                {
                    this.val$chkAssoc = jCheckBox;
                    this.val$chkOrtho = jCheckBox2;
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    if (this.val$chkAssoc.isSelected()) {
                        this.val$chkOrtho.setSelected(false);
                    }
                }
            });
        }
    }

    private boolean doAnyPresentationsHaveSlabbingEnabled(ViewController viewController) {
        PresentationType[] presentationTypeArray = new PresentationType[]{PresentationType.a, PresentationType.b, PresentationType.c};
        ViewStateNew viewStateNew = viewController.ap();
        if (viewStateNew instanceof ViewStateNew.ViewStateNew3D) {
            for (PresentationType presentationType : presentationTypeArray) {
                if (!((ViewStateNew.ViewStateNew3D)viewStateNew).b((PresentationType)presentationType).slabbingEnabled) continue;
                return true;
            }
        }
        return false;
    }

    private class SeriesListCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;
        float SERIES_COMBO_FONT_SIZE = 5.0f;
        private Dimension SERIES_COMBO_THUMB_RECT = new Dimension(40, 40);

        public SeriesListCellRenderer() {
            this.setHorizontalAlignment(2);
            this.setFont(this.getFont().deriveFont(this.SERIES_COMBO_FONT_SIZE));
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
            super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
            if (!(object instanceof ViewController)) {
                return this;
            }
            ViewController viewController = (ViewController)object;
            this.setText(f.a(8, viewController));
            ImageIcon imageIcon = new ImageIcon(ProtocolMenu.a(viewController, this.SERIES_COMBO_THUMB_RECT));
            this.setIcon(imageIcon);
            return this;
        }
    }
}

