/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.dicom.gui.HUEDProfilePanel;
import com.mimvista.dicom.util.HUEDConverter;
import com.mimvista.dicom.util.HUEDProfile;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.MIMSwingUtils;
import com.mimvista.gui.util.c;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.license.LicenseTransformer;
import com.mimvista.mui.MIMJDialog;
import com.mimvista.numerics.ImageCube;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class HUEDProfileEditor
extends MIMJDialog {
    public static Messages props = Messages.a("Dicom");
    private final int width = 500;
    private final int height = 800;
    private HUEDProfilePanel profilePanel;
    private ViewController vc;
    private JButton linkBut;
    private boolean forLink;

    public HUEDProfileEditor(JFrame jFrame, ViewController viewController) {
        super((Window)jFrame, props.getProperty("HUED_EDITOR_TITLE"), false, false);
        this.vc = viewController;
        this.forLink = viewController != null && viewController.getUncopiedMutableInfo().u().o();
        this.setSize(500, 800);
        this.setLocationRelativeTo(jFrame);
        this.setDefaultCloseOperation(2);
        this.buildUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
    }

    private void buildUI() {
        this.profilePanel = new HUEDProfilePanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.profilePanel, "Center");
        JButton jButton = c.c(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (HUEDProfileEditor.this.profilePanel.saveProfiles()) {
                    HUEDProfileEditor.this.setVisible(false);
                    HUEDProfileEditor.this.dispose();
                }
            }
        }, "");
        this.linkBut = new JButton(props.getProperty("HUED_EDITOR_LINK"));
        this.linkBut.setIcon(ImageManipulator.c("link", 18));
        this.linkBut.setToolTipText(props.getProperty("HUED_EDITOR_LINK_TIP"));
        this.linkBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode = HUEDProfileEditor.this.profilePanel.getLastSelectedProfileNode();
                if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile && HUEDProfileEditor.this.vc instanceof ViewController3D) {
                    HUEDProfile hUEDProfile = (HUEDProfile)object;
                    ((ViewController3D)HUEDProfileEditor.this.vc).a(hUEDProfile);
                }
            }
        });
        if (LicenseTransformer.isDevelopment()) {
            this.linkBut.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 3 && mouseEvent.getClickCount() >= 2) {
                        HUEDProfileEditor.this.setVisible(false);
                        HUEDProfileEditor.this.dispose();
                        MIMSwingUtils.a(new Runnable(){

                            @Override
                            public void run() {
                                Object object;
                                DefaultMutableTreeNode defaultMutableTreeNode = HUEDProfileEditor.this.profilePanel.getLastSelectedProfileNode();
                                if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile && HUEDProfileEditor.this.vc instanceof ViewController3D) {
                                    ay.e("Adjust CT numbers...");
                                    HUEDProfile hUEDProfile = (HUEDProfile)object;
                                    HUEDConverter hUEDConverter = new HUEDConverter(hUEDProfile);
                                    ImageCube.ImageCubeShort imageCubeShort = (ImageCube.ImageCubeShort)((ImageVolumeShort)HUEDProfileEditor.this.vc.aw()).ad();
                                    for (short[] sArray : imageCubeShort.b()) {
                                        for (int i2 = 0; i2 < sArray.length; ++i2) {
                                            float f2 = HUEDProfileEditor.this.vc.av().a(sArray[i2]);
                                            float f3 = hUEDConverter.getCalibratedHU(f2);
                                            float f4 = HUEDProfileEditor.this.vc.av().c(f3);
                                            sArray[i2] = (short)Math.round(f4);
                                        }
                                    }
                                    ((ImageVolumeShort)HUEDProfileEditor.this.vc.aw()).aj();
                                    HUEDProfileEditor.this.vc.aN();
                                    HUEDProfileEditor.this.vc.g().Q();
                                    ay.e("Done!");
                                }
                            }
                        });
                    }
                }
            });
        }
        this.linkBut.setDefaultCapable(true);
        this.linkBut.setEnabled(false);
        this.profilePanel.addProfileSelectionListener(this.getTreeSelListener());
        JButton jButton2 = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfileEditor.this.setVisible(false);
                HUEDProfileEditor.this.dispose();
            }
        }, "");
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.linkBut);
        box.add(Box.createHorizontalStrut(5));
        box.add(jButton2);
        this.add((Component)box, "Last");
    }

    private TreeSelectionListener getTreeSelListener() {
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DefaultMutableTreeNode defaultMutableTreeNode = HUEDProfileEditor.this.profilePanel.getLastSelectedProfileNode();
                if (defaultMutableTreeNode == null) {
                    if (HUEDProfileEditor.this.forLink) {
                        HUEDProfileEditor.this.linkBut.setEnabled(false);
                    }
                    return;
                }
                Object object = defaultMutableTreeNode.getUserObject();
                if (object instanceof HUEDProfile) {
                    if (HUEDProfileEditor.this.forLink) {
                        HUEDProfileEditor.this.linkBut.setEnabled(true);
                    }
                } else if (HUEDProfileEditor.this.forLink) {
                    HUEDProfileEditor.this.linkBut.setEnabled(false);
                }
            }
        };
        return treeSelectionListener;
    }
}

