/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.dicom.util.HUEDConverter;
import com.mimvista.dicom.util.HUEDProfile;
import com.mimvista.dicom.util.HUEDProfileManager;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.gui.util.InputDialog;
import com.mimvista.gui.util.k;
import com.mimvista.gui.util.l;
import com.mimvista.report.gui.content.hued.HUEDProfileTableModel;
import com.mimvista.util.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class HUEDProfilePanel
extends JPanel {
    public static Messages props = Messages.a("Dicom");
    private final int width = 200;
    private final int height = 350;
    private JTree profileTree;
    private DefaultMutableTreeNode rootNode;
    private JPanel rPanel;
    private JTable dataTable;
    private ChartPanel chartPanel;
    private JButton graphBut;
    private JButton addRowBut;
    private JButton removeRowBut;

    public HUEDProfilePanel() {
        this.buildUI();
        this.clearSeedDataInGUI();
    }

    private void buildUI() {
        this.buildProfileTree();
        this.buildRightPanel();
        JScrollPane jScrollPane = new JScrollPane(this.profileTree);
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, this.rPanel);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setResizeWeight(0.0);
        this.buildChartPane();
        JSplitPane jSplitPane2 = new JSplitPane(0, jSplitPane, (Component)this.chartPanel);
        jSplitPane2.setOneTouchExpandable(true);
        jSplitPane2.setDividerLocation(Integer.MAX_VALUE);
        jSplitPane2.setResizeWeight(0.0);
        this.setLayout(new BorderLayout());
        jSplitPane2.setPreferredSize(new Dimension(200, 350));
        this.add((Component)jSplitPane2, "Center");
        JButton jButton = new JButton(props.getProperty("HUED_EDITOR_NEW_PROFILE"));
        jButton.setIcon(ImageManipulator.c("page", 18));
        jButton.setToolTipText(props.getProperty("HUED_EDITOR_NEW_PROFILE_TITLE"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.addNewProfile();
            }
        });
        jButton.setDefaultCapable(true);
        this.graphBut = new JButton(props.getProperty("HUED_EDITOR_GRAPH"));
        this.graphBut.setIcon(ImageManipulator.c("convert_CT", 18));
        this.graphBut.setToolTipText(props.getProperty("HUED_EDITOR_GRAPH_TIP"));
        this.graphBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.toggleGraph();
            }
        });
        this.addRowBut = new JButton();
        this.addRowBut.setIcon(ImageManipulator.c("add", 18));
        this.addRowBut.setToolTipText(props.getProperty("HUED_EDITOR_ADD_ROW"));
        this.addRowBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.addRow();
            }
        });
        this.addRowBut.setEnabled(false);
        this.removeRowBut = new JButton();
        this.removeRowBut.setIcon(ImageManipulator.c("subtract", 18));
        this.removeRowBut.setToolTipText(props.getProperty("HUED_EDITOR_DEL_ROWS"));
        this.removeRowBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.removeRow();
            }
        });
        this.removeRowBut.setEnabled(false);
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        box.add(jButton);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.graphBut);
        box.add(Box.createHorizontalGlue());
        box.add(this.addRowBut);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.removeRowBut);
        this.add((Component)box, "First");
    }

    private void toggleGraph() {
        JSplitPane jSplitPane = (JSplitPane)this.chartPanel.getParent();
        int n2 = jSplitPane.getSize().height - jSplitPane.getDividerSize() - 1;
        if (jSplitPane.getDividerLocation() >= n2) {
            int n3 = jSplitPane.getLastDividerLocation() < 0 ? n2 / 3 : jSplitPane.getLastDividerLocation();
            jSplitPane.setDividerLocation(n3);
            this.graphBut.setToolTipText(props.getProperty("HUED_EDITOR_GRAPH_HIDE_TIP"));
        } else {
            jSplitPane.setDividerLocation(n2);
            this.graphBut.setToolTipText(props.getProperty("HUED_EDITOR_GRAPH_TIP"));
        }
    }

    private void updateGraph(HUEDProfile hUEDProfile) {
        try {
            JFreeChart jFreeChart;
            Font font = new Font("Serif", 0, 12);
            if (hUEDProfile == null || hUEDProfile.getSize() < 3) {
                jFreeChart = ChartFactory.createBarChart((String)"", (String)props.getProperty("HUED_EDITOR_HU_COL"), (String)props.getProperty("HUED_EDITOR_ED_COL"), null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                jFreeChart.getCategoryPlot().getDomainAxis().setLabelFont(font);
                jFreeChart.getCategoryPlot().getRangeAxis().setLabelFont(font);
            } else {
                XYSeries xYSeries = new XYSeries((Comparable)((Object)props.getProperty("HUED_EDITOR_GRAPH_LINES")));
                HUEDConverter hUEDConverter = new HUEDConverter(hUEDProfile);
                float f2 = hUEDProfile.getMaxHU() + 100.0f;
                float f3 = hUEDProfile.getMinHU() - 100.0f;
                xYSeries.add(hUEDConverter.getHUThreshold(), (double)hUEDConverter.toED((float)hUEDConverter.getHUThreshold()));
                xYSeries.add((double)f3, (double)hUEDConverter.toED(f3));
                xYSeries.add((double)f2, (double)hUEDConverter.toED(f2));
                XYSeries xYSeries2 = new XYSeries((Comparable)((Object)props.getProperty("HUED_EDITOR_GRAPH_XYPT")));
                for (int i2 = 0; i2 < hUEDProfile.getSize(); ++i2) {
                    xYSeries2.add((double)hUEDProfile.getHU(i2), (double)hUEDProfile.getED(i2));
                }
                XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
                xYSeriesCollection.addSeries(xYSeries);
                xYSeriesCollection.addSeries(xYSeries2);
                jFreeChart = ChartFactory.createXYLineChart((String)"", (String)props.getProperty("HUED_EDITOR_HU_COL"), (String)props.getProperty("HUED_EDITOR_ED_COL"), (XYDataset)xYSeriesCollection, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
                XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
                xYLineAndShapeRenderer.setSeriesLinesVisible(0, true);
                xYLineAndShapeRenderer.setSeriesShapesVisible(0, false);
                xYLineAndShapeRenderer.setSeriesLinesVisible(1, false);
                xYLineAndShapeRenderer.setSeriesShapesVisible(1, true);
                xYPlot.setRenderer((XYItemRenderer)xYLineAndShapeRenderer);
                xYLineAndShapeRenderer.setBaseLegendTextFont(font);
                xYPlot.getDomainAxis().setLabelFont(font);
                xYPlot.getRangeAxis().setLabelFont(font);
            }
            this.chartPanel.setChart(jFreeChart);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JFreeChart jFreeChart = ChartFactory.createBarChart((String)"", (String)props.getProperty("HUED_EDITOR_HU_COL"), (String)props.getProperty("HUED_EDITOR_ED_COL"), null, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            this.chartPanel.setChart(jFreeChart);
        }
    }

    private void buildChartPane() {
        this.chartPanel = new ChartPanel(null);
    }

    private void buildProfileTree() {
        this.rootNode = new DefaultMutableTreeNode(props.getProperty("HUED_EDITOR_PROFILES"));
        HUEDProfileManager hUEDProfileManager = new HUEDProfileManager();
        List<HUEDProfile> list = hUEDProfileManager.getProfiles();
        for (HUEDProfile hUEDProfile : list) {
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(hUEDProfile);
            this.rootNode.add(defaultMutableTreeNode);
        }
        this.profileTree = new JTree(this.rootNode);
        this.profileTree.setRootVisible(true);
        this.profileTree.getSelectionModel().setSelectionMode(1);
        this.addProfileSelectionListener(this.getTreeSelListener());
        this.profileTree.addMouseListener(this.getTreeMouseListener());
        for (int i2 = 0; i2 < this.profileTree.getRowCount(); ++i2) {
            this.profileTree.expandRow(i2);
        }
        this.hookupProfileListMenu();
    }

    public void addProfileSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.profileTree.addTreeSelectionListener(treeSelectionListener);
    }

    public DefaultMutableTreeNode getLastSelectedProfileNode() {
        return (DefaultMutableTreeNode)this.profileTree.getLastSelectedPathComponent();
    }

    private MouseAdapter getTreeMouseListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode;
                if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (defaultMutableTreeNode = HUEDProfilePanel.this.getLastSelectedProfileNode()) != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile) {
                    HUEDProfilePanel.this.editProfile((HUEDProfile)object);
                }
            }
        };
        return mouseAdapter;
    }

    private TreeSelectionListener getTreeSelListener() {
        TreeSelectionListener treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                HUEDProfilePanel.this.updateTableAndGraph();
            }
        };
        return treeSelectionListener;
    }

    private void updateTableAndGraph() {
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastSelectedProfileNode();
        this.clearSeedDataInGUI();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (object instanceof HUEDProfile) {
            this.addRowBut.setEnabled(true);
            this.updateTable((HUEDProfile)object);
            this.updateGraph((HUEDProfile)object);
        }
    }

    private void hookupProfileListMenu() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            private void checkForPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    Point point = mouseEvent.getPoint();
                    TreePath treePath = HUEDProfilePanel.this.profileTree.getPathForLocation(point.x, point.y);
                    HUEDProfilePanel.this.profileTree.setSelectionPath(treePath);
                    DefaultMutableTreeNode defaultMutableTreeNode = HUEDProfilePanel.this.getLastSelectedProfileNode();
                    JPopupMenu jPopupMenu = HUEDProfilePanel.this.getMetaDataEditMenu(defaultMutableTreeNode);
                    jPopupMenu.show(HUEDProfilePanel.this.profileTree, point.x, point.y);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.checkForPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.checkForPopup(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                this.checkForPopup(mouseEvent);
            }
        };
        this.profileTree.addMouseListener(mouseAdapter);
    }

    private JPopupMenu getMetaDataEditMenu(final DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        final HUEDProfile hUEDProfile = defaultMutableTreeNode != null ? ((object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile ? (HUEDProfile)object : null) : null;
        object = new JPopupMenu();
        ((JPopupMenu)object).setInvoker(this.profileTree);
        JMenuItem jMenuItem = new JMenuItem(props.getProperty("HUED_EDITOR_NEW_PROFILE"));
        jMenuItem.setEnabled(true);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.addNewProfile();
            }
        });
        ((JPopupMenu)object).add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(props.getProperty("HUED_EDITOR_EDIT_PROFILE"));
        jMenuItem2.setEnabled(hUEDProfile != null);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.editProfile(hUEDProfile);
            }
        });
        ((JPopupMenu)object).add(jMenuItem2);
        ((JPopupMenu)object).addSeparator();
        JMenuItem jMenuItem3 = new JMenuItem(props.getProperty("HUED_EDITOR_DEL_PROFILE"));
        jMenuItem3.setEnabled(hUEDProfile != null);
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.delProfile(defaultMutableTreeNode);
            }
        });
        ((JPopupMenu)object).add(jMenuItem3);
        return object;
    }

    private void addNewProfile() {
        InputDialog inputDialog = new InputDialog(this, "", props.getProperty("HUED_EDITOR_NEW_PROFILE_TITLE"));
        l<String> l2 = inputDialog.addTextField(props.getProperty("HUED_EDITOR_PROFILE_NAME") + " ");
        l2.a(new k(){

            @Override
            public String validate(Object object) {
                if (object == null || object.toString().trim().isEmpty()) {
                    return props.getProperty("HUED_EDITOR_NAME_EMPTY_MSG");
                }
                return null;
            }
        });
        l<String> l3 = inputDialog.addTextField(props.getProperty("HUED_EDITOR_DEVNUM") + " ");
        inputDialog.setErrorBarVisible(true);
        if (inputDialog.b() == 0) {
            HUEDProfile hUEDProfile = new HUEDProfile();
            hUEDProfile.setName(l2.b());
            hUEDProfile.setDevNum(l3.b());
            this.updateProfileTime(hUEDProfile);
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(hUEDProfile);
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.profileTree.getModel();
            defaultTreeModel.insertNodeInto(defaultMutableTreeNode, this.rootNode, this.rootNode.getChildCount());
            this.profileTree.expandPath(new TreePath(this.rootNode.getPath()));
            TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
            this.profileTree.setSelectionPath(treePath);
            this.profileTree.scrollPathToVisible(treePath);
            this.firePropertyChange("mimPropertyModified", null, null);
        }
    }

    private void editProfile(HUEDProfile hUEDProfile) {
        InputDialog inputDialog = new InputDialog(this, "", props.getProperty("HUED_EDITOR_EDIT_PROFILE_TITLE"));
        l<String> l2 = inputDialog.addTextField(props.getProperty("HUED_EDITOR_PROFILE_NAME") + " ");
        l2.a(hUEDProfile.getName());
        l2.a(new k(){

            @Override
            public String validate(Object object) {
                if (object == null || object.toString().trim().isEmpty()) {
                    return props.getProperty("HUED_EDITOR_NAME_EMPTY_MSG");
                }
                return null;
            }
        });
        l<String> l3 = inputDialog.addTextField(props.getProperty("HUED_EDITOR_DEVNUM") + " ");
        l3.a(hUEDProfile.getDevNum());
        inputDialog.setErrorBarVisible(true);
        if (inputDialog.b() == 0) {
            hUEDProfile.setName(l2.b());
            hUEDProfile.setDevNum(l3.b());
            this.firePropertyChange("mimPropertyModified", null, null);
        }
    }

    private void delProfile(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.profileTree.getModel();
        defaultTreeModel.removeNodeFromParent(defaultMutableTreeNode);
        this.firePropertyChange("mimPropertyModified", null, null);
    }

    private void buildRightPanel() {
        this.rPanel = new JPanel();
        this.rPanel.setLayout(new BorderLayout());
        this.dataTable = new JTable();
        this.dataTable.setAutoResizeMode(4);
        this.dataTable.addMouseListener(this.getHUEDTableListener());
        this.dataTable.setCellSelectionEnabled(true);
        this.dataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                HUEDProfilePanel.this.removeRowBut.setEnabled(HUEDProfilePanel.this.canRemoveRow());
            }
        });
        this.dataTable.setDefaultEditor(Number.class, new EasyNumberEditor());
        JScrollPane jScrollPane = new JScrollPane(this.dataTable);
        jScrollPane.addMouseListener(this.getHUEDTableListener());
        this.rPanel.add((Component)jScrollPane, "Center");
    }

    private MouseAdapter getHUEDTableListener() {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    JPopupMenu jPopupMenu = HUEDProfilePanel.this.getTableMenu();
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        };
        return mouseAdapter;
    }

    private void removeRow() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastSelectedProfileNode();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile) {
            HUEDProfile hUEDProfile = (HUEDProfile)object;
            int[] nArray = this.dataTable.getSelectedRows();
            hUEDProfile.removeRows(nArray);
            this.updateTableAndGraph();
        }
    }

    private void addRow() {
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastSelectedProfileNode();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile) {
            HUEDProfile hUEDProfile = (HUEDProfile)object;
            hUEDProfile.addRow();
            this.updateTableAndGraph();
        }
    }

    private boolean canRemoveRow() {
        Object object;
        boolean bl2 = false;
        boolean bl3 = this.dataTable.getSelectedColumn() >= 0;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastSelectedProfileNode();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile) {
            bl2 = true;
        }
        return bl2 && bl3;
    }

    private JPopupMenu getTableMenu() {
        Object object;
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setInvoker(this.dataTable);
        boolean bl2 = false;
        DefaultMutableTreeNode defaultMutableTreeNode = this.getLastSelectedProfileNode();
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) instanceof HUEDProfile) {
            bl2 = true;
        }
        object = new JMenuItem(props.getProperty("HUED_EDITOR_DEL_ROWS"));
        ((JMenuItem)object).setEnabled(this.canRemoveRow());
        ((AbstractButton)object).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.removeRow();
            }
        });
        jPopupMenu.add((JMenuItem)object);
        JMenuItem jMenuItem = new JMenuItem(props.getProperty("HUED_EDITOR_ADD_ROW"));
        jMenuItem.setEnabled(bl2);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HUEDProfilePanel.this.addRow();
            }
        });
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    private boolean arrayContains(int[] nArray, int n2) {
        for (int n3 : nArray) {
            if (n3 != n2) continue;
            return true;
        }
        return false;
    }

    private void updateTable(HUEDProfile hUEDProfile) {
        HUEDTableModel hUEDTableModel = new HUEDTableModel(hUEDProfile);
        this.dataTable.setModel(hUEDTableModel);
    }

    private void clearSeedDataInGUI() {
        HUEDTableModel hUEDTableModel = new HUEDTableModel(null);
        this.dataTable.setModel(hUEDTableModel);
        this.updateGraph(null);
        this.addRowBut.setEnabled(false);
    }

    public boolean saveProfiles() {
        if (this.dataTable.isEditing() && !this.dataTable.getCellEditor().stopCellEditing()) {
            return false;
        }
        HUEDProfileManager hUEDProfileManager = new HUEDProfileManager();
        hUEDProfileManager.removeAll();
        for (int i2 = 0; i2 < this.rootNode.getChildCount(); ++i2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i2);
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof HUEDProfile)) continue;
            hUEDProfileManager.updateProfile((HUEDProfile)object);
        }
        return true;
    }

    private void updateProfileTime(HUEDProfile hUEDProfile) {
        this.profileTree.updateUI();
    }

    private class HUEDTableModel
    extends HUEDProfileTableModel {
        public HUEDTableModel(HUEDProfile hUEDProfile) {
            super(hUEDProfile, false);
            this.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    HUEDProfilePanel.this.updateTableAndGraph();
                    HUEDProfilePanel.this.firePropertyChange("mimPropertyModified", null, null);
                }
            });
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            try {
                if (n3 == 0) {
                    this.profile.setHU(n2, Float.valueOf(object.toString()).floatValue());
                } else if (n3 == 1) {
                    this.profile.setED(n2, Float.valueOf(object.toString()).floatValue());
                }
                this.fireTableCellUpdated(n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class EasyNumberEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        public EasyNumberEditor() {
            super(new JTextField());
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            final JTextField jTextField = (JTextField)super.getTableCellEditorComponent(jTable, object, bl2, n2, n3);
            jTextField.setText(object.toString());
            jTextField.setHorizontalAlignment(4);
            jTextField.selectAll();
            if (!bl2) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        jTextField.selectAll();
                    }
                });
            }
            return jTextField;
        }
    }
}

