/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.internals.PlanarImage;
import com.mimvista.internals.ao;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class PlanarImageViewer
extends JFrame
implements MouseWheelListener {
    private BufferedImage img;
    private ao images;
    private int currentIndex = 0;
    private static final long serialVersionUID = 1L;

    public PlanarImageViewer(ao ao2, String string) {
        this.images = ao2;
        this.init(string);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getWheelRotation();
        int n3 = this.currentIndex;
        this.currentIndex += n2;
        if (this.currentIndex < 0) {
            this.currentIndex = 0;
        } else if (this.currentIndex >= this.images.f()) {
            this.currentIndex = this.images.f() - 1;
        }
        if (this.currentIndex != n3) {
            this.createImage();
            this.repaint();
        }
    }

    private void init(String string) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setDefaultCloseOperation(1);
        this.setResizable(true);
        this.setTitle(string);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(dimension.width / 2, dimension.height / 2));
        this.addMouseWheelListener(this);
        this.createImage();
        this.setContentPane(new JPanel(){
            private static final long serialVersionUID = 3799347830954933075L;

            @Override
            public void paintComponent(Graphics graphics) {
                AffineTransform affineTransform = new AffineTransform();
                Dimension dimension = this.getSize();
                double d2 = Math.min((float)dimension.width / (float)PlanarImageViewer.this.img.getWidth(), (float)dimension.height / (float)PlanarImageViewer.this.img.getHeight());
                affineTransform.scale(d2, d2);
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.drawImage(PlanarImageViewer.this.img, affineTransform, null);
            }
        });
        this.pack();
        this.setVisible(true);
    }

    private void createImage() {
        this.img = ((PlanarImage)this.images.a(this.currentIndex)).f();
    }
}

