/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.mimvista.archive.remote.SeriesQuery;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.JsonPathUtil;
import com.mimvista.dicom.gui.DicomObjectSelectionDialog;
import com.mimvista.internals.ViewController3D;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMDateFormat;
import com.mimvista.util.Messages;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;

public class RtStructSelectionDialog
extends DicomObjectSelectionDialog.DcmSeriesObjectSelectionDialog {
    public static final int COLINDEX_HIDDEN = 0;
    public static final int COLINDEX_LABEL = 1;
    public static final int COLINDEX_NAME = 2;
    public static final int COLINDEX_SERIES_DESC = 3;
    public static final int COLINDEX_OPERATOR = 4;
    public static final int COLINDEX_DATE = 5;
    private static Messages infoProps = Messages.a("InfoItem");
    private static String LABEL = infoProps.getProperty("LABEL");
    private static String NAME = infoProps.getProperty("NAME");
    private static String SERIES_DESC = infoProps.getProperty("SERIES_DESC");
    private static String OPERATOR = infoProps.getProperty("OPERATOR");
    private static String CREATED = infoProps.getProperty("CREATED");
    protected ViewController3D viewController;
    protected Window parentWindow;
    protected TableRowSorter<DicomObjectSelectionDialog.HiddenDataTableModel> rowSorter;

    public RtStructSelectionDialog(Window window, SeriesQuery seriesQuery, ViewController3D viewController3D) {
        super(window, seriesQuery);
        this.setTitle(props.getProperty("DCM_RT_STRUCT_SELECT_TITLE"));
        this.viewController = viewController3D;
        this.parentWindow = window;
        this.rowSorter = new TableRowSorter<DicomObjectSelectionDialog.HiddenDataTableModel>(this.model);
        this.rowSorter.setComparator(5, new DateComparator());
        ArrayList<RowSorter.SortKey> arrayList = new ArrayList<RowSorter.SortKey>();
        arrayList.add(new RowSorter.SortKey(5, SortOrder.DESCENDING));
        this.rowSorter.setSortKeys(arrayList);
        this.table.setRowSorter(this.rowSorter);
        TableColumn tableColumn = this.table.getColumn(CREATED);
        tableColumn.setCellRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                String string = DateUtils.b() + " " + DateUtils.d();
                MIMDateFormat mIMDateFormat = new MIMDateFormat(string);
                return new JLabel(mIMDateFormat.format((Date)object));
            }
        });
    }

    @Override
    protected void addTableColumns() {
        this.model.addColumn(LABEL);
        this.model.addColumn(NAME);
        this.model.addColumn(SERIES_DESC);
        this.model.addColumn(OPERATOR);
        this.model.addColumn(CREATED);
    }

    @Override
    protected void addTableItem(DcmSeries dcmSeries) {
        Date date;
        String string = this.getStringValue(dcmSeries, 805699586);
        String string2 = this.getStringValue(dcmSeries, 805699588);
        String string3 = this.getStringValue(dcmSeries, 528446);
        String string4 = this.getStringValue(dcmSeries, 528496);
        Date date2 = null;
        if (dcmSeries.exists(805699592) && (date = (Date)dcmSeries.getTagValue(JsonPathUtil.forTag(805699592))) != null) {
            date2 = date;
        }
        if (date2 == null) {
            date2 = new Date(0, 0, 0, 0, 0, 0);
        }
        if (dcmSeries.exists(805699593) && (date = (Date)dcmSeries.getTagValue(JsonPathUtil.forTag(805699593))) != null) {
            date2 = DateUtils.b(date2, date);
        }
        this.model.addRow(dcmSeries, new Object[]{string, string2, string3, string4, date2});
    }

    @Override
    protected void setColumnWidths() {
        this.table.getColumn(LABEL).setPreferredWidth(25);
        this.table.getColumn(NAME).setPreferredWidth(100);
        this.table.getColumn(SERIES_DESC).setPreferredWidth(200);
        this.table.getColumn(OPERATOR).setPreferredWidth(25);
        this.table.getColumn(CREATED).setPreferredWidth(100);
    }

    private String getStringValue(DcmSeries dcmSeries, int n2) {
        if (dcmSeries.exists(n2)) {
            return (String)dcmSeries.getTagValue(JsonPathUtil.forTag(n2));
        }
        return null;
    }

    private class DateComparator
    implements Comparator<Date> {
        private DateComparator() {
        }

        @Override
        public int compare(Date date, Date date2) {
            return date.compareTo(date2);
        }
    }
}

