/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.gui;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.gui.DicomObjectSelectionDialog;
import com.mimvista.dicom.rtdose.DoseRefFinder;
import com.mimvista.exodus.MIM;
import com.mimvista.internals.ViewController;
import com.mimvista.mui.ao;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.work.f;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class SelectSeriesByFORDialog<U>
extends DicomObjectSelectionDialog<SeriesDataHolder<U>> {
    private static final long serialVersionUID = 4631581351548685327L;
    protected final List<DcmSeries> selectedSeries = Lists.newArrayList();

    public static DcmSeries warnUserAndSelectDcmSeries(final Collection<DcmSeries> collection, String string, String string2, final String string3, String string4, boolean bl2) {
        Function<Collection<DcmSeries>, SelectSeriesByFORDialog<DcmSeries>> function = new Function<Collection<DcmSeries>, SelectSeriesByFORDialog<DcmSeries>>(){

            public SelectSeriesByFORDialog<DcmSeries> apply(Collection<DcmSeries> collection2) {
                return SelectSeriesByFORDialog.getDialogForDcmSeries(ao.S(), string3, collection);
            }
        };
        return SelectSeriesByFORDialog.warnUserAndGetSelection(function, collection, string, string2, string3, string4, bl2);
    }

    public static ViewController warnUserAndSelectVC(final Collection<ViewController> collection, String string, String string2, final String string3, String string4, boolean bl2) {
        Function<Collection<ViewController>, SelectSeriesByFORDialog<ViewController>> function = new Function<Collection<ViewController>, SelectSeriesByFORDialog<ViewController>>(){

            public SelectSeriesByFORDialog<ViewController> apply(Collection<ViewController> collection2) {
                return SelectSeriesByFORDialog.getDialogForVCs(ao.S(), string3, collection);
            }
        };
        return SelectSeriesByFORDialog.warnUserAndGetSelection(function, collection, string, string2, string3, string4, bl2);
    }

    protected static <T> T warnUserAndGetSelection(final Function<Collection<T>, SelectSeriesByFORDialog<T>> function, final Collection<T> collection, String string, String string2, String string3, String string4, boolean bl2) {
        if (collection.isEmpty()) {
            return null;
        }
        if (MIM.isHeadless()) {
            if (collection.size() == 1) {
                return collection.iterator().next();
            }
            ay.d((Object)"Multiple FOR matches found while headless, unable to select matching series.", SelectSeriesByFORDialog.class);
        } else {
            int n2;
            Messages messages = Messages.a("Dicom");
            Object[] objectArray = new Object[]{messages.b("SERIES_FOR_WARNING_CONTINUE"), MIMFormat.a(messages.b("SERIES_FOR_WARNING_DONT_LOAD"), string4)};
            boolean bl3 = collection.size() > 1 || bl2 ? (n2 = MOptionPane.a(ao.S(), MIMFormat.a(string3 + "\n\n" + string2, new Object[0]), string, 0, 2, null, objectArray, objectArray[0])) == 0 : true;
            if (bl3) {
                if (collection.size() == 1 && !bl2) {
                    return collection.iterator().next();
                }
                ay.b((Object)"FOR matches found, user selection required.", SelectSeriesByFORDialog.class);
                FutureTask futureTask = new FutureTask(new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        final AtomicReference atomicReference = new AtomicReference();
                        final CountDownLatch countDownLatch = new CountDownLatch(1);
                        final SelectSeriesByFORDialog selectSeriesByFORDialog = (SelectSeriesByFORDialog)function.apply((Object)collection);
                        selectSeriesByFORDialog.addFinishedLoadingRunnable(new Runnable(){

                            @Override
                            public void run() {
                                atomicReference.set(selectSeriesByFORDialog.getResult());
                                countDownLatch.countDown();
                            }
                        });
                        selectSeriesByFORDialog.setLocationRelativeTo(ao.S());
                        selectSeriesByFORDialog.setModal(true);
                        selectSeriesByFORDialog.open();
                        try {
                            countDownLatch.await(500L, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return atomicReference.get();
                    }
                });
                f.e.submit(futureTask);
                try {
                    return (T)futureTask.get();
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Problem occured while waiting for matching FOR series selection.", throwable, DoseRefFinder.class);
                }
            }
        }
        return null;
    }

    public static SelectSeriesByFORDialog<DcmSeries> getDialogForDcmSeries(Window window, String string, Collection<DcmSeries> collection) {
        ArrayList arrayList = Lists.newArrayList();
        for (DcmSeries dcmSeries : collection) {
            arrayList.add(SeriesDataHolder.getSeriesDataHolder(dcmSeries));
        }
        return new SelectSeriesByFORDialog<DcmSeries>(window, string, arrayList);
    }

    public static SelectSeriesByFORDialog<ViewController> getDialogForVCs(Window window, String string, Collection<ViewController> collection) {
        ArrayList arrayList = Lists.newArrayList();
        for (ViewController viewController : collection) {
            arrayList.add(SeriesDataHolder.getSeriesDataHolder(viewController));
        }
        return new SelectSeriesByFORDialog<ViewController>(window, string, arrayList);
    }

    protected SelectSeriesByFORDialog(Window window, String string, List<SeriesDataHolder<U>> list) {
        super(window, string, list);
        this.setTitle(props.getProperty("SERIES_FOR_SELECT_DIALOG_TITLE"));
    }

    @Override
    protected int getDefaultWidth() {
        return 500;
    }

    @Override
    protected void addTableColumns() {
        Messages messages = Messages.a("PatientList");
        this.model.addColumn(messages.b("MODALITY_HEADER"));
        this.model.addColumn(messages.b("SERIES_DESCRIPTION_HEADER"));
        this.model.addColumn(messages.b("DATE_HEADER"));
        this.model.addColumn(messages.b("TIME_HEADER"));
        this.model.addColumn(messages.b("STUDY_DESCRIPTION_HEADER"));
    }

    @Override
    protected void addTableItem(SeriesDataHolder seriesDataHolder) {
        String string = seriesDataHolder.modality;
        String string2 = seriesDataHolder.seriesDesc;
        String string3 = seriesDataHolder.date;
        String string4 = seriesDataHolder.time;
        String string5 = seriesDataHolder.studyDesc;
        this.model.addRow(seriesDataHolder, new String[]{string, string2, string3, string4, string5});
    }

    @Override
    protected void setColumnWidths() {
        Messages messages = Messages.a("PatientList");
        this.table.getColumn(messages.b("SERIES_DESCRIPTION_HEADER")).setPreferredWidth(300);
        this.table.getColumn(messages.b("DATE_HEADER")).setPreferredWidth(100);
        this.table.getColumn(messages.b("TIME_HEADER")).setPreferredWidth(100);
    }

    @Override
    protected void performOpen(SeriesDataHolder seriesDataHolder) {
    }

    public U getResult() {
        SeriesDataHolder seriesDataHolder = (SeriesDataHolder)this.getDicomObjectFromSelection();
        if (seriesDataHolder != null) {
            return (U)seriesDataHolder.object.get();
        }
        return null;
    }

    public static class SeriesDataHolder<U> {
        public String modality;
        public String seriesDesc;
        public String date;
        public String time;
        public String studyDesc;
        public WeakReference<U> object;

        public static SeriesDataHolder<DcmSeries> getSeriesDataHolder(DcmSeries dcmSeries) {
            SeriesDataHolder<DcmSeries> seriesDataHolder = new SeriesDataHolder<DcmSeries>();
            seriesDataHolder.modality = dcmSeries.getModality();
            seriesDataHolder.seriesDesc = dcmSeries.getSeriesDescription();
            seriesDataHolder.date = DateUtils.a().format(dcmSeries.getDisplayDate());
            seriesDataHolder.time = DateUtils.c().format(dcmSeries.getDisplayTime());
            seriesDataHolder.studyDesc = dcmSeries.getStudyDescription();
            seriesDataHolder.object = new WeakReference<DcmSeries>(dcmSeries);
            return seriesDataHolder;
        }

        public static SeriesDataHolder<ViewController> getSeriesDataHolder(ViewController viewController) {
            SeriesDataHolder<ViewController> seriesDataHolder = new SeriesDataHolder<ViewController>();
            seriesDataHolder.modality = viewController.getModality();
            seriesDataHolder.seriesDesc = viewController.getSeriesDescription();
            seriesDataHolder.date = DateUtils.a().format(viewController.getUncopiedMutableInfo().j());
            seriesDataHolder.time = DateUtils.c().format(viewController.getUncopiedMutableInfo().f());
            seriesDataHolder.studyDesc = viewController.getStudyDescription();
            seriesDataHolder.object = new WeakReference<ViewController>(viewController);
            return seriesDataHolder;
        }

        public U getResult() {
            return (U)this.object.get();
        }
    }
}

