/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.network;

import com.google.common.collect.ImmutableList;
import com.mimvista.dicom.Modality;
import com.mimvista.util.ay;
import java.util.Arrays;
import java.util.List;
import org.dcm4che2.net.TransferCapability;

public class DICOMTransferUtil {
    private static final List<Modality> implicitOnlyTransferModalities = new ImmutableList.Builder().add((Object[])new Modality[]{Modality.RTST, Modality.RTDOSE, Modality.RTPLAN}).build();

    public static TransferCapability getTransferCapabilityForSOPClassUID(String string, String[] stringArray, String string2) {
        String[] stringArray2 = null;
        Modality modality = Modality.getModalityForSopClass(string);
        if (!implicitOnlyTransferModalities.contains(modality)) {
            stringArray2 = stringArray;
        } else {
            for (String string3 : stringArray) {
                if (!"1.2.840.10008.1.2".equals(string3)) continue;
                stringArray2 = new String[]{"1.2.840.10008.1.2"};
            }
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            StringBuilder stringBuilder = new StringBuilder("The selected transfer syntax is not available for SOPClassUID, defaulting to ImplicitVRLittleEndian");
            stringBuilder.append("\n\tSOPClassUID: ");
            stringBuilder.append(string);
            stringBuilder.append("\n\tTransferSyntaxes Avail: ");
            stringBuilder.append(Arrays.toString(stringArray));
            stringBuilder.append("\n\tTransferCapability: ");
            stringBuilder.append(string2);
            ay.d((Object)stringBuilder, DICOMTransferUtil.class);
            stringArray2 = new String[]{"1.2.840.10008.1.2"};
        }
        return new TransferCapability(string, stringArray2, string2);
    }
}

