/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.network;

import com.google.common.collect.Lists;
import com.mimvista.archive.Parser;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.pro.l;
import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.gui.DcmPullTransfer;
import com.mimvista.dicom.network.DcmQueryClientTagPreferences;
import com.mimvista.dicom.network.MITRAReportQuery;
import com.mimvista.dicom.qrserver.CGetStorage;
import com.mimvista.dicom.qrserver.CGetStorageDelegate;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.DcmqueryclientPrefs;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.DicomQueryPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.cp;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.NoPresentationContextException;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.DicomService;

public class DcmQueryClient
extends Observable {
    protected static final String DEFAULT_TEMP_PATH = GetOSPath.convertPath("C:\\MIM_DATA\\GETTEMP");
    protected static final String DEFAULT_ACHIVE_PATH = GetOSPath.convertPath("C:\\MIM_DATA\\GETACHIVE");
    protected static final String DEFAULT_AE_TITLE = "MOVESTUDY";
    protected static final int DEFAULT_TIMEOUT = 240000;
    protected int priority = 0;
    protected int cancelAfter = Integer.MAX_VALUE;
    protected cp status;
    protected int numberOfCompletedSuboperations = 0;
    protected int numberOfRemainingSuboperations = 0;
    protected int numberOfWarningSuboperations = 0;
    protected int numberOfFailedSuboperations = 0;
    protected int currentStatus = 0;
    protected boolean drilldown = false;
    protected boolean enableCGet = false;
    protected static int dimseTimeout = DcmqueryclientPrefs.dimseTimeout.getValue();
    protected static int connectTimeout = DcmqueryclientPrefs.connectTimeout.getValue();
    protected static int acceptTimeout = DcmqueryclientPrefs.acceptTimeout.getValue();
    protected CGetStorage storage;
    protected CGetStorageDelegate storageDelegate;
    protected Progress progress = new o();
    protected boolean cancelled = false;
    protected Lock cancelLock = new ReentrantLock();
    protected static final String[] TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    protected MIMDcmUrl url;
    protected DicomLocationsPrefs.a host;
    protected DicomObject keys = new BasicDicomObject();
    protected String dest;
    protected static final String[] CUIDS = new String[]{"1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.2.3"};
    protected static final int[] MOVE_KEYS = new int[]{524370, 0x100020, 0x20000D, 0x20000E, 524312};
    protected Executor executor = new NewThreadExecutor("DCMQUERYCLIENT");
    protected NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    protected NetworkConnection remoteConn = new NetworkConnection();
    protected Device device = new Device("DCMQUERYCLIENT");
    protected NetworkApplicationEntity ae = new NetworkApplicationEntity();
    protected NetworkConnection conn = new NetworkConnection();
    protected Association assoc;

    public DcmQueryClient(DicomLocationsPrefs.a a2) {
        this(a2, false);
    }

    public DcmQueryClient(DicomLocationsPrefs.a a2, Boolean bl2) {
        this.host = a2;
        this.url = a2.toDcmUrl();
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(DcmQueryClient.maskNull(this.url.getCallingAET()));
        this.ae.setDimseRspTimeout(dimseTimeout);
        this.ae.setMoveRspTimeout(dimseTimeout);
        this.conn.setConnectTimeout(connectTimeout);
        this.conn.setAcceptTimeout(acceptTimeout);
        this.setCalledAETitle(this.url.getCalledAET());
        this.setRemoteHost(this.url.getHost());
        this.setRemotePort(this.url.getPort());
        this.enableCGet = bl2;
        if (bl2.booleanValue()) {
            this.storage = new CGetStorage(DicomStoreConfigLoader.getSupportedSopUids());
            this.ae.register((DicomService)this.storage);
        }
        this.configureTransferCapability();
    }

    public void setDest(String string) {
        this.dest = string;
    }

    public void setCalledAETitle(String string) {
        this.remoteAE.setAETitle(string);
    }

    public final void setRemoteHost(String string) {
        this.remoteConn.setHostname(string);
    }

    public final void setRemotePort(int n2) {
        this.remoteConn.setPort(n2);
    }

    private static String maskNull(String string) {
        return string != null ? string : DcmqueryclientPrefs.aeTitle.getValue();
    }

    protected void configureTransferCapability() {
        ArrayList<TransferCapability> arrayList = new ArrayList<TransferCapability>();
        if (this.enableCGet) {
            int n2;
            for (n2 = 0; n2 < CUIDS.length; ++n2) {
                arrayList.add(new TransferCapability(CUIDS[n2], TS, "SCU"));
            }
            for (n2 = 0; n2 < DicomStoreConfigLoader.getSupportedSopUids().length; ++n2) {
                arrayList.add(new TransferCapability(DicomStoreConfigLoader.getSupportedSopUids()[n2], TS, "SCP"));
            }
        } else {
            for (int i2 = 0; i2 < CUIDS.length - 1; ++i2) {
                arrayList.add(new TransferCapability(CUIDS[i2], TS, "SCU"));
            }
        }
        if (MITRAReportQuery.isMitraReportQueryEnabled()) {
            arrayList.add(new TransferCapability("1.2.840.113532.3500.8", TS, "SCU"));
            arrayList.add(new TransferCapability("1.2.840.113532.3500.8", TS, "SCP"));
        }
        this.ae.setTransferCapability(arrayList.toArray(new TransferCapability[0]));
    }

    private DcmQueryClientTagPreferences getTagPrefs() {
        DcmQueryClientTagPreferences dcmQueryClientTagPreferences;
        DcmQueryClientTagPreferences dcmQueryClientTagPreferences2 = DicomQueryPrefs.queryClientTagPreferencesGlobal.getValue();
        if (!cn.h(this.remoteAE.getAETitle())) {
            DcmQueryClientTagPreferences dcmQueryClientTagPreferences3 = DicomQueryPrefs.queryClientTagPreferencesForAETitle.b(this.remoteAE.getAETitle()).getValue();
            dcmQueryClientTagPreferences = new DcmQueryClientTagPreferences(dcmQueryClientTagPreferences2, dcmQueryClientTagPreferences3);
        } else {
            dcmQueryClientTagPreferences = dcmQueryClientTagPreferences2;
        }
        return dcmQueryClientTagPreferences;
    }

    private void applyWhitelist(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel) {
        ArrayList arrayList = Lists.newArrayList();
        DcmQueryClientTagPreferences dcmQueryClientTagPreferences = this.getTagPrefs();
        DcmQueryClientTagPreferences.WhiteBlackList whiteBlackList = dcmQueryClientTagPreferences.levelToList.get(queryRetrieveLevel.name());
        arrayList.addAll(whiteBlackList.white);
        if (queryRetrieveLevel == DcmPullTransfer.QueryRetrieveLevel.IMAGE && !this.drilldown) {
            arrayList.addAll(dcmQueryClientTagPreferences.levelToList.get((Object)"IMAGE-NO-DRILL").white);
        }
        for (DcmQueryClientTagPreferences.DcmQueryClientTagPreference dcmQueryClientTagPreference : arrayList) {
            this.keys.putNull(dcmQueryClientTagPreference.tag, dcmQueryClientTagPreference.vr);
        }
    }

    private void applyBlacklist(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel) {
        ArrayList arrayList = Lists.newArrayList();
        DcmQueryClientTagPreferences dcmQueryClientTagPreferences = this.getTagPrefs();
        DcmQueryClientTagPreferences.WhiteBlackList whiteBlackList = dcmQueryClientTagPreferences.levelToList.get(queryRetrieveLevel.name());
        arrayList.addAll(whiteBlackList.black);
        if (queryRetrieveLevel == DcmPullTransfer.QueryRetrieveLevel.IMAGE && !this.drilldown) {
            arrayList.addAll(dcmQueryClientTagPreferences.levelToList.get((Object)"IMAGE-NO-DRILL").black);
        }
        for (DcmQueryClientTagPreferences.DcmQueryClientTagPreference dcmQueryClientTagPreference : arrayList) {
            this.keys.remove(dcmQueryClientTagPreference.tag);
        }
    }

    private void addDummyDateIfNeeded(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel) {
        if (DicomQueryPrefs.forceNonEmptyDateRangeForDicomQuery.getValue().booleanValue() && queryRetrieveLevel == DcmPullTransfer.QueryRetrieveLevel.STUDY && !this.keys.contains(524320)) {
            this.keys.putString(524320, TagUtils.vrOfTag(524320), "17760704");
        }
    }

    private void initKeys2(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, l l2) {
        this.keys.clear();
        if (this.host.isUseSpecificCharacterSet()) {
            Parser.setDefaultSpecificCharacterSet(this.keys);
        }
        this.keys.putString(524370, VR.CS, queryRetrieveLevel.name());
        this.applyWhitelist(queryRetrieveLevel);
        l2.a(this.keys, true);
        this.addDummyDateIfNeeded(queryRetrieveLevel);
        this.applyBlacklist(queryRetrieveLevel);
    }

    private void initKeys(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, List<String> list) {
        this.keys.clear();
        if (this.host.isUseSpecificCharacterSet()) {
            Parser.setDefaultSpecificCharacterSet(this.keys);
        }
        this.keys.putString(524370, VR.CS, queryRetrieveLevel.name());
        this.applyWhitelist(queryRetrieveLevel);
        this.addAdditionalKeys(list);
        this.addDummyDateIfNeeded(queryRetrieveLevel);
        this.applyBlacklist(queryRetrieveLevel);
    }

    private void addAdditionalKeys(List<String> list) {
        for (String string : list) {
            String[] stringArray = cn.a(string, ":");
            if (stringArray.length != 2) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n2 = TagUtils.forTagName(string2);
            VR vR = TagUtils.vrOfTag(n2);
            this.keys.putString(n2, vR, string3);
        }
    }

    protected String selectTransferSyntax(TransferCapability transferCapability) {
        String[] stringArray = transferCapability.getTransferSyntax();
        return stringArray[0];
    }

    protected TransferCapability selectTransferCapability(String string) {
        TransferCapability transferCapability = this.assoc.getTransferCapabilityAsSCU(string);
        if (transferCapability != null) {
            return transferCapability;
        }
        return null;
    }

    public boolean open() throws ConfigurationException, IOException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
        return this.assoc != null;
    }

    private List<DicomObject> doQueryBasedOnCurrentState(Searchable.a a2) throws IOException, InterruptedException {
        ay.a((Object)("performing dicom query with the following parameters: \n" + this.keys.toString()), this);
        TransferCapability transferCapability = this.selectTransferCapability(CUIDS[0]);
        if (transferCapability == null) {
            throw new IllegalStateException();
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        DimseRSP dimseRSP = this.assoc.cfind(string, this.priority, this.keys, string2, this.cancelAfter);
        if (a2.b()) {
            return new ArrayList<DicomObject>();
        }
        ArrayList<DicomObject> arrayList = new ArrayList<DicomObject>();
        while (dimseRSP.next()) {
            if (a2.b()) {
                return new ArrayList<DicomObject>();
            }
            DicomObject dicomObject = dimseRSP.getCommand();
            if (!CommandUtils.isPending((DicomObject)dicomObject)) continue;
            DicomObject dicomObject2 = dimseRSP.getDataset();
            arrayList.add(dicomObject2);
        }
        return arrayList;
    }

    public List<DicomObject> query2(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, l l2) throws IOException, InterruptedException {
        return this.query2(queryRetrieveLevel, l2, new Searchable.b());
    }

    public List<DicomObject> query2(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, l l2, Searchable.a a2) throws IOException, InterruptedException {
        this.initKeys2(queryRetrieveLevel, l2);
        return this.doQueryBasedOnCurrentState(a2);
    }

    public List<DicomObject> query(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, List<String> list) throws IOException, InterruptedException {
        return this.query(queryRetrieveLevel, list, new Searchable.b());
    }

    public List<DicomObject> query(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, List<String> list, Searchable.a a2) throws IOException, InterruptedException {
        this.initKeys(queryRetrieveLevel, list);
        return this.doQueryBasedOnCurrentState(a2);
    }

    private int doMove(DicomObject dicomObject) throws IOException, InterruptedException {
        TransferCapability transferCapability = this.selectTransferCapability(CUIDS[1]);
        if (transferCapability == null) {
            throw new NoPresentationContextException(UIDDictionary.getDictionary().prompt(CUIDS[1]) + " not supported by" + this.remoteAE.getAETitle());
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        DicomObject dicomObject2 = dicomObject.subSet(MOVE_KEYS);
        boolean bl2 = false;
        DimseRSP dimseRSP = this.assoc.cmove(string, this.priority, dicomObject2, string2, this.dest);
        while (dimseRSP.next()) {
            this.cancelLock.lock();
            this.cancelLock.unlock();
            if (this.cancelled) break;
            DicomObject dicomObject3 = dimseRSP.getCommand();
            this.numberOfCompletedSuboperations = dicomObject3.getInt(4129);
            this.numberOfRemainingSuboperations = dicomObject3.getInt(4128);
            this.numberOfWarningSuboperations = dicomObject3.getInt(4131);
            this.numberOfFailedSuboperations = dicomObject3.getInt(4130);
            this.currentStatus = dicomObject3.getInt(2304);
            this.setChanged();
            this.notifyObservers();
        }
        return this.currentStatus;
    }

    public List<DicomObject> move(List<DicomObject> list) throws IOException, InterruptedException {
        if (this.dest == null) {
            return list;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (list == null) {
            return list;
        }
        boolean bl2 = false;
        block4: for (DicomObject dicomObject : list) {
            if (!dicomObject.contains(0x20000D) && this.keys.contains(0x20000D)) {
                dicomObject.putString(0x20000D, VR.UI, this.keys.getString(0x20000D));
            }
            if (this.dest == null) continue;
            switch (this.doMove(dicomObject)) {
                case 0: {
                    ++n4;
                    continue block4;
                }
                case 45056: {
                    ++n3;
                    continue block4;
                }
            }
            ++n2;
        }
        if (this.dest != null) {
            ay.a((Object)("Successfully moved " + n4 + " Studies"), this);
            if (n3 > 0) {
                ay.d((Object)("One or more Failures during move of " + n3 + " Studies"), this);
            }
            if (n2 > 0) {
                ay.d((Object)("Failed to move " + n2 + " Studies"), this);
            }
        }
        this.setStatus(new cp(n4, n3, n2));
        return list;
    }

    public void get(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel, List<String> list, CGetStorageDelegate cGetStorageDelegate) throws IOException, InterruptedException {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("Please supply some things you want to retrieve");
        }
        this.storageDelegate = cGetStorageDelegate;
        this.storage.setDelegate(cGetStorageDelegate);
        this.keys.clear();
        this.keys.putString(524370, VR.CS, queryRetrieveLevel.name());
        this.addAdditionalKeys(list);
        if (!this.enableCGet) {
            throw new IllegalStateException("MoveStudy is set to be not support C-Get, you can not invoke get()in this state.");
        }
        TransferCapability transferCapability = this.selectTransferCapability(CUIDS[2]);
        if (transferCapability == null) {
            return;
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        DimseRSPHandler dimseRSPHandler = new DimseRSPHandler(){

            public void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
                DcmQueryClient.this.onGetRSP(association, dicomObject, dicomObject2);
            }
        };
        this.assoc.cget(string, this.priority, this.keys, string2, dimseRSPHandler);
        this.assoc.waitForDimseRSP();
    }

    protected void onGetRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
        if (!CommandUtils.isPending((DicomObject)dicomObject)) {
            this.numberOfCompletedSuboperations = dicomObject.getInt(4129);
            this.numberOfRemainingSuboperations = dicomObject.getInt(4128);
            this.numberOfWarningSuboperations = dicomObject.getInt(4131);
            this.numberOfFailedSuboperations = dicomObject.getInt(4130);
            this.storageDelegate.retrieveFinished(true);
            this.storageDelegate = null;
            this.storage.setDelegate(null);
        }
    }

    public void close() throws InterruptedException {
        if (this.assoc != null) {
            this.assoc.release(true);
        }
    }

    public void setStatus(cp cp2) {
        this.status = cp2;
    }

    public void setDrilldown(boolean bl2) {
        this.drilldown = true;
    }

    public int getNumberOfOperations() {
        return this.numberOfCompletedSuboperations + this.numberOfRemainingSuboperations + this.numberOfWarningSuboperations + this.numberOfFailedSuboperations;
    }

    public cp getStatus() {
        return this.status;
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void cancel() {
        this.cancelled = true;
        if (this.assoc != null) {
            this.assoc.abort();
        }
    }

    public Lock getCancelLock() {
        return this.cancelLock;
    }

    public String toString() {
        if (this.url != null) {
            return this.url.toString();
        }
        return super.toString();
    }

    public static void main(String[] stringArray) {
    }
}

