/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.network;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.dicom.gui.DcmPullTransfer;
import com.mimvista.dicom.util.TagUtils;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.VR;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DcmQueryClientTagPreferences
implements Cloneable {
    public final Map<String, WhiteBlackList> levelToList = Maps.newHashMap();
    public static final String IMAGE_NO_DRILL = "IMAGE-NO-DRILL";

    public DcmQueryClientTagPreferences() {
    }

    public DcmQueryClientTagPreferences(DcmQueryClientTagPreferences dcmQueryClientTagPreferences, DcmQueryClientTagPreferences dcmQueryClientTagPreferences2) {
        for (String string : dcmQueryClientTagPreferences.levelToList.keySet()) {
            this.levelToList.put(string, dcmQueryClientTagPreferences.levelToList.get(string).clone());
        }
        if (dcmQueryClientTagPreferences2 != null) {
            for (String string : dcmQueryClientTagPreferences2.levelToList.keySet()) {
                WhiteBlackList whiteBlackList = this.levelToList.get(string);
                WhiteBlackList whiteBlackList2 = dcmQueryClientTagPreferences2.levelToList.get(string);
                if (whiteBlackList == null) {
                    this.levelToList.put(string, whiteBlackList2.clone());
                    continue;
                }
                for (DcmQueryClientTagPreference dcmQueryClientTagPreference : whiteBlackList2.white) {
                    whiteBlackList.black.remove(dcmQueryClientTagPreference);
                    whiteBlackList.white.add(dcmQueryClientTagPreference);
                }
                for (DcmQueryClientTagPreference dcmQueryClientTagPreference : whiteBlackList2.black) {
                    whiteBlackList.white.remove(dcmQueryClientTagPreference);
                    whiteBlackList.black.add(dcmQueryClientTagPreference);
                }
            }
        }
    }

    public WhiteBlackList getWBListForLevel(DcmPullTransfer.QueryRetrieveLevel queryRetrieveLevel) {
        return this.levelToList.get(queryRetrieveLevel.name());
    }

    public boolean isTagWhitelisted(int n2) {
        for (Map.Entry<String, WhiteBlackList> entry : this.levelToList.entrySet()) {
            WhiteBlackList whiteBlackList = entry.getValue();
            for (DcmQueryClientTagPreference dcmQueryClientTagPreference : whiteBlackList.white) {
                if (dcmQueryClientTagPreference.tag != n2) continue;
                return true;
            }
        }
        return false;
    }

    protected DcmQueryClientTagPreferences clone() {
        try {
            DcmQueryClientTagPreferences dcmQueryClientTagPreferences = (DcmQueryClientTagPreferences)super.clone();
            for (String string : this.levelToList.keySet()) {
                dcmQueryClientTagPreferences.levelToList.put(string, this.levelToList.get(string).clone());
            }
            return dcmQueryClientTagPreferences;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.levelToList == null ? 0 : this.levelToList.hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DcmQueryClientTagPreferences dcmQueryClientTagPreferences = (DcmQueryClientTagPreferences)object;
        return !(this.levelToList == null ? dcmQueryClientTagPreferences.levelToList != null : !this.levelToList.equals(dcmQueryClientTagPreferences.levelToList));
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class DcmQueryClientTagPreference
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int tag;
        final VR vr;

        public DcmQueryClientTagPreference(int n2) {
            this.tag = n2;
            this.vr = TagUtils.vrOfTag(n2);
        }

        public DcmQueryClientTagPreference(int n2, VR vR) {
            this.tag = n2;
            this.vr = vR;
        }

        protected DcmQueryClientTagPreference() {
            this.tag = 0;
            this.vr = VR.AE;
        }

        public VR getVR() {
            return this.vr;
        }

        public int getTag() {
            return this.tag;
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + this.tag;
            n3 = 31 * n3 + (this.vr == null ? 0 : this.vr.code());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            DcmQueryClientTagPreference dcmQueryClientTagPreference = (DcmQueryClientTagPreference)object;
            if (this.tag != dcmQueryClientTagPreference.tag) {
                return false;
            }
            return !(this.vr == null ? dcmQueryClientTagPreference.vr != null : this.vr.code() != dcmQueryClientTagPreference.vr.code());
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    public static class WhiteBlackList
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = 1L;
        public final Set<DcmQueryClientTagPreference> white = Sets.newHashSet();
        public final Set<DcmQueryClientTagPreference> black = Sets.newHashSet();

        protected WhiteBlackList clone() {
            try {
                return (WhiteBlackList)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }

        public int hashCode() {
            int n2 = 31;
            int n3 = 1;
            n3 = 31 * n3 + (this.black == null ? 0 : this.black.hashCode());
            n3 = 31 * n3 + (this.white == null ? 0 : this.white.hashCode());
            return n3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            WhiteBlackList whiteBlackList = (WhiteBlackList)object;
            if (this.black == null ? whiteBlackList.black != null : !this.black.equals(whiteBlackList.black)) {
                return false;
            }
            return !(this.white == null ? whiteBlackList.white != null : !this.white.equals(whiteBlackList.white));
        }
    }
}

