/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.network;

import com.mimvista.dicom.DcmError;
import com.mimvista.dicom.MIMDcmUrl;
import com.mimvista.dicom.network.DICOMTransferUtil;
import com.mimvista.dicom.network.MIMDcmSndDevice;
import com.mimvista.dicom.network.MIMStorageCommitmentSCU;
import com.mimvista.dicom.network.MIMStorageCommitmentSCUService;
import com.mimvista.dicom.read.ConfigurableFileExcluder;
import com.mimvista.dicom.read.FileExcluder;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.file.MIMFile;
import com.mimvista.preferencesNew.DicomSendPrefs;
import com.mimvista.preferencesNew.DicomStorePrefs;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.p;
import com.mimvista.util.progress.s;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.UIDDictionary;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.io.TranscoderInputHandler;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.NoPresentationContextException;
import org.dcm4che2.net.PDVOutputStream;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.pdu.AAbort;
import org.dcm4che2.net.pdu.AAssociateRJ;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.util.StringUtils;
import org.dcm4che2.util.UIDUtils;

public class DcmSnd
extends MIMStorageCommitmentSCU {
    public static Messages props = Messages.a("Dicom");
    private static final int KB = 1024;
    private static final int MB = 0x100000;
    private static final int PEEK_LEN = 1024;
    private static final String[] ONLY_IVLE_TS = new String[]{"1.2.840.10008.1.2"};
    private static final String[] IVLE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"};
    private static final String[] EVLE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.2"};
    private static final String[] EVBE_TS = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};
    public static final int NORMAL_MODE = 0;
    public static final int SINGLE_FILE_MODE = 1;
    public static final int DEF_STORAGE_COMMIT_PORT = 4009;
    private static final int maxOpsInvoked = DicomSendPrefs.maxOpsInvoked.getValue();
    private static final int maxPDULengthReceive = DicomSendPrefs.pduReceiveSize.getValue();
    private static final int maxPDULengthSend = DicomSendPrefs.pduSendSize.getValue();
    private static final boolean packPDV = DicomStorePrefs.packPdv.getValue();
    private static final int dimseRspTimeout = DicomSendPrefs.dimseRspTimeout.getValue();
    private static final int idleTimeout = DicomSendPrefs.idleTimeout.getValue();
    private static final int connectTimeout = DicomSendPrefs.connectTimeout.getValue();
    private static final int acceptTimeout = DicomSendPrefs.acceptTimeout.getValue();
    private static final int socketCloseDelay = DicomSendPrefs.socketCloseDelay.getValue();
    private static final boolean tcpNoDelay = DicomSendPrefs.tcpNoDelay.getValue();
    private static final int associationReaperPeriod = DicomSendPrefs.reaperPeriod.getValue();
    private static int waitForCmtResultTime = DicomSendPrefs.storeCommitRspTimeout.getValue();
    private Executor executor = new NewThreadExecutor("DCMSND");
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection remoteConn = new NetworkConnection();
    private MIMDcmSndDevice device = new MIMDcmSndDevice("DCMSND");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private int mode = 0;
    private int priority = 0;
    private int transcoderBufferSize = 1024;
    private Association assoc;
    private HashMap<String, HashSet<String>> as2ts = new HashMap();
    private ArrayList<FileInfo> fileInfoList = new ArrayList();
    private int filesSent = 0;
    private long totalTransferred = 0L;
    private boolean congested = false;
    private long transferTime = 0L;
    private String errMessage = "";
    private boolean skipThisError = true;
    private Vector<DcmError> errors = new Vector();
    private boolean cancelling = false;
    private boolean hasBeenUsed = false;
    private s progress = new p();
    private MIMStorageCommitmentSCUService stgCmtSCU = null;
    private boolean stgCmt = false;
    private String commitTransUID;
    private DicomObject stgCmtResult;
    private long totalSize = 0L;
    private Lock cancelLock = new ReentrantLock();
    private static String[] badExtensions = null;

    private DcmSnd() {
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.initializeDevice();
        this.initializeNetworkConnection();
        this.initializeNetworkApplicationEntity();
    }

    private void initializeDevice() {
        this.setAssociationReaperPeriod(associationReaperPeriod);
    }

    private void initializeNetworkConnection() {
        this.setConnectTimeout(connectTimeout);
        this.setAcceptTimeout(acceptTimeout);
        this.setSocketCloseDelay(socketCloseDelay);
        this.setTcpNoDelay(tcpNoDelay);
    }

    private void initializeNetworkApplicationEntity() {
        this.ae.setAssociationInitiator(true);
        this.ae.register((DicomService)this);
        this.ae.setAETitle("DCMSND");
        this.setMaxOpsInvoked(maxOpsInvoked);
        this.setMaxPDULengthReceive(maxPDULengthReceive);
        this.setMaxPDULengthSend(maxPDULengthSend);
        this.setPackPDV(packPDV);
        this.setDimseRspTimeout(dimseRspTimeout);
        this.setIdleTimeout(idleTimeout);
    }

    public DcmSnd(String string, int n2, String string2, String string3) {
        this(string, n2, string2, string3, 0);
    }

    public DcmSnd(String string, int n2, String string2, String string3, int n3) {
        this();
        if (string == null) {
            throw new IllegalArgumentException("Missing host name");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Missing calling AET");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Missing called AET");
        }
        this.ae.setAETitle(string2);
        this.remoteAE.setAETitle(string3);
        this.remoteConn.setHostname(string);
        this.remoteConn.setPort(n2);
        ay.b((Object)String.format("DICOM sending from AE %s -> %s @ %s:%d", string2, string3, string, n2), (Object)this);
        this.mode = n3;
    }

    public DcmSnd(MIMDcmUrl mIMDcmUrl) {
        this(mIMDcmUrl.getHost(), mIMDcmUrl.getPort(), mIMDcmUrl.getCallingAET(), mIMDcmUrl.getCalledAET());
    }

    public final void setCalledAET(String string) {
        this.remoteAE.setAETitle(string);
    }

    public final void setCalling(String string) {
        this.ae.setAETitle(string);
    }

    public final void setConnectTimeout(int n2) {
        this.conn.setConnectTimeout(n2);
    }

    public final void setMaxPDULengthReceive(int n2) {
        this.ae.setMaxPDULengthReceive(n2);
    }

    public final void setMaxOpsInvoked(int n2) {
        this.ae.setMaxOpsInvoked(n2);
    }

    public final void setPackPDV(boolean bl2) {
        this.ae.setPackPDV(bl2);
    }

    public final void setAssociationReaperPeriod(int n2) {
        this.device.setAssociationReaperPeriod(n2);
    }

    public final void setDimseRspTimeout(int n2) {
        this.ae.setDimseRspTimeout(n2);
    }

    public final void setIdleTimeout(int n2) {
        this.ae.setIdleTimeout(n2);
    }

    public final void setPriority(int n2) {
        this.priority = n2;
    }

    public final void setTcpNoDelay(boolean bl2) {
        this.conn.setTcpNoDelay(bl2);
    }

    public final void setAcceptTimeout(int n2) {
        this.conn.setAcceptTimeout(n2);
    }

    public final void setSocketCloseDelay(int n2) {
        this.conn.setSocketCloseDelay(n2);
    }

    public final void setMaxPDULengthSend(int n2) {
        this.ae.setMaxPDULengthSend(n2);
    }

    public final void setTranscoderBufferSize(int n2) {
        this.transcoderBufferSize = n2;
    }

    public final Lock getCancelLock() {
        return this.cancelLock;
    }

    public final void setTotalSize(long l2) {
        this.totalSize = l2;
    }

    public final void setWaitForCmtResultTime(int n2) {
        waitForCmtResultTime = n2;
    }

    public final TransferCapability[] getTransferCapability() {
        return this.ae.getTransferCapability();
    }

    private final int getNumberOfFilesSent() {
        return this.filesSent;
    }

    private void prompt(float f2) {
        StringBuffer stringBuffer = new StringBuffer("Sent ");
        stringBuffer.append(this.getNumberOfFilesSent());
        stringBuffer.append(" files (=");
        stringBuffer.append(DcmSnd.promptBytes(this.getSentBytes()));
        stringBuffer.append(") in ");
        stringBuffer.append(f2);
        stringBuffer.append("s (=");
        stringBuffer.append(DcmSnd.promptBytes((float)this.getSentBytes() / f2));
        stringBuffer.append("/s)");
    }

    private static String promptBytes(float f2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (f2 > 1048576.0f) {
            stringBuffer.append(f2 / 1048576.0f);
            stringBuffer.append("MB");
        } else {
            stringBuffer.append(f2 / 1024.0f);
            stringBuffer.append("KB");
        }
        return stringBuffer.toString();
    }

    private static String promptUID(String string) {
        return string == null ? "null UID" : UIDDictionary.getDictionary().prompt(string);
    }

    private void addFile(File file) throws UserCancelException {
        FileInfo fileInfo;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                this.addFile(fileArray[i2]);
            }
            return;
        }
        if (this.cancelling) {
            throw new UserCancelException();
        }
        for (String iOException2 : badExtensions) {
            if (!file.getName().toUpperCase().endsWith(iOException2)) continue;
            return;
        }
        try {
            fileInfo = this.readFileInfo(file);
        }
        catch (IOException iOException) {
            ay.d((Object)(iOException.getMessage() + file + " - skipped."), (Object)this);
            ay.c((Object)("Failed to parse this dicom file " + file + " - skipped: "), (Throwable)iOException, (Object)this);
            this.errMessage = "COULD NOT PARSE DICOM FILES";
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException2) {
                string = file.getAbsolutePath();
            }
            this.errors.add(new DcmError("unable to parse dicom file", string));
            return;
        }
        this.addTransferCapability(fileInfo.cuid, fileInfo.tsuid);
        this.fileInfoList.add(fileInfo);
    }

    private void addTransferCapability(String string, String string2) {
        HashSet<String> hashSet = this.as2ts.get(string);
        if (hashSet == null) {
            ay.a((Object)("Add a new abstract syntax " + DcmSnd.promptUID(string)), (Object)this);
            hashSet = new HashSet();
            hashSet.add("1.2.840.10008.1.2");
            this.as2ts.put(string, hashSet);
        }
        hashSet.add(string2);
    }

    private void configureTransferCapability() {
        int n2 = this.stgCmt ? 1 : 0;
        TransferCapability[] transferCapabilityArray = new TransferCapability[n2 + this.as2ts.size()];
        if (this.stgCmt) {
            ay.a((Object)"Add a transfer capability for Storage Commitment SCU", (Object)this);
            transferCapabilityArray[0] = new TransferCapability("1.2.840.10008.1.20.1", ONLY_IVLE_TS, "SCU");
        }
        Iterator<Map.Entry<String, HashSet<String>>> iterator = this.as2ts.entrySet().iterator();
        for (int i2 = n2; i2 < transferCapabilityArray.length; ++i2) {
            Map.Entry<String, HashSet<String>> entry = iterator.next();
            String string = entry.getKey();
            HashSet<String> hashSet = entry.getValue();
            transferCapabilityArray[i2] = DICOMTransferUtil.getTransferCapabilityForSOPClassUID(string, hashSet.toArray(new String[hashSet.size()]), "SCU");
            ay.a((Object)("Add a transfer capability for SOP class: " + DcmSnd.promptUID(string)), (Object)this);
        }
        this.ae.setTransferCapability(transferCapabilityArray);
    }

    private void open() throws IOException, ConfigurationException, InterruptedException {
        TransferCapability transferCapability;
        try {
            this.assoc = this.ae.connect(this.remoteAE, this.executor);
        }
        catch (ConnectException connectException) {
            this.errMessage = props.b("DCM_SND_UNREACHABLE");
            this.skipThisError = false;
            this.assoc = null;
            throw connectException;
        }
        catch (ConfigurationException configurationException) {
            this.errMessage = configurationException.getMessage().toUpperCase();
            this.skipThisError = false;
            this.assoc = null;
            throw configurationException;
        }
        catch (InterruptedException interruptedException) {
            this.errMessage = props.b("DCM_SND_INTERRUPTED");
            this.assoc = null;
            throw interruptedException;
        }
        catch (AAssociateRJ aAssociateRJ) {
            this.errMessage = "ASSOCIATION REQUEST REJECTED";
            if (aAssociateRJ.getResult() == 2 && aAssociateRJ.getReason() == 1) {
                this.congested = true;
            }
            this.assoc = null;
            throw aAssociateRJ;
        }
        catch (IOException iOException) {
            this.errMessage = props.b("DCM_SND_NETWORK_ERROR");
            this.skipThisError = false;
            this.assoc = null;
            throw iOException;
        }
        if (this.stgCmt && (transferCapability = this.assoc.getTransferCapabilityAsSCU("1.2.840.10008.1.20.1")) == null) {
            this.errMessage = "STORAGE COMMITMENT NOT SUPPORTED BY SERVER";
            this.skipThisError = false;
            this.close();
            this.assoc = null;
            throw new IOException(this.errMessage);
        }
    }

    private boolean send() {
        int n2 = this.fileInfoList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            String string;
            String string2;
            FileInfo fileInfo = this.fileInfoList.get(i2);
            ay.a((Object)("Sending file " + fileInfo.f.getAbsolutePath()), (Object)this);
            ay.a((Object)("Acquiring the transfer capability for abstract syntax" + DcmSnd.promptUID(fileInfo.cuid)), (Object)this);
            TransferCapability transferCapability = this.assoc.getTransferCapabilityAsSCU(fileInfo.cuid);
            if (transferCapability == null) {
                this.errMessage = DcmSnd.promptUID(fileInfo.cuid) + " NOT SUPPORTED BY SERVER";
                string2 = null;
                try {
                    string2 = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string2 = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError("unable to negotiate presentation context", string2));
                ay.c((Object)(DcmSnd.promptUID(fileInfo.cuid) + " not supported by " + this.remoteAE.getAETitle()), (Object)this);
                ay.c((Object)("Skipping file " + fileInfo.f), (Object)this);
                continue;
            }
            ay.a((Object)("Selecting the transfer syntax for abstract syntax " + DcmSnd.promptUID(fileInfo.cuid)), (Object)this);
            string2 = this.selectTransferSyntax(transferCapability.getTransferSyntax(), fileInfo.tsuid);
            if (string2 == null) {
                try {
                    transferCapability = this.decompress(fileInfo);
                    string2 = this.selectTransferSyntax(transferCapability.getTransferSyntax(), fileInfo.tmpFileInfo.tsuid);
                }
                catch (IOException iOException) {
                    this.errMessage = DcmSnd.promptUID(fileInfo.cuid) + " WITH " + DcmSnd.promptUID(fileInfo.tsuid) + " IO error happened when decompressing!";
                    string = null;
                    try {
                        string = fileInfo.f.getCanonicalPath();
                    }
                    catch (IOException iOException2) {
                        string = fileInfo.f.getAbsolutePath();
                    }
                    ay.c((Object)(DcmSnd.promptUID(fileInfo.cuid) + " with " + DcmSnd.promptUID(fileInfo.tsuid) + " IO error happed when decompressing " + string), (Object)this);
                    ay.c((Object)("Skipping file " + fileInfo.f), (Object)this);
                    continue;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    this.errMessage = DcmSnd.promptUID(fileInfo.cuid) + " WITH " + DcmSnd.promptUID(fileInfo.tsuid) + unsupportedOperationException.getMessage();
                    string = null;
                    try {
                        string = fileInfo.f.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = fileInfo.f.getAbsolutePath();
                    }
                    ay.c((Object)(DcmSnd.promptUID(fileInfo.cuid) + " with " + DcmSnd.promptUID(fileInfo.tsuid) + unsupportedOperationException.getMessage() + string), (Object)this);
                    ay.c((Object)("Skipping file " + fileInfo.f), (Object)this);
                    continue;
                }
                catch (Throwable throwable) {
                    this.errMessage = DcmSnd.promptUID(fileInfo.cuid) + " WITH " + DcmSnd.promptUID(fileInfo.tsuid) + throwable.getMessage();
                    string = null;
                    try {
                        string = fileInfo.f.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string = fileInfo.f.getAbsolutePath();
                    }
                    ay.c((Object)(DcmSnd.promptUID(fileInfo.cuid) + " with " + DcmSnd.promptUID(fileInfo.tsuid) + throwable.getMessage() + string), (Object)this);
                    ay.c((Object)("Skipping file " + fileInfo.f), (Object)this);
                    continue;
                }
                if (string2 == null) {
                    this.errMessage = DcmSnd.promptUID(fileInfo.cuid) + " WITH " + DcmSnd.promptUID(fileInfo.tsuid) + " NOT SUPPORTED BY SERVER";
                    object = null;
                    try {
                        object = fileInfo.f.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        object = fileInfo.f.getAbsolutePath();
                    }
                    this.errors.add(new DcmError("unable to negotiate presentation context", (String)object));
                    ay.c((Object)(DcmSnd.promptUID(fileInfo.cuid) + " with " + DcmSnd.promptUID(fileInfo.tsuid) + " not supported by" + this.remoteAE.getAETitle()), (Object)this);
                    ay.c((Object)("Skipping file " + fileInfo.f), (Object)this);
                    continue;
                }
            }
            ay.a((Object)("The selected transfer syntax is " + DcmSnd.promptUID(string2)), (Object)this);
            ay.a((Object)"Sending C-STORE-REQUEST ...", (Object)this);
            try {
                object = new DimseRSPHandler(){

                    public void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
                        DcmSnd.this.onDimseRSP(association, dicomObject, dicomObject2);
                    }
                };
                if (fileInfo.tmpFileInfo == null) {
                    this.assoc.cstore(fileInfo.cuid, fileInfo.iuid, this.priority, (org.dcm4che2.net.DataWriter)new DataWriter(fileInfo), string2, object);
                    continue;
                }
                this.assoc.cstore(fileInfo.tmpFileInfo.cuid, fileInfo.tmpFileInfo.iuid, this.priority, (org.dcm4che2.net.DataWriter)new DataWriter(fileInfo.tmpFileInfo), string2, object);
                ay.a((Object)("Send file " + fileInfo.f.getAbsolutePath() + " indirectly successful"), (Object)this);
                continue;
            }
            catch (NoPresentationContextException noPresentationContextException) {
                this.errMessage = "WARNING: " + noPresentationContextException.getMessage().toUpperCase();
                ay.c((Object)("Failed to send file " + fileInfo.f.getAbsolutePath() + " :"), (Throwable)noPresentationContextException, (Object)this);
                string = null;
                try {
                    string = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError("unable to negotiate presentation context", string));
                continue;
            }
            catch (DcmFileReadException dcmFileReadException) {
                this.errMessage = "READ DICOM FILE ERROR";
                ay.d((Object)("Can't read Dicom file: " + fileInfo.f.getAbsolutePath() + " Exception:"), (Throwable)dcmFileReadException, (Object)this);
                string = null;
                try {
                    string = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError("unable to read the dicom file", string));
                continue;
            }
            catch (AAbort aAbort) {
                this.errMessage = props.b("DCM_SND_ASSOC_ERROR");
                ay.d((Object)("Association transfer failed: " + fileInfo.f.getAbsolutePath() + " Exception:"), (Throwable)aAbort, (Object)this);
                string = null;
                try {
                    string = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError("unable to send the dicom file", string));
                return false;
            }
            catch (IOException iOException) {
                this.errMessage = props.b("DCM_SND_NETWORK_ERROR");
                ay.d((Object)("Network transfer failed: " + fileInfo.f.getAbsolutePath() + " Exception:"), (Throwable)iOException, (Object)this);
                this.skipThisError = false;
                string = null;
                try {
                    string = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException3) {
                    string = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError("unable to send the dicom file", string));
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.errMessage = props.b("DCM_SND_INTERRUPTED");
                ay.d((Object)("network interrupted error while sending " + fileInfo.f.getAbsolutePath() + " :"), (Throwable)interruptedException, (Object)this);
                string = null;
                try {
                    string = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError("InterruptedException occured during sending the dicom file", string));
            }
        }
        try {
            this.assoc.waitForDimseRSP();
        }
        catch (InterruptedException interruptedException) {
            this.errMessage = props.b("DCM_SND_INTERRUPTED");
            ay.d((Object)"network interrupted error while waiting for all C-STORE Responses: ", (Throwable)interruptedException, (Object)this);
            interruptedException.printStackTrace();
        }
        try {
            this.assoc.checkException();
        }
        catch (AAbort aAbort) {
            this.errMessage = props.b("DCM_SND_ASSOC_ERROR");
            ay.d((Object)"association transfer error: ", (Throwable)aAbort, (Object)this);
            this.errors.add(new DcmError(this.errMessage, "N/A"));
            return false;
        }
        catch (IOException iOException) {
            this.errMessage = props.b("DCM_SND_NETWORK_ERROR");
            ay.d((Object)"network transfer error: ", (Throwable)iOException, (Object)this);
            this.skipThisError = false;
            this.errors.add(new DcmError(this.errMessage, "N/A"));
            return false;
        }
        return true;
    }

    private TransferCapability decompress(FileInfo fileInfo) throws IOException {
        ay.a((Object)("Can't send file " + fileInfo.f.getAbsolutePath() + " directly, should decompress it at first"), (Object)this);
        File file = MIMFile.createTempFile("UNC", "TMP");
        DicomJpegDecompressor.decompressFile(fileInfo.f, file);
        fileInfo.tmpFileInfo = this.readFileInfo(file);
        return this.assoc.getTransferCapabilityAsSCU(fileInfo.tmpFileInfo.cuid);
    }

    private boolean commit() {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        this.commitTransUID = UIDUtils.createUID();
        basicDicomObject.putString(528789, VR.UI, this.commitTransUID);
        ay.b((Object)("Storage commitment transaction UID: " + this.commitTransUID), (Object)this);
        DicomElement dicomElement = basicDicomObject.putSequence(528793);
        int n2 = this.fileInfoList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FileInfo fileInfo = this.fileInfoList.get(i2);
            if (!fileInfo.transferred) continue;
            ay.a((Object)("Add storage commitment for file " + fileInfo.f.getAbsolutePath()), (Object)this);
            BasicDicomObject basicDicomObject2 = new BasicDicomObject();
            basicDicomObject2.putString(528720, VR.UI, fileInfo.cuid);
            basicDicomObject2.putString(528725, VR.UI, fileInfo.iuid);
            dicomElement.addDicomObject((DicomObject)basicDicomObject2);
        }
        if (dicomElement.countItems() == 0) {
            this.progress.b_("No files to commit");
            ay.b((Object)"No files to commit", (Object)this);
            return false;
        }
        try {
            this.progress.b_("Sending Storage Commitment Request ...");
            ay.b((Object)"Sending storage commitment request ...", (Object)this);
            this.stgCmtSCU.addNewStgCmtRequest(this.commitTransUID, this);
            DimseRSP dimseRSP = this.assoc.naction("1.2.840.10008.1.20.1", "1.2.840.10008.1.20.1.1", 1, (DicomObject)basicDicomObject, "1.2.840.10008.1.2");
            if (dimseRSP.next()) {
                DicomObject dicomObject = dimseRSP.getCommand();
                int n3 = dicomObject.getInt(256);
                if (n3 != 33072) {
                    throw new IOException("received invalid Response for N-ACTION Request");
                }
                int n4 = dicomObject.getInt(2304);
                if (n4 == 0) {
                    this.progress.b_("Storage Commitment Request is sent");
                    return true;
                }
                this.errMessage = "STORAGE COMMITMENT REQUEST FAILED WITH STATUS: " + StringUtils.shortToHex((int)n4) + "H";
                ay.c((Object)("Storage Commitment request failed with status: " + StringUtils.shortToHex((int)n4) + "H"), (Object)this);
                ay.c((Object)dicomObject.toString(), (Object)this);
            } else {
                this.errMessage = "STORAGE COMMITMENT REQUEST ERROR";
                ay.d((Object)"Failed to get storage commitment response", (Object)this);
            }
        }
        catch (NoPresentationContextException noPresentationContextException) {
            this.errMessage = "STORAGE COMMITMENT NOT SUPPORTED BY SERVER";
            ay.d((Object)"Cannot request Storage Commitment:", (Throwable)noPresentationContextException, (Object)this);
        }
        catch (IOException iOException) {
            this.errMessage = "STORAGE COMMITMENT REQUEST ERROR";
            ay.d((Object)"Failed to send Storage Commitment request: ", (Throwable)iOException, (Object)this);
        }
        catch (InterruptedException interruptedException) {
            this.errMessage = props.b("DCM_SND_INTERRUPTED");
            ay.d((Object)"Failed to send Storage Commitment request: ", (Throwable)interruptedException, (Object)this);
        }
        this.errors.add(new DcmError(this.errMessage, "N/A"));
        this.stgCmtSCU.removeNewStgCmtRequest(this.commitTransUID);
        return false;
    }

    private String selectTransferSyntax(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return string;
        }
        if (string.equals("1.2.840.10008.1.2")) {
            return this.selectTransferSyntax(stringArray, IVLE_TS);
        }
        if (string.equals("1.2.840.10008.1.2.1")) {
            return this.selectTransferSyntax(stringArray, EVLE_TS);
        }
        if (string.equals("1.2.840.10008.1.2.2")) {
            return this.selectTransferSyntax(stringArray, EVBE_TS);
        }
        return null;
    }

    private String selectTransferSyntax(String[] stringArray, String[] stringArray2) {
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equals(stringArray2[i2])) continue;
                return stringArray[i3];
            }
        }
        return null;
    }

    private void close() {
        try {
            this.assoc.release(false);
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)interruptedException, (Object)this);
        }
    }

    private File getFileByIDs(String string, String string2) {
        int n2 = this.fileInfoList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            FileInfo fileInfo = this.fileInfoList.get(i2);
            if (!fileInfo.cuid.equals(string) || !fileInfo.iuid.equals(string2)) continue;
            return fileInfo.f;
        }
        return null;
    }

    private void promptErrRSP(String string, int n2, FileInfo fileInfo, DicomObject dicomObject) {
        String string2 = string + StringUtils.shortToHex((int)n2) + "H for " + fileInfo + ", cuid=" + fileInfo.cuid + ", tsuid=" + fileInfo.tsuid;
        ay.d((Object)string2, (Object)this);
        ay.d((Object)dicomObject.toString(), (Object)this);
    }

    private void promptStgCmt(DicomObject dicomObject) {
        DicomObject dicomObject2;
        int n2;
        DicomElement dicomElement = dicomObject.get(528793);
        if (dicomElement == null) {
            this.errMessage = "ALL FILES ARE FAILED TO COMMIT";
            this.errors.add(new DcmError(this.errMessage, "N/A"));
            ay.d((Object)"All files failed to commit", (Object)this);
            return;
        }
        ay.b((Object)(Integer.toString(dicomElement.countItems()) + " successful"), (Object)this);
        DicomElement dicomElement2 = dicomObject.get(528792);
        if (dicomElement2 != null) {
            this.errMessage = "STORAGE COMMITMENT OF SOME FILES COULD NOT BE ACHIEVED";
            ay.c((Object)(Integer.toString(dicomElement2.countItems()) + " FAILED!"), (Object)this);
        }
        ay.a((Object)"Successful SOP instances: ", (Object)this);
        for (n2 = 0; n2 < dicomElement.countItems(); ++n2) {
            dicomObject2 = dicomElement.getDicomObject(n2);
            ay.a((Object)("SOP Class: " + DcmSnd.promptUID(dicomObject2.getString(528720)) + " SOP Instance: " + dicomObject2.getString(528725)), (Object)this);
        }
        if (dicomElement2 != null) {
            ay.c((Object)"Failed SOP instances: ", (Object)this);
            for (n2 = 0; n2 < dicomElement2.countItems(); ++n2) {
                dicomObject2 = dicomElement2.getDicomObject(n2);
                String string = dicomObject2.getString(528720);
                String string2 = dicomObject2.getString(528725);
                ay.c((Object)("SOP Class: " + DcmSnd.promptUID(string) + " SOP Instance: " + string2), (Object)this);
                ay.c((Object)("Failure Reason: 0x" + Integer.toHexString(dicomObject2.getInt(528791)).toUpperCase()), (Object)this);
                File file = this.getFileByIDs(string, string2);
                if (file != null) {
                    String string3 = null;
                    try {
                        string3 = file.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string3 = file.getAbsolutePath();
                    }
                    this.errors.add(new DcmError("failed to achieve the storage commitment of the file", string3));
                    continue;
                }
                ay.d((Object)"Found an unknown SOP Instance in Storage Commitment Result", (Object)this);
            }
        }
    }

    private void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
        int n2 = dicomObject.getInt(256);
        int n3 = dicomObject.getInt(2304);
        int n4 = dicomObject.getInt(288);
        FileInfo fileInfo = this.fileInfoList.get(n4 - 1);
        if (n2 != 32769) {
            ay.d((Object)("received invalid C-STORE Response with command field 0x" + Integer.toHexString(n2).toUpperCase()), (Object)this);
            this.errMessage = "Error on server: received invalid Response for C-STORE Request";
            String string = "sent the file with invalid response";
            String string2 = null;
            try {
                string2 = fileInfo.f.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = fileInfo.f.getAbsolutePath();
            }
            this.errors.add(new DcmError(string, string2));
            return;
        }
        ay.a((Object)("Received a C-STORE-RESPONSE:" + dicomObject.toString()), (Object)this);
        switch (n3) {
            case 0: {
                ay.a((Object)("Sent the file successfully: " + fileInfo.f.getAbsolutePath()), (Object)this);
                fileInfo.transferred = true;
                this.totalTransferred += fileInfo.length;
                ++this.filesSent;
                break;
            }
            case 45056: 
            case 45062: 
            case 45063: {
                ay.c((Object)("Sent the file with warning code 0x" + Integer.toHexString(n3).toUpperCase() + ": " + fileInfo.f.getAbsolutePath()), (Object)this);
                fileInfo.transferred = true;
                this.totalTransferred += fileInfo.length;
                ++this.filesSent;
                this.errMessage = "Warning on server: " + dicomObject.getString(2306, "UNKNOWN") + ". Error Code: 0x" + Integer.toHexString(n3).toUpperCase();
                String string = "sent the file with warning response. Error Code: 0x" + Integer.toHexString(n3).toUpperCase();
                String string3 = null;
                try {
                    string3 = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string3 = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError(string, string3));
                this.promptErrRSP("WARNING: Received RSP with Status ", n3, fileInfo, dicomObject);
                System.out.print('W');
                break;
            }
            default: {
                ay.c((Object)("Sent the file with error code 0x" + Integer.toHexString(n3).toUpperCase() + ": " + fileInfo.f.getAbsolutePath()), (Object)this);
                this.errMessage = "Error on server: " + dicomObject.getString(2306, "UNKNOWN") + ". Error Code: 0x" + Integer.toHexString(n3).toUpperCase();
                String string = "sent the file with error response. Error Code: 0x" + Integer.toHexString(n3).toUpperCase();
                String string4 = null;
                try {
                    string4 = fileInfo.f.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string4 = fileInfo.f.getAbsolutePath();
                }
                this.errors.add(new DcmError(string, string4));
                this.promptErrRSP("ERROR: Received RSP with Status ", n3, fileInfo, dicomObject);
                System.out.print('F');
            }
        }
        if (this.totalSize > 0L) {
            this.progress.b((int)((double)this.totalTransferred / (double)this.totalSize * 100.0) + this.progress.g() - 100);
            this.progress.b_(MIMFormat.a(props.getProperty("DCM_SND_TRANSFERRED"), (double)Math.round((double)this.totalTransferred / 1024.0) / 1000.0, (double)Math.round((double)this.totalSize / 1024.0) / 1000.0));
        } else {
            ay.c((Object)"Using a progress bar blindly in DICOM Send...", (Object)this);
            this.progress.b((int)this.totalTransferred);
        }
    }

    @Override
    protected void onNEventReportRQ(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) {
        if (this.stgCmtSCU != null) {
            this.stgCmtSCU.onNEventReportRQ(association, n2, dicomObject, dicomObject2, dicomObject3);
        }
    }

    synchronized boolean receivedStgCmtResult(String string, DicomObject dicomObject) {
        if (string.equals(this.commitTransUID)) {
            this.stgCmtResult = dicomObject;
            ((Object)((Object)this)).notifyAll();
            return true;
        }
        return false;
    }

    private void readPresentationContextsFromFiles(String[] stringArray) {
        this.readPresentationContextsFromFiles(stringArray, false);
    }

    private void readPresentationContextsFromFiles(String[] stringArray, boolean bl2) {
        this.init();
        this.stgCmt = bl2;
        this.stgCmtResult = null;
        ay.b((Object)"Reading presentation contexts from files ...", (Object)this);
        this.progress.a(stringArray.length + 100);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                this.addFile(new File(stringArray[i2]));
            }
            catch (UserCancelException userCancelException) {
                ay.b((Object)"Current transfer is cancelled by user", (Object)this);
                return;
            }
            this.progress.N_();
            this.progress.b_(MIMFormat.a(props.getProperty("DCM_SND_READING"), i2 + 1, stringArray.length));
        }
        ay.b((Object)"Configuring transfer capabilities ...", (Object)this);
        this.configureTransferCapability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileInfo readFileInfo(File file) throws IOException {
        FileInfo fileInfo = new FileInfo(file);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        try {
            DicomInputStream dicomInputStream = new DicomInputStream(file);
            try {
                dicomInputStream.setHandler((DicomInputHandler)new StopTagInputHandler(524320));
                dicomInputStream.readDicomObject((DicomObject)basicDicomObject, 1024);
                fileInfo.tsuid = dicomInputStream.getTransferSyntax().uid();
                fileInfo.fmiEndPos = dicomInputStream.getEndOfFileMetaInfoPosition();
            }
            finally {
                try {
                    dicomInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            throw new IOException("WARNING: Failed to parse " + file);
        }
        fileInfo.cuid = basicDicomObject.getString(524310);
        if (fileInfo.cuid == null) {
            throw new IOException("WARNING: Missing SOP Class UID in " + file);
        }
        fileInfo.iuid = basicDicomObject.getString(524312);
        if (fileInfo.iuid == null) {
            throw new IOException("WARNING: Missing SOP Instance UID in " + file);
        }
        return fileInfo;
    }

    private void init() {
        this.assoc = null;
        this.fileInfoList.clear();
        this.as2ts.clear();
        this.filesSent = 0;
        this.totalTransferred = 0L;
        this.transferTime = 0L;
        this.congested = false;
        this.cancelling = false;
        this.errMessage = "";
        this.skipThisError = true;
        this.errors.clear();
        this.stgCmt = false;
        this.commitTransUID = null;
    }

    private synchronized DicomObject waitForStgCmtResult() throws InterruptedException {
        long l2;
        this.progress.b_(props.getProperty("DCM_SND_WAITING"));
        ay.b((Object)"Waiting for Storage Commitment Result..", (Object)this);
        long l3 = System.currentTimeMillis();
        long l4 = 0L;
        while (!this.cancelling && this.stgCmtResult == null && (l4 = (long)waitForCmtResultTime - ((l2 = System.currentTimeMillis()) - l3)) > 0L) {
            ((Object)((Object)this)).wait(l4);
        }
        l2 = System.currentTimeMillis();
        float f2 = (float)(l2 - l3) / 1000.0f;
        if (this.cancelling) {
            this.progress.b_(props.getProperty("DCM_SND_CANCELLED"));
            ay.b((Object)"Storage Commitment is cancelled", (Object)this);
            return null;
        }
        if (this.stgCmtResult == null) {
            ay.d((Object)("Timeout occurred when waiting for Storage Commitment Result: " + f2 + "s"), (Object)this);
            return null;
        }
        this.progress.b_(MIMFormat.a(props.getProperty("DCM_SND_RECEIVED"), Float.valueOf(f2)));
        ay.b((Object)("Received Storage Commitment Result in " + f2 + "s"), (Object)this);
        return this.stgCmtResult;
    }

    private boolean waitingForStgCmtResult() {
        try {
            DicomObject dicomObject = this.waitForStgCmtResult();
            if (dicomObject != null) {
                this.promptStgCmt(dicomObject);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            this.errMessage = props.b("DCM_SND_INTERRUPTED");
            ay.d((Object)("Failed to receive storage commitment result:" + interruptedException.getMessage()), (Object)this);
        }
        return false;
    }

    public void send(String[] stringArray) {
        this.send(stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String[] stringArray, boolean bl2) {
        if (this.hasBeenUsed) {
            throw new IllegalStateException("An instance of DcmSnd cannot be re-used!");
        }
        this.hasBeenUsed = true;
        if (this.mode != 0) {
            throw new IllegalStateException("Error mode");
        }
        long l2 = System.currentTimeMillis();
        this.readPresentationContextsFromFiles(stringArray, bl2);
        if (this.cancelling) {
            return;
        }
        if (this.stgCmt) {
            ay.b((Object)"Storage commitment is activated", (Object)this);
            this.stgCmtSCU = MIMStorageCommitmentSCUService.getInstance();
        }
        long l3 = System.currentTimeMillis();
        ay.b((Object)("Read presentation context from files in " + (float)(l3 - l2) / 1000.0f + "s"), (Object)this);
        long l4 = System.currentTimeMillis();
        if (!this.cancelling) {
            ay.b((Object)"Connecting to remote AE ...", (Object)this);
            try {
                this.open();
            }
            catch (Exception exception) {
                ay.d((Object)"Failed to establish association: ", (Throwable)exception, (Object)this);
                return;
            }
            long l5 = System.currentTimeMillis();
            ay.b((Object)("Connected to remote AE in " + (float)(l5 - l4) / 1000.0f + "s"), (Object)this);
            ay.b((Object)"Sending files ...", (Object)this);
            l4 = System.currentTimeMillis();
            boolean bl3 = this.send();
            l5 = System.currentTimeMillis();
            this.transferTime = l5 - l4;
            if (this.transferTime == 0L) {
                this.transferTime = 1L;
            }
            this.prompt((float)this.transferTime / 1000.0f);
            this.cancelLock.lock();
            try {
                this.progress.a(false, true);
                boolean bl4 = false;
                if (bl3 && !this.cancelling && this.stgCmt) {
                    ay.b((Object)"Requesting commit", (Object)this);
                    this.progress.b_(props.getProperty("DCM_SND_PREPARING"));
                    int n2 = this.ae.getIdleTimeout();
                    if (waitForCmtResultTime > n2) {
                        this.ae.setIdleTimeout(waitForCmtResultTime);
                    }
                    ay.b((Object)"Preparing for storage commitment ...", (Object)this);
                    l4 = System.currentTimeMillis();
                    if (this.commit()) {
                        l5 = System.currentTimeMillis();
                        ay.b((Object)("Request Storage Commitment in " + (float)(l5 - l4) / 1000.0f + "s"), (Object)this);
                        bl4 = !this.waitingForStgCmtResult();
                    }
                    this.ae.setIdleTimeout(n2);
                }
                ay.b((Object)"Releasing association to remote AE...", (Object)this);
                this.close();
                ay.b((Object)"Released association to remote AE", (Object)this);
                if (!this.cancelling && bl4 && !this.waitingForStgCmtResult()) {
                    this.stgCmtSCU.removeNewStgCmtRequest(this.commitTransUID);
                    this.errMessage = "COULD NOT RECEIVE STORAGE COMMITMENT RESULT";
                    this.errors.add(new DcmError(this.errMessage, "N/A"));
                }
            }
            finally {
                this.cancelLock.unlock();
            }
        }
        if (this.cancelling) {
            this.skipThisError = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean echo() {
        if (this.mode != 0) {
            throw new IllegalStateException("Error mode");
        }
        this.init();
        TransferCapability transferCapability = new TransferCapability("1.2.840.10008.1.1", ONLY_IVLE_TS, "SCU");
        this.ae.setTransferCapability(new TransferCapability[]{transferCapability});
        try {
            this.open();
        }
        catch (Exception exception) {
            ay.d((Object)"Failed to establish association: ", (Throwable)exception, (Object)this);
            return false;
        }
        try {
            DimseRSP dimseRSP = this.assoc.cecho();
            if (dimseRSP.next()) {
                boolean bl2 = dimseRSP.getCommand().getInt(2304) == 0;
                return bl2;
            }
        }
        catch (IOException iOException) {
            ay.d((Object)"Failed to echo: ", (Throwable)iOException, (Object)this);
            boolean bl3 = false;
            return bl3;
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)"Failed to echo: ", (Throwable)interruptedException, (Object)this);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            ay.b((Object)"Releasing association to remote AE...", (Object)this);
            this.close();
            ay.b((Object)"Released association to remote AE", (Object)this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws IOException, InterruptedException, ConfigurationException {
        this.init();
        TransferCapability transferCapability = new TransferCapability("1.2.840.10008.1.1", ONLY_IVLE_TS, "SCU");
        this.ae.setTransferCapability(new TransferCapability[]{transferCapability});
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
        try {
            this.assoc.cecho().next();
        }
        finally {
            this.close();
        }
    }

    public void setProgress(s s2) {
        if (s2 == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.progress = s2;
    }

    public boolean isCongested() {
        return this.congested;
    }

    public long getSentBytes() {
        return this.totalTransferred;
    }

    public long getTransferTime() {
        return this.transferTime;
    }

    public String getErrorMsg() {
        return this.errMessage;
    }

    public boolean getSkipThisError() {
        return this.skipThisError;
    }

    public Vector getErrors() {
        return this.errors;
    }

    public synchronized void cancel() {
        this.cancelling = true;
        if (this.assoc != null) {
            ay.b((Object)("Cancelling current dcmsnd association: " + this.assoc), (Object)this);
            this.assoc.abort();
            ay.b((Object)("Cancelled current dcmsnd association: " + this.assoc), (Object)this);
            ((Object)((Object)this)).notifyAll();
        }
    }

    public void terminate() {
        try {
            this.assoc.getSocket().close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void initializeConnection(String[] stringArray) throws IOException, ConfigurationException, InterruptedException {
        if (this.mode != 1) {
            throw new IllegalStateException("Error mode");
        }
        this.readPresentationContextsFromFiles(stringArray);
        this.open();
    }

    public int sendSingleFile(String string) throws IOException, InterruptedException {
        String string22;
        if (this.mode != 1) {
            throw new IllegalStateException("Error mode");
        }
        if (this.assoc == null) {
            throw new IOException("Association is not established");
        }
        File file = new File(string);
        if (file.isDirectory()) {
            throw new FileNotFoundException("The argument should be a file rather than a directory");
        }
        for (String string22 : badExtensions) {
            if (!file.getName().toUpperCase().endsWith(string22)) continue;
            throw new IOException("Extension not supported for DICOM Send: " + string22);
        }
        FileInfo fileInfo = this.readFileInfo(file);
        TransferCapability transferCapability = this.assoc.getTransferCapabilityAsSCU(fileInfo.cuid);
        if (transferCapability == null) {
            throw new NoPresentationContextException(DcmSnd.promptUID(fileInfo.cuid) + " not supported by " + this.remoteAE.getAETitle());
        }
        String string3 = this.selectTransferSyntax(transferCapability.getTransferSyntax(), fileInfo.tsuid);
        if (string3 == null && (string3 = this.selectTransferSyntax((transferCapability = this.decompress(fileInfo)).getTransferSyntax(), fileInfo.tmpFileInfo.tsuid)) == null) {
            throw new NoPresentationContextException(DcmSnd.promptUID(fileInfo.cuid) + " with " + DcmSnd.promptUID(fileInfo.tsuid) + " not supported by" + this.remoteAE.getAETitle());
        }
        if (fileInfo.tmpFileInfo == null) {
            string22 = this.assoc.cstore(fileInfo.cuid, fileInfo.iuid, this.priority, (org.dcm4che2.net.DataWriter)new DataWriter(fileInfo), string3);
        } else {
            string22 = this.assoc.cstore(fileInfo.tmpFileInfo.cuid, fileInfo.tmpFileInfo.iuid, this.priority, (org.dcm4che2.net.DataWriter)new DataWriter(fileInfo.tmpFileInfo), string3);
            ay.a((Object)("Send file " + fileInfo.f.getAbsolutePath() + " indirectly successful"), (Object)this);
            if (fileInfo.tmpFileInfo != null) {
                try {
                    fileInfo.tmpFileInfo.f.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (string22.next()) {
            return string22.getCommand().getInt(2304);
        }
        throw new IOException("failed to get C-STORE-RSP");
    }

    public void releaseConnection() {
        if (this.mode != 1) {
            throw new IllegalStateException("Error mode");
        }
        try {
            if (this.assoc != null) {
                this.assoc.release(true);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    static {
        ConfigurableFileExcluder configurableFileExcluder = new ConfigurableFileExcluder();
        badExtensions = ((FileExcluder)configurableFileExcluder).getExcludedDicomReadExtensions();
        for (int i2 = 0; i2 < badExtensions.length; ++i2) {
            DcmSnd.badExtensions[i2] = badExtensions[i2].toUpperCase();
        }
    }

    private static class UserCancelException
    extends Exception {
        private static final long serialVersionUID = 1704770946834595841L;
    }

    private static class DcmFileReadException
    extends IOException {
        private static final long serialVersionUID = -1748523113718689355L;

        public DcmFileReadException(String string) {
            super(string);
        }
    }

    private class DataWriter
    implements org.dcm4che2.net.DataWriter {
        private FileInfo info;

        public DataWriter(FileInfo fileInfo) {
            this.info = fileInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(PDVOutputStream pDVOutputStream, String string) throws IOException {
            if (string.equals(this.info.tsuid)) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(this.info.f);
                }
                catch (IOException iOException) {
                    throw new DcmFileReadException("cannot open dicom file " + this.info.f.getAbsolutePath());
                }
                try {
                    for (long i2 = this.info.fmiEndPos; i2 > 0L; i2 -= fileInputStream.skip(i2)) {
                    }
                    pDVOutputStream.copyFrom((InputStream)fileInputStream);
                }
                finally {
                    fileInputStream.close();
                }
            }
            DicomInputStream dicomInputStream = null;
            try {
                dicomInputStream = new DicomInputStream(this.info.f);
            }
            catch (IOException iOException) {
                throw new DcmFileReadException("cannot parse dicom file " + this.info.f.getAbsolutePath());
            }
            try {
                DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)pDVOutputStream);
                dicomOutputStream.setTransferSyntax(string);
                TranscoderInputHandler transcoderInputHandler = new TranscoderInputHandler(dicomOutputStream, DcmSnd.this.transcoderBufferSize);
                dicomInputStream.setHandler((DicomInputHandler)transcoderInputHandler);
                dicomInputStream.readDicomObject();
            }
            finally {
                dicomInputStream.close();
            }
        }
    }

    private static final class FileInfo {
        File f;
        String cuid;
        String iuid;
        String tsuid;
        long fmiEndPos;
        long length;
        boolean transferred;
        public FileInfo tmpFileInfo;

        public FileInfo(File file) {
            this.f = file;
            this.length = file.length();
        }
    }
}

