/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.network;

import com.mimvista.dicom.network.DcmSnd;
import com.mimvista.dicom.network.MIMStorageCommitmentSCU;
import com.mimvista.preferencesNew.DicomStgcmtscuPrefs;
import com.mimvista.util.ay;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.DicomService;

class MIMStorageCommitmentSCUService
extends MIMStorageCommitmentSCU {
    private static MIMStorageCommitmentSCUService instance = null;
    private Executor executor = new NewThreadExecutor("SgcmtSCU");
    private Device device = new Device("SgcmtSCU");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private boolean started = false;
    private HashMap<String, DcmSnd> requestQueue = new HashMap();

    static synchronized MIMStorageCommitmentSCUService getInstance() {
        if (instance == null) {
            instance = new MIMStorageCommitmentSCUService();
            instance.start();
        } else if (!MIMStorageCommitmentSCUService.instance.started) {
            instance.start();
        }
        return instance;
    }

    private MIMStorageCommitmentSCUService() {
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.initializeDevice();
        this.initializeNetworkConnection();
        this.initializeNetworkApplicationEntity();
    }

    private void initializeDevice() {
        int n2 = DicomStgcmtscuPrefs.reaper.getValue();
        ay.b((Object)("StorageCommitmentSCU device association reaper period: " + n2 + " ms"), (Object)this);
        this.device.setAssociationReaperPeriod(n2);
    }

    private void initializeNetworkConnection() {
        int n2 = DicomStgcmtscuPrefs.port.getValue();
        int n3 = DicomStgcmtscuPrefs.associationRequestTimeout.getValue();
        int n4 = DicomStgcmtscuPrefs.socketCloseDelay.getValue();
        boolean bl2 = DicomStgcmtscuPrefs.tcpNoDelay.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Initializing StorageCommitmentSCU Network Connection");
        stringBuilder.append("\n\tPort: ");
        stringBuilder.append(n2);
        stringBuilder.append(", Association Request Timeout: ");
        stringBuilder.append(n3);
        stringBuilder.append(" ms, Socket Close Delay: ");
        stringBuilder.append(n4);
        stringBuilder.append(" ms, TCP No Delay: ");
        stringBuilder.append(bl2 ? "yes" : "no");
        ay.b((Object)stringBuilder, (Object)this);
        this.conn.setPort(n2);
        this.conn.setRequestTimeout(n3);
        this.conn.setSocketCloseDelay(n4);
        this.conn.setTcpNoDelay(bl2);
    }

    private void initializeNetworkApplicationEntity() {
        this.ae.setAssociationAcceptor(true);
        this.ae.register((DicomService)this);
        int n2 = DicomStgcmtscuPrefs.idleTimeout.getValue();
        int n3 = DicomStgcmtscuPrefs.pduReceiveSize.getValue();
        int n4 = DicomStgcmtscuPrefs.pduSendSize.getValue();
        boolean bl2 = DicomStgcmtscuPrefs.packPdv.getValue();
        int n5 = DicomStgcmtscuPrefs.maxOpsPerformed.getValue();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Initializing StorageCommitmentSCU");
        stringBuilder.append("\n\tIdle Timeout: ");
        stringBuilder.append(n2);
        stringBuilder.append(" ms, PDU Receive Size: ");
        stringBuilder.append(n3);
        stringBuilder.append(" bytes, PDU Send Size: ");
        stringBuilder.append(n4);
        stringBuilder.append(" bytes\n\tPack PDV: ");
        stringBuilder.append(bl2 ? "yes" : "no");
        stringBuilder.append(", Max Operations Performed: ");
        stringBuilder.append(n5);
        ay.b((Object)stringBuilder, (Object)this);
        this.ae.setMaxOpsPerformed(n5);
        this.ae.setMaxPDULengthReceive(n3);
        this.ae.setMaxPDULengthSend(n4);
        this.ae.setPackPDV(bl2);
        this.ae.setIdleTimeout(n2);
        TransferCapability[] transferCapabilityArray = new TransferCapability[]{new TransferCapability("1.2.840.10008.1.20.1", new String[]{"1.2.840.10008.1.2"}, "SCU")};
        this.ae.setTransferCapability(transferCapabilityArray);
    }

    @Override
    protected void onNEventReportRQ(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) {
        int n3 = dicomObject.getInt(4098);
        if (n3 != 1 && n3 != 2) {
            ay.d((Object)("Received unrecognized event type: " + Integer.toString(n3)), (Object)this);
            dicomObject3.putInt(2304, VR.US, 277);
            dicomObject3.putInt(4098, VR.US, n3);
            return;
        }
        String string = dicomObject2.getString(528789);
        if (string == null) {
            ay.d((Object)"Received storage commitment response without transaction UID", (Object)this);
            dicomObject3.putInt(2304, VR.US, 530);
            return;
        }
        DcmSnd dcmSnd = this.removeNewStgCmtRequest(string);
        if (dcmSnd == null || !dcmSnd.receivedStgCmtResult(string, dicomObject2)) {
            ay.d((Object)("Received storage commitment response with invalid transaction UID " + string), (Object)this);
            dicomObject3.putInt(2304, VR.US, 277);
            dicomObject3.putString(528789, VR.UI, string);
        }
    }

    synchronized void addNewStgCmtRequest(String string, DcmSnd dcmSnd) {
        this.requestQueue.put(string, dcmSnd);
    }

    synchronized DcmSnd removeNewStgCmtRequest(String string) {
        return this.requestQueue.remove(string);
    }

    private void start() {
        try {
            this.device.startListening(this.executor);
            this.started = true;
        }
        catch (IOException iOException) {
            ay.d((Object)"Failed to start storage commitment scu service", (Throwable)iOException, (Object)this);
        }
    }
}

