/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.network;

import com.mimvista.archive.gui.SourceType;
import com.mimvista.archive.gui.ai;
import com.mimvista.archive.gui.aj;
import com.mimvista.archive.gui.am;
import com.mimvista.archive.search.DicomSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.Searchable;
import com.mimvista.archive.search.g;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DcmStudy;
import com.mimvista.dicom.network.DcmQueryClient;
import com.mimvista.file.PathUtils;
import com.mimvista.osdep.BrowserControl;
import com.mimvista.preferencesNew.DcmqueryclientPrefs;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.QrserverPrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.util.work.m;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.DimseRSP;

public class MITRAReportQuery
extends DcmQueryClient {
    public static final String MITRA_AffectedSopClassUID = "1.2.840.113532.3500.8";
    private String accessionNumber = null;
    private String patientName = null;
    private String patientId = null;
    private Date patientBirthdate = null;
    private String patientSex = null;
    private String studyInstanceUid = null;

    public MITRAReportQuery(DicomLocationsPrefs.a a2) {
        super(a2);
    }

    public void setAccessionNumber(String string) {
        this.accessionNumber = string;
    }

    public void setPatientName(String string) {
        this.patientName = string;
    }

    public void setPatientId(String string) {
        this.patientId = string;
    }

    public void setPatientBirthdate(Date date) {
        this.patientBirthdate = date;
    }

    public void setPatientSex(String string) {
        this.patientSex = string;
    }

    public void setStudyInstanceUid(String string) {
        this.studyInstanceUid = string;
    }

    private DicomObject buildQuery() {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putString(524368, VR.SH, this.accessionNumber);
        basicDicomObject.putString(0x100010, VR.PN, this.patientName);
        basicDicomObject.putString(0x100020, VR.LO, this.patientId);
        basicDicomObject.putDate(0x100030, VR.DA, this.patientBirthdate);
        basicDicomObject.putString(0x100040, VR.CS, this.patientSex);
        basicDicomObject.putString(0x20000D, VR.UI, this.studyInstanceUid);
        basicDicomObject.putNull(3280992, VR.LO);
        basicDicomObject.putNull(1074266368, VR.DA);
        basicDicomObject.putNull(1074266369, VR.TM);
        basicDicomObject.putNull(1074266380, VR.PN);
        basicDicomObject.putNull(1074266386, VR.DA);
        basicDicomObject.putNull(1074266387, VR.TM);
        basicDicomObject.putNull(1074266389, VR.LT);
        basicDicomObject.putNull(1074266624, VR.SH);
        basicDicomObject.putNull(1074266642, VR.CS);
        return basicDicomObject;
    }

    private List<DicomObject> executeQuery(Searchable.a a2) throws IOException, InterruptedException {
        String string = "1.2.840.10008.1.2";
        DimseRSP dimseRSP = this.assoc.cfind(MITRA_AffectedSopClassUID, 0, this.buildQuery(), string, Integer.MAX_VALUE);
        if (a2.b()) {
            return new ArrayList<DicomObject>();
        }
        ArrayList<DicomObject> arrayList = new ArrayList<DicomObject>();
        while (dimseRSP.next()) {
            if (a2.b()) {
                return new ArrayList<DicomObject>();
            }
            DicomObject dicomObject = dimseRSP.getCommand();
            if (!CommandUtils.isPending((DicomObject)dicomObject)) continue;
            DicomObject dicomObject2 = dimseRSP.getDataset();
            arrayList.add(dicomObject2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Progress progress, final Searchable.a a2) {
        block23: {
            progress.a(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    a2.a();
                }
            });
            progress.a(true);
            progress.a();
            try {
                if (!this.open()) break block23;
                int n2 = 0;
                List<DicomObject> list = this.executeQuery(a2);
                for (DicomObject dicomObject : list) {
                    File file;
                    ay.a((Object)("Received MITRA Report Response:\n" + dicomObject), this);
                    while ((file = new File(PathUtils.getTempPath(), "MITRAReport_" + n2++ + ".txt")).exists()) {
                    }
                    FileWriter fileWriter = new FileWriter(file);
                    Throwable throwable = null;
                    try {
                        String string = dicomObject.getString(1074266389);
                        string = string.replaceAll("\\\\x0A", "\n");
                        fileWriter.append(string);
                        fileWriter.flush();
                        fileWriter.close();
                        ay.b((Object)("Wrote MITRA Report Response to: " + file.getAbsolutePath()), this);
                        BrowserControl.a(file.getAbsolutePath());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fileWriter == null) continue;
                        if (throwable != null) {
                            try {
                                fileWriter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        fileWriter.close();
                    }
                }
                progress.b();
            }
            catch (Exception exception) {
                ay.d((Object)("Error with DicomQueryClient: " + this.url), (Throwable)exception, this);
                progress.k();
            }
            finally {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    ay.d((Object)("Error closing query: " + this), (Throwable)exception, this);
                }
            }
        }
    }

    public static boolean isMitraReportQueryEnabled() {
        return DcmqueryclientPrefs.enableMitraReportQr.getValue();
    }

    public static boolean isMitraReportQueryResponseEnabled() {
        return QrserverPrefs.enableMitraReportQrRsp.getValue();
    }

    public static class MITRAReportQuerySeriesAction
    extends ai {
        protected aj context;

        public MITRAReportQuerySeriesAction(aj aj2) {
            this.context = aj2;
            this.types = EnumSet.of(SourceType.a);
        }

        @Override
        public boolean accept(SearchSource searchSource) {
            return searchSource instanceof DicomSearchSource && MITRAReportQuery.isMitraReportQueryEnabled();
        }

        @Override
        public String getText() {
            return Messages.a("Archive", "MITRA_QUERY_REPORTS");
        }

        @Override
        public void act(am am2) {
            ArrayList<DicomLocationsPrefs.a> arrayList = new ArrayList<DicomLocationsPrefs.a>();
            ArrayList<DicomSearchSource> arrayList2 = new ArrayList<DicomSearchSource>();
            arrayList2.addAll(g.h());
            arrayList2.addAll(g.i());
            for (DicomSearchSource object : arrayList2) {
                DicomLocationsPrefs.a a2 = object.a();
                if (!a2.isAllowMitraReportQuery() || arrayList.contains(a2)) continue;
                arrayList.add(a2);
            }
            HashSet hashSet = new HashSet();
            for (DcmSeries dcmSeries : am2.d()) {
                hashSet.add(dcmSeries.getStudy());
            }
            m.c.submit(() -> {
                for (DicomLocationsPrefs.a a2 : arrayList) {
                    try {
                        for (DcmStudy dcmStudy : hashSet) {
                            MITRAReportQuery mITRAReportQuery = new MITRAReportQuery(a2);
                            mITRAReportQuery.setAccessionNumber(dcmStudy.getStringProperty(524368));
                            mITRAReportQuery.setPatientId(dcmStudy.getPatientID());
                            mITRAReportQuery.setPatientName(dcmStudy.getStringProperty(0x100010));
                            mITRAReportQuery.setStudyInstanceUid(dcmStudy.getStudyInstanceUID());
                            mITRAReportQuery.execute(new o(), new Searchable.b());
                        }
                    }
                    catch (Throwable throwable) {
                        ay.d((Object)throwable, this);
                    }
                }
            });
        }
    }
}

