/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.mimvista.util.ay;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.NoPresentationContextException;
import org.dcm4che2.net.TransferCapability;

public class CFindSCU {
    private static final String DEFAULT_AE_TITLE = "CFINDSCU";
    private static final String DEFAULT_CALLED_AE_TITLE = "MIMDCMQUERY";
    private static final String DEFAULT_REMOTE_HOST = "127.0.0.1";
    private static final int DEFAULT_REMOTE_PORT = 8177;
    private static final int PATIENT = 0;
    private static final int STUDY = 1;
    private static final int SERIES = 2;
    private static final int IMAGE = 3;
    private static final int PATIENTROOT = 0;
    private static final int STUDYROOT = 1;
    private int informationModel;
    private int priority = 0;
    private int cancelAfter = Integer.MAX_VALUE;
    private static final String[] QUERYLEVEL = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    private static final String[] PATIENT_LEVEL_FIND_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.1.1"};
    private static final String[] STUDY_LEVEL_FIND_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.2.1"};
    private static final String[][] FIND_CUID = new String[][]{PATIENT_LEVEL_FIND_CUID, STUDY_LEVEL_FIND_CUID, STUDY_LEVEL_FIND_CUID, STUDY_LEVEL_FIND_CUID};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1"};
    private Executor executor = new NewThreadExecutor("CFINDSCU");
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection remoteConn = new NetworkConnection();
    private Device device = new Device("CFINDSCU");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private Association assoc;
    private int queryLevel;
    private DicomObject keys = new BasicDicomObject();
    private String AETiltle = "CFINDSCU";

    public CFindSCU() {
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(this.AETiltle);
    }

    public CFindSCU(boolean bl2) {
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(this.AETiltle);
        if (bl2) {
            this.setCalledAETitle(DEFAULT_CALLED_AE_TITLE);
            this.setRemoteHost(DEFAULT_REMOTE_HOST);
            this.setRemotePort(8177);
        }
    }

    public void setCalledAETitle(String string) {
        this.remoteAE.setAETitle(string);
    }

    public final void setRemoteHost(String string) {
        this.remoteConn.setHostname(string);
    }

    public final void setRemotePort(int n2) {
        this.remoteConn.setPort(n2);
    }

    public void open() throws IOException, ConfigurationException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
    }

    private TransferCapability selectTransferCapability(String[] stringArray) {
        TransferCapability transferCapability = this.assoc.getTransferCapabilityAsSCU(stringArray[this.informationModel]);
        if (transferCapability != null) {
            return transferCapability;
        }
        return null;
    }

    private TransferCapability selectFindTransferCapability() throws NoPresentationContextException {
        TransferCapability transferCapability = this.selectTransferCapability(FIND_CUID[this.queryLevel]);
        if (transferCapability != null) {
            return transferCapability;
        }
        return null;
    }

    private String selectTransferSyntax(TransferCapability transferCapability) {
        String[] stringArray = transferCapability.getTransferSyntax();
        return stringArray[0];
    }

    public void configureTransferCapability(int n2) {
        String[] stringArray = FIND_CUID[n2];
        TransferCapability[] transferCapabilityArray = new TransferCapability[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            transferCapabilityArray[i2] = new TransferCapability(stringArray[i2], NATIVE_LE_TS, "SCU");
        }
        this.ae.setTransferCapability(transferCapabilityArray);
    }

    public List query() throws IOException, InterruptedException {
        TransferCapability transferCapability = this.selectFindTransferCapability();
        if (transferCapability == null) {
            return null;
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        DimseRSP dimseRSP = this.assoc.cfind(string, this.priority, this.keys, string2, this.cancelAfter);
        ArrayList<DicomObject> arrayList = new ArrayList<DicomObject>();
        while (dimseRSP.next()) {
            DicomObject dicomObject = dimseRSP.getCommand();
            if (!CommandUtils.isPending((DicomObject)dicomObject)) continue;
            DicomObject dicomObject2 = dimseRSP.getDataset();
            arrayList.add(dicomObject2);
        }
        return arrayList;
    }

    public void putKey(int n2, String string) {
        this.keys.putString(n2, null, string);
    }

    public void setInformationModel(int n2) {
        this.informationModel = n2;
    }

    public void setQueryLevel(int n2) {
        this.queryLevel = n2;
        this.keys.putString(524370, VR.CS, QUERYLEVEL[n2]);
    }

    public void setPatientLevelQuery(String string, String string2) {
        this.keys.putString(0x100010, null, string);
        this.keys.putString(0x100020, null, string2);
        this.keys.putString(0x100030, null, null);
        this.keys.putString(0x100040, null, null);
    }

    public void setStudyLevelQuery(String string, String string2, String string3, String string4, String string5, String string6) {
        this.keys.putString(0x100010, null, string);
        this.keys.putString(0x100020, null, string2);
        this.keys.putString(0x20000D, null, string3);
        this.keys.putString(524320, null, string4);
        this.keys.putString(524336, null, string5);
        this.keys.putString(0x200010, null, string6);
        this.keys.putString(524385, null, null);
        this.keys.putString(528432, null, null);
    }

    public void setSeriesLevelQuery(String string, String string2, String string3, String string4) {
        this.keys.putString(0x20000D, null, string);
        this.keys.putString(0x20000E, null, string2);
        this.keys.putString(524384, null, string3);
        this.keys.putString(0x200011, null, string4);
        this.keys.putString(528446, null, null);
        this.keys.putString(1577008, null, null);
    }

    public void setImageLevelQuery(String string, String string2, String string3, String string4) {
        this.keys.putString(0x20000D, null, string);
        this.keys.putString(0x20000E, null, string2);
        this.keys.putString(524312, null, string3);
        this.keys.putString(2097171, null, string4);
    }

    public void close() throws InterruptedException {
        this.assoc.release(true);
    }

    public static void main(String[] stringArray) {
        CFindSCU cFindSCU = new CFindSCU(true);
        cFindSCU.setInformationModel(1);
        cFindSCU.setQueryLevel(1);
        cFindSCU.configureTransferCapability(1);
        long l2 = System.currentTimeMillis();
        try {
            cFindSCU.open();
        }
        catch (Exception exception) {
            System.err.println("ERROR: Failed to establish association:");
            exception.printStackTrace(System.err);
        }
        long l3 = System.currentTimeMillis();
        System.out.println("Connected to MIMDCMQUERY in " + (float)(l3 - l2) / 1000.0f + "s");
        try {
            cFindSCU.setStudyLevelQuery(null, "Sample07", null, null, null, null);
            List list = cFindSCU.query();
            if (list == null) {
                return;
            }
            for (Object e2 : list) {
                System.out.println(e2);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)("Can not query from the remote AE" + iOException), CFindSCU.class);
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        try {
            cFindSCU.close();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

