/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.mimvista.archive.e;
import com.mimvista.dicom.qrserver.CGetStorage;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.util.ay;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.DicomService;

public class CGetSCU {
    private static final String DEFAULT_AE_TITLE = "CGETSCU";
    private static final String DEFAULT_TEMP_PATH = GetOSPath.convertPath("C:\\MIM_DATA\\GETTEMP");
    private static final String DEFAULT_ACHIVE_PATH = GetOSPath.convertPath("C:\\MIM_DATA\\GETACHIVE");
    private static final int STUDY = 1;
    private static final int STUDYROOT = 1;
    private int informationModel;
    private int priority = 0;
    private int completed;
    private int warning;
    private int failed;
    private static final String[] RETRIEVELEVEL = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    private static final String[] PATIENT_LEVEL_GET_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.3"};
    private static final String[] STUDY_LEVEL_GET_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.3", "1.2.840.10008.5.1.4.1.2.1.3"};
    private static final String[][] GET_CUID = new String[][]{PATIENT_LEVEL_GET_CUID, STUDY_LEVEL_GET_CUID, STUDY_LEVEL_GET_CUID, STUDY_LEVEL_GET_CUID};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1"};
    private static final int[] GET_KEYS = new int[]{524370, 0x100020, 0x20000D, 0x20000E, 524312};
    private String tempPath = DEFAULT_TEMP_PATH;
    private String archivePath = DEFAULT_ACHIVE_PATH;
    private CGetStorage storage;
    private Executor executor = new NewThreadExecutor("CGETSCU");
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection remoteConn = new NetworkConnection();
    private Device device = new Device("CGETSCU");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private Association assoc;
    private DicomObject keys = new BasicDicomObject();
    private String AETiltle = "CGETSCU";
    private int getLevel;

    public CGetSCU(String string) {
        this.tempPath = string;
        this.storage = new CGetStorage(DicomStoreConfigLoader.getSupportedSopUids());
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(this.AETiltle);
        this.ae.register((DicomService)this.storage);
    }

    public void setCalledAETitle(String string) {
        this.remoteAE.setAETitle(string);
    }

    public final void setRemoteHost(String string) {
        this.remoteConn.setHostname(string);
    }

    public final void setRemotePort(int n2) {
        this.remoteConn.setPort(n2);
    }

    public void configureTransferCapability(int n2) {
        int n3;
        String[] stringArray = GET_CUID[n2];
        TransferCapability[] transferCapabilityArray = new TransferCapability[stringArray.length + DicomStoreConfigLoader.getSupportedSopUids().length];
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            transferCapabilityArray[n3] = new TransferCapability(stringArray[n3], NATIVE_LE_TS, "SCU");
        }
        for (n3 = 0; n3 < DicomStoreConfigLoader.getSupportedSopUids().length; ++n3) {
            transferCapabilityArray[n3 + stringArray.length] = new TransferCapability(DicomStoreConfigLoader.getSupportedSopUids()[n3], NATIVE_LE_TS, "SCP");
        }
        this.ae.setTransferCapability(transferCapabilityArray);
    }

    private TransferCapability selectTransferCapability(String[] stringArray) {
        TransferCapability transferCapability = this.assoc.getTransferCapabilityAsSCU(stringArray[this.informationModel]);
        if (transferCapability != null) {
            return transferCapability;
        }
        return null;
    }

    private String selectTransferSyntax(TransferCapability transferCapability) {
        String[] stringArray = transferCapability.getTransferSyntax();
        return stringArray[0];
    }

    public void setInformationModel(int n2) {
        this.informationModel = n2;
    }

    public void setGetLevel(int n2) {
        this.getLevel = n2;
        this.keys.putString(524370, VR.CS, RETRIEVELEVEL[n2]);
    }

    public void setPatientLevelGet(String string) {
        this.keys.putString(0x100020, null, string);
    }

    public void setStudyLevelGet(String string, String string2) {
        this.keys.putString(0x100020, null, string);
        this.keys.putString(0x20000D, null, string2);
    }

    public void setSeriesLevelGet(String string, String string2, String string3) {
        this.keys.putString(0x100020, null, string);
        this.keys.putString(0x20000D, null, string2);
        this.keys.putString(0x20000E, null, string3);
    }

    public void setImageLevelGet(String string, String string2, String string3, String string4) {
        this.keys.putString(0x100020, null, string);
        this.keys.putString(0x20000D, null, string2);
        this.keys.putString(0x20000E, null, string3);
        this.keys.putString(524312, null, string4);
    }

    public void open() throws IOException, ConfigurationException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
    }

    public void close() throws InterruptedException {
        if (this.assoc != null) {
            this.assoc.release(true);
        }
    }

    public void get() throws IOException, InterruptedException {
        TransferCapability transferCapability = this.selectTransferCapability(GET_CUID[this.getLevel]);
        if (transferCapability == null) {
            return;
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        DimseRSPHandler dimseRSPHandler = new DimseRSPHandler(){

            public void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
                CGetSCU.this.onGetRSP(association, dicomObject, dicomObject2);
            }
        };
        this.assoc.cget(string, this.priority, this.keys, string2, dimseRSPHandler);
        this.assoc.waitForDimseRSP();
    }

    protected void onGetRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
        if (!CommandUtils.isPending((DicomObject)dicomObject)) {
            this.completed += dicomObject.getInt(4129);
            this.warning += dicomObject.getInt(4131);
            this.failed += dicomObject.getInt(4130);
            File file = new File(this.archivePath);
            File file2 = new File(this.tempPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                new e.a(file2, file, this.AETiltle).performAction();
            }
            catch (IOException iOException) {
                ay.d((Object)"Can not archive files using C-Get to the archive location.", (Throwable)iOException, this);
            }
        }
    }

    public static void main(String[] stringArray) {
        CGetSCU cGetSCU = new CGetSCU(DEFAULT_TEMP_PATH);
        cGetSCU.setInformationModel(1);
        cGetSCU.configureTransferCapability(1);
        cGetSCU.setGetLevel(1);
        try {
            cGetSCU.open();
            cGetSCU.setStudyLevelGet(null, "1.2.840.113619.2.1.1.322987458.880.1013699321.308");
            cGetSCU.get();
            cGetSCU.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public void setTempPath(String string) {
        this.tempPath = string;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public void setArchivePath(String string) {
        this.archivePath = string;
    }
}

