/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.ConfigurationException;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DimseRSPHandler;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.NewThreadExecutor;
import org.dcm4che2.net.TransferCapability;

public class CMoveSCU {
    private static final String DEFAULT_AE_TITLE = "CMOVESCU";
    private static final String DEFAULT_CALLED_AE_TITLE = "MIMDCMQUERY";
    private static final String DEFAULT_REMOTE_HOST = "127.0.0.1";
    private static final int DEFAULT_REMOTE_PORT = 8177;
    private static final int PATIENT = 0;
    private static final int STUDY = 1;
    private static final int SERIES = 2;
    private static final int IMAGE = 3;
    private static final int PATIENTROOT = 0;
    private static final int STUDYROOT = 1;
    private int informationModel;
    private int priority = 0;
    private int completed;
    private int warning;
    private int failed;
    private static final String[] RETRIEVELEVEL = new String[]{"PATIENT", "STUDY", "SERIES", "IMAGE"};
    private static final String[] PATIENT_LEVEL_MOVE_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.1.2"};
    private static final String[] STUDY_LEVEL_MOVE_CUID = new String[]{"1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.2"};
    private static final String[][] MOVE_CUID = new String[][]{PATIENT_LEVEL_MOVE_CUID, STUDY_LEVEL_MOVE_CUID, STUDY_LEVEL_MOVE_CUID, STUDY_LEVEL_MOVE_CUID};
    private static final String[] NATIVE_LE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1"};
    private static final int[] MOVE_KEYS = new int[]{524370, 0x100020, 0x20000D, 0x20000E, 524312};
    private Executor executor = new NewThreadExecutor("CMOVESCU");
    private NetworkApplicationEntity remoteAE = new NetworkApplicationEntity();
    private NetworkConnection remoteConn = new NetworkConnection();
    private Device device = new Device("CMOVESCU");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection conn = new NetworkConnection();
    private Association assoc;
    private int retrieveLevel;
    private DicomObject keys = new BasicDicomObject();
    private String AETiltle = "CMOVESCU";
    private String moveDest;

    public CMoveSCU() {
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(this.AETiltle);
    }

    public CMoveSCU(boolean bl2) {
        this.remoteAE.setInstalled(true);
        this.remoteAE.setAssociationAcceptor(true);
        this.remoteAE.setNetworkConnection(new NetworkConnection[]{this.remoteConn});
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.conn);
        this.ae.setNetworkConnection(this.conn);
        this.ae.setAssociationInitiator(true);
        this.ae.setAETitle(this.AETiltle);
        if (bl2) {
            this.setCalledAETitle(DEFAULT_CALLED_AE_TITLE);
            this.setRemoteHost(DEFAULT_REMOTE_HOST);
            this.setRemotePort(8177);
        }
    }

    public void setCalledAETitle(String string) {
        this.remoteAE.setAETitle(string);
    }

    public final void setRemoteHost(String string) {
        this.remoteConn.setHostname(string);
    }

    public final void setRemotePort(int n2) {
        this.remoteConn.setPort(n2);
    }

    public void configureTransferCapability(int n2) {
        String[] stringArray = MOVE_CUID[n2];
        TransferCapability[] transferCapabilityArray = new TransferCapability[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            transferCapabilityArray[i2] = new TransferCapability(stringArray[i2], NATIVE_LE_TS, "SCU");
        }
        this.ae.setTransferCapability(transferCapabilityArray);
    }

    private TransferCapability selectTransferCapability(String[] stringArray) {
        TransferCapability transferCapability = this.assoc.getTransferCapabilityAsSCU(stringArray[this.informationModel]);
        if (transferCapability != null) {
            return transferCapability;
        }
        return null;
    }

    private String selectTransferSyntax(TransferCapability transferCapability) {
        String[] stringArray = transferCapability.getTransferSyntax();
        return stringArray[0];
    }

    public void open() throws IOException, ConfigurationException, InterruptedException {
        this.assoc = this.ae.connect(this.remoteAE, this.executor);
    }

    public void close() throws InterruptedException {
        if (this.assoc != null) {
            this.assoc.release(true);
        }
    }

    public void retrieve() throws IOException, InterruptedException {
        if (this.moveDest == null) {
            return;
        }
        TransferCapability transferCapability = this.selectTransferCapability(MOVE_CUID[this.retrieveLevel]);
        if (transferCapability == null) {
            return;
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        DimseRSPHandler dimseRSPHandler = new DimseRSPHandler(){

            public void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
                CMoveSCU.this.onMoveRSP(association, dicomObject, dicomObject2);
            }
        };
        this.assoc.cmove(string, this.priority, this.keys, string2, this.moveDest, dimseRSPHandler);
        this.assoc.waitForDimseRSP();
    }

    protected void onMoveRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
        if (!CommandUtils.isPending((DicomObject)dicomObject)) {
            this.completed += dicomObject.getInt(4129);
            this.warning += dicomObject.getInt(4131);
            this.failed += dicomObject.getInt(4130);
        }
    }

    public void putKey(int n2, String string) {
        this.keys.putString(n2, null, string);
    }

    public void setInformationModel(int n2) {
        this.informationModel = n2;
    }

    public void setRetrieveLevel(int n2) {
        this.retrieveLevel = n2;
        this.keys.putString(524370, VR.CS, RETRIEVELEVEL[n2]);
    }

    public void setMoveDest(String string) {
        this.moveDest = string;
    }

    public void setPatientLevelRetrieve(String string) {
        this.keys.putString(0x100020, null, string);
    }

    public void setStudyLevelRetrieve(String string, String string2) {
        this.keys.putString(0x100020, null, string);
        this.keys.putString(0x20000D, null, string2);
    }

    public void setSeriesLevelRetrieve(String string, String string2, String string3) {
        this.keys.putString(0x100020, null, string);
        this.keys.putString(0x20000D, null, string2);
        this.keys.putString(0x20000E, null, string3);
    }

    public void setImageLevelRetrieve(String string, String string2, String string3, String string4) {
        this.keys.putString(0x100020, null, string);
        this.keys.putString(0x20000D, null, string2);
        this.keys.putString(0x20000E, null, string3);
        this.keys.putString(524312, null, string4);
    }

    public void moveAfterFind(List list) throws IOException, InterruptedException {
        if (this.moveDest == null) {
            return;
        }
        TransferCapability transferCapability = this.selectTransferCapability(MOVE_CUID[this.retrieveLevel]);
        if (transferCapability == null) {
            return;
        }
        String string = transferCapability.getSopClass();
        String string2 = this.selectTransferSyntax(transferCapability);
        if (list == null) {
            return;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            DicomObject dicomObject = ((DicomObject)list.get(i2)).subSet(MOVE_KEYS);
            DimseRSPHandler dimseRSPHandler = new DimseRSPHandler(){

                public void onDimseRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2) {
                    CMoveSCU.this.onMoveRSP(association, dicomObject, dicomObject2);
                }
            };
            this.assoc.cmove(string, this.priority, dicomObject, string2, this.moveDest, dimseRSPHandler);
        }
        this.assoc.waitForDimseRSP();
    }

    public static void main(String[] stringArray) {
        CMoveSCU cMoveSCU = new CMoveSCU(true);
        cMoveSCU.setInformationModel(1);
        cMoveSCU.configureTransferCapability(1);
        cMoveSCU.setMoveDest("AE_MIM");
        cMoveSCU.setRetrieveLevel(1);
        try {
            cMoveSCU.open();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        cMoveSCU.setStudyLevelRetrieve("Sample07", "1.2.840.113619.2.1.1.322987458.880.1013699321.308");
        try {
            cMoveSCU.retrieve();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        try {
            cMoveSCU.close();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

