/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.mimvista.ExternallyVisible;
import com.mimvista.archive.remote.MIMpacsServer;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.g;
import com.mimvista.dicom.network.MITRAReportQuery;
import com.mimvista.dicom.qrserver.MITRAReportRSP;
import com.mimvista.dicom.qrserver.MatchKey;
import com.mimvista.dicom.qrserver.MimDimseRSP;
import com.mimvista.dicom.qrserver.MultiFindRSP;
import com.mimvista.dicom.qrserver.MultiGetRSP;
import com.mimvista.dicom.qrserver.MultiMoveRSP;
import com.mimvista.dicom.qrserver.QueryResultProducer;
import com.mimvista.dicom.qrserver.QueryRetrieveService;
import com.mimvista.dicom.qrserver.RetrieveFilePath;
import com.mimvista.dicom.qrserver.ReturnKey;
import com.mimvista.dicom.server.DicomStoreConfigLoader;
import com.mimvista.exodus.d;
import com.mimvista.metabase.a;
import com.mimvista.metabase.indexing.client.MetabaseIndexingClient;
import com.mimvista.osdep.GetOSPath;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.QrserverPrefs;
import com.mimvista.util.ay;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.CommandUtils;
import org.dcm4che2.net.Device;
import org.dcm4che2.net.DicomServiceException;
import org.dcm4che2.net.DimseRSP;
import org.dcm4che2.net.NetworkApplicationEntity;
import org.dcm4che2.net.NetworkConnection;
import org.dcm4che2.net.TransferCapability;
import org.dcm4che2.net.service.DicomService;
import org.dcm4che2.net.service.VerificationService;

@ExternallyVisible
public class MIMDcmQuery
extends QueryRetrieveService {
    public static final String DEFAULT_QR_SERVER_FOLDER = GetOSPath.convertPath("C:\\MIM_DATA\\ARCHIVE");
    private String AETitle = MIMDcmQuery.getConfiguredAETitle();
    private int port = MIMDcmQuery.getConfiguredPort();
    private int maxAssociationNumber = QrserverPrefs.maxAssociations.getValue();
    private static final String[] NON_RETIRED_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2", "1.2.840.10008.1.2"};
    private static final String[] ONLY_DEF_TS = new String[]{"1.2.840.10008.1.2"};
    private static long threadId = 0L;
    private Device device = new Device("MIMDCMQUERY");
    private NetworkApplicationEntity ae = new NetworkApplicationEntity();
    private NetworkConnection nc = new NetworkConnection();
    private String[] tsuids = NON_RETIRED_TS;
    private String informationModel;
    private String moveDestination;
    private Thread metabaseScanThread = null;
    public static final String[] INFOMODEL_UIDS = new String[]{"1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.2", "1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.3", "1.2.840.10008.5.1.4.1.2.2.3"};
    public static final String[] INFOMODEL_UIDS_PLUS_SOP_UIDS;

    public static void main(String[] stringArray) {
        new ServiceHelper().serviceMainOsx(stringArray);
    }

    public static DicomLocationsPrefs.a getConfiguredDcmHost() {
        DicomLocationsPrefs.a a2 = new DicomLocationsPrefs.a();
        a2.setDescription(MIMDcmQuery.getConfiguredAETitle());
        a2.setAeTitle(MIMDcmQuery.getConfiguredAETitle());
        a2.setHost("127.0.0.1");
        a2.setPort("" + MIMDcmQuery.getConfiguredPort());
        a2.setAllowQuery(true);
        return a2;
    }

    public static String getConfiguredAETitle() {
        return QrserverPrefs.aeTitle.getValue();
    }

    public static int getConfiguredPort() {
        return QrserverPrefs.port.getValue();
    }

    private static Executor createExecutor() {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            private ThreadFactory delegate = Executors.defaultThreadFactory();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = this.delegate.newThread(runnable);
                Class<MIMDcmQuery> clazz = MIMDcmQuery.class;
                synchronized (MIMDcmQuery.class) {
                    long l2 = threadId++;
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    thread.setName("MIMDCMQUERY-" + l2);
                    return thread;
                }
            }
        });
    }

    private void initTransferCapability() {
        int n2;
        TransferCapability[] transferCapabilityArray = new TransferCapability[INFOMODEL_UIDS_PLUS_SOP_UIDS.length + 1];
        transferCapabilityArray[0] = new TransferCapability("1.2.840.10008.1.1", ONLY_DEF_TS, "SCP");
        for (n2 = 0; n2 < 6; ++n2) {
            transferCapabilityArray[n2 + 1] = new TransferCapability(INFOMODEL_UIDS_PLUS_SOP_UIDS[n2], this.tsuids, "SCP");
        }
        for (n2 = 6; n2 < INFOMODEL_UIDS_PLUS_SOP_UIDS.length; ++n2) {
            transferCapabilityArray[n2 + 1] = new TransferCapability(INFOMODEL_UIDS_PLUS_SOP_UIDS[n2], this.tsuids, "SCU");
        }
        this.ae.setTransferCapability(transferCapabilityArray);
    }

    public MIMDcmQuery() {
        super(INFOMODEL_UIDS_PLUS_SOP_UIDS);
        this.executor = MIMDcmQuery.createExecutor();
        CommandUtils.setIncludeUIDinRSP((boolean)true);
        this.device.setNetworkApplicationEntity(this.ae);
        this.device.setNetworkConnection(this.nc);
        this.ae.setNetworkConnection(this.nc);
        this.ae.setAssociationAcceptor(true);
        this.ae.register((DicomService)new VerificationService());
        this.ae.register((DicomService)this);
        this.ae.setAETitle(this.AETitle);
        this.nc.setPort(this.port);
        this.nc.setMaxScpAssociations(this.maxAssociationNumber);
        this.initTransferCapability();
    }

    public void start() throws IOException {
        this.device.startListening(this.executor);
        ay.b((Object)("Start MIMDcmQuery Server listening on port " + this.nc.getPort()), (Object)this);
        this.startMetabaseScanIfNeeded();
    }

    public void stop() {
        this.device.stopListening();
    }

    private synchronized void startMetabaseScanIfNeeded() {
        if (this.metabaseScanThread == null && this.needsMetabaseScan()) {
            this.metabaseScanThread = new Thread(() -> {
                ay.b((Object)"QR: going to run startup scan", (Object)this);
                String string = QrserverPrefs.archivePath.getValue().getAbsolutePath();
                File file = new File(string);
                if (!file.exists()) {
                    String string2 = "QR: archive path doesn't exist, so it can't be indexed (first run?)";
                    ay.a((Object)string2, (Object)this);
                    return;
                }
                MetabaseIndexingClient metabaseIndexingClient = new MetabaseIndexingClient();
                try {
                    metabaseIndexingClient.a(file);
                }
                catch (MetabaseIndexingClient.IndexingServiceConnectException indexingServiceConnectException) {
                    ay.d((Object)"Can't connect to the indexing service - check the admin service logs, the admin service may need to be restarted or might be old", (Throwable)indexingServiceConnectException, (Object)this);
                }
                catch (Throwable throwable) {
                    ay.d((Object)"Error while trying to schedule an archive folder scan with the indexing service", throwable, (Object)this);
                }
                this.metabaseScanThread = null;
            }, "MIMDcmQuery Metabase Scanning Thread");
            this.metabaseScanThread.start();
        } else {
            ay.a((Object)"We don't need to metabase scan to run as MIMDcmQuery Server", (Object)this);
        }
    }

    private boolean needsMetabaseScan() {
        if (!"Archive".equals(QrserverPrefs.querySource.getValue())) {
            return false;
        }
        File file = QrserverPrefs.archivePath.getValue();
        for (String string : MIMpacsServer.getArchiveLocations()) {
            if (!file.equals(new File(string))) continue;
            return false;
        }
        for (LocalSearchSource localSearchSource : g.e()) {
            if (!file.equals(new File(localSearchSource.a()))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected MimDimseRSP doCFind(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) throws DicomServiceException {
        MatchKey matchKey;
        if ("2.16.840.1.114362.1.6.1.0.13913.7391446449.323911726.1089.1".equals(dicomObject2.getString(930295814))) {
            this.startMetabaseScanIfNeeded();
            return new MultiFindRSP(dicomObject2, dicomObject3, null);
        }
        if (MITRAReportQuery.isMitraReportQueryResponseEnabled() && "1.2.840.113532.3500.8".equals(dicomObject.getString(2))) {
            return new MITRAReportRSP(dicomObject2, dicomObject3);
        }
        ay.b((Object)"Start to do C-Find operation.", (Object)this);
        try {
            matchKey = new MatchKey(dicomObject2);
        }
        catch (Exception exception) {
            ay.c((Object)exception, (Object)this);
            return new MultiFindRSP(dicomObject2, dicomObject3, null);
        }
        ReturnKey returnKey = new ReturnKey(dicomObject2);
        this.informationModel = dicomObject.getString(2);
        QueryResultProducer queryResultProducer = new QueryResultProducer();
        a<DicomObject> a2 = null;
        if ("1.2.840.10008.5.1.4.1.2.1.1".equals(this.informationModel)) {
            a2 = queryResultProducer.patientRootQuery(matchKey, returnKey);
        } else if ("1.2.840.10008.5.1.4.1.2.2.1".equals(this.informationModel)) {
            a2 = queryResultProducer.studyRootQuery(matchKey, returnKey);
        } else {
            ay.c((Object)("WARNING: Information Model: " + this.informationModel + "No Supported"), (Object)this);
        }
        return new MultiFindRSP(dicomObject2, dicomObject3, a2);
    }

    @Override
    protected MimDimseRSP doCMove(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) throws DicomServiceException {
        MatchKey matchKey;
        ay.b((Object)"Start to do C-Move operation.", (Object)this);
        try {
            matchKey = new MatchKey(dicomObject2);
        }
        catch (Exception exception) {
            ay.c((Object)exception, (Object)this);
            return new MultiMoveRSP(dicomObject2, dicomObject3, null, this.AETitle, this.moveDestination);
        }
        this.informationModel = dicomObject.getString(2);
        this.moveDestination = dicomObject.getString(1536);
        List<String> list = null;
        if ("1.2.840.10008.5.1.4.1.2.1.2".equals(this.informationModel)) {
            list = RetrieveFilePath.patientRootRetrieve(matchKey);
        } else if ("1.2.840.10008.5.1.4.1.2.2.2".equals(this.informationModel)) {
            list = RetrieveFilePath.studyRootRetrieve(matchKey);
        } else {
            ay.c((Object)("WARNING: Information Model: " + this.informationModel + "No Supported"), (Object)this);
        }
        return new MultiMoveRSP(dicomObject2, dicomObject3, list, this.AETitle, this.moveDestination);
    }

    @Override
    protected DimseRSP doCGet(Association association, int n2, DicomObject dicomObject, DicomObject dicomObject2, DicomObject dicomObject3) throws DicomServiceException {
        MatchKey matchKey;
        ay.b((Object)"Start to do C-Get operation.", (Object)this);
        try {
            matchKey = new MatchKey(dicomObject2);
        }
        catch (Exception exception) {
            ay.c((Object)exception, (Object)this);
            return new MultiGetRSP(association, dicomObject2, dicomObject3, null);
        }
        this.informationModel = dicomObject.getString(2);
        List<String> list = null;
        if ("1.2.840.10008.5.1.4.1.2.1.3".equals(this.informationModel)) {
            list = RetrieveFilePath.patientRootRetrieve(matchKey);
        } else if ("1.2.840.10008.5.1.4.1.2.2.3".equals(this.informationModel)) {
            list = RetrieveFilePath.studyRootRetrieve(matchKey);
        } else {
            ay.c((Object)("WARNING: Information Model: " + this.informationModel + "No Supported"), (Object)this);
        }
        return new MultiGetRSP(association, dicomObject2, dicomObject3, list);
    }

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        Collections.addAll(arrayList, INFOMODEL_UIDS);
        Collections.addAll(arrayList, DicomStoreConfigLoader.getSupportedSopUids());
        if (MITRAReportQuery.isMitraReportQueryEnabled()) {
            arrayList.add("1.2.840.113532.3500.8");
        }
        INFOMODEL_UIDS_PLUS_SOP_UIDS = arrayList.toArray(new String[0]);
    }

    @ExternallyVisible
    public static class ServiceHelper
    extends com.mimvista.util.service.a {
        @Override
        protected void mimServiceMain(String[] stringArray) {
            d.a("dcmquery", true);
            MIMDcmQuery mIMDcmQuery = new MIMDcmQuery();
            try {
                mIMDcmQuery.start();
            }
            catch (IOException iOException) {
                ay.d((Object)"Can not start the MIMDcmQuery server: ", (Throwable)iOException, MIMDcmQuery.class);
                System.exit(1);
            }
        }
    }
}

