/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.google.common.collect.Lists;
import com.mimvista.dicom.qrserver.MultiFindRSP;
import com.mimvista.metabase.a;
import java.util.Iterator;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.DateUtils;

public class MITRAReportRSP
extends MultiFindRSP {
    public MITRAReportRSP(DicomObject dicomObject, DicomObject dicomObject2) {
        super(dicomObject, dicomObject2, new TestMITRAReportResponse(dicomObject));
    }

    @Override
    public String getType() {
        return "MITRA Report";
    }

    private static class TestMITRAReportResponse
    implements a<DicomObject> {
        private DicomObject response;
        private static String interpretationDiagnosisDescription = "*** Final Report ***\\x0A\\x0ADATE OF EXAM:     Feb 11, 2013\\x0A\\x0A. . .\\x0APET/CT NECK, CHEST, ABDOMEN AND PELVIS\\x0A\\x0ACLINICAL HISTORY:  Squamous cell carcinoma of the scalp and skin of neck.\\x0AInitial staging.\\x0A\\x0ARADIOPHARMACEUTICAL:  15.4 mCi F-18 Fluorodeoxyglucose (FDG) IV.\\x0A\\x0ABLOOD GLUCOSE LEVEL AT THE TIME OF RADIOPHARMACEUTICAL ADMINISTRATION:  105\\x0Amg/dl\\x0A\\x0ATECHNIQUE:  Beginning approximately 66 minutes after tracer administration,\\x0Aroutine whole body PET/CT imaging was performed from the level of the base\\x0Aof the skull to the upper thighs.  PET images were reviewed in standard\\x0Aorthogonal projections.  Non-Contrast CT imaging was performed for\\x0Aattenuation correction and localization purposes only.  These images do not\\x0Aconstitute a diagnostic-quality CT examination and are not used to diagnose\\x0Adisease independently of the PET images.\\x0A\\x0ACOMPARISON:  Outside CT neck dated 1/17/2013\\x0A\\x0AFINDINGS:  There is a single markedly enlarged hypermetabolic lymph node\\x0Awithin the right (16024) 02/11/2013 02:53:55";

        public TestMITRAReportResponse(DicomObject dicomObject) {
            this.response = TestMITRAReportResponse.buildTestResponse(dicomObject);
        }

        @Override
        public Iterator<DicomObject> iterator() {
            return Lists.newArrayList((Object[])new DicomObject[]{this.response}).iterator();
        }

        @Override
        public void close() {
        }

        private static DicomObject buildTestResponse(DicomObject dicomObject) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            basicDicomObject.putString(524368, VR.SH, dicomObject.getString(524368));
            basicDicomObject.putString(0x100010, VR.PN, dicomObject.getString(0x100010));
            basicDicomObject.putString(0x100020, VR.LO, dicomObject.getString(0x100020));
            basicDicomObject.putDate(0x100030, VR.DA, dicomObject.getDate(0x100030));
            basicDicomObject.putString(0x100040, VR.CS, dicomObject.getString(0x100040));
            basicDicomObject.putString(0x20000D, VR.UI, dicomObject.getString(0x20000D));
            basicDicomObject.putString(3280992, VR.LO, "PET-CT,SKULL TO MID-THIGH");
            basicDicomObject.putDate(1074266368, VR.DA, DateUtils.parseDA((String)"20130211", (boolean)false));
            basicDicomObject.putDate(1074266369, VR.TM, DateUtils.parseTM((String)"1422", (boolean)false));
            basicDicomObject.putString(1074266380, VR.PN, "SPECK");
            basicDicomObject.putDate(1074266386, VR.DA, DateUtils.parseDA((String)"20130211", (boolean)false));
            basicDicomObject.putDate(1074266387, VR.TM, DateUtils.parseTM((String)"1422", (boolean)false));
            basicDicomObject.putString(1074266389, VR.LT, interpretationDiagnosisDescription);
            basicDicomObject.putNull(1074266624, VR.SH);
            basicDicomObject.putNull(1074266642, VR.CS);
            return basicDicomObject;
        }
    }
}

