/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import java.io.Serializable;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;

public class MatchKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QueryLevel level;
    private String patientID;
    private String patientName;
    private String studyDate;
    private String studyTime;
    private String accessionNumber;
    private String studyInstanceUID;
    private String studyID;
    private String modality;
    private String seriesInstanceUID;
    private String seriesNumber;
    private String sopInstanceUID;

    public MatchKey(DicomObject dicomObject) throws Exception {
        BasicDicomObject basicDicomObject = new BasicDicomObject(dicomObject);
        this.level = QueryLevel.valueOf(basicDicomObject.getString(524370).toUpperCase());
        switch (this.level) {
            case IMAGE: {
                this.sopInstanceUID = basicDicomObject.getString(524312);
            }
            case SERIES: {
                this.seriesInstanceUID = basicDicomObject.getString(0x20000E);
                this.modality = basicDicomObject.getString(524384);
                this.seriesNumber = basicDicomObject.getString(0x200011);
            }
            case STUDY: {
                this.studyInstanceUID = basicDicomObject.getString(0x20000D);
                this.patientID = basicDicomObject.getString(0x100020);
                this.patientName = basicDicomObject.getString(0x100010);
                this.studyDate = basicDicomObject.getString(524320);
                this.studyTime = basicDicomObject.getString(524336);
                this.accessionNumber = basicDicomObject.getString(524368);
                this.studyID = basicDicomObject.getString(0x200010);
                this.studyTime = basicDicomObject.getString(524336);
            }
            case PATIENT: {
                this.patientID = basicDicomObject.getString(0x100020);
                this.patientName = basicDicomObject.getString(0x100010);
            }
        }
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public QueryLevel getLevel() {
        return this.level;
    }

    public String getModality() {
        return this.modality;
    }

    public String getPatientID() {
        return this.patientID;
    }

    public String getPatientName() {
        return this.patientName;
    }

    public String getQueryLevel() {
        return this.level.name();
    }

    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    public String getStudyDate() {
        return this.studyDate;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public String getSopInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getStudyTime() {
        return this.studyTime;
    }

    public String getStudyID() {
        return this.studyID;
    }

    public String getSeriesNumber() {
        return this.seriesNumber;
    }

    public static enum QueryLevel {
        PATIENT,
        STUDY,
        SERIES,
        IMAGE;

    }
}

