/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.mimvista.dicom.qrserver.AbstractMimDimRSP;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputHandler;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.io.StopTagInputHandler;
import org.dcm4che2.io.TranscoderInputHandler;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.PDVOutputStream;
import org.dcm4che2.net.TransferCapability;

public class MultiGetRSP
extends AbstractMimDimRSP {
    private int size = 0;
    private int successfully = 0;
    private int failed = 0;
    private DicomObject rsp;
    private List<String> resultPath;
    private Association assoc;
    private static final int PEEK_LEN = 1024;
    private int priority = 0;
    private int transcoderBufferSize = 1024;
    private boolean sentFirstRspAlready = false;
    private static final String[] IVLE_TS = new String[]{"1.2.840.10008.1.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2.2"};
    private static final String[] EVLE_TS = new String[]{"1.2.840.10008.1.2.1", "1.2.840.10008.1.2", "1.2.840.10008.1.2.2"};
    private static final String[] EVBE_TS = new String[]{"1.2.840.10008.1.2.2", "1.2.840.10008.1.2.1", "1.2.840.10008.1.2"};

    @Override
    public String getType() {
        return "MultiGet";
    }

    MultiGetRSP(Association association, DicomObject dicomObject, DicomObject dicomObject2, List<String> list) {
        this.resultPath = list;
        this.rsp = dicomObject2;
        if (list != null) {
            this.size = list.size();
        }
        this.assoc = association;
    }

    public void cancel(Association association) throws IOException {
        this.rsp.putInt(2304, VR.US, 65024);
        this.resultPath = null;
    }

    public DicomObject getCommand() {
        return this.rsp;
    }

    public DicomObject getDataset() {
        return null;
    }

    public boolean next() throws IOException, InterruptedException {
        if (this.resultPath == null) {
            this.rsp.putInt(2304, VR.US, 0);
            ay.b((Object)"There is no result to return.MIMDcmQuery Server has finished sending back c-get-rsp.", this);
            return false;
        }
        Iterator<String> iterator = this.resultPath.iterator();
        if (iterator.hasNext()) {
            if (this.sentFirstRspAlready) {
                --this.size;
                if (this.sendOneFileWithStatus(this.assoc, iterator.next())) {
                    ++this.successfully;
                } else {
                    ++this.failed;
                    ay.c((Object)("WARNING: There are " + this.failed + "  failed suboperations"), this);
                }
                iterator.remove();
            } else {
                this.sentFirstRspAlready = true;
            }
        } else {
            return false;
        }
        this.rsp.putInt(4128, VR.US, this.size);
        this.rsp.putInt(4129, VR.US, this.successfully);
        this.rsp.putInt(4130, VR.US, this.failed);
        if (iterator.hasNext()) {
            this.rsp.putInt(2304, VR.US, 65280);
            return true;
        }
        this.rsp.putInt(2304, VR.US, 0);
        ay.b((Object)"MIMDcmQuery Server has finished sending back c-get-rsp.", this);
        return true;
    }

    private boolean sendOneFileWithStatus(Association association, String string) {
        FileInfo fileInfo = this.getFileInfo(new File(string));
        TransferCapability transferCapability = association.getTransferCapabilityAsSCU(fileInfo.cuid);
        if (transferCapability == null) {
            ay.c((Object)("WARNING: MIMDcmQuery Server can not support the SOPClassUID: " + fileInfo.cuid + "as SCU."), this);
            return false;
        }
        String string2 = this.selectTransferSyntax(transferCapability.getTransferSyntax(), fileInfo.tsuid);
        if (string2 == null) {
            ay.c((Object)("WARNING: MIMDcmQuery Server can not support the transfer systax UID:" + fileInfo.tsuid), this);
            return false;
        }
        try {
            association.cstore(fileInfo.cuid, fileInfo.iuid, this.priority, (org.dcm4che2.net.DataWriter)new DataWriter(fileInfo), string2);
        }
        catch (IOException | InterruptedException exception) {
            ay.d((Object)"Failed to send c-store-rq to the C-GET SCU.", (Throwable)exception, this);
            return false;
        }
        return true;
    }

    private FileInfo getFileInfo(File file) {
        FileInfo fileInfo = new FileInfo(file);
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        try (DicomInputStream dicomInputStream = new DicomInputStream(file);){
            dicomInputStream.setHandler((DicomInputHandler)new StopTagInputHandler(524320));
            dicomInputStream.readDicomObject((DicomObject)basicDicomObject, 1024);
            fileInfo.tsuid = dicomInputStream.getTransferSyntax().uid();
            fileInfo.fmiEndPos = dicomInputStream.getEndOfFileMetaInfoPosition();
        }
        catch (IOException iOException) {
            ay.c((Object)("WARNING: Failed to parse " + file + " - skipped."), (Throwable)iOException, this);
            return null;
        }
        fileInfo.cuid = basicDicomObject.getString(524310);
        if (fileInfo.cuid == null) {
            ay.c((Object)("WARNING: Missing SOP Class UID in " + file + " - skipped."), this);
            return null;
        }
        fileInfo.iuid = basicDicomObject.getString(524312);
        if (fileInfo.iuid == null) {
            ay.c((Object)("WARNING: Missing SOP Instance UID in " + file + " - skipped."), this);
            return null;
        }
        return fileInfo;
    }

    private String selectTransferSyntax(String[] stringArray, String string) {
        if (string.equals("1.2.840.10008.1.2")) {
            return this.selectTransferSyntax(stringArray, IVLE_TS);
        }
        if (string.equals("1.2.840.10008.1.2.1")) {
            return this.selectTransferSyntax(stringArray, EVLE_TS);
        }
        if (string.equals("1.2.840.10008.1.2.2")) {
            return this.selectTransferSyntax(stringArray, EVBE_TS);
        }
        return string;
    }

    private String selectTransferSyntax(String[] stringArray, String[] stringArray2) {
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray[i3].equals(stringArray2[i2])) continue;
                return stringArray[i3];
            }
        }
        return null;
    }

    private class DataWriter
    implements org.dcm4che2.net.DataWriter {
        private FileInfo info;

        public DataWriter(FileInfo fileInfo) {
            this.info = fileInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(PDVOutputStream pDVOutputStream, String string) throws IOException {
            if (string.equals(this.info.tsuid)) {
                try (FileInputStream fileInputStream = new FileInputStream(this.info.f);){
                    for (long i2 = this.info.fmiEndPos; i2 > 0L; i2 -= fileInputStream.skip(i2)) {
                    }
                    pDVOutputStream.copyFrom((InputStream)fileInputStream);
                }
            }
            try (DicomInputStream dicomInputStream = new DicomInputStream(this.info.f);){
                DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)pDVOutputStream);
                dicomOutputStream.setTransferSyntax(string);
                TranscoderInputHandler transcoderInputHandler = new TranscoderInputHandler(dicomOutputStream, MultiGetRSP.this.transcoderBufferSize);
                dicomInputStream.setHandler((DicomInputHandler)transcoderInputHandler);
                dicomInputStream.readDicomObject();
            }
        }
    }

    private static final class FileInfo {
        File f;
        String cuid;
        String iuid;
        String tsuid;
        long fmiEndPos;
        long length;

        public FileInfo(File file) {
            this.f = file;
            this.length = file.length();
        }
    }
}

