/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.mimvista.dicom.DicomDestination;
import com.mimvista.dicom.network.DcmSnd;
import com.mimvista.dicom.qrserver.AbstractMimDimRSP;
import com.mimvista.preferencesNew.DicomLocationsPrefs;
import com.mimvista.preferencesNew.QrserverPrefs;
import com.mimvista.util.ay;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.net.Association;
import org.dcm4che2.net.ConfigurationException;

public class MultiMoveRSP
extends AbstractMimDimRSP {
    private List<String> resultPath;
    private String moveDestination;
    private String CallingAETitle;
    private DcmSnd storeSCU;
    private int size = 0;
    private DicomObject rsp;
    private boolean isFinished = false;
    private String[] files;

    MultiMoveRSP(DicomObject dicomObject, DicomObject dicomObject2, List<String> list, String string, String string2) {
        this.resultPath = list;
        this.CallingAETitle = string;
        this.moveDestination = string2;
        this.rsp = dicomObject2;
        if (list != null) {
            this.size = list.size();
        }
        this.files = new String[this.size];
        this.initDcmSnd();
    }

    private DicomLocationsPrefs.a getDICOMLocationIndex() {
        Object object = DicomLocationsPrefs.dicomLocations.getValue();
        if (object.size() == 0) {
            System.err.println("NO DICOM LOCATION");
            ay.d((Object)"ERROR: No DICOM Location in the dicom_locations.txt", this);
            return null;
        }
        Object object2 = QrserverPrefs.allowedRetrieveDestinations.getValue();
        if (!object2.contains(this.moveDestination)) {
            throw new IllegalArgumentException("AE Title is not configured as allowed DICOM storage server: " + this.moveDestination);
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            DicomLocationsPrefs.a a2 = (DicomLocationsPrefs.a)iterator.next();
            String string = a2.getAeTitle();
            if (!string.equalsIgnoreCase(this.moveDestination)) continue;
            return a2;
        }
        return null;
    }

    private void initDcmSnd() {
        DicomLocationsPrefs.a a2 = this.getDICOMLocationIndex();
        DicomDestination dicomDestination = new DicomDestination(a2);
        String string = this.moveDestination;
        String string2 = this.CallingAETitle;
        String string3 = dicomDestination.getHostname();
        int n2 = new Integer(dicomDestination.getPort());
        this.storeSCU = new DcmSnd(string3, n2, string2, string, 1);
        this.resultPath.toArray(this.files);
        try {
            this.storeSCU.initializeConnection(this.files);
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, this);
            this.isFinished = true;
            this.rsp.putInt(2304, VR.US, 272);
        }
        catch (ConfigurationException configurationException) {
            ay.d((Object)configurationException, this);
            this.isFinished = true;
            this.rsp.putInt(2304, VR.US, 272);
        }
        catch (InterruptedException interruptedException) {
            ay.d((Object)interruptedException, this);
            this.isFinished = true;
            this.rsp.putInt(2304, VR.US, 272);
        }
    }

    public void cancel(Association association) throws IOException {
        this.rsp.putInt(2304, VR.US, 65024);
        this.resultPath = null;
        this.closeDcmSendSession();
    }

    public DicomObject getCommand() {
        return this.rsp;
    }

    public DicomObject getDataset() {
        return null;
    }

    @Override
    public String getType() {
        return "MultiMove";
    }

    public boolean next() {
        if (this.isFinished) {
            return false;
        }
        if (this.resultPath == null) {
            this.rsp.putInt(2304, VR.US, 0);
            ay.b((Object)"There is no result to return.MIMDcmQuery Server has finished sending back c-move-rsp.", this);
            this.isFinished = true;
            this.closeDcmSendSession();
            return true;
        }
        Iterator<String> iterator = this.resultPath.iterator();
        int n2 = this.size;
        if (iterator.hasNext()) {
            --n2;
            try {
                this.storeSCU.sendSingleFile(iterator.next());
                ++this.successCount;
            }
            catch (Exception exception) {
                ay.d((Object)"MultiMoveRSP send failed", (Throwable)exception, this);
                ++this.failCount;
                ay.c((Object)("WARNING: There are " + this.failCount + "  failed suboperations"), this);
            }
            iterator.remove();
            this.rsp.putInt(4128, VR.US, n2);
            this.rsp.putInt(4129, VR.US, this.successCount);
            this.rsp.putInt(4130, VR.US, this.failCount);
            this.rsp.putInt(4131, VR.US, 0);
            this.rsp.putInt(2304, VR.US, 65280);
        } else {
            if (this.failCount == this.size) {
                this.rsp.putInt(2304, VR.US, 272);
            } else {
                this.rsp.putInt(2304, VR.US, 0);
            }
            this.closeDcmSendSession();
            ay.b((Object)"MIMDcmQuery Server has finished sending back c-move-rsp.", this);
            this.isFinished = true;
        }
        return true;
    }

    private void closeDcmSendSession() {
        this.storeSCU.releaseConnection();
        ay.b((Object)"Closed Dcm Send session.", this);
    }
}

