/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.mimvista.archive.NameFormatter;
import com.mimvista.archive.Parser;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.factories.DcmSeriesFactory;
import com.mimvista.dicom.qrserver.MatchKey;
import com.mimvista.dicom.qrserver.RetrieveFilePath;
import com.mimvista.dicom.qrserver.ReturnKey;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.a;
import com.mimvista.metabase.b;
import com.mimvista.metabase.j;
import com.mimvista.metabase.l;
import com.mimvista.metabase.n;
import com.mimvista.metabase.v;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.DateUtils;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class QueryResultProducer {
    public static final String DICOM_QUERY_DATE_FORMAT_STR = "yyyyMMdd";
    public static final String DICOM_QUERY_TIME_FORMAT_STR = "HHmmss";

    public a<DicomObject> patientRootQuery(MatchKey matchKey, ReturnKey returnKey) {
        switch (matchKey.getLevel()) {
            case PATIENT: {
                return this.matchPatientLevel(matchKey, returnKey);
            }
            case STUDY: {
                return this.matchStudyLevel(matchKey, returnKey);
            }
            case SERIES: {
                return this.matchSeriesLevel(matchKey, returnKey);
            }
            case IMAGE: {
                return this.matchImageLevel(matchKey, returnKey);
            }
        }
        ay.c((Object)"Query Level Error", this);
        return null;
    }

    public a<DicomObject> studyRootQuery(MatchKey matchKey, ReturnKey returnKey) {
        switch (matchKey.getLevel()) {
            case STUDY: {
                return this.matchStudyLevel(matchKey, returnKey);
            }
            case SERIES: {
                return this.matchSeriesLevel(matchKey, returnKey);
            }
            case IMAGE: {
                return this.matchImageLevel(matchKey, returnKey);
            }
        }
        ay.c((Object)"Query Level Error", this);
        return null;
    }

    private String replaceWildcards(String string) {
        if (string == null) {
            return null;
        }
        return string.replace("*", ".*").replace("?", ".");
    }

    private void addEqualsFilter(MetabaseQuery metabaseQuery, int n2, String string) {
        if (!cn.h(string)) {
            metabaseQuery.b(n.a().c(MetabaseKeys.fromTag(n2), (Object)string), n.a().e(MetabaseKeys.fromTag(n2)), n.a().c(MetabaseKeys.fromTag(n2), (Object)""), n.a().c(MetabaseKeys.fromTag(n2), (Object)null));
        }
    }

    private void addDateRangeFilter(MetabaseQuery metabaseQuery, int n2, String string) {
        if (!cn.h(string)) {
            String[] stringArray = string.split("-");
            String string2 = stringArray[0];
            String string3 = stringArray.length == 2 ? stringArray[1] : null;
            String string4 = MetabaseKeys.fromTag(n2);
            Date date = DateUtils.i(string2);
            Date date2 = DateUtils.i(string3);
            if (date2 != null) {
                date2 = org.jdesktop.swingx.calendar.DateUtils.endOfDay((Date)date2);
            }
            if (date != null || date2 != null) {
                MetabaseQuery metabaseQuery2 = n.a().e(string4);
                MetabaseQuery metabaseQuery3 = n.a();
                if (date != null) {
                    metabaseQuery3.f(string4, date);
                }
                if (date2 != null) {
                    metabaseQuery3.h(string4, date2);
                }
                metabaseQuery.b(metabaseQuery3, metabaseQuery2);
            }
        }
    }

    private void addTimeRangeFilter(MetabaseQuery metabaseQuery, int n2, String string) {
        if (!cn.h(string)) {
            String[] stringArray = string.split("-");
            String string2 = stringArray[0];
            String string3 = stringArray.length == 2 ? stringArray[1] : null;
            String string4 = MetabaseKeys.fromTag(n2);
            Date date = DateUtils.j(string2);
            Date date2 = DateUtils.j(string3);
            if (date != null || date2 != null) {
                MetabaseQuery metabaseQuery2 = n.a().e(string4);
                MetabaseQuery metabaseQuery3 = n.a();
                if (date != null) {
                    metabaseQuery3.f(string4, date);
                }
                if (date2 != null) {
                    metabaseQuery3.h(string4, date2);
                }
                metabaseQuery.b(metabaseQuery3, metabaseQuery2);
            }
        }
    }

    private void addPatientFilters(MatchKey matchKey, MetabaseQuery metabaseQuery) {
        String string;
        String string2 = matchKey.getPatientName();
        if (string2 != null && !string2.isEmpty()) {
            metabaseQuery.b(b.a(n.a(), string2), n.a().e(MetabaseKeys.fromTag(0x100010)));
        }
        if ((string = matchKey.getPatientID()) != null && !string.isEmpty()) {
            metabaseQuery.b(b.c(n.a(), string, VersionNumber.rawCurrentVersionNotAccountingForMIMviewer()), n.a().d(MetabaseKeys.fromTag(0x100020), "^none$"), n.a().e(MetabaseKeys.fromTag(0x100020)));
        }
    }

    private void addStudyFilters(MatchKey matchKey, MetabaseQuery metabaseQuery) {
        this.addEqualsFilter(metabaseQuery, 0x200010, matchKey.getStudyID());
        this.addEqualsFilter(metabaseQuery, 524368, matchKey.getAccessionNumber());
        this.addEqualsFilter(metabaseQuery, 0x20000D, matchKey.getStudyInstanceUID());
        this.addDateRangeFilter(metabaseQuery, 524320, matchKey.getStudyDate());
        this.addTimeRangeFilter(metabaseQuery, 524336, matchKey.getStudyTime());
    }

    private void addSeriesFilters(MatchKey matchKey, MetabaseQuery metabaseQuery) {
        String string;
        String string2;
        String string3 = matchKey.getStudyInstanceUID();
        if (!cn.h(string3)) {
            metabaseQuery.c(MetabaseKeys.fromTag(0x20000D), (Object)string3);
        }
        if (!cn.h(string2 = matchKey.getModality())) {
            metabaseQuery.d(MetabaseKeys.fromTag(524384), "^" + this.replaceWildcards(string2) + "$");
        }
        if (!cn.h(string = matchKey.getSeriesInstanceUID())) {
            metabaseQuery.c(MetabaseKeys.fromTag(0x20000E), (Object)string);
        }
    }

    private void addPatientResultTags(DicomObject dicomObject, Series series, ReturnKey returnKey) {
        l l2 = series.getStudy().getPatient();
        if (returnKey.contains(0x100010)) {
            dicomObject.putString(0x100010, VR.PN, NameFormatter.c(l2.getName()));
        }
        if (returnKey.contains(0x100020)) {
            dicomObject.putString(0x100020, VR.LO, l2.getId());
        }
        if (returnKey.contains(0x100030)) {
            dicomObject.putDate(0x100030, VR.DA, l2.getBirthDate());
        }
        if (returnKey.contains(0x100040)) {
            dicomObject.putString(0x100040, VR.CS, l2.getSex());
        }
    }

    private void addStudyResultTags(DicomObject dicomObject, Series series, ReturnKey returnKey) {
        v v2 = series.getStudy();
        if (returnKey.contains(524320)) {
            dicomObject.putDate(524320, VR.DA, v2.getStudyDate());
        }
        if (returnKey.contains(524336)) {
            dicomObject.putDate(524336, VR.TM, v2.getStudyTime());
        }
        if (returnKey.contains(0x200010)) {
            dicomObject.putString(0x200010, null, v2.getStudyId());
        }
        if (returnKey.contains(524368)) {
            dicomObject.putString(524368, VR.SH, v2.getAccessionNumber());
        }
        if (returnKey.contains(528432)) {
            dicomObject.putString(528432, VR.LO, v2.getStudyDescription());
        }
        if (returnKey.contains(0x20000D)) {
            dicomObject.putString(0x20000D, VR.UI, v2.getStudyInstanceUid());
        }
    }

    private void addSeriesResultTags(DicomObject dicomObject, Series series, ReturnKey returnKey) {
        if (returnKey.contains(524384)) {
            dicomObject.putString(524384, VR.CS, series.getModality());
        }
        if (returnKey.contains(524337)) {
            dicomObject.putDate(524337, VR.TM, series.getSeriesTime());
        }
        if (returnKey.contains(528446)) {
            dicomObject.putString(528446, VR.LO, series.getSeriesDescription());
        }
        if (returnKey.contains(0x200011)) {
            dicomObject.putString(0x200011, VR.IS, series.getString(0x200011));
        }
        if (returnKey.contains(2101769)) {
            dicomObject.putInt(2101769, VR.IS, series.getNumberOfImages());
        }
        if (returnKey.contains(0x20000E)) {
            dicomObject.putString(0x20000E, VR.UI, series.getSeriesInstanceUid());
        }
        if (returnKey.contains(0x20000D)) {
            dicomObject.putString(0x20000D, VR.UI, series.getStudy().getStudyInstanceUid());
        }
    }

    private void addQueryRetrieveLevel(MatchKey matchKey, ReturnKey returnKey, DicomObject dicomObject) {
        if (returnKey.contains(524370)) {
            dicomObject.putString(524370, VR.CS, matchKey.getQueryLevel());
        }
    }

    private a<DicomObject> matchPatientLevel(final MatchKey matchKey, final ReturnKey returnKey) {
        final MetabaseQuery metabaseQuery = n.a();
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        this.addPatientFilters(matchKey, metabaseQuery);
        return new a<DicomObject>(){
            private a<? extends Series> seriesIterable;
            private Set<PatientInfo> alreadySeenPatients = Sets.newHashSet();

            @Override
            public Iterator<DicomObject> iterator() {
                this.close();
                ay.a((Object)("Executing patient-level metabase query: " + metabaseQuery), this);
                this.seriesIterable = metabaseQuery.b(j.a());
                UnmodifiableIterator unmodifiableIterator = this.seriesIterable.iterator();
                unmodifiableIterator = Iterators.filter(unmodifiableIterator, (Predicate)new Predicate<Series>(){

                    public boolean apply(Series series) {
                        l l2 = series.getPatient();
                        String string = l2.getName();
                        String string2 = l2.getId();
                        return alreadySeenPatients.add(new PatientInfo(string, string2));
                    }
                });
                return Iterators.transform((Iterator)unmodifiableIterator, (Function)new Function<Series, DicomObject>(){

                    public DicomObject apply(Series series) {
                        NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
                        Parser.setDefaultSpecificCharacterSet((DicomObject)nonCrashyDicomObject);
                        QueryResultProducer.this.addQueryRetrieveLevel(matchKey, returnKey, (DicomObject)nonCrashyDicomObject);
                        QueryResultProducer.this.addPatientResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                        return nonCrashyDicomObject;
                    }
                });
            }

            @Override
            public void close() {
                if (this.seriesIterable != null) {
                    this.seriesIterable.close();
                    this.seriesIterable = null;
                    this.alreadySeenPatients.clear();
                }
            }
        };
    }

    private a<DicomObject> matchStudyLevel(final MatchKey matchKey, final ReturnKey returnKey) {
        final MetabaseQuery metabaseQuery = n.a();
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        this.addPatientFilters(matchKey, metabaseQuery);
        this.addStudyFilters(matchKey, metabaseQuery);
        return new a<DicomObject>(){
            private a<? extends Series> seriesIterable;
            private Set<String> alreadySeenStudyInstanceUids = Sets.newHashSet();

            @Override
            public Iterator<DicomObject> iterator() {
                this.close();
                ay.a((Object)("Executing study-level metabase query: " + metabaseQuery), this);
                this.seriesIterable = metabaseQuery.b(j.a());
                UnmodifiableIterator unmodifiableIterator = this.seriesIterable.iterator();
                unmodifiableIterator = Iterators.filter(unmodifiableIterator, (Predicate)new Predicate<Series>(){

                    public boolean apply(Series series) {
                        return alreadySeenStudyInstanceUids.add(series.getStudy().getStudyInstanceUid());
                    }
                });
                return Iterators.transform((Iterator)unmodifiableIterator, (Function)new Function<Series, DicomObject>(){

                    public DicomObject apply(Series series) {
                        NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
                        Parser.setDefaultSpecificCharacterSet((DicomObject)nonCrashyDicomObject);
                        QueryResultProducer.this.addQueryRetrieveLevel(matchKey, returnKey, (DicomObject)nonCrashyDicomObject);
                        QueryResultProducer.this.addPatientResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                        QueryResultProducer.this.addStudyResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                        return nonCrashyDicomObject;
                    }
                });
            }

            @Override
            public void close() {
                if (this.seriesIterable != null) {
                    this.seriesIterable.close();
                    this.seriesIterable = null;
                    this.alreadySeenStudyInstanceUids.clear();
                }
            }
        };
    }

    private a<DicomObject> matchSeriesLevel(final MatchKey matchKey, final ReturnKey returnKey) {
        final MetabaseQuery metabaseQuery = n.a();
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        this.addSeriesFilters(matchKey, metabaseQuery);
        return new a<DicomObject>(){
            private a<? extends Series> seriesIterable;

            @Override
            public Iterator<DicomObject> iterator() {
                this.close();
                ay.a((Object)("Executing series-level metabase query: " + metabaseQuery), this);
                this.seriesIterable = metabaseQuery.b(j.a());
                UnmodifiableIterator unmodifiableIterator = this.seriesIterable.iterator();
                unmodifiableIterator = Iterators.filter(unmodifiableIterator, (Predicate)new Predicate<Series>(){

                    public boolean apply(Series series) {
                        return series.getEmbedIndex() == null;
                    }
                });
                return Iterators.transform((Iterator)unmodifiableIterator, (Function)new Function<Series, DicomObject>(){

                    public DicomObject apply(Series series) {
                        NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
                        Parser.setDefaultSpecificCharacterSet((DicomObject)nonCrashyDicomObject);
                        QueryResultProducer.this.addQueryRetrieveLevel(matchKey, returnKey, (DicomObject)nonCrashyDicomObject);
                        QueryResultProducer.this.addPatientResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                        QueryResultProducer.this.addStudyResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                        QueryResultProducer.this.addSeriesResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                        return nonCrashyDicomObject;
                    }
                });
            }

            @Override
            public void close() {
                if (this.seriesIterable != null) {
                    this.seriesIterable.close();
                    this.seriesIterable = null;
                }
            }
        };
    }

    private a<DicomObject> matchImageLevel(final MatchKey matchKey, final ReturnKey returnKey) {
        if (cn.h(matchKey.getSeriesInstanceUID())) {
            ay.d((Object)"Image-level query attempted with no supplied SeriesInstanceUID. Can't query like this.", this);
            return new a<DicomObject>(){

                @Override
                public Iterator<DicomObject> iterator() {
                    return Iterators.emptyIterator();
                }

                @Override
                public void close() {
                }
            };
        }
        final MetabaseQuery metabaseQuery = n.a();
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        this.addSeriesFilters(matchKey, metabaseQuery);
        return new a<DicomObject>(){

            @Override
            public void close() {
            }

            @Override
            public Iterator<DicomObject> iterator() {
                List<? extends Series> list = metabaseQuery.a(j.a());
                if (list.isEmpty()) {
                    return Iterators.emptyIterator();
                }
                Series series = list.get(0);
                DcmSeries dcmSeries = DcmSeriesFactory.getDcmSeriesFromMetabaseSeries(series);
                List list2 = Ordering.natural().sortedCopy(series.getSopInstanceUids());
                return Iterators.transform(list2.iterator(), string -> {
                    NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
                    nonCrashyDicomObject.putString(524312, VR.UI, (String)string);
                    if (returnKey.contains(2097171)) {
                        DcmSeries dcmSeries2 = dcmSeries.getSopInstance((String)string);
                        try {
                            nonCrashyDicomObject.putInt(2097171, null, (Integer)dcmSeries2.getTagValue(2097171));
                        }
                        catch (NullPointerException nullPointerException) {
                            nonCrashyDicomObject.putNull(2097171, VR.IS);
                        }
                    }
                    QueryResultProducer.this.addQueryRetrieveLevel(matchKey, returnKey, (DicomObject)nonCrashyDicomObject);
                    QueryResultProducer.this.addStudyResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                    QueryResultProducer.this.addSeriesResultTags((DicomObject)nonCrashyDicomObject, series, returnKey);
                    return nonCrashyDicomObject;
                });
            }
        };
    }

    private class PatientInfo {
        private String patientName;
        private String patientId;

        public PatientInfo(String string, String string2) {
            this.patientName = string;
            this.patientId = string2;
        }

        public int hashCode() {
            return Objects.hash(this.patientName, this.patientId);
        }

        public boolean equals(Object object) {
            if (object instanceof PatientInfo) {
                PatientInfo patientInfo = (PatientInfo)object;
                return Objects.equals(this.patientName, patientInfo.patientName) && Objects.equals(this.patientId, patientInfo.patientId);
            }
            return false;
        }
    }
}

