/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.qrserver;

import com.google.common.collect.Lists;
import com.mimvista.dicom.qrserver.MatchKey;
import com.mimvista.dicom.read.ConfigurableFileExcluder;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.metabase.Series;
import com.mimvista.metabase.b;
import com.mimvista.metabase.j;
import com.mimvista.metabase.n;
import com.mimvista.preferencesNew.QrserverPrefs;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RetrieveFilePath {
    private RetrieveFilePath() {
    }

    public static List<String> patientRootRetrieve(MatchKey matchKey) {
        switch (matchKey.getLevel()) {
            case PATIENT: {
                return RetrieveFilePath.getPatientLevelResult(matchKey);
            }
            case STUDY: {
                return RetrieveFilePath.getStudyLevelResult(matchKey);
            }
            case SERIES: {
                return RetrieveFilePath.getSeriesLevelResult(matchKey);
            }
            case IMAGE: {
                return RetrieveFilePath.getImageLevelResult(matchKey);
            }
        }
        ay.c((Object)"Query Level Error", RetrieveFilePath.class);
        ay.d((Object)"Query Level Error", RetrieveFilePath.class);
        return null;
    }

    public static List<String> studyRootRetrieve(MatchKey matchKey) {
        switch (matchKey.getLevel()) {
            case STUDY: {
                return RetrieveFilePath.getStudyLevelResult(matchKey);
            }
            case SERIES: {
                return RetrieveFilePath.getSeriesLevelResult(matchKey);
            }
            case IMAGE: {
                return RetrieveFilePath.getImageLevelResult(matchKey);
            }
        }
        ay.c((Object)"Query Level Error", RetrieveFilePath.class);
        ay.d((Object)"Query Level Error", RetrieveFilePath.class);
        return null;
    }

    public static void addQueryRetrieveFilter(MetabaseQuery metabaseQuery) {
        if (QrserverPrefs.querySource.getValue() == QrserverPrefs.QuerySourceType.b) {
            String string = QrserverPrefs.archivePath.getValue().getAbsolutePath();
            b.b(metabaseQuery, string);
        } else {
            b.b(metabaseQuery);
        }
    }

    private static List<String> getPatientLevelResult(MatchKey matchKey) {
        String string = matchKey.getPatientID() != null ? matchKey.getPatientID() : "";
        MetabaseQuery metabaseQuery = n.a().c(MetabaseKeys.fromTag(0x100020), (Object)string).f("mimdata.folders");
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        List<? extends Series> list = metabaseQuery.a(j.a());
        ArrayList<String> arrayList = new ArrayList<String>(list.size() * 10);
        for (Series series : list) {
            for (String string2 : series.getFolders()) {
                if (RetrieveFilePath.addImagesToResults(arrayList, string2)) break;
            }
        }
        return arrayList;
    }

    private static List<String> getStudyLevelResult(MatchKey matchKey) {
        String string = matchKey.getStudyInstanceUID();
        MetabaseQuery metabaseQuery = n.a().c(MetabaseKeys.fromTag(0x20000D), (Object)string).f("mimdata.folders");
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        List<? extends Series> list = metabaseQuery.a(j.a());
        ArrayList<String> arrayList = new ArrayList<String>(list.size() * 10);
        for (Series series : list) {
            for (String string2 : series.getFolders()) {
                if (RetrieveFilePath.addImagesToResults(arrayList, string2)) break;
            }
        }
        return arrayList;
    }

    private static List<String> getSeriesLevelResult(MatchKey matchKey) {
        String string = matchKey.getSeriesInstanceUID();
        MetabaseQuery metabaseQuery = n.a().c(MetabaseKeys.fromTag(0x20000E), (Object)string).f("mimdata.folders");
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        List<? extends Series> list = metabaseQuery.a(j.a());
        ArrayList<String> arrayList = new ArrayList<String>(list.size() * 10);
        for (Series series : list) {
            for (String string2 : series.getFolders()) {
                if (RetrieveFilePath.addImagesToResults(arrayList, string2)) break;
            }
        }
        return arrayList;
    }

    private static List<String> getImageLevelResult(MatchKey matchKey) {
        if (cn.h(matchKey.getSeriesInstanceUID())) {
            ay.d((Object)"Image-level retrieve attempted with no supplied SeriesInstanceUID. Can't retrieve like this.", RetrieveFilePath.class);
            return Collections.emptyList();
        }
        if (cn.h(matchKey.getSopInstanceUID())) {
            ay.d((Object)"Image-level retrieve attempted with no supplied SOPInstanceUID. Can't retrieve like this.", RetrieveFilePath.class);
            return Collections.emptyList();
        }
        MetabaseQuery metabaseQuery = n.a();
        RetrieveFilePath.addQueryRetrieveFilter(metabaseQuery);
        metabaseQuery.c(MetabaseKeys.fromTag(0x20000E), (Object)matchKey.getSeriesInstanceUID());
        List<? extends Series> list = metabaseQuery.a(j.a());
        if (list.isEmpty()) {
            ay.d((Object)("Image-level retrieve attempted for a series that can't be found, with UID " + matchKey.getSeriesInstanceUID() + "."), RetrieveFilePath.class);
            return Collections.emptyList();
        }
        ArrayList arrayList = Lists.newArrayList();
        for (String string : list.get(0).getFolders()) {
            File file = new File(string, matchKey.getSopInstanceUID() + ".dcm");
            if (!file.exists()) continue;
            arrayList.add(file.getAbsolutePath());
        }
        return arrayList;
    }

    private static boolean addImagesToResults(List<String> list, String string) {
        File file = new File(string);
        boolean bl2 = false;
        if (file.exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles(new ConfigurableFileExcluder().getFilenameFilter());
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                list.add(fileArray[i2].getAbsolutePath());
                bl2 = true;
            }
        }
        return bl2;
    }
}

