/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.mimvista.c;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleDicomContourCreator;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.ColorTable;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.SeriesInfo;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public abstract class AbstractRtStructLoader {
    public static final String CHILD_OVERLAY_RTROI_RELATIONSHIP = "ENCLOSING";
    public static final String CHILD_OVERLAY_OBSERVATION_KEY = "ChildOverlayType";
    public static Messages props = Messages.a("Dicom");
    protected File file = null;
    protected LoadMethod loadMethod = LoadMethod.REPLACE;
    protected DicomObject dicom = null;
    protected TreeMap<Integer, RoiInfo> roiInfoMap = new TreeMap();
    protected boolean manufacturerWithoutKeyholes = false;
    protected List<String> mergeResults = Collections.emptyList();
    protected String refdSeriesUID;
    protected boolean allowUIDMismatch = false;
    protected boolean loadNonAxial;
    protected boolean askedLoadNonAxial = false;
    protected boolean accurayStyleRTST = false;

    protected void loadRtstruct(Progress progress) {
        String string;
        if (this.loadMethod == null) {
            return;
        }
        String string2 = this.getInfo().ag();
        if (!string2.equals(this.refdSeriesUID)) {
            if (this.allowUIDMismatch) {
                ay.c((Object)("Loading RTstruct for wrong series!: " + this.refdSeriesUID + " vs " + string2 + " , allowing due to override."), this);
            } else {
                throw new IllegalStateException("Reading RTstruct for wrong series!: " + this.refdSeriesUID + " vs " + string2);
            }
        }
        if ((string = this.dicom.getString(524400, "")).toLowerCase().contains("accuray")) {
            this.accurayStyleRTST = true;
        }
        this.checkKeyholeBehavior();
        this.readStructureSetRoiSeq();
        this.readRoiContourSequence();
        this.readObservationSequence();
        this.processROIs(progress);
    }

    public void setAllowUIDMismatch(boolean bl2) {
        this.allowUIDMismatch = bl2;
    }

    protected String getReferencedSeriesUID() {
        String string = this.dicom.getString(new int[]{805699600, 0, 805699602, 0, 805699604, 0, 0x20000E});
        return string;
    }

    public static float isContourUniform(List<PointSet> list) {
        float f2 = Float.MAX_VALUE;
        ArrayList<Float> arrayList = new ArrayList<Float>();
        for (PointSet pointSet : list) {
            arrayList.add(Float.valueOf(pointSet.pointSet[2]));
        }
        List list2 = Ordering.natural().sortedCopy(arrayList);
        if (list2.size() < 5) {
            return Float.NaN;
        }
        block1: for (int i2 = 0; i2 < list2.size() - 1; ++i2) {
            float f3 = ((Float)list2.get(i2)).floatValue();
            float f4 = ((Float)list2.get(i2 + 1)).floatValue();
            int n2 = 1;
            while ((double)Math.abs(f3 - f4) < 0.1) {
                if (++n2 == list2.size() - i2) break block1;
                f4 = ((Float)list2.get(i2 + n2)).floatValue();
            }
            float f5 = Math.abs(f3 - f4);
            if (f5 < f2) {
                f2 = f5;
            }
            i2 = i2 + n2 - 1;
        }
        float f6 = ((Float)list2.get(0)).floatValue();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Float f7 = (Float)iterator.next();
            float f8 = Math.abs(f7.floatValue() - f6) / f2;
            if (!((double)Math.abs(f8 - (float)Math.round(f8)) > 0.2)) continue;
            return Float.NaN;
        }
        return f2;
    }

    protected String[] getManufacturersWithoutKeyholesPref() {
        return new String[]{"VARIAN Medical Systems"};
    }

    private void checkKeyholeBehavior() {
        this.manufacturerWithoutKeyholes = DicomPrefs.subtractOverlappingContourSlices.getValue();
    }

    private void readStructureSetRoiSeq() {
        DicomElement dicomElement = this.dicom.get(805699616);
        String[] stringArray = this.dicom.getStrings(528496);
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            RoiInfo roiInfo = new RoiInfo();
            roiInfo.name = dicomObject.getString(805699622);
            roiInfo.description = dicomObject.getString(805699624);
            roiInfo.generationAlgo = dicomObject.getString(0x30060036);
            roiInfo.referencedRoiNumber = dicomObject.getInt(805699618);
            if (stringArray != null) {
                roiInfo.operatorNames = stringArray;
            }
            this.roiInfoMap.put(roiInfo.referencedRoiNumber, roiInfo);
        }
    }

    protected void readRoiContourSequence() {
        this.readRoiContourSequence(805699641);
    }

    protected void readRoiContourSequence(int n2) {
        DicomElement dicomElement = this.dicom.get(n2);
        if (dicomElement == null) {
            return;
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomObject dicomObject = dicomElement.getDicomObject(i2);
            RoiInfo roiInfo = this.roiInfoMap.get(dicomObject.getInt(805699716));
            if (roiInfo == null) continue;
            int[] nArray = dicomObject.getInts(805699626);
            if (nArray != null && nArray.length >= 3) {
                roiInfo.color = new ColorTable.RGB(nArray[0], nArray[1], nArray[2]);
            } else {
                ay.b((Object)("ROI #" + roiInfo.referencedRoiNumber + " is missing the ROIDisplayColor, so I'm making it red."), this);
                roiInfo.color = new ColorTable.RGB(255, 0, 0);
            }
            DicomElement dicomElement2 = dicomObject.get(805699648);
            if (dicomElement2 == null || dicomElement2.countItems() == 0) {
                roiInfo.type = "CLOSED_PLANAR";
                continue;
            }
            for (int i3 = 0; i3 < dicomElement2.countItems(); ++i3) {
                PointSet pointSet;
                Object object;
                Object object2;
                DicomObject dicomObject2 = dicomElement2.getDicomObject(i3);
                DicomElement dicomElement3 = dicomObject2.get(805699606);
                TreeSet<FrameNumber> treeSet = new TreeSet<FrameNumber>();
                if (dicomElement3 != null) {
                    for (int i4 = 0; i4 < dicomElement3.countItems(); ++i4) {
                        object2 = dicomElement3.getDicomObject(i4);
                        object = object2.getInts(528736);
                        if (object == null) continue;
                        for (int n3 : object) {
                            treeSet.add(new FrameNumber(n3));
                        }
                    }
                }
                object2 = dicomObject2.getFloats(805699664);
                if (this.accurayStyleRTST) {
                    int n4 = dicomObject2.getInt(805699656);
                    pointSet = new AccurayPointSet((float[])object2, n4);
                } else {
                    pointSet = new PointSet((float[])object2);
                }
                object = treeSet.iterator();
                while (object.hasNext()) {
                    FrameNumber frameNumber = (FrameNumber)object.next();
                    if (!roiInfo.framedPointSets.containsKey(frameNumber)) {
                        roiInfo.framedPointSets.put(frameNumber, new ArrayList());
                    }
                    roiInfo.framedPointSets.get(frameNumber).add(pointSet);
                }
                roiInfo.pointSets.add(pointSet);
                roiInfo.type = dicomObject2.getString(805699650, roiInfo.type);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readObservationSequence() {
        DicomElement dicomElement = this.dicom.get(805699712);
        if (dicomElement == null) {
            return;
        }
        for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
            DicomElement dicomElement2;
            void object;
            ChildOverlayType childOverlayType;
            String string;
            DicomObject dicomObject;
            Object[] objectArray;
            DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
            int n2 = dicomObject2.getInt(805699716);
            RoiInfo roiInfo = this.roiInfoMap.get(n2);
            if (roiInfo == null) continue;
            roiInfo.obsLabel = dicomObject2.getString(805699717, "");
            if (roiInfo.obsLabel.equalsIgnoreCase("CORONAL") || roiInfo.obsLabel.equalsIgnoreCase("SAGITTAL")) {
                this.askToLoadNonAxial();
            }
            String string2 = "";
            try {
                string2 = dicomObject2.getString(805699748, OverlayishBase.InterpretedType.a.c());
                roiInfo.interpretedType = OverlayishBase.InterpretedType.a(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                roiInfo.interpretedType = OverlayishBase.InterpretedType.a;
                ay.b((Object)("Invalid interpreted type '" + string2 + "' found while loading in RTstruct: "), this);
            }
            String string3 = null;
            try {
                objectArray = dicomObject2.getBytes(930295813);
                if (objectArray != null) {
                    string3 = new String((byte[])objectArray, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ay.d((Object)unsupportedEncodingException, this);
            }
            if (string3 == null && (string3 = dicomObject2.getString(930295813, VR.ST, (String)null)) == null) {
                string3 = dicomObject2.getString(805699720, "");
            }
            if (string3 != null) {
                roiInfo.observationDesc = string3;
            }
            for (byte by2 : objectArray = (Object[])roiInfo.observationDesc.split(",")) {
                if (!by2.contains(":") || (dicomObject = by2.split(":")) == null || ((String[])dicomObject).length <= 1) continue;
                String string4 = dicomObject[0] == null || dicomObject[0].isEmpty() ? "" : dicomObject[0].trim();
                string = dicomObject[1];
                if (((DicomObject)dicomObject).length > 2) {
                    for (int i3 = 2; i3 < ((DicomObject)dicomObject).length; ++i3) {
                        string = string + ":" + (String)dicomObject[i3];
                    }
                }
                roiInfo.observationInformation.put(string4, string.trim());
            }
            Object var9_13 = null;
            String string5 = roiInfo.observationInformation.get(CHILD_OVERLAY_OBSERVATION_KEY);
            if (string5 != null && (childOverlayType = ChildOverlayType.match(string5, roiInfo.type)) != null) {
                ChildOverlayType childOverlayType2 = childOverlayType;
            }
            if (object == null || (dicomElement2 = dicomObject2.get(0x30060030)) == null) continue;
            for (int i4 = 0; i4 < dicomElement2.countItems(); ++i4) {
                dicomObject = dicomElement2.getDicomObject(i4);
                int n3 = dicomObject.getInt(805699716, -1);
                if (n3 == -1 || !this.roiInfoMap.containsKey(n3) || !CHILD_OVERLAY_RTROI_RELATIONSHIP.equalsIgnoreCase(string = dicomObject.getString(0x30060033, "").trim())) continue;
                roiInfo.childType = object;
                RoiInfo roiInfo2 = this.roiInfoMap.get(n3);
                roiInfo2.children.put(n2, (ChildOverlayType)object);
            }
        }
    }

    protected void fillContour(RoiInfo roiInfo, SimpleImageVolume<?> simpleImageVolume, SimpleContour simpleContour, Progress progress) {
        this.fillContour(roiInfo.pointSets, simpleImageVolume, simpleContour, progress);
    }

    protected void fillContour(List<PointSet> list, SimpleImageVolume<?> simpleImageVolume, SimpleContour simpleContour, Progress progress) {
        boolean bl2 = this.dicom.getString(524400, "").contains("MIM");
        SimpleDicomContourCreator.a a2 = SimpleDicomContourCreator.a.a(simpleImageVolume, this.dicom);
        if (this.accurayStyleRTST) {
            Object object;
            ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
            HashMap hashMap = Maps.newHashMap();
            HashMap hashMap2 = Maps.newHashMap();
            for (PointSet pointSet : list) {
                object = (AccurayPointSet)pointSet;
                hashMap2.put(((AccurayPointSet)object).stackId, ((AccurayPointSet)object).geometryType);
                arrayListMultimap.put((Object)((AccurayPointSet)object).stackId, (Object)pointSet);
            }
            Iterator<Object> iterator = arrayListMultimap.keySet().iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)((Object)iterator.next());
                object = arrayListMultimap.get((Object)n2);
                int n3 = (Integer)hashMap2.get(n2);
                SimpleContour simpleContour2 = new SimpleContour(simpleContour.q());
                simpleContour2.d(simpleContour.v());
                SimpleDicomContourCreator simpleDicomContourCreator = new SimpleDicomContourCreator(simpleContour2);
                simpleDicomContourCreator.a(!bl2);
                simpleDicomContourCreator.a((List<PointSet>)object, this.manufacturerWithoutKeyholes, new o(), a2);
                if (hashMap.containsKey(n3)) {
                    ((SimpleContour)hashMap.get(n3)).d(simpleContour2);
                    continue;
                }
                hashMap.put(n3, simpleContour2);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                int n4 = (Integer)entry.getKey();
                SimpleContour simpleContour3 = (SimpleContour)entry.getValue();
                if (n4 != 0 && n4 != 2) continue;
                simpleContour.d(simpleContour3);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                SimpleContour simpleContour4 = (SimpleContour)entry.getValue();
                int n5 = (Integer)entry.getKey();
                if (n5 != 1) continue;
                simpleContour.e(simpleContour4);
            }
            progress.N_();
        } else {
            SimpleDicomContourCreator simpleDicomContourCreator = new SimpleDicomContourCreator(simpleContour);
            simpleDicomContourCreator.a(!bl2);
            simpleDicomContourCreator.a(list, this.manufacturerWithoutKeyholes, progress, a2);
            String string = this.dicom.getString(524400, "");
            if ((string.toLowerCase().contains("nucletron") || string.toLowerCase().contains("mim")) && !list.isEmpty() && list.size() > 1 && simpleContour.Q()) {
                simpleContour.y();
                simpleDicomContourCreator.a(list, false, new o(), a2);
            }
        }
    }

    public void setLoadMethod(LoadMethod loadMethod) {
        this.loadMethod = loadMethod;
    }

    protected abstract void askToLoadNonAxial();

    protected abstract void processROIs(Progress var1);

    protected abstract SeriesInfo getInfo();

    public class RoiInfo {
        ColorTable.RGB color;
        int referencedRoiNumber = -1;
        public String name;
        String[] operatorNames = new String[0];
        String description;
        String type;
        List<PointSet> pointSets = Lists.newArrayList();
        Map<String, String> observationInformation = Maps.newHashMap();
        Map<FrameNumber, ArrayList<PointSet>> framedPointSets = Maps.newHashMap();
        public String obsLabel = "";
        public String observationDesc = "";
        OverlayishBase.InterpretedType interpretedType = OverlayishBase.InterpretedType.a;
        String generationAlgo;
        ChildOverlayType childType = null;
        Map<Integer, ChildOverlayType> children = Maps.newHashMap();
    }

    public static class AccurayPointSet
    extends PointSet {
        public int stackId;
        public int geometryType;

        public AccurayPointSet(float[] fArray, int n2) {
            super(fArray);
            this.stackId = n2 >> 24;
            this.geometryType = n2 << 8 >>> 24;
        }
    }

    public static class PointSet {
        @c
        public float[] pointSet;

        public PointSet(float[] fArray) {
            if (fArray == null) {
                fArray = new float[]{};
            }
            this.pointSet = fArray;
        }
    }

    public static enum LoadMethod {
        REPLACE,
        APPEND,
        MERGE;

    }

    public static enum ChildOverlayType {
        RECIST(false, "OPEN_NONPLANAR"),
        PERP(false, "OPEN_NONPLANAR"),
        SUV_PEAK(false, "OPEN_NONPLANAR"),
        CV(false, "OPEN_NONPLANAR");

        boolean shouldCreateSelf;
        String roiType;

        public static ChildOverlayType match(String string, String string2) {
            ChildOverlayType childOverlayType = ChildOverlayType.valueOf(string);
            if (childOverlayType != null && childOverlayType.roiType.equalsIgnoreCase(string2)) {
                return childOverlayType;
            }
            return null;
        }

        private ChildOverlayType(boolean bl2, String string2) {
            this.shouldCreateSelf = bl2;
            this.roiType = string2;
        }

        public boolean shouldCreateSelf() {
            return this.shouldCreateSelf;
        }
    }
}

