/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jayway.jsonpath.InvalidPathException;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.c;
import com.mimvista.d;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.read.ByteArrayDataProvider;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.MultiSeriesFrameData;
import com.mimvista.dicom.read.ReorientationParams;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.PlanarImage;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.o;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.workflow.backend.i;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AtomicLoadUnit
extends JsonDicomSeries
implements com.mimvista.workflow.backend.g,
Cloneable {
    private static final long serialVersionUID = 1L;
    private g loadProgress = new o();
    private boolean haveIBeenCloned = false;
    private final DcmSeries series;
    private final String archiveDir;
    private Set<String> sopsToLoad;
    private Function<JsonDicomSeries, List<FrameNumber>> frameNumberGenerator = null;
    private List<FrameNumber> framesForMatching = null;
    private long vcId = -1L;
    private Map<PlanarImage.a, PlanarImage> loadedImages;
    private List<AtomicLoadUnit> regReferencedTargets;
    private ReorientationParams reorientationParams = new ReorientationParams();
    private Boolean load2dUsAs3d = null;
    private Boolean userWantsToLoadDose = null;
    private SearchSource source;
    private transient i workflowTarget;
    private final String workflowDisplayName;
    private final String modality;
    private final boolean is2D;
    private final String patientName;
    private final String patientId;
    private final String studyDesc;
    private final String seriesDesc;
    private final String date;
    private final String time;
    private final String numImages;
    private final Date dateTime;
    private DataProviderWrapper dataProvider;
    private final Modality modalityType;
    private final UIDContainer.SeriesUID seriesUid;
    private final UIDContainer.StudyUID studyUid;
    private final UIDContainer.SOPInstanceUID sopUid;
    private String overriddenReferencedSeriesUID = null;
    private MultiSeriesFrameData mfData = null;

    public AtomicLoadUnit(DcmSeries dcmSeries) {
        super(dcmSeries);
        this.series = dcmSeries;
        String string = dcmSeries.getArchiveDir();
        this.archiveDir = cn.h(string) ? dcmSeries.getSeriesInstanceUID() : string;
        this.workflowDisplayName = dcmSeries.getWorkflowDisplayName();
        this.modality = dcmSeries.getModality();
        this.is2D = SeriesIdentifier.is2D(dcmSeries);
        this.patientName = dcmSeries.getPatientName();
        this.patientId = dcmSeries.getPatientID();
        this.studyDesc = dcmSeries.getStudyDescription();
        this.seriesDesc = dcmSeries.getSeriesDescription();
        this.date = dcmSeries.getDate();
        this.time = dcmSeries.getTime();
        this.dateTime = dcmSeries.getDateTime();
        this.numImages = dcmSeries.getNumberOfImages();
        this.source = dcmSeries.getSearchSource();
        this.dataProvider = dcmSeries._getDataProviderRef();
        this.modalityType = Modality.get(this.modality);
        this.seriesUid = dcmSeries.getSeriesInstanceUID() == null ? null : new UIDContainer.SeriesUID(dcmSeries.getSeriesInstanceUID());
        this.studyUid = dcmSeries.getStudy() == null ? null : new UIDContainer.StudyUID(dcmSeries.getStudy().getStudyInstanceUID());
        this.sopUid = dcmSeries.getOneOfMySOPInstanceUIDs() == null ? null : new UIDContainer.SOPInstanceUID(dcmSeries.getOneOfMySOPInstanceUIDs());
    }

    public Boolean shouldLoadThis2dUsAs3d() {
        return this.load2dUsAs3d;
    }

    public void setLoad2dUsAs3d(Boolean bl2) {
        this.load2dUsAs3d = bl2;
    }

    public DcmSeries getSeries() {
        return this.series;
    }

    public g getLoadProgress() {
        return this.loadProgress;
    }

    public void setLoadProgress(g g2) {
        this.loadProgress = g2;
    }

    @c
    public Set<String> getSopsToLoad() {
        if (this.sopsToLoad == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.sopsToLoad);
    }

    public void setSopsToLoad(UIDContainer.SOPInstanceUID ... sOPInstanceUIDArray) {
        if (sOPInstanceUIDArray == null) {
            this.sopsToLoad = null;
        } else {
            this.setSopsToLoad(Arrays.asList(sOPInstanceUIDArray));
        }
    }

    public void setSopsToLoad(@d Iterable<UIDContainer.SOPInstanceUID> iterable) {
        if (iterable == null) {
            this.sopsToLoad = null;
        } else {
            this.sopsToLoad = Sets.newTreeSet();
            Iterables.addAll(this.sopsToLoad, (Iterable)Iterables.transform(iterable, UIDContainer.TO_STRING));
        }
        this.getDataProviderForLoading();
    }

    public boolean hasFrameNums() {
        return this.frameNumberGenerator != null;
    }

    public List<FrameNumber> getFrameNums(JsonDicomSeries jsonDicomSeries) {
        if (this.frameNumberGenerator != null) {
            return (List)this.frameNumberGenerator.apply((Object)jsonDicomSeries);
        }
        return null;
    }

    public void setFrameNums(Function<JsonDicomSeries, List<FrameNumber>> function) {
        this.frameNumberGenerator = function;
        if (function != null) {
            this.framesForMatching = (List)function.apply((Object)this);
        }
    }

    public List<FrameNumber> getFramesForMatching() {
        return this.framesForMatching;
    }

    public long getVcId() {
        return this.vcId;
    }

    public void setVcId(long l2) {
        this.vcId = l2;
    }

    public List<AtomicLoadUnit> getRegReferencedTargets() {
        return this.regReferencedTargets;
    }

    public void setRegReferencedTargets(List<AtomicLoadUnit> list) {
        this.regReferencedTargets = list;
    }

    private void initLoadedImagesMap() {
        if (this.haveIBeenCloned) {
            throw new IllegalStateException("Trying to initialize loadedImagesMap after having been cloned is BAD JUJU.");
        }
        this.loadedImages = Maps.newHashMap();
    }

    public PlanarImage getPreviouslyLoadedImage(PlanarImage.a a2) {
        if (this.loadedImages == null) {
            this.initLoadedImagesMap();
        }
        return this.loadedImages.remove(a2);
    }

    public void stashAwayLoadedImagesForClones(Iterable<? extends PlanarImage> iterable) {
        for (PlanarImage planarImage : iterable) {
            this.loadedImages.put(planarImage.O(), planarImage);
        }
    }

    @Override
    public AtomicLoadUnit clone() {
        if (!this.haveIBeenCloned) {
            this.initLoadedImagesMap();
        }
        AtomicLoadUnit atomicLoadUnit = (AtomicLoadUnit)super.clone();
        this.haveIBeenCloned = true;
        return atomicLoadUnit;
    }

    public List<PlanarImage.a> getPlanarKeys() {
        if (this.sopsToLoad == null || this.sopsToLoad.size() != 1) {
            return null;
        }
        String string = (String)Iterables.get(this.sopsToLoad, (int)0);
        ArrayList arrayList = Lists.newArrayList();
        SeriesInfo seriesInfo = this.series.getDataProvider().getUncopiedMutableInfo();
        UIDContainer.SeriesUID seriesUID = new UIDContainer.SeriesUID(seriesInfo.ag());
        List<FrameNumber> list = this.getFrameNums(seriesInfo.y());
        if (list != null && list.size() > 0) {
            for (FrameNumber frameNumber : list) {
                arrayList.add(new PlanarImage.a(seriesUID, new UIDContainer.SOPInstanceUID(string), frameNumber));
            }
        } else {
            arrayList.add(new PlanarImage.a(seriesUID, new UIDContainer.SOPInstanceUID(string), null));
        }
        return arrayList;
    }

    public String getPatientBirthdate() {
        return this.getSeries().getPatientBirthdate();
    }

    @Override
    public String getWorkflowDisplayName() {
        return this.workflowDisplayName;
    }

    @Override
    public String getModality() {
        return this.modality;
    }

    @Override
    public boolean is2D() {
        return this.is2D;
    }

    @Override
    public String getPatientName() {
        return this.patientName;
    }

    @Override
    public String getPatientID() {
        return this.patientId;
    }

    @Override
    public String getStudyDescription() {
        return this.studyDesc;
    }

    @Override
    public String getSeriesDescription() {
        return this.seriesDesc;
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public String getTime() {
        return this.time;
    }

    @Override
    public Date getDateTime() {
        return this.dateTime;
    }

    @Override
    public String getNumberOfImages() {
        return this.numImages;
    }

    public SearchSource getSearchSource() {
        return this.source;
    }

    public void setSearchSource(SearchSource searchSource) {
        this.source = searchSource;
    }

    public LoaderDataProvider getFreshDataProvider() {
        LoaderDataProvider loaderDataProvider = this.source.d(this.series);
        if (this.sopsToLoad != null && !this.sopsToLoad.isEmpty()) {
            loaderDataProvider.setSopsToLoad(this.sopsToLoad);
        }
        return loaderDataProvider;
    }

    public void decoupleDataProviderWrapper() {
        this.dataProvider = new DataProviderWrapper(this.dataProvider.get());
    }

    public LoaderDataProvider getDataProviderForLoading() {
        LoaderDataProvider loaderDataProvider = this.dataProvider.get();
        if (loaderDataProvider != null && loaderDataProvider.isSpecialStickyProvider()) {
            return loaderDataProvider;
        }
        if (loaderDataProvider instanceof ByteArrayDataProvider) {
            return loaderDataProvider;
        }
        LoaderDataProvider loaderDataProvider2 = this.getFreshDataProvider();
        if (loaderDataProvider != null) {
            loaderDataProvider.copyCachedStateTo(loaderDataProvider2);
        }
        this.dataProvider.set(loaderDataProvider2);
        return loaderDataProvider2;
    }

    public synchronized LoaderDataProvider getDataProvider() {
        if (this.dataProvider.get() == null) {
            this.dataProvider.set(this.getFreshDataProvider());
        }
        return this.dataProvider.get();
    }

    public Modality getModalityType() {
        return this.modalityType;
    }

    public UIDContainer.SeriesUID getSeriesUid() {
        return this.seriesUid;
    }

    public UIDContainer.StudyUID getStudyUid() {
        return this.studyUid;
    }

    public UIDContainer.SOPInstanceUID getSopInstanceUid() {
        return this.sopUid;
    }

    public ReorientationParams getReorientationParams() {
        return this.reorientationParams;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[");
        stringBuilder.append(this.getModality());
        stringBuilder.append(" seriesUID: ");
        stringBuilder.append(this.getSeriesUid());
        if (this.framesForMatching != null && !this.framesForMatching.isEmpty()) {
            stringBuilder.append("\nframes: ");
            stringBuilder.append(this.framesForMatching);
        }
        if (this.sopsToLoad != null && !this.sopsToLoad.isEmpty()) {
            stringBuilder.append("\nSOPs TL (" + this.sopsToLoad.size() + "): ");
            stringBuilder.append(Iterables.limit(this.sopsToLoad, (int)10));
        }
        if (this.sopUid != null) {
            stringBuilder.append("\nSOP: ");
            stringBuilder.append(this.sopUid);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        List<FrameNumber> list = this.framesForMatching;
        n3 = 31 * n3 + (this.archiveDir == null ? 0 : this.archiveDir.hashCode());
        n3 = 31 * n3 + (this.sopsToLoad == null ? 0 : ((Object)this.sopsToLoad).hashCode());
        n3 = 31 * n3 + (this.sopUid == null ? 0 : this.sopUid.hashCode());
        n3 = 31 * n3 + (list == null ? 0 : ((Object)list).hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AtomicLoadUnit atomicLoadUnit = (AtomicLoadUnit)object;
        List<FrameNumber> list = this.framesForMatching;
        List<FrameNumber> list2 = atomicLoadUnit.framesForMatching;
        if (this.archiveDir == null ? atomicLoadUnit.archiveDir != null : !this.archiveDir.equals(atomicLoadUnit.archiveDir)) {
            return false;
        }
        if (this.sopsToLoad == null ? atomicLoadUnit.sopsToLoad != null : !((Object)this.sopsToLoad).equals(atomicLoadUnit.sopsToLoad)) {
            return false;
        }
        if (this.sopUid == null ? atomicLoadUnit.sopUid != null : !this.sopUid.equals(atomicLoadUnit.sopUid)) {
            return false;
        }
        return !(list == null ? list2 != null : !((Object)list).equals(list2));
    }

    @Override
    public DicomSeries getDicomSeries() {
        return this;
    }

    public MultiSeriesFrameData getMultiFrameData() {
        return this.mfData;
    }

    public void setMultiFrameData(MultiSeriesFrameData multiSeriesFrameData) {
        this.mfData = multiSeriesFrameData;
    }

    public String getStringTagValue(int n2, boolean bl2, String string) {
        String string2 = null;
        try {
            string2 = this.getTagValue(n2, String.class);
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        if (string2 == null && bl2) {
            try {
                string2 = this.getDataProvider().getValueForDicomTag(n2);
            }
            catch (Exception exception) {
                ay.d((Object)exception, this);
            }
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public String[] getStringTagValues(int n2, boolean bl2, String[] stringArray) {
        String[] stringArray2 = null;
        try {
            ImmutableList<String> immutableList = this.getTagValues(n2, String.class);
            if (immutableList != null && !immutableList.isEmpty()) {
                stringArray2 = (String[])immutableList.toArray((Object[])new String[immutableList.size()]);
            }
        }
        catch (InvalidPathException invalidPathException) {
        }
        catch (Exception exception) {
            ay.d((Object)exception, this);
        }
        if (stringArray2 == null && bl2) {
            try {
                stringArray2 = this.getDataProvider().getValuesForDicomTag(n2);
            }
            catch (Exception exception) {
                ay.d((Object)exception, this);
            }
        }
        if (stringArray2 == null) {
            stringArray2 = stringArray;
        }
        return stringArray2;
    }

    public i getWorkflowTarget() {
        return this.workflowTarget;
    }

    public void setWorkflowTarget(i i2) {
        this.workflowTarget = i2;
    }

    public String getOverriddenReferencedSeriesUID() {
        return this.overriddenReferencedSeriesUID;
    }

    public void setOverriddenReferencedSeriesUID(String string) {
        this.overriddenReferencedSeriesUID = string;
    }

    public Boolean getUserWantsToLoadDose() {
        return this.userWantsToLoadDose;
    }

    public void setUserWantsToLoadDose(Boolean bl2) {
        this.userWantsToLoadDose = bl2;
    }

    public boolean isEncapsulatedDoc() {
        SeriesInfo seriesInfo = this.getDataProvider().getUncopiedMutableInfoIfAlreadyLoaded();
        if (seriesInfo != null) {
            return SeriesIdentifier.isEncapsulatedPDF(seriesInfo);
        }
        String string = this.getStringTagValue(524310, false, null);
        if (string != null) {
            return SeriesIdentifier.isEncapsulatedPDF(string);
        }
        seriesInfo = this.getDataProvider().getUncopiedMutableInfo();
        return SeriesIdentifier.isEncapsulatedPDF(seriesInfo);
    }

    public static class DataProviderWrapper {
        private SoftReference<LoaderDataProvider> ldp;

        public DataProviderWrapper(LoaderDataProvider loaderDataProvider) {
            this.ldp = new SoftReference<LoaderDataProvider>(loaderDataProvider);
        }

        public LoaderDataProvider get() {
            return this.ldp.get();
        }

        public void set(LoaderDataProvider loaderDataProvider) {
            this.ldp = new SoftReference<LoaderDataProvider>(loaderDataProvider);
        }
    }
}

