/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.read.AbstractRtStructLoader;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.file.MIMFile;
import com.mimvista.internals.SimpleContour;
import com.mimvista.internals.SimpleDicomContourCreator;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.iphone.MobileMimBundleExporter;
import com.mimvista.iphone.d;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.overlays.BundleContourOverlay;
import com.mimvista.mui.overlays.OverlayColor;
import com.mimvista.mui.overlays.OverlayColorPool;
import com.mimvista.mui.overlays.PolygonContour;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.Point2f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.Polylines;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.ao;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.SeriesInfo;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BundleRtStructLoader
extends AbstractRtStructLoader {
    private final MobileMimBundleExporter.c item;
    private final d ownerSeries;
    private OverlayColorPool pool = new OverlayColorPool();

    public BundleRtStructLoader(MobileMimBundleExporter.c c2, d d2) {
        this.item = c2;
        this.ownerSeries = d2;
    }

    @Override
    public void loadRtstruct(Progress progress) {
        for (MIMFile mIMFile : this.item.a) {
            this.file = mIMFile;
            this.dicom = DicomReader.readFileIntoDicomObject(this.file);
            if (this.dicom == null) continue;
            break;
        }
        this.refdSeriesUID = this.getReferencedSeriesUID();
        if (this.refdSeriesUID == null) {
            return;
        }
        if (this.ownerSeries == null) {
            return;
        }
        super.loadRtstruct(progress);
    }

    @Override
    protected SeriesInfo getInfo() {
        return this.ownerSeries.g().getUncopiedMutableInfo();
    }

    @Override
    protected void processROIs(Progress progress) {
        int n2 = 0;
        for (Object object : this.roiInfoMap.values()) {
            n2 += ((AbstractRtStructLoader.RoiInfo)object).pointSets.size();
        }
        progress.b(0);
        progress.a(n2);
        progress.a(false);
        int n3 = 1;
        for (Map.Entry entry : this.roiInfoMap.entrySet()) {
            progress.b_("Loading contour " + n3++ + " of " + this.roiInfoMap.entrySet().size());
            AbstractRtStructLoader.RoiInfo roiInfo = (AbstractRtStructLoader.RoiInfo)entry.getValue();
            if ("CLOSED_PLANAR".equals(roiInfo.type)) {
                this.build3DContour(roiInfo, progress);
                continue;
            }
            if ("POINT".equals(roiInfo.type)) {
                this.buildPointContour(roiInfo, progress);
                continue;
            }
            this.build3DContour(roiInfo, progress);
        }
    }

    @Override
    protected void askToLoadNonAxial() {
        if (!this.askedLoadNonAxial) {
            this.askedLoadNonAxial = true;
            this.loadNonAxial = false;
        }
    }

    private void buildPointContour(AbstractRtStructLoader.RoiInfo roiInfo, Progress progress) {
    }

    private OverlayColor getTrueColor(AbstractRtStructLoader.RoiInfo roiInfo) {
        if (roiInfo.color == null) {
            return null;
        }
        Color color = roiInfo.color.a();
        return new OverlayColor("CustomColor", color);
    }

    private void build3DContour(AbstractRtStructLoader.RoiInfo roiInfo, Progress progress) {
        SimpleImageVolume<ImageCube.ImageCubeShort> simpleImageVolume = this.ownerSeries.g();
        SimpleContour simpleContour = new SimpleContour(this.ownerSeries.g());
        this.fillContour(roiInfo, simpleImageVolume, simpleContour, progress);
        BundleContourOverlay bundleContourOverlay = new BundleContourOverlay(simpleContour);
        bundleContourOverlay.c(roiInfo.name);
        bundleContourOverlay.a(this.getTrueColor(roiInfo));
        bundleContourOverlay.c_(roiInfo.description);
        bundleContourOverlay.b(roiInfo.observationDesc);
        bundleContourOverlay.a(roiInfo.interpretedType);
        bundleContourOverlay.a(roiInfo.referencedRoiNumber);
        if (this.accurayStyleRTST) {
            PresentationType presentationType = "AXIAL".equalsIgnoreCase(roiInfo.obsLabel) ? PresentationType.a : ("CORONAL".equalsIgnoreCase(roiInfo.obsLabel) ? PresentationType.c : PresentationType.b);
            bundleContourOverlay.a(BundleRtStructLoader.buildContourPassThroughForAccuray(presentationType, roiInfo, bundleContourOverlay.a().q()));
        }
        this.ownerSeries.a(bundleContourOverlay);
    }

    public static PolygonContour buildContourPassthrough(PresentationType presentationType, AbstractRtStructLoader.RoiInfo roiInfo, SimpleImageFrame simpleImageFrame) {
        PolygonContour polygonContour = new PolygonContour(presentationType);
        int[] nArray = presentationType.a();
        for (AbstractRtStructLoader.PointSet pointSet : roiInfo.pointSets) {
            ArrayList arrayList = Lists.newArrayList();
            List<VoxelPoint3f> list = SimpleDicomContourCreator.a(pointSet, simpleImageFrame);
            for (VoxelPoint3f voxelPoint3f : list) {
                arrayList.add(new Point2f(voxelPoint3f.b(nArray[0]), voxelPoint3f.b(nArray[1])));
            }
            int n2 = Math.round(list.get(0).b(nArray[2]) - 0.5f);
            polygonContour.a(n2, new Polylines.VoxelPolyline2f(arrayList, presentationType, new Point3f.PointVolumeInfo(simpleImageFrame)));
        }
        return polygonContour;
    }

    public static PolygonContour buildContourPassThroughForAccuray(PresentationType presentationType, AbstractRtStructLoader.RoiInfo roiInfo, SimpleImageFrame simpleImageFrame) {
        ao ao2 = new ao(presentationType);
        int[] nArray = presentationType.a();
        List<AbstractRtStructLoader.PointSet> list = roiInfo.pointSets;
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        HashMap hashMap = Maps.newHashMap();
        HashMap hashMap2 = Maps.newHashMap();
        for (AbstractRtStructLoader.PointSet object2 : list) {
            AbstractRtStructLoader.AccurayPointSet polygonContour = (AbstractRtStructLoader.AccurayPointSet)object2;
            hashMap2.put(polygonContour.stackId, polygonContour.geometryType);
            arrayListMultimap.put((Object)polygonContour.stackId, (Object)object2);
        }
        GeometryFactory geometryFactory = new GeometryFactory();
        Iterator iterator = arrayListMultimap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            ay.e("Stacked point sets " + n2);
            List iterator2 = arrayListMultimap.get((Object)n2);
            int n7 = (Integer)hashMap2.get(n2);
            ao ao3 = new ao(presentationType);
            for (Object object : iterator2) {
                ArrayList arrayList = Lists.newArrayList();
                List<VoxelPoint3f> list2 = SimpleDicomContourCreator.a((AbstractRtStructLoader.PointSet)object, simpleImageFrame);
                for (VoxelPoint3f voxelPoint3f : list2) {
                    arrayList.add(new Coordinate((double)voxelPoint3f.b(nArray[0]), (double)voxelPoint3f.b(nArray[1])));
                }
                arrayList.add(arrayList.get(0));
                LinearRing linearRing = new LinearRing((com.vividsolutions.jts.geom.d)new CoordinateArraySequence(arrayList.toArray(new Coordinate[0])), geometryFactory);
                int n3 = Math.round(list2.get(0).b(nArray[2]) - 0.5f);
                Polygon polygon = new Polygon(linearRing, null, geometryFactory);
                ao3.a(n3, polygon);
            }
            if (hashMap.containsKey(n7)) {
                ((ao)hashMap.get(n7)).a(ao3);
                continue;
            }
            hashMap.put(n7, ao3);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            int n4 = (Integer)entry.getKey();
            ao ao4 = (ao)entry.getValue();
            if (n4 != 0 && n4 != 2) continue;
            ao2.a(ao4);
        }
        ao ao5 = new ao(presentationType);
        for (Map.Entry entry : hashMap.entrySet()) {
            ao ao6 = (ao)entry.getValue();
            int n5 = (Integer)entry.getKey();
            if (n5 != 1) continue;
            ao5.a(ao6);
        }
        ao2.b(ao5);
        PolygonContour polygonContour = new PolygonContour(presentationType);
        Iterator iterator3 = ao2.a.keySet().iterator();
        while (iterator3.hasNext()) {
            int n6 = (Integer)iterator3.next();
            for (Polygon polygon : ao2.a.get((Object)n6)) {
                Object object;
                object = Lists.newArrayList();
                for (Coordinate coordinate : polygon.getExteriorRing().getCoordinates()) {
                    object.add(new Point2f((float)coordinate.x, (float)coordinate.y));
                }
                polygonContour.a(n6, new Polylines.VoxelPolyline2f((List<Point2f>)object, presentationType, new Point3f.PointVolumeInfo(simpleImageFrame)));
                for (int i2 = 0; i2 < polygon.getNumInteriorRing(); ++i2) {
                    ArrayList arrayList = Lists.newArrayList();
                    for (Coordinate coordinate : polygon.getInteriorRingN(i2).getCoordinates()) {
                        arrayList.add(new Point2f((float)coordinate.x, (float)coordinate.y));
                    }
                    polygonContour.a(n6, new Polylines.VoxelPolyline2f(arrayList, presentationType, new Point3f.PointVolumeInfo(simpleImageFrame)));
                }
            }
        }
        return polygonContour;
    }
}

