/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.Lists;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.util.ay;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class ByteArrayDataProvider
extends LoaderDataProvider {
    List<String> fileNames;
    List<byte[]> filesInMemory;
    boolean isDataZipped = false;

    public ByteArrayDataProvider(String string, byte[] byArray) {
        this.fileNames = Lists.newArrayList((Object[])new String[]{string});
        this.filesInMemory = Lists.newArrayList((Object[])new byte[][]{byArray});
    }

    public ByteArrayDataProvider(List<String> list, List<byte[]> list2) {
        this.fileNames = list;
        this.filesInMemory = list2;
    }

    public void setDataZipped(boolean bl2) {
        this.isDataZipped = bl2;
    }

    public void cleanRefs() {
        this.fileNames = null;
        this.filesInMemory = null;
    }

    @Override
    public List<String> getFilenames() {
        return Lists.newArrayList(this.fileNames);
    }

    @Override
    public InputStream getStream(String string) {
        InputStream inputStream = new ByteArrayInputStream(this.filesInMemory.get(this.fileNames.indexOf(string)));
        if (this.isDataZipped) {
            try {
                inputStream = new GZIPInputStream(inputStream);
            }
            catch (IOException iOException) {
                ay.d((Object)"Error.", (Throwable)iOException, ByteArrayDataProvider.class);
                return null;
            }
        }
        return inputStream;
    }
}

