/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import com.jayway.jsonpath.Filter;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.a;
import com.mimvista.commands.keyboard.bk;
import com.mimvista.d;
import com.mimvista.dicom.DicomImageConverter;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.read.Dicom2DLoader;
import com.mimvista.dicom.read.DicomLoaderBase;
import com.mimvista.dicom.read.DicomLoadingUtility;
import com.mimvista.dicom.read.DicomProgressHandlerJimmy;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.PixelDataExtractor;
import com.mimvista.dicom.read.ShadyProgressInputStream;
import com.mimvista.dicom.read.SimpleDicomVolumeLoaderImpl;
import com.mimvista.dicom.util.DicomRLEDecompressor;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.internals.PlanarImage;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.x;
import com.mimvista.numerics.ColorSpaceUtility;
import com.mimvista.preferencesNew.NukesPrefs0;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.bt;
import com.mimvista.util.cn;
import com.mimvista.util.logging.MIMLogLevel;
import com.mimvista.util.logging.a.c;
import com.mimvista.util.logging.k;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.NMSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.dcm4che2.data.DicomObject;

@a
public class Dicom2DLoaderImpl<PIType extends PlanarImage>
extends DicomLoaderBase
implements Dicom2DLoader<PIType> {
    protected String path;
    protected boolean isSuccess;
    protected ArrayList<PIType> images;
    public static Messages props = Messages.a("General");
    private static c log = ay.b(Dicom2DLoaderImpl.class);
    private boolean hasBadSlices = false;
    protected x loaderPrefs = new x();
    private final int PROGRESS_MULTIPLIER = 100;

    public void load(Progress progress, File[] fileArray) {
        this.load(progress, new LoaderDataProvider.FileBasedLoaderDataProvider(fileArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Progress progress, LoaderDataProvider loaderDataProvider) {
        bt.a((Object)this, loaderDataProvider);
        if (this.images == null) {
            this.images = new ArrayList();
        } else {
            this.images.clear();
        }
        this.loaderPrefs.e.defaultGantryAnswer = false;
        if (this.loaderPrefs.e.askAboutGantryTilt == null) {
            this.loaderPrefs.e.askAboutGantryTilt = true;
        }
        this.isSuccess = false;
        List<String> list = loaderDataProvider.getFilenames();
        int n2 = list.size();
        progress.a(n2 * 100);
        progress.a();
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = MIMFormat.a(props.getProperty("LOAD_SLICE_LABEL"), String.valueOf(i2 + 1), String.valueOf(n2));
            progress.b_((String)object);
            String string = list.get(i2);
            InputStream inputStream = loaderDataProvider.getStream(string);
            ShadyProgressInputStream shadyProgressInputStream = new ShadyProgressInputStream(inputStream);
            DicomProgressHandlerJimmy dicomProgressHandlerJimmy = new DicomProgressHandlerJimmy(progress, shadyProgressInputStream, 100);
            try {
                ay.a((Object)"loading 2D image...", this);
                DicomReader.DicomReadResult dicomReadResult = DicomReader.readStreamIntoDicom(shadyProgressInputStream, new DicomReader.DicomReadParams().setHandler(dicomProgressHandlerJimmy).setAllowPartialPixelData(true));
                if (dicomReadResult == null) continue;
                dicomReadResult.dob = this.applyDicomObjectFilters(dicomReadResult.dob);
                if (dicomReadResult.wasMissingPixelData) {
                    this.hasBadSlices = true;
                }
                LoadResult loadResult = this.initializeNewImage(dicomReadResult.dob);
                arrayList.add(loadResult);
                k k2 = new k();
                for (PlanarImage planarImage : loadResult.imgs) {
                    planarImage.b(this.computeDicomCenter(dicomReadResult.dob, planarImage, k2));
                    if (dicomReadResult.dob.containsValue(0x200032)) {
                        planarImage.K();
                    } else {
                        DicomObject dicomObject = dicomReadResult.dob.getNestedDicomObject(5505058);
                        if (dicomObject != null && dicomObject.containsValue(0x200032)) {
                            planarImage.K();
                        }
                    }
                    SimpleDicomVolumeLoaderImpl.adjustUnitsForVolume(planarImage);
                }
                k2.a(MIMLogLevel.b, this);
                continue;
            }
            catch (Exception exception) {
                ay.d((Object)"Loading 2D image", (Throwable)exception, this);
                continue;
            }
            finally {
                progress.b(100 * (i2 + 1));
            }
        }
        Collections.sort(arrayList, new Comparator<LoadResult>(){

            @Override
            public int compare(LoadResult loadResult, LoadResult loadResult2) {
                int n2 = loadResult2.acqNumber - loadResult.acqNumber;
                if (n2 == 0) {
                    n2 = loadResult2.imageIndex - loadResult.imageIndex;
                }
                if (n2 == 0) {
                    n2 = loadResult2.instanceNumber - loadResult.instanceNumber;
                }
                return n2;
            }
        });
        for (Object object : arrayList) {
            this.images.addAll(((LoadResult)object).imgs);
        }
        if (!MIMContext.P() && !this.loaderPrefs.c && this.hasBadSlices) {
            MOptionPane.b(SeriesInfo.g, Messages.a("General", "DICOMLOADER_BAD_SLICES"), Messages.a("General", "DICOMLOADER_ERROR"), 0);
        }
        this.isSuccess = this.images.size() > 0;
        progress.b();
    }

    @Override
    public boolean isSuccessfullyLoaded() {
        return this.isSuccess;
    }

    @Override
    public ArrayList<PIType> getImages() {
        if (this.images == null) {
            return null;
        }
        return Lists.newArrayList(this.images);
    }

    @Override
    public void setLoaderPrefs(x x2) {
        this.loaderPrefs = x2;
    }

    private float[] read2DSpacingTags(DicomObject dicomObject, ImmutableList<Integer> immutableList) {
        for (Integer n2 : immutableList) {
            float[] fArray = dicomObject.getFloats(n2.intValue());
            if (fArray == null || fArray.length < 2 || !(fArray[0] > 0.0f) || !(fArray[1] > 0.0f)) continue;
            float[] fArray2 = new float[2];
            fArray2[1] = fArray[0];
            fArray2[0] = fArray[1];
            return fArray2;
        }
        return null;
    }

    protected LoadResult initializeNewImage(DicomObject dicomObject) {
        int n2;
        Object object;
        int n3;
        LoadResult loadResult = new LoadResult();
        if (dicomObject == null) {
            return loadResult;
        }
        SeriesInfo seriesInfo = DicomLoadingUtility.getSeriesInfo(dicomObject, this.loaderPrefs);
        int n4 = dicomObject.getInt(0x280008, 1);
        loadResult.acqNumber = dicomObject.getInt(0x200012, -1);
        loadResult.instanceNumber = dicomObject.getInt(2097171, -1);
        loadResult.imageIndex = dicomObject.getInt(5509936, -1);
        PixelDataExtractor.RescaleParameters rescaleParameters = new PixelDataExtractor.RescaleParameters(seriesInfo.rescale.slope, seriesInfo.rescale.intercept, null);
        ByteBuffer byteBuffer = this.extractData(dicomObject, rescaleParameters);
        if (byteBuffer == null) {
            try {
                DicomObject dicomObject2 = DicomReader.saveOutToTempFileAndDecompress(dicomObject);
                if (dicomObject2 != null) {
                    dicomObject = dicomObject2;
                    byteBuffer = this.extractData(dicomObject2, rescaleParameters);
                }
            }
            catch (IOException iOException) {
                log.a((Object)"Tried to decompress data, but was unsuccessful: ", iOException);
            }
        }
        seriesInfo.rescale.slope = rescaleParameters.slope;
        seriesInfo.rescale.intercept = rescaleParameters.intercept;
        int n5 = seriesInfo.bitsAlloc / 8;
        int n6 = seriesInfo.samplesPerPix * n5;
        if (n6 > 1) {
            seriesInfo.bitSigned = true;
        }
        int[] nArray = new int[]{dicomObject.getInt(2621457, 0), dicomObject.getInt(2621456, 0)};
        int n7 = seriesInfo.samplesPerPix == 1 ? nArray[0] * nArray[1] * 2 : nArray[0] * nArray[1] * n6;
        int n8 = byteBuffer.capacity() / n4;
        int[] nArray2 = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        byteBuffer.rewind();
        for (n3 = 0; n3 < n4; ++n3) {
            Object object2;
            PIType PIType = this.getNewPlanarImage();
            ((PlanarImage)PIType).a(n4 > 1);
            ((PlanarImage)PIType).a(n3);
            ((PlanarImage)PIType).a(nArray);
            Object object3 = DicomLoadingUtility.getPixSpacingOrder(dicomObject);
            if (object3 == null) {
                object3 = this.read2DSpacingTags(dicomObject, (ImmutableList<Integer>)ImmutableList.of((Object)1577316, (Object)1581072, (Object)805437457));
            }
            if (object3 == null) {
                object2 = dicomObject;
                if (dicomObject.contains(1597457) && !dicomObject.contains(1597484) && !dicomObject.contains(1597486) && (object = dicomObject.getNestedDicomObject(1597457)).contains(1597484) && object.contains(1597486)) {
                    object2 = object;
                }
                double d2 = object2.getDouble(1597484, -1.0);
                double d3 = object2.getDouble(1597486, -1.0);
                if (d2 > 0.0 && d3 > 0.0) {
                    object3 = new float[]{(float)(d2 * 10.0), (float)(d3 * 10.0)};
                }
            }
            if (object3 == null || object3[0] == 0.0f || object3[1] == 0.0f) {
                object3 = new float[]{1.0f, 1.0f};
                seriesInfo.spacingAvailable = false;
            } else {
                seriesInfo.spacingAvailable = true;
            }
            ((PlanarImage)PIType).a((float[])object3);
            object2 = seriesInfo.m();
            ((SeriesInfo)object2).a(((SeriesInfo)object2).y().clone());
            ((PlanarImage)PIType).b((SeriesInfo)object2);
            object = new byte[n7];
            n2 = n7;
            if (n2 > byteBuffer.remaining()) {
                n2 = byteBuffer.remaining();
                this.hasBadSlices = true;
            }
            byteBuffer.get((byte[])object, 0, n2);
            ByteBuffer byteBuffer2 = ByteBuffer.wrap((byte[])object);
            byteBuffer2.order(byteBuffer.order());
            ((PlanarImage)PIType).a(byteBuffer2);
            if (seriesInfo.samplesPerPix == 1) {
                int[] nArray3 = ((PlanarImage)PIType).F();
                if (nArray3[0] < nArray2[0]) {
                    nArray2[0] = nArray3[0];
                }
                if (nArray3[1] > nArray2[1]) {
                    nArray2[1] = nArray3[1];
                }
            }
            loadResult.imgs.add(PIType);
        }
        n3 = 1;
        if (n3 != 0) {
            for (Object object3 : loadResult.imgs) {
                if (((PlanarImage)object3).D()) continue;
                SimpleDicomVolumeLoaderImpl.possiblyRescaleVolumeWithVeryFewValues(((PlanarImage)object3).getUncopiedMutableInfo(), nArray2);
                int n9 = ((PlanarImage)object3).getUncopiedMutableInfo().scalingFactorFromOriginal;
                if (n9 == 1) continue;
                object = ((PlanarImage)object3).al_();
                for (n2 = 0; n2 < ((Buffer)object).limit(); ++n2) {
                    short s2 = ((ShortBuffer)object).get(n2);
                    ((ShortBuffer)object).put(n2, (short)((float)s2 * (float)n9));
                }
                ((PlanarImage)object3).E();
                ((PlanarImage)object3).F();
            }
        }
        return loadResult;
    }

    protected PIType getNewPlanarImage() {
        return (PIType)new PlanarImage();
    }

    protected ByteBuffer extractData(DicomObject dicomObject, PixelDataExtractor.RescaleParameters rescaleParameters) {
        int n2 = dicomObject.getInt(0x280002, 1);
        if (n2 == 1) {
            short[] sArray = PixelDataExtractor.extractPixelData(dicomObject, rescaleParameters);
            this.adjustDataRange(sArray, rescaleParameters);
            ShortBuffer shortBuffer = ShortBuffer.wrap(sArray);
            ByteBuffer byteBuffer = ByteBuffer.allocate(sArray.length * 2);
            ShortBuffer shortBuffer2 = byteBuffer.asShortBuffer();
            while (shortBuffer.hasRemaining()) {
                shortBuffer2.put(shortBuffer.get());
            }
            byteBuffer.rewind();
            return byteBuffer;
        }
        ByteBuffer byteBuffer = null;
        ByteBuffer byteBuffer2 = null;
        ByteOrder byteOrder = dicomObject.bigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        DicomObject dicomObject2 = dicomObject.fileMetaInfo();
        if (dicomObject2 != null) {
            String string = dicomObject2.getString(131088);
            if (string != null && DicomJpegDecompressor.isJpegCompressed(string)) {
                byte[] byArray = DicomJpegDecompressor.getBGRArrayFromDataset(dicomObject);
                if (byArray == null) {
                    return null;
                }
                byteBuffer = ByteBuffer.allocate(byArray.length);
                byteBuffer.order(byteOrder);
                for (byte by2 : byArray) {
                    byteBuffer.put(by2);
                }
                return byteBuffer;
            }
            if (DicomRLEDecompressor.isRLECompressed(string)) {
                byteBuffer2 = ByteBuffer.wrap(DicomRLEDecompressor.getPixelDataFromCompressedRLEDicomObject(dicomObject));
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if ("1.2.840.10008.1.2".equals(string) || "1.2.840.10008.1.2.1".equals(string)) {
                byteOrder = ByteOrder.LITTLE_ENDIAN;
            } else if ("1.2.840.10008.1.2.2".equals(string)) {
                byteOrder = ByteOrder.BIG_ENDIAN;
            }
        }
        int n3 = dicomObject.getInt(2621696);
        int n4 = dicomObject.getInt(2621697);
        int n5 = dicomObject.getInt(2621446, 0);
        String string = dicomObject.getString(2621444, "");
        if (byteBuffer2 == null) {
            byteBuffer2 = ByteBuffer.wrap(dicomObject.getBytes(2145386512, byteOrder == ByteOrder.BIG_ENDIAN));
        }
        byteBuffer2.order(byteOrder);
        if (n4 > n3) {
            ay.c((Object)"Bits Stored shouldn't be larger than Bits Allocated!", this);
            n4 = n3;
        }
        if (n2 == 1) {
            throw new IllegalStateException("How did you get here?");
        }
        if (n2 == 3) {
            switch (n3) {
                case 8: {
                    byteBuffer = DicomImageConverter.adjustRGBFormat(byteBuffer2, byteOrder, n2, n3, n5, string);
                    ColorSpaceUtility.a(byteBuffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported bits width for color image: " + String.valueOf(n3));
                }
            }
        }
        if (byteBuffer != null) {
            byteBuffer.rewind();
        }
        return byteBuffer;
    }

    protected int[] getVolMinMaxDuringLoad(short[] sArray) {
        int[] nArray = new int[]{Short.MAX_VALUE, Short.MIN_VALUE};
        for (int n2 : sArray) {
            if (n2 < nArray[0]) {
                nArray[0] = n2;
                continue;
            }
            if (n2 <= nArray[1]) continue;
            nArray[1] = n2;
        }
        return nArray;
    }

    protected void adjustDataRange(short[] sArray, PixelDataExtractor.RescaleParameters rescaleParameters) {
        block3: {
            int n2;
            int n3;
            int n4;
            int n5;
            block2: {
                n5 = 0;
                n4 = 31767;
                int[] nArray = this.getVolMinMaxDuringLoad(sArray);
                n3 = nArray[1];
                if (n3 - (n2 = nArray[0]) > n4 - n5) break block2;
                if (n2 >= n5) break block3;
                rescaleParameters.intercept += (float)(n2 - n5) * rescaleParameters.slope;
                int n6 = n2 - n5;
                int n7 = 0;
                while (n7 < sArray.length) {
                    int n8 = n7++;
                    sArray[n8] = (short)(sArray[n8] - n6);
                }
                break block3;
            }
            float f2 = (float)(n3 - n2) / (float)(n4 - n5);
            float f3 = (float)n2 * rescaleParameters.slope;
            float f4 = (float)n5 * rescaleParameters.slope * f2;
            rescaleParameters.intercept += f3 - f4;
            rescaleParameters.slope *= f2;
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                sArray[i2] = (short)Math.round((float)(sArray[i2] - n2) / f2 + (float)n5);
            }
        }
    }

    public static float[] determineIppLikePre655Mim(DicomSeries dicomSeries) {
        float[] fArray = Dicom2DLoaderImpl.getIppFromRootTagIfPresent(dicomSeries);
        if (fArray == null) {
            fArray = new float[]{0.0f, 0.0f, 0.0f};
        }
        return fArray;
    }

    public static float[] determineBestIpp(DicomSeries dicomSeries, SimpleImageFrame simpleImageFrame, @d StringBuilder stringBuilder) {
        float[] fArray = Dicom2DLoaderImpl.getIppFromRootTagIfPresent(dicomSeries);
        if (fArray == null) {
            fArray = Dicom2DLoaderImpl.getIppFromDetectorInfoIfPresent(dicomSeries, simpleImageFrame);
        }
        if (fArray == null) {
            fArray = new float[]{0.0f, 0.0f, 0.0f};
            if (stringBuilder != null) {
                stringBuilder.append("ImagePositionPatient information is unavailable. ");
                stringBuilder.append("We'll use the default value to calculate DICOM center. ");
            }
        }
        return fArray;
    }

    public static float[] getIppFromRootTagIfPresent(DicomSeries dicomSeries) {
        ImmutableList immutableList = dicomSeries.getTagValues(0x200032);
        if (immutableList.size() != 3) {
            return null;
        }
        return Floats.toArray(immutableList);
    }

    public static float[] getIppFromDetectorInfoIfPresent(DicomSeries dicomSeries, SimpleImageFrame simpleImageFrame) {
        ImmutableList<? extends DicomSeries> immutableList;
        int n2;
        ImmutableList immutableList2 = dicomSeries.getTagValues(5505056);
        if (immutableList2.isEmpty()) {
            return null;
        }
        int n3 = simpleImageFrame.c();
        if (n3 >= 0 && n3 < immutableList2.size() && (n2 = ((Integer)immutableList2.get(n3)).intValue()) >= 1 && (immutableList = dicomSeries.getTagSequence(5505058)) != null && n2 <= immutableList.size()) {
            DicomSeries dicomSeries2 = (DicomSeries)immutableList.get(n2 - 1);
            return Dicom2DLoaderImpl.getIppFromRootTagIfPresent(dicomSeries2);
        }
        return null;
    }

    public static float[] computeDicomCenter(float[] fArray, float[] fArray2, float[] fArray3, int[] nArray) {
        float[] fArray4 = (float[])fArray.clone();
        float f2 = (float)(nArray[0] - 1) * fArray3[0] / 2.0f;
        fArray4[0] = fArray4[0] + f2 * fArray2[0];
        fArray4[1] = fArray4[1] + f2 * fArray2[1];
        fArray4[2] = fArray4[2] + f2 * fArray2[2];
        float f3 = (float)(nArray[1] - 1) * fArray3[1] / 2.0f;
        fArray4[0] = fArray4[0] + f3 * fArray2[3];
        fArray4[1] = fArray4[1] + f3 * fArray2[4];
        fArray4[2] = fArray4[2] + f3 * fArray2[5];
        return fArray4;
    }

    protected float[] computeDicomCenter(DicomObject dicomObject, PIType PIType, k k2) {
        StringBuilder stringBuilder = new StringBuilder();
        float[] fArray = Dicom2DLoaderImpl.determineBestIpp(new JsonDicomSeries(dicomObject), PIType, stringBuilder);
        SeriesInfo seriesInfo = ((PlanarImage)PIType).getUncopiedMutableInfo();
        float[] fArray2 = seriesInfo.imageOrientation;
        if (fArray2 == null || fArray2.length != 6 || seriesInfo.imageOrientationWasBlank) {
            stringBuilder.append("ImageOrientationPatient information is unavailable. ");
            stringBuilder.append("We'll use the default value to calculate DICOM center. ");
            seriesInfo.imageOrientation = fArray2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
            seriesInfo.origImageOrientation = (float[])fArray2.clone();
            seriesInfo.acqOrientation = SimpleOrientationHelper.c(fArray2, seriesInfo.a(this.loaderPrefs.e));
        }
        k2.a(stringBuilder.toString());
        return Dicom2DLoaderImpl.computeDicomCenter(fArray, fArray2, ((PlanarImage)PIType).b(), ((PlanarImage)PIType).a());
    }

    private static bk guessIopBasedOnStrings(List<String> list) {
        HashSet hashSet = Sets.newHashSet();
        for (int i2 = 0; i2 < 2; ++i2) {
            boolean bl2 = i2 == 0;
            for (String string : list) {
                hashSet.addAll(Dicom2DLoaderImpl.getMatchingNmOrientations(string, bl2));
            }
            if (hashSet.isEmpty()) continue;
            if (hashSet.size() > 1) {
                ay.c((Object)("Image seems to have conflicting orientation labels.  Matched orientations: " + hashSet + " Values we used: " + list), Dicom2DLoader.class);
                return null;
            }
            return (bk)hashSet.iterator().next();
        }
        return null;
    }

    public static bk tryToGuessCorrectIop(SimpleImageFrame simpleImageFrame, boolean bl2) {
        bk bk2;
        String[] stringArray;
        String string = simpleImageFrame.getUncopiedMutableInfo().seriesDesc;
        if (NukesPrefs0.guessOrientationBasedOnColonSeparatedSeriesDesc.getValue().booleanValue() && !cn.h(string) && (stringArray = string.split(":")).length == 4 && (bk2 = Dicom2DLoaderImpl.guessIopBasedOnStrings(Lists.newArrayList((Object[])new String[]{stringArray[0]}))) != null) {
            return bk2;
        }
        stringArray = Dicom2DLoaderImpl.getPossibleOrientationIdentifyingStrings(simpleImageFrame, bl2);
        return Dicom2DLoaderImpl.guessIopBasedOnStrings(stringArray);
    }

    public static List<bk> getMatchingNmOrientations(String string, boolean bl2) {
        List<bk> list = bk.a();
        ArrayList arrayList = Lists.newArrayList();
        string = string.toLowerCase();
        for (bk bk2 : list) {
            if (!bk2.a(string, bl2)) continue;
            arrayList.add(bk2);
        }
        return arrayList;
    }

    public static List<String> getPossibleOrientationIdentifyingStrings(SimpleImageFrame simpleImageFrame, boolean bl2) {
        HashSet hashSet = Sets.newHashSet();
        SeriesInfo seriesInfo = simpleImageFrame.getUncopiedMutableInfo();
        JsonDicomSeries jsonDicomSeries = seriesInfo.y();
        boolean bl3 = true;
        ModalitySeriesInfo modalitySeriesInfo = seriesInfo.modInfo;
        NMSeriesInfo nMSeriesInfo = null;
        if (modalitySeriesInfo != null && modalitySeriesInfo.c()) {
            nMSeriesInfo = modalitySeriesInfo.d();
        }
        String string = (String)jsonDicomSeries.getTagValue(JsonPath.compile((String)TagUtils.toHexStringWithIndexes(0x540400), (Filter[])new Filter[0]));
        if (nMSeriesInfo != null) {
            if (string != null && nMSeriesInfo.e() && Dicom2DLoaderImpl.getMatchingNmOrientations(string, false).size() > 1) {
                bl3 = false;
            }
            if (nMSeriesInfo.numberOfDetectors > 1) {
                bl3 = false;
            }
        }
        if (bl3) {
            hashSet.add(string);
        }
        if (modalitySeriesInfo != null && modalitySeriesInfo.c()) {
            Object object;
            Integer n2;
            Integer n3 = modalitySeriesInfo.d().a(simpleImageFrame.c());
            if (n3 != null) {
                n2 = n3;
                n3 = Integer.valueOf(n3 - 1);
                object = n3;
            }
            if ((n2 = bl2 ? Integer.valueOf(0) : n3) != null) {
                object = (String)jsonDicomSeries.getTagValue(JsonPath.compile((String)TagUtils.toHexStringWithIndexes(5505058, n2, 5505568, 0, 524548), (Filter[])new Filter[0]));
                hashSet.add(object);
                String string2 = (String)jsonDicomSeries.getTagValue(JsonPath.compile((String)TagUtils.toHexStringWithIndexes(5505058, n2, 5505568, 0, 524544), (Filter[])new Filter[0]));
                hashSet.add(string2);
            }
            object = jsonDicomSeries.getTagValues(0x111012, String.class);
            if (n3 != null && object != null && object.size() > n3 && n3 >= 0) {
                hashSet.add(object.get(n3.intValue()));
            }
        }
        hashSet.remove(null);
        return Lists.newArrayList((Iterable)hashSet);
    }

    private class LoadResult {
        List<PIType> imgs = Lists.newArrayList();
        int acqNumber = -1;
        int instanceNumber = -1;
        int imageIndex = -1;

        private LoadResult() {
        }
    }
}

