/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mimvista.archive.NameFormatter;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomBundle;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.SeriesIdentifier;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.read.FileExcluder;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.dicom.read.RadionuclideCodeValueMapping;
import com.mimvista.dicom.read.RadiopharmaceuticalCodeValueMapping;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.internals.FrameNumber;
import com.mimvista.internals.PresetWindowLevel;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.fusionmode.FusionModeType;
import com.mimvista.internals.x;
import com.mimvista.numerics.IOP;
import com.mimvista.preferences.al;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.viewer.CTSeriesInfo;
import com.mimvista.viewer.DOCSeriesInfo;
import com.mimvista.viewer.DXSeriesInfo;
import com.mimvista.viewer.MRSeriesInfo;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.NMSeriesInfo;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.RTImageSeriesInfo;
import com.mimvista.viewer.RTSeriesInfo;
import com.mimvista.viewer.RegSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.SurfSegSeriesInfo;
import com.mimvista.viewer.USSeriesInfo;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.vecmath.Vector3d;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.UIDUtils;

public class DicomLoadingUtility {
    public static Messages props = Messages.a("viewer");
    private static final double IOPOrthogonalityTolerance = 1.745E-4;
    private static final double IOPNormalizedLengthTolerance = 0.002;

    private DicomLoadingUtility() {
    }

    public static float[] getPixSpacingOrder(DicomObject dicomObject) {
        float[] fArray = dicomObject.getFloats(2621488, (float[])null);
        if (fArray == null || fArray.length == 0) {
            fArray = dicomObject.getFloats(new int[]{1375769129, 0, 2658576, 0, 2621488}, (float[])null);
        }
        if (fArray == null || fArray.length == 0) {
            return null;
        }
        fArray = (float[])fArray.clone();
        boolean bl2 = "RTdose".equalsIgnoreCase(dicomObject.getString(524384, "")) ? true : !DicomLoadingUtility.isBeforePixSpacingCorrectionVersion(dicomObject);
        if (bl2) {
            float f2 = fArray[0];
            fArray[0] = fArray[1];
            fArray[1] = f2;
        }
        return fArray;
    }

    private static boolean isBeforePixSpacingCorrectionVersion(DicomObject dicomObject) {
        String string = dicomObject.getString(524400, "").toLowerCase();
        if (string.contains("mim")) {
            String string2 = dicomObject.getString(131091, "");
            String string3 = "(MIM\\s+)(\\d)\\.(\\d)\\.(\\d).*";
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string2);
            if (matcher.matches()) {
                int n2 = 0;
                int n3 = 0;
                try {
                    n2 = Integer.parseInt(matcher.group(2));
                    n3 = Integer.parseInt(matcher.group(3));
                }
                catch (Exception exception) {
                    return false;
                }
                if (n2 < 5 || n2 == 5 && n3 < 3) {
                    return true;
                }
            }
        }
        return false;
    }

    public static SeriesInfo createFuzzySeriesInfoFromPath(String string) {
        File file = new File(string);
        File[] fileArray = file.listFiles(new FileExcluder().getFilenameFilter());
        DicomObject dicomObject = null;
        SeriesInfo seriesInfo = null;
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.isFile() || dicomObject != null) continue;
                dicomObject = DicomReader.readFileIntoDicomObject(file2, 2145386512);
                if (dicomObject != null && !dicomObject.isEmpty()) {
                    seriesInfo = DicomLoadingUtility.getSeriesInfo(dicomObject, new x());
                    if (seriesInfo == null) continue;
                    return seriesInfo;
                }
                dicomObject = null;
            }
        }
        return seriesInfo;
    }

    public static DicomObject derivedStrippedDicomObject(DicomObject dicomObject) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomObject.accept(new DicomObject.Visitor((DicomObject)basicDicomObject){
            final /* synthetic */ DicomObject val$copy;
            {
                this.val$copy = dicomObject;
            }

            public boolean visit(DicomElement dicomElement) {
                if (dicomElement.tag() >= 2145386512) {
                    return true;
                }
                if (dicomElement.tag() == 4325393) {
                    return true;
                }
                if (dicomElement.length() > 20000) {
                    return true;
                }
                if (dicomElement.vr() == VR.SQ) {
                    for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                        DicomObject dicomObject = DicomLoadingUtility.derivedStrippedDicomObject(dicomElement.getDicomObject(i2));
                        DicomElement dicomElement2 = this.val$copy.putSequence(dicomElement.tag());
                        dicomElement2.addDicomObject(dicomObject);
                        this.val$copy.add(dicomElement2);
                    }
                    return true;
                }
                this.val$copy.add(dicomElement);
                return true;
            }
        });
        return basicDicomObject;
    }

    public static SeriesInfo createFuzzySeriesInfoFromFiles(List<? extends File> list) {
        DicomObject dicomObject = null;
        SeriesInfo seriesInfo = null;
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String string;
                File file = list.get(i2);
                if (!file.isFile() || (string = file.getName()).toLowerCase().endsWith(".xml") || string.toLowerCase().endsWith(".xfm") || string.toLowerCase().endsWith(".mim") || string.toLowerCase().endsWith(".txt") || dicomObject != null) continue;
                dicomObject = DicomReader.readFileIntoDicomObject(file, 2145386512);
                if (dicomObject != null && !dicomObject.isEmpty()) {
                    seriesInfo = DicomLoadingUtility.getSeriesInfo(dicomObject, new x());
                    continue;
                }
                dicomObject = null;
            }
        }
        return seriesInfo;
    }

    public static SeriesInfo getSeriesInfo(DicomObject dicomObject) {
        return DicomLoadingUtility.getSeriesInfo(dicomObject, new x());
    }

    public static SeriesInfo getSeriesInfo(DicomObject object, x x2) {
        Object object2;
        if (object.isEmpty()) {
            throw new IllegalArgumentException("shouldn't have an empty dataset");
        }
        if (!(object instanceof NonCrashyDicomObject)) {
            object2 = new NonCrashyDicomObject();
            object.copyTo((DicomObject)object2, false);
            object = object2;
        }
        object2 = new SeriesInfo();
        DicomLoadingUtility.loadDicomInfo((SeriesInfo)object2, object, x2);
        NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
        DicomObject dicomObject = object.subSet(0, 2145386511);
        dicomObject.copyTo((DicomObject)nonCrashyDicomObject, false);
        ((SeriesInfo)object2).a(new JsonDicomSeries((DicomObject)nonCrashyDicomObject));
        ((SeriesInfo)object2).a(new JsonDicomBundle((DicomObject)nonCrashyDicomObject));
        return object2;
    }

    public static void loadDicomInfo(SeriesInfo seriesInfo, DicomObject dicomObject, x x2) {
        DicomReader.sanitizeDicomObject(dicomObject);
        DicomLoadingUtility.readSeriesIdentificationData(seriesInfo, dicomObject);
        DicomLoadingUtility.readPatientData(seriesInfo, dicomObject);
        DicomLoadingUtility.readDatesAndTimes(seriesInfo, dicomObject);
        DicomLoadingUtility.readImageMetadata(seriesInfo, dicomObject);
        DicomLoadingUtility.readAcquisitionData(seriesInfo, dicomObject);
        DicomLoadingUtility.readContrastData(seriesInfo, dicomObject);
        DicomLoadingUtility.loadModalitySpecificTags(seriesInfo, dicomObject);
        if (dicomObject.containsValue(928055632)) {
            seriesInfo.reSlicerProducedVolume = true;
        }
        if (dicomObject.containsValue(928059392)) {
            seriesInfo.b(dicomObject.getFloats(928059392));
        }
        if (dicomObject.containsValue(930291992)) {
            seriesInfo.a(dicomObject.getNestedDicomObject(930291992));
        }
        if (dicomObject.contains(930295847)) {
            seriesInfo.wasModifiedByDICOMReadFilter = true;
        }
        DicomLoadingUtility.loadRadPharmValues(seriesInfo, dicomObject);
        DicomLoadingUtility.processVolumeOrientations(seriesInfo, x2);
    }

    private static void readSeriesIdentificationData(SeriesInfo seriesInfo, DicomObject dicomObject) {
        String[] stringArray;
        seriesInfo.studyID = dicomObject.getString(0x200010, "");
        seriesInfo.studyUID = dicomObject.getString(0x20000D, "");
        seriesInfo.j(dicomObject.getString(0x20000E));
        seriesInfo.sopClassUID = dicomObject.getString(524310, "");
        seriesInfo.sopInstanceUID = dicomObject.getString(524312, "");
        seriesInfo.transferSyntaxUID = dicomObject.getString(131088, "");
        seriesInfo.frameOfRefUID = dicomObject.getString(0x200052);
        if (seriesInfo.frameOfRefUID == null || seriesInfo.frameOfRefUID.isEmpty()) {
            stringArray = UIDUtils.createUID((String)"2.16.840.1.114362.1");
            seriesInfo.frameOfRefUID = stringArray;
            seriesInfo.missingFrameOfReference = true;
        }
        seriesInfo.accession = dicomObject.getString(524368, "");
        seriesInfo.instanceNum = dicomObject.getInt(2097171, 1);
        seriesInfo.seriesNumber = dicomObject.getString(0x200011, "");
        seriesInfo.acquisitionNumber = dicomObject.getString(0x200012, "");
        seriesInfo.studyDesc = dicomObject.getString(528432, "");
        seriesInfo.seriesDesc = dicomObject.getString(528446, "");
        seriesInfo.doseComment = dicomObject.getString(805568518, "");
        seriesInfo.imageComments = dicomObject.getString(0x204000, "");
        seriesInfo.seriesName = seriesInfo.modality + " - " + dicomObject.getString(528446, seriesInfo.ag());
        seriesInfo.numberOfSlices = dicomObject.getInt(5505153, -1);
        if (seriesInfo.numberOfSlices == -1) {
            seriesInfo.numberOfSlices = dicomObject.getInt(0x280008, 1);
        }
        if ((stringArray = dicomObject.getStrings(5509120)) != null) {
            seriesInfo.seriesType = cn.a(stringArray, "\\");
            seriesInfo.seriesType = seriesInfo.seriesType.toUpperCase();
        }
        seriesInfo.origModality = seriesInfo.modality = dicomObject.getString(524384, "");
        if ("1.2.840.10008.5.1.4.1.1.128".equals(seriesInfo.sopClassUID)) {
            seriesInfo.modality = "PT";
        } else if ("1.2.840.10008.5.1.4.1.1.2".equals(seriesInfo.sopClassUID)) {
            seriesInfo.modality = "CT";
        } else if ("1.2.840.10008.5.1.4.1.1.7".equals(seriesInfo.sopClassUID) || "1.2.840.10008.5.1.4.1.1.7.4".equals(seriesInfo.sopClassUID)) {
            seriesInfo.modality = "OT";
        }
    }

    private static void readPatientData(SeriesInfo seriesInfo, DicomObject dicomObject) {
        seriesInfo.patientId = dicomObject.getString(0x100020, ".");
        seriesInfo.patientNameRaw = DicomLoadingUtility.extractPatientName(dicomObject);
        seriesInfo.patientName = NameFormatter.a(seriesInfo.patientNameRaw);
        seriesInfo.b(dicomObject.getString(0x101010, ""));
        seriesInfo.birthDate = dicomObject.getString(0x100030, "");
        seriesInfo.originalSex = seriesInfo.sex = dicomObject.getString(0x100040, "");
        seriesInfo.originalWeight = seriesInfo.weight = dicomObject.getFloat(0x101030);
        seriesInfo.originalPatientSize = seriesInfo.patientSize = dicomObject.getFloat(0x101020);
        seriesInfo.referringPhysRaw = dicomObject.getString(524432, "");
        seriesInfo.referringPhys = NameFormatter.a(seriesInfo.referringPhysRaw);
        seriesInfo.institutionName = dicomObject.getString(524416, "");
        seriesInfo.operatorName = dicomObject.getString(528496, "");
        seriesInfo.stationName = dicomObject.getString(528400, "");
        seriesInfo.bodyPartExamined = dicomObject.getString(1572885, "");
        seriesInfo.requestedProcedureDesc = dicomObject.getString(3280992, "");
        seriesInfo.performedProcedureStepDesc = dicomObject.getString(4194900, "");
        seriesInfo.protocolName = dicomObject.getString(1577008, "");
        seriesInfo.heartRate = dicomObject.getString(0x181088, "");
        seriesInfo.lowRRValue = dicomObject.getInt(0x181081, -1);
        seriesInfo.highRRValue = dicomObject.getInt(1577090, -1);
        seriesInfo.intervalsAcquired = (int)Math.round(Double.valueOf(dicomObject.getString(1577091, "-1")));
        seriesInfo.intervalsRejected = dicomObject.getInt(1577092, -1);
    }

    private static void readDatesAndTimes(SeriesInfo seriesInfo, DicomObject dicomObject) {
        String string;
        seriesInfo.originalAcqTime = seriesInfo.acqTime = dicomObject.getDate(524338);
        seriesInfo.originalAcqDate = seriesInfo.acqDate = dicomObject.getDate(524322);
        seriesInfo.e(RawDicomUtils.readProperDateForPatientList(dicomObject));
        seriesInfo.contentDate = dicomObject.getString(524323, "");
        seriesInfo.contentTime = dicomObject.getString(524339, "");
        String string2 = "00000000";
        String string3 = dicomObject.getString(524320, string2);
        seriesInfo.d(string3);
        if (string2.equals(string3)) {
            seriesInfo.hasStudyDate = false;
        }
        seriesInfo.studyTime = DateUtils.l(dicomObject.getString(524336));
        seriesInfo.studyTimeRaw = dicomObject.getString(524336, "000000");
        seriesInfo.f(dicomObject.getString(524337, dicomObject.getString(524338, dicomObject.getString(805699593, dicomObject.getString(524336, dicomObject.getString(524339, "000000"))))));
        if (seriesInfo.P().length() > 6) {
            seriesInfo.f(seriesInfo.P().substring(0, 6));
        }
        if ((string = DicomLoadingUtility.getBestSeriesDateString(dicomObject)) == null) {
            string = seriesInfo.N();
        }
        seriesInfo.c(string);
        seriesInfo.seriesTimeDate = DicomLoadingUtility.getBestSeriesDate(dicomObject);
    }

    public static Date getBestSeriesDate(DicomObject dicomObject) {
        Date date = null;
        Date date2 = null;
        for (Pair<Integer, Integer> cloneable : DicomLoadingUtility.getDateAndTimeTagsToExamineForSeriesDate()) {
            date = dicomObject.getDate(((Integer)cloneable.x).intValue(), (Date)null);
            if (date == null) continue;
            String string = dicomObject.getString(((Integer)cloneable.y).intValue(), "000000");
            if (string.length() > 6) {
                string = string.substring(0, 6);
            }
            date2 = DateUtils.l(string);
            break;
        }
        if (date != null && date2 != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date2);
            calendar.set(11, calendar2.get(11));
            calendar.set(12, calendar2.get(12));
            calendar.set(13, calendar2.getActualMaximum(13));
            date = calendar.getTime();
        }
        return date;
    }

    public static String getBestSeriesDateString(DicomObject dicomObject) {
        Integer n2;
        String string = null;
        Iterator<Integer> iterator = DicomLoadingUtility.getTagsToExamineForSeriesDate().iterator();
        while (iterator.hasNext() && (string = dicomObject.getString((n2 = iterator.next()).intValue(), (String)null)) == null) {
        }
        return string;
    }

    public static List<Pair<Integer, Integer>> getDateAndTimeTagsToExamineForSeriesDate() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(Pair.get(524321, 524337));
        builder.add(Pair.get(524322, 524338));
        builder.add(Pair.get(805699592, 805699593));
        builder.add(Pair.get(524320, 524336));
        builder.add(Pair.get(524323, 524339));
        return builder.build();
    }

    public static List<Integer> getTagsToExamineForSeriesDate() {
        return Lists.transform(DicomLoadingUtility.getDateAndTimeTagsToExamineForSeriesDate(), (Function)new Function<Pair<Integer, Integer>, Integer>(){

            public Integer apply(Pair<Integer, Integer> pair) {
                return (Integer)pair.x;
            }
        });
    }

    private static void readImageMetadata(SeriesInfo seriesInfo, DicomObject dicomObject) {
        Object object;
        String[] stringArray;
        seriesInfo.bitSigned = dicomObject.getInt(2621699, 1) == 1;
        seriesInfo.bitsAlloc = dicomObject.getInt(2621696);
        seriesInfo.bitsStored = dicomObject.getInt(2621697);
        seriesInfo.highBit = dicomObject.getInt(2621698);
        seriesInfo.samplesPerPix = dicomObject.getInt(0x280002, 1);
        seriesInfo.planarConfig = dicomObject.getInt(2621446, 0);
        seriesInfo.lossyCompression = dicomObject.getString(2629904, "");
        seriesInfo.scatterCorrection = dicomObject.getString(5509381, "");
        seriesInfo.photometricInterp = dicomObject.getString(2621444, "").toUpperCase();
        String[] stringArray2 = dicomObject.getStrings(524296);
        if (stringArray2 != null) {
            seriesInfo.imageType = cn.a(stringArray2, "\\");
            seriesInfo.imageType = seriesInfo.imageType.toUpperCase();
        }
        seriesInfo.correctedImage = (stringArray = dicomObject.getStrings(2621521)) != null && stringArray.length > 0 ? cn.a(stringArray, ",") : "";
        seriesInfo.derivationDescription = dicomObject.getString(532753, "");
        String[] stringArray3 = RawDicomUtils.readCodeSequence(dicomObject, new int[]{561685});
        if (stringArray3 != null && (stringArray3.length > 1 && "113062".equals(stringArray3[1]) || stringArray3.length > 2 && stringArray3[2] != null && stringArray3[2].toLowerCase().contains("subtraction"))) {
            seriesInfo.derivationCodeIndicatesSubtraction = true;
        }
        DicomLoadingUtility.fillCompositedFromInfo(seriesInfo, dicomObject);
        seriesInfo.gantryDetectorTilt = DicomLoadingUtility.readGantryDetectorTilt(seriesInfo, dicomObject);
        boolean bl2 = false;
        if (dicomObject.contains(0x200032)) {
            bl2 = true;
        } else {
            object = dicomObject.getNestedDicomObject(5505058);
            if (object != null && object.containsValue(0x200032)) {
                bl2 = true;
            }
        }
        seriesInfo.hasImagePositionPatient = bl2;
        object = DicomLoadingUtility.readIOP(dicomObject);
        if (object != null) {
            seriesInfo.origImageOrientation = (float[])object.clone();
        } else {
            seriesInfo.imageOrientationWasBlank = true;
            ay.b((Object)"No ImageOrientation was present in the DICOM file.", DicomLoadingUtility.class);
        }
        String string = dicomObject.getString(1593600, "");
        seriesInfo.origPatientPosition = SimpleOrientationHelper.PatientPosition.a(string);
        seriesInfo.nativeShortAxis = DicomLoadingUtility.isNativeShortAxis(dicomObject);
        seriesInfo.laterality = dicomObject.getString(0x200060, "");
        seriesInfo.imageLaterality = dicomObject.getString(0x200062, "");
        DicomObject dicomObject2 = dicomObject.getNestedDicomObject(0x37733007);
        if (dicomObject2 != null) {
            seriesInfo.alignedToVolumeStudyUID = dicomObject2.getString(0x20000D, (String)null);
            seriesInfo.alignedToVolumeSeriesUID = dicomObject2.getString(0x20000E, (String)null);
        }
    }

    private static void fillCompositedFromInfo(SeriesInfo seriesInfo, DicomObject dicomObject) {
        try {
            String string = dicomObject.getString(928055553, (String)null);
            if (string != null) {
                seriesInfo.compositedFrom = FusionModeType.valueOf(string);
            } else if (seriesInfo.seriesDesc != null) {
                for (FusionModeType fusionModeType : FusionModeType.values()) {
                    if (!seriesInfo.seriesDesc.contains(fusionModeType.getExternalizedString())) continue;
                    seriesInfo.compositedFrom = fusionModeType;
                    break;
                }
            }
            float f2 = dicomObject.getFloat(0x37733000, Float.NaN);
            float f3 = dicomObject.getFloat(930295809, Float.NaN);
            float f4 = dicomObject.getFloat(930295810, Float.NaN);
            if (!(Float.isNaN(f2) || Float.isNaN(f3) || Float.isNaN(f4))) {
                seriesInfo.clusterParams = new SeriesInfo.ClusterAnalysisParams();
                seriesInfo.clusterParams.smoothFWHM = f2;
                seriesInfo.clusterParams.stddev = f3;
                seriesInfo.clusterParams.pValue = f4;
            }
        }
        catch (Exception exception) {
            ay.d((Object)"Error determining FusionModeType", (Throwable)exception, DicomLoadingUtility.class);
        }
    }

    private static boolean isNativeShortAxis(DicomObject dicomObject) {
        if ("APEX_TO_BASE".equals(dicomObject.getString(0x540500, ""))) {
            return true;
        }
        String[] stringArray = RawDicomUtils.readCodeSequence(dicomObject, new int[]{5505568});
        if (stringArray == null) {
            stringArray = RawDicomUtils.readCodeSequence(dicomObject, new int[]{5505058, 0, 5505568});
        }
        return stringArray != null && "G-A186".equals(stringArray[1]);
    }

    private static void readAcquisitionData(SeriesInfo seriesInfo, DicomObject dicomObject) {
        seriesInfo.manufacturer = dicomObject.getString(524400, "");
        seriesInfo.modelName = dicomObject.getString(528528, "");
        seriesInfo.softwareVersions = dicomObject.getString(1576992, "");
        seriesInfo.actualFrameDuration = dicomObject.getInt(1577538, 0);
        seriesInfo.hasFrameReferenceTime = dicomObject.contains(5509888);
        seriesInfo.frameReferenceTime = dicomObject.getFloat(5509888, 0.0f);
        seriesInfo.scanDuration = dicomObject.getFloat(1577059, 0.0f);
        seriesInfo.numOfTemporalPositions = dicomObject.getInt(2097413, -1);
        seriesInfo.numOfTimeSlots = dicomObject.getInt(5505137, -1);
        seriesInfo.temporalPositionID = dicomObject.getInt(0x200100, -1);
        seriesInfo.triggerTime = dicomObject.getFloat(1577056, -1.0f);
        seriesInfo.frameTime = dicomObject.getFloat(1577059, -1.0f);
        seriesInfo.angularViewVector = dicomObject.getString(5505168, "");
        seriesInfo.frameTimeVector = dicomObject.getString(1577061, "");
        seriesInfo.rotationVector = dicomObject.getString(0x540050, "");
        seriesInfo.numberOfFramesInRotation = dicomObject.getInt(new int[]{5505106, 0, 5505107}, 0);
        seriesInfo.numberOfRotations = dicomObject.getInt(5505105, 0);
        seriesInfo.gePrivatePctRpeakDelay = DicomReader.parseIntegerTag(dicomObject, 4526131);
        seriesInfo.gePrivateReconstructionMatrix = DicomReader.parseIntegerTag(dicomObject, 4395065);
        seriesInfo.philipsPrivatePhaseNumber = DicomReader.parseIntegerTag(dicomObject, 536940552);
        if (dicomObject.contains(930308098)) {
            seriesInfo.binnedID = dicomObject.getInt(930308096, VR.IS);
            seriesInfo.numOfBins = dicomObject.getInt(930308098, VR.IS);
            seriesInfo.binNum = dicomObject.getInt(930308097, VR.IS);
            seriesInfo.binDesc = dicomObject.getString(930308099, VR.SH);
            seriesInfo.frameNumFromSeriesDesc = new FrameNumber(seriesInfo.binNum);
            seriesInfo.maxFramesFromSeriesDesc = seriesInfo.numOfBins;
        }
        seriesInfo.current = dicomObject.getString(0x181151, "");
        seriesInfo.echoTime = dicomObject.getString(0x180081, "");
        seriesInfo.exposure = dicomObject.getString(1577298, "");
        seriesInfo.exposureTime = dicomObject.getString(1577296, "");
        seriesInfo.fieldStrength = dicomObject.getString(1572999, "");
        seriesInfo.filterType = dicomObject.getString(1577312, "");
        seriesInfo.kvp = dicomObject.getString(1572960, "");
        seriesInfo.repititionTime = dicomObject.getString(0x180080, "");
        seriesInfo.scanningSequence = dicomObject.getString(1572896, "");
        seriesInfo.scanOptions = dicomObject.getString(1572898, "");
        seriesInfo.sequenceName = dicomObject.getString(1572900, "");
        seriesInfo.sequenceVariant = dicomObject.getString(1572897, "");
        seriesInfo.decayCorrection = dicomObject.getString(5509378, "NONE");
        seriesInfo.priPositionerAngle = Float.valueOf(dicomObject.getFloat(1578256));
        seriesInfo.secPositionerAngle = Float.valueOf(dicomObject.getFloat(0x181511));
        seriesInfo.priPositionerAngleInc = dicomObject.getFloats(1578272);
        seriesInfo.secPositionerAngleInc = dicomObject.getFloats(1578273);
    }

    private static void readContrastData(SeriesInfo seriesInfo, DicomObject dicomObject) {
        String string;
        Object object;
        Object object2 = "";
        object2 = "CT".equalsIgnoreCase(seriesInfo.modality) ? (!cn.h((String)(object = dicomObject.getString(2625620, (String)null))) ? object : (!cn.h(string = dicomObject.getString(5509121, (String)null)) ? string : "HU")) : dicomObject.getString(5509121, "");
        seriesInfo.rescale.slope = dicomObject.getFloat(2625619, 1.0f);
        if (seriesInfo.rescale.slope == 0.0f) {
            seriesInfo.rescale.slope = 1.0f;
            object2 = "UNKNOWN";
        }
        seriesInfo.rescale.intercept = dicomObject.getFloat(2625618, 0.0f);
        if (dicomObject.getInt(0x280002, 0) == 1) {
            seriesInfo.windowWidth = dicomObject.getFloat(2625617, 0.0f);
            seriesInfo.windowCenter = dicomObject.getFloat(2625616, 0.0f);
            seriesInfo.presetsFromDICOM = DicomLoadingUtility.loadPresetsFromDICOM(dicomObject);
        }
        if (seriesInfo.sopClassUID.equals("1.2.840.10008.5.1.4.1.1.20") && (object = DicomLoadingUtility.readRealWorldValueMapping(dicomObject)) != null) {
            seriesInfo.rescale.slope = (float)((RealWorldValueMapping)object).slope;
            seriesInfo.rescale.intercept = (float)((RealWorldValueMapping)object).intercept;
            object2 = ((RealWorldValueMapping)object).units;
        }
        seriesInfo.u().a((String)object2);
    }

    public static RealWorldValueMapping readRealWorldValueMapping(DicomObject dicomObject) {
        DicomElement dicomElement;
        DicomObject dicomObject2;
        Object object;
        DicomObject dicomObject3 = null;
        DicomElement dicomElement2 = dicomObject.get(4231318);
        if (dicomElement2 != null) {
            dicomObject3 = dicomElement2.getDicomObject();
        }
        if (dicomObject3 == null && (object = dicomObject.get(0x409094)) != null && (dicomObject2 = object.getDicomObject()) != null && (dicomElement = dicomObject2.get(4231318)) != null) {
            dicomObject3 = dicomElement.getDicomObject();
        }
        if (dicomObject3 != null) {
            String string;
            object = new RealWorldValueMapping();
            object.slope = (float)dicomObject3.getDouble(4231717, 1.0);
            object.intercept = (float)dicomObject3.getDouble(4231716, 0.0);
            dicomObject2 = dicomObject3.get(4196586);
            if (dicomObject2 != null && (dicomElement = dicomObject2.getDicomObject()) != null && (string = dicomElement.getString(524544, (String)null)) != null) {
                object.units = DataUnitUtils.convertRealWorldValueMappingUnitCode(string);
            }
            return object;
        }
        return null;
    }

    private static void loadRadPharmValues(SeriesInfo seriesInfo, DicomObject dicomObject) {
        Object object;
        String string;
        String string2;
        Object object2;
        if ("PT".equals(seriesInfo.modality) && seriesInfo.manufacturer.toLowerCase().contains("philips") && seriesInfo.u().a(DataUnitUtils.COUNTS_CANON_)) {
            float f2;
            object2 = dicomObject.getBytes(1884491785);
            if (object2 != null && ((byte[])object2).length > 0) {
                f2 = Float.valueOf(new String((byte[])object2)).floatValue();
                if (f2 != 0.0f) {
                    seriesInfo.u().a("BQML");
                }
            } else {
                object2 = dicomObject.getBytes(1884491776);
                if (object2 != null && ((byte[])object2).length > 0 && (f2 = Float.valueOf(new String((byte[])object2)).floatValue()) != 0.0f) {
                    seriesInfo.philipsSuvScalingTag = f2;
                }
            }
        }
        seriesInfo.originalWeight = dicomObject.getFloat(0x101030, 0.0f);
        seriesInfo.weight = Float.valueOf(seriesInfo.weight).isNaN() ? seriesInfo.originalWeight : seriesInfo.weight;
        object2 = dicomObject.getNestedDicomObject(5505046);
        Object object3 = dicomObject;
        if (object2 != null) {
            object3 = object2;
        }
        seriesInfo.originalDose = object3.getFloat(1577076, Float.NaN);
        if ("NM".equals(dicomObject.getString(524384)) && !Float.isNaN(seriesInfo.originalDose) && seriesInfo.originalDose > 0.0f && seriesInfo.originalDose < 10000.0f) {
            seriesInfo.originalDose *= 1000000.0f;
        }
        seriesInfo.dose = Float.valueOf(seriesInfo.dose).isNaN() ? seriesInfo.originalDose : seriesInfo.dose;
        seriesInfo.startDate = DicomLoadingUtility.getRadiopharmStartDateTimeTag(seriesInfo, object3);
        seriesInfo.originalStartTime = seriesInfo.originalStartDate = DateUtils.a(object3, 1577080);
        if (seriesInfo.originalStartTime == null) {
            seriesInfo.originalStartTime = object3.getDate(1577074);
        }
        seriesInfo.startTime = seriesInfo.startTime == null ? seriesInfo.originalStartTime : seriesInfo.startTime;
        seriesInfo.originalHalfLife = object3.getFloat(1577077, Float.NaN);
        seriesInfo.halflife = Float.valueOf(seriesInfo.halflife).isNaN() ? seriesInfo.originalHalfLife : seriesInfo.halflife;
        seriesInfo.reconstructionMethod = dicomObject.getString(5509379, "");
        seriesInfo.countsSource = dicomObject.getString(5509122, "");
        DicomObject dicomObject2 = object3.getNestedDicomObject(5505796);
        if (dicomObject2 == null) {
            dicomObject2 = dicomObject.getNestedDicomObject(5505796);
        }
        if (dicomObject2 != null) {
            seriesInfo.radPharmCode = string2 = dicomObject2.getString(524544, "");
            string = RadiopharmaceuticalCodeValueMapping.getMeaningForValue(string2);
            seriesInfo.radpharm = string != null ? string : dicomObject2.getString(524548, "");
        }
        if (cn.h(seriesInfo.radpharm)) {
            seriesInfo.radpharm = object3.getString(1572913, dicomObject.getString(1572913, ""));
        }
        if ((string2 = object3.getNestedDicomObject(5505792)) == null) {
            string2 = dicomObject.getNestedDicomObject(5505792);
        }
        if (string2 != null) {
            string = string2.getString(524544, "");
            object = RadionuclideCodeValueMapping.getMeaningForValue(string);
            if (object != null) {
                seriesInfo.h((String)object);
            } else {
                seriesInfo.h(string2.getString(524548, ""));
            }
        }
        string = dicomObject.getString(930308352);
        object = dicomObject.getDate(930308353);
        if (!cn.h(string)) {
            seriesInfo.u().a(1.0f, ((Date)object).getTime(), string, string);
            seriesInfo.d(true);
        }
    }

    private static Date getRadiopharmStartDateTimeTag(SeriesInfo seriesInfo, DicomObject dicomObject) {
        Cloneable cloneable;
        Date date = DateUtils.a(dicomObject, 1577080);
        if (date != null) {
            return date;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        date = seriesInfo.acqDate;
        if (date == null) {
            try {
                date = simpleDateFormat.parse(seriesInfo.M());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            try {
                date = simpleDateFormat.parse(seriesInfo.N());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        if (date == null) {
            date = new Date();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Date date2 = dicomObject.getDate(1577074);
        if (date2 != null) {
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTime(date2);
            n2 = ((Calendar)cloneable).get(11);
            n3 = ((Calendar)cloneable).get(12);
            n4 = ((Calendar)cloneable).get(13);
        } else if (seriesInfo.acqTime != null) {
            ay.b((Object)("No RadiopharmaceuticalStartTime, trying acq time... " + seriesInfo.seriesDesc), "SUV");
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTime(seriesInfo.acqTime);
            n2 = ((Calendar)cloneable).get(11);
            n3 = ((Calendar)cloneable).get(12);
            n4 = ((Calendar)cloneable).get(13);
        } else if (seriesInfo.P() != null) {
            ay.b((Object)("No RadiopharmaceuticalStartTime, trying series time... " + seriesInfo.seriesDesc), "SUV");
            cloneable = new SimpleDateFormat("HH");
            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("mm");
            SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("ss");
            try {
                n2 = Integer.valueOf(((Format)cloneable).format(seriesInfo.P()));
                n3 = Integer.valueOf(simpleDateFormat2.format(seriesInfo.P()));
                n4 = Integer.valueOf(simpleDateFormat3.format(seriesInfo.P()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        } else if (seriesInfo.studyTime != null) {
            ay.b((Object)("No RadiopharmaceuticalStartTime, trying study time... " + seriesInfo.seriesDesc), "SUV");
            cloneable = Calendar.getInstance();
            ((Calendar)cloneable).setTime(seriesInfo.studyTime);
            n2 = ((Calendar)cloneable).get(11);
            n3 = ((Calendar)cloneable).get(12);
            n4 = ((Calendar)cloneable).get(13);
        }
        cloneable = Calendar.getInstance();
        ((Calendar)cloneable).setTime(date);
        ((Calendar)cloneable).set(11, n2);
        ((Calendar)cloneable).set(12, n3);
        ((Calendar)cloneable).set(13, n4);
        return ((Calendar)cloneable).getTime();
    }

    private static String extractPatientName(DicomObject dicomObject) {
        String string = dicomObject.getString(0x100010, "");
        if (!DicomPrefs.encodeNonAsciiNames.getValue().booleanValue()) {
            return string;
        }
        if (!NameFormatter.f(string)) {
            return string;
        }
        String string2 = DicomPrefs.fallbackEncoding.getValue();
        try {
            String string3 = NameFormatter.a(dicomObject, string2);
            return string3;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static void loadModalitySpecificTags(SeriesInfo seriesInfo, DicomObject dicomObject) {
        Modality modality = Modality.getModalityForSopClass(seriesInfo.sopClassUID);
        if (modality == Modality.CT) {
            seriesInfo.modInfo = new CTSeriesInfo(dicomObject, seriesInfo);
        } else if (modality == Modality.MR) {
            seriesInfo.modInfo = new MRSeriesInfo(dicomObject);
        } else if (modality == Modality.PT) {
            seriesInfo.modInfo = new PTSeriesInfo(dicomObject, seriesInfo);
        } else if (modality == Modality.NM) {
            seriesInfo.modInfo = new NMSeriesInfo(dicomObject);
            if (seriesInfo.missingFrameOfReference) {
                seriesInfo.frameOfRefUID = UIDGenerator.getOrSetFrameOfRefUidForSop(seriesInfo.sopInstanceUID, seriesInfo.frameOfRefUID);
            }
        } else {
            seriesInfo.modInfo = modality == Modality.CR || modality == Modality.DX ? new DXSeriesInfo(dicomObject) : (modality == Modality.RTST || modality == Modality.RTPLAN || !cn.h(dicomObject.getString(930291986)) ? new RTSeriesInfo(dicomObject) : (modality == Modality.RTDOSE ? new RTDoseSeriesInfo(dicomObject) : (modality == Modality.REG || SeriesIdentifier.isFinding(seriesInfo) ? new RegSeriesInfo(dicomObject) : (modality == Modality.US ? new USSeriesInfo(dicomObject) : (modality == Modality.RTIMAGE ? new RTImageSeriesInfo(dicomObject, seriesInfo) : (SeriesIdentifier.isEncapsulatedByMIM(dicomObject) ? new DOCSeriesInfo(dicomObject) : (modality == Modality.SEG ? new SurfSegSeriesInfo(dicomObject) : new ModalitySeriesInfo.StubModalitySeriesInfo())))))));
        }
    }

    private static Float readGantryDetectorTilt(SeriesInfo seriesInfo, DicomObject dicomObject) {
        String string = dicomObject.getString(1577248, "");
        if (string != null && !"".equals(string)) {
            try {
                double d2 = Double.parseDouble(string);
                int n2 = (int)Math.floor(d2) / 360;
                d2 -= (double)(n2 * 360);
                if (d2 > -90.0 && d2 < 90.0) {
                    if (d2 == 0.0) {
                        return null;
                    }
                    return Float.valueOf((float)d2);
                }
                System.out.println("Gantry detector tilt present but out of acceptable range: " + d2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Series appears to have gantry tilt, but can't parse " + seriesInfo.gantryDetectorTilt);
            }
        }
        return null;
    }

    public static void processVolumeOrientations(SeriesInfo seriesInfo, x x2) {
        float[] fArray = seriesInfo.origImageOrientation;
        seriesInfo.imageOrientation = fArray == null ? null : (float[])fArray.clone();
        seriesInfo.h(false);
        seriesInfo.acqOrientation = SimpleOrientationHelper.c(seriesInfo.imageOrientation, seriesInfo.a(x2));
        if (seriesInfo.imageOrientation == null) {
            seriesInfo.imageOrientation = SimpleOrientationHelper.a();
            System.out.println("Orientation DICOM tags bad or missing. Defaulting to HFS.");
        } else {
            seriesInfo.h(true);
        }
    }

    public static float[] readIOP(DicomObject dicomObject) {
        return DicomLoadingUtility.readIOP(new JsonDicomSeries(dicomObject));
    }

    public static float[] readIOP(DicomSeries dicomSeries) {
        IOP iOP;
        Object object;
        ImmutableList immutableList = dicomSeries.getTagValues(2097207);
        if (immutableList.isEmpty() && (object = (DicomSeries)dicomSeries.getTagValue(5505058)) != null) {
            immutableList = object.getTagValues(2097207);
        }
        object = null;
        if (!immutableList.isEmpty()) {
            object = Floats.toArray(immutableList);
        }
        if ((object = (Object)DicomLoadingUtility.validateIOP((float[])object)) == null && (iOP = SimpleOrientationHelper.a(dicomSeries)) != null) {
            object = IOP.b(iOP);
        }
        return object;
    }

    private static float[] validateIOP(float[] fArray) {
        if (fArray != null) {
            if (fArray.length == 6) {
                Vector3d vector3d = new Vector3d((double)fArray[0], (double)fArray[1], (double)fArray[2]);
                Vector3d vector3d2 = new Vector3d((double)fArray[3], (double)fArray[4], (double)fArray[5]);
                double d2 = vector3d.length();
                double d3 = vector3d2.length();
                double d4 = vector3d.dot(vector3d2);
                if (d2 == 0.0 || d3 == 0.0) {
                    ay.a((Object)("ImageOrientationPatient has zero-length component: " + Arrays.toString(fArray)), DicomLoadingUtility.class);
                    fArray = null;
                } else if (Math.abs(d4) > 1.745E-4) {
                    ay.a((Object)("ImageOrientationPatient vectors are non-orthogonal: " + Arrays.toString(fArray)), DicomLoadingUtility.class);
                    fArray = null;
                } else {
                    boolean bl2;
                    boolean bl3 = Math.abs(1.0 - d2) < 0.002;
                    boolean bl4 = bl2 = Math.abs(1.0 - d3) < 0.002;
                    if (!bl3 || !bl2) {
                        ay.a((Object)"ImageOrientationPatient value not normalized, correcting...", DicomLoadingUtility.class);
                        if (!bl3) {
                            vector3d.scale(1.0 / d2);
                        }
                        if (!bl2) {
                            vector3d2.scale(1.0 / d3);
                        }
                        float[] fArray2 = new float[]{(float)vector3d.x, (float)vector3d.y, (float)vector3d.z, (float)vector3d2.x, (float)vector3d2.y, (float)vector3d2.z};
                        ay.e((Object)("Original   ImageOrientationPatient: " + Arrays.toString(fArray)), DicomLoadingUtility.class);
                        ay.e((Object)("Normalized ImageOrientationPatient: " + Arrays.toString(fArray2)), DicomLoadingUtility.class);
                        fArray = fArray2;
                    }
                }
            } else {
                fArray = null;
            }
        }
        return fArray;
    }

    public static PresetWindowLevel[] loadPresetsFromDICOM(DicomObject dicomObject) {
        try {
            float[] fArray = dicomObject.getFloats(2625617);
            if (fArray == null && Float.isNaN((fArray = new float[]{dicomObject.getFloat(2625617, Float.NaN)})[0])) {
                fArray = null;
            }
            float[] fArray2 = dicomObject.getFloats(2625616);
            if (fArray == null || fArray2 == null) {
                return null;
            }
            String[] stringArray = dicomObject.getStrings(2625621);
            int n2 = Math.min(fArray.length, fArray2.length);
            if (n2 < 1) {
                return null;
            }
            PresetWindowLevel[] presetWindowLevelArray = new PresetWindowLevel[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = stringArray != null && i2 < stringArray.length ? stringArray[i2] : "PRESET " + (i2 + 1);
                presetWindowLevelArray[i2] = new PresetWindowLevel(string, fArray2[i2], fArray[i2], 1.0f);
            }
            return presetWindowLevelArray;
        }
        catch (Exception exception) {
            ay.d((Object)"Error reading preset window/level data in DICOM", (Throwable)exception, DicomLoadingUtility.class);
            return null;
        }
    }

    public static enum CrazySlopeStrategy implements al<CrazySlopeStrategy>
    {
        ALWAYS_DISCARD,
        ALWAYS_KEEP,
        PROMPT_USER_DISCARD_WHEN_HEADLESS,
        PROMPT_USER_KEEP_WHEN_HEADLESS;


        @Override
        public String getStringForPrefs() {
            return this.name();
        }

        @Override
        public String getExternalizedString() {
            return Messages.a("Dicom", "CRAZY_SLOPE_STRAT_" + this.name());
        }
    }

    public static class RealWorldValueMapping {
        double slope;
        double intercept;
        String units;
    }
}

