/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.read;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.commands.workflow.AssignRtImageOrientationCommand;
import com.mimvista.commands.workflow.EditViewLinkCommand;
import com.mimvista.commands.workflow.FusionCommand;
import com.mimvista.commands.workflow.SetViewableExtentsCommand;
import com.mimvista.commands.workflow.WorkflowCommand;
import com.mimvista.dicom.read.DicomRtStructLoader;
import com.mimvista.dicom.rtplan.Collimator;
import com.mimvista.dicom.rtplan.DicomBeamRecord;
import com.mimvista.dicom.rtplan.ReferencePoint;
import com.mimvista.dicom.rtplan.ReportableRtplanState;
import com.mimvista.dicom.rtplan.RtplanSessionState;
import com.mimvista.dicom.rtplan.RtplanStateManager;
import com.mimvista.dicom.rtplan.Wedge;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.ImageCapturer;
import com.mimvista.internals.DynamicVolumeRef;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.FusionViewControllerEdits;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.fusionmode.SecondaryRaycast.FusionModeDRR;
import com.mimvista.internals.linking.FORLinkHelper;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.internals.s;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.Session;
import com.mimvista.mui.ao;
import com.mimvista.mui.bc;
import com.mimvista.mui.bd;
import com.mimvista.mui.captures.Capture;
import com.mimvista.mui.captures.CaptureStorage;
import com.mimvista.mui.layout.HangingProtocol;
import com.mimvista.mui.layout.c;
import com.mimvista.mui.mouse.mode.ab;
import com.mimvista.mui.overlays.AbstractContourOverlayish;
import com.mimvista.mui.overlays.GhostableOverlay;
import com.mimvista.mui.overlays.OverlayCollection;
import com.mimvista.mui.overlays.Overlayish;
import com.mimvista.mui.overlays.OverlayishBase;
import com.mimvista.mui.overlays.PointContourOverlay;
import com.mimvista.mui.overlays.planreview.RTMLCOverlay;
import com.mimvista.mui.overlays.planreview.RTWedgeOverlay;
import com.mimvista.mui.presenters.protocol.AddPageGroupState;
import com.mimvista.mui.presenters.protocol.SeriesRemoveState;
import com.mimvista.mui.x;
import com.mimvista.mui.y;
import com.mimvista.mui.z;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.VoxelIndexPoint3f;
import com.mimvista.numerics.VoxelIndexPoint3i;
import com.mimvista.numerics.contourtools.l;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.preferencesNew.PlanReviewPrefs;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.MOptionPane;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.a;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMContext;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.viewer.RTImageSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomRTplanReader {
    private final ViewController viewController;
    private DicomObject dicom = null;

    public DicomRTplanReader(ViewController viewController, DicomObject dicomObject) {
        this.viewController = viewController;
        this.dicom = dicomObject;
    }

    public void load(Progress progress) {
        try {
            this.createIsocenterPointOverlays(progress);
            String string = this.dicom.getString(524312);
            if (RtplanStateManager.getForSession(this.viewController.g()).getState(string) == null) {
                if (DicomPrefs.loadRtPlanStateObject.getValue().booleanValue() && !this.isAMIMIsocenterRTPlan()) {
                    RtplanSessionState rtplanSessionState = this.loadRtPlanStateObject(true);
                    this.createPlanReviewElements(rtplanSessionState, progress);
                } else {
                    RtplanSessionState rtplanSessionState = this.loadRtPlanStateObject(false);
                    rtplanSessionState.invalidate();
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Reading RTplan", throwable, this);
        }
    }

    private boolean isAMIMIsocenterRTPlan() {
        boolean bl2 = this.dicom.getString(528528, "").toLowerCase().contains("mim");
        int n2 = this.dicom.getInt(new int[]{805961840, 0, 805961848}, 0);
        int n3 = this.dicom.getInt(new int[]{805961840, 0, 0x300A00A0}, 0);
        return bl2 && n2 == 0 && n3 == 0;
    }

    private void createIsocenterPointOverlays(Progress progress) throws RuntimeException {
        Object object;
        ImageFrame imageFrame;
        Object object2;
        Object object3;
        HashMap hashMap = Maps.newHashMap();
        if (this.dicom.contains(806162601)) {
            object3 = this.dicom.getFloats(806162601, VR.DS);
            if (object3 != null && ((DicomElement)object3).length >= 3) {
                Point3f point3f = new Point3f((float[])object3);
                hashMap.put(DicomRTplanReader.truncatePoint(point3f), point3f);
            }
        } else {
            object3 = this.dicom.get(805961904);
            if (object3 != null) {
                for (int i2 = 0; i2 < object3.countItems(); ++i2) {
                    DicomObject dicomObject = object3.getDicomObject(i2);
                    Point3f point3f = dicomObject.get(805962001);
                    if (point3f == null || (object2 = (Object)(imageFrame = point3f.getDicomObject()).getFloats(805962028, null)) == null || ((MetricPoint3f)object2).length < 3) continue;
                    object = new Point3f((float[])object2);
                    hashMap.put(DicomRTplanReader.truncatePoint((Point3f)((Object)object)), object);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        for (Point3f point3f : hashMap.values()) {
            imageFrame = this.viewController.aw();
            object2 = new DicomPoint3f((Tuple3f)point3f, (SimpleImageFrame)imageFrame).c();
            object = new PointContourOverlay(this.viewController, imageFrame, (MetricPoint3f)((Object)object2));
            ((GhostableOverlay)object).c("ISOCENTER");
            ((PointContourOverlay)object).a(OverlayishBase.InterpretedType.w);
            ((PointContourOverlay)object).f_(true);
            ((PointContourOverlay)object).a(l2);
            ((PointContourOverlay)object).b(l2);
            OverlayCollection overlayCollection = imageFrame.n();
            overlayCollection.a((Overlayish)object, false);
            overlayCollection.d((AbstractContourOverlayish)object);
        }
    }

    public static Point3i truncatePoint(Point3f point3f) {
        return new Point3i((int)(point3f.x * 1000.0f), (int)point3f.y * 1000, (int)point3f.z * 1000);
    }

    private RtplanSessionState loadRtPlanStateObject(boolean bl2) throws RuntimeException {
        Session session = this.viewController.g();
        RtplanSessionState rtplanSessionState = new RtplanSessionState(new DynamicVolumeRef(this.viewController), this.dicom);
        if (bl2) {
            boolean bl3;
            List<String> list = rtplanSessionState.getErrorMessages();
            boolean bl4 = bl3 = session.T() || MIMContext.P();
            if (list.size() != 0) {
                if (!bl3) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<HTML>");
                    stringBuilder.append(Messages.a("PlanReview", "PR_DISSAPOINTMENT"));
                    stringBuilder.append("<UL>");
                    for (String string : list) {
                        stringBuilder.append("<LI>" + string + "</LI>");
                    }
                    stringBuilder.append("</UL></HTML>");
                    MOptionPane.b(ao.Q().O(), stringBuilder.toString(), Messages.a("PlanReview", "PR_PLAN_LOADING_ERROR"), 0);
                }
                for (String string : list) {
                    ay.c((Object)string, DicomRtStructLoader.class);
                }
            }
        }
        RtplanStateManager.getForSession(session).addState(rtplanSessionState);
        return rtplanSessionState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanReviewElements(RtplanSessionState rtplanSessionState, Progress progress) throws RuntimeException {
        try {
            z z2;
            Object object;
            Object object22;
            Object object3;
            Iterator iterator;
            Object object4;
            ViewLink.ViewEvent[] viewEventArray;
            Session session = this.viewController.g();
            List<String> list = rtplanSessionState.getErrorMessages();
            if (list.size() > 0) {
                RtplanStateManager.getForSession(session).addErrorMessages(this.dicom.getString(524312), list);
                return;
            }
            ArrayList arrayList = Lists.newArrayList();
            MetricPoint3f metricPoint3f = new VoxelIndexPoint3f(new Point3f.PointVolumeInfo(this.viewController.aE())).d();
            MetricPoint3f metricPoint3f2 = new VoxelIndexPoint3i(this.viewController.ay(), new Point3f.PointVolumeInfo(this.viewController.aE())).a().d();
            ImmutableList<ReportableRtplanState.BeamRecord> immutableList = rtplanSessionState.getBeamRecords();
            progress.a(immutableList.size());
            for (Object object5 : rtplanSessionState.getBeamRecords()) {
                viewEventArray = (ViewLink.ViewEvent[])object5;
                object4 = this.createBeamRTImage((DicomBeamRecord)viewEventArray);
                ViewLoadState.LoadFromPseudoVolumeState loadFromPseudoVolumeState = new ViewLoadState.LoadFromPseudoVolumeState((SimpleImageVolume<ImageCube.ImageCubeShort>)object4, null, session);
                loadFromPseudoVolumeState.stamp();
                iterator = session.b(loadFromPseudoVolumeState.a);
                Object object6 = new FusionViewControllerEdits.FusionState((ViewController)((Object)iterator), this.viewController);
                ((FusionViewControllerEdits.FusionState)object6).a(FusionCommand.AlignmentMode.c);
                ((FusionViewControllerEdits.FusionState)object6).stamp();
                object3 = ((FusionViewControllerEdits.FusionState)object6).a();
                ((ViewController)object3).b(MatrixMultiplier.b(), false);
                object22 = new y((s)object3, new Rectangle(((ViewController)object3).ay()[0], ((ViewController)object3).ay()[1]), PresentationType.a);
                object = ((y)object22).a();
                z2 = ((y)object22).a((z)object, ((s)object3).b());
                object.f().a(true);
                z2.f().a(true);
                com.mimvista.mui.u u2 = (com.mimvista.mui.u)bd.e(PresentationType.a);
                u2.b((bc)object);
                u2.b(z2);
                FusionModeDRR fusionModeDRR = new FusionModeDRR();
                ImageSlice.ImageSliceShort imageSliceShort = fusionModeDRR.a((x)u2, z2);
                System.arraycopy(imageSliceShort.data, 0, ((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)((SimpleImageVolume)object4).ad()).f((int)0)).data, 0, ((short[])imageSliceShort.data).length);
                ViewLoadState.LoadFromPseudoVolumeState loadFromPseudoVolumeState2 = new ViewLoadState.LoadFromPseudoVolumeState((SimpleImageVolume<ImageCube.ImageCubeShort>)object4, null, session);
                loadFromPseudoVolumeState2.stamp();
                ViewController3D viewController3D = (ViewController3D)session.b(loadFromPseudoVolumeState2.a);
                viewController3D.aN();
                viewController3D.b(object5.getBeamName());
                viewController3D.o(true);
                arrayList.add(viewController3D);
                this.createAxialViewOverlays(rtplanSessionState, (ReportableRtplanState.BeamRecord)viewEventArray);
                SeriesRemoveState seriesRemoveState = new SeriesRemoveState((ViewController)object3);
                SeriesRemoveState seriesRemoveState2 = new SeriesRemoveState((ViewController)((Object)iterator));
                seriesRemoveState.stamp();
                seriesRemoveState2.stamp();
                MetricPoint3f metricPoint3f3 = viewEventArray.getCollimatorPosition().b(this.viewController.aw());
                metricPoint3f.set(MathUtils.b(metricPoint3f.f(), metricPoint3f3.f()));
                metricPoint3f2.set(MathUtils.a(metricPoint3f2.f(), metricPoint3f3.f()));
                rtplanSessionState.addDRR((ReportableRtplanState.BeamRecord)object5, viewController3D);
                progress.N_();
            }
            for (Object object5 : arrayList) {
                viewEventArray = new ViewLink.ViewEvent[]{ViewLink.ViewEvent.a, ViewLink.ViewEvent.b, ViewLink.ViewEvent.c, ViewLink.ViewEvent.e, ViewLink.ViewEvent.q, ViewLink.ViewEvent.p, ViewLink.ViewEvent.j, ViewLink.ViewEvent.l, ViewLink.ViewEvent.i, ViewLink.ViewEvent.k, ViewLink.ViewEvent.m, ViewLink.ViewEvent.n, ViewLink.ViewEvent.x};
                object4 = new EditViewLinkCommand(Collections.singletonList(object5), viewEventArray, false, false);
                ((WorkflowCommand)object4).setSession(session);
                ((EditViewLinkCommand)object4).execute();
            }
            FORLinkHelper.a(Lists.newArrayList((Object[])new Long[]{this.viewController.aV()}), session);
            Object object7 = metricPoint3f2.a();
            object7.add((Tuple3f)metricPoint3f);
            object7.scale(0.5f);
            metricPoint3f2.sub((Tuple3f)metricPoint3f);
            float f2 = MathUtils.F(metricPoint3f2.f());
            float f3 = (float)this.viewController.ay()[0] * this.viewController.ao_()[0];
            f2 = f2 > f3 ? (f2 - f3) / 2.0f + f3 : f2;
            object4 = new SetViewableExtentsCommand(this.viewController.bh(), f2);
            ((SetViewableExtentsCommand)object4).setCenter((MetricPoint3f)((Object)object7));
            ((SetViewableExtentsCommand)object4).execute();
            if (!PlanReviewPrefs.showAxialBeamOverlaysByDefault.getValue().booleanValue()) {
                float f4 = this.viewController.e(PresentationType.a);
                this.viewController.a(f4 * f4, new EditTargetInfo());
                rtplanSessionState.setAlwaysShowingSelectedBeam(false);
                for (Object object6 : rtplanSessionState.getBeamRecords()) {
                    rtplanSessionState.setBeamVisiblity((ReportableRtplanState.BeamRecord)object6, false);
                }
            }
            if (!session.T()) {
                HangingProtocol hangingProtocol = c.c("Plan_Review.mhp");
                hangingProtocol.c(Lists.newArrayList((Object[])new ViewController[]{this.viewController}));
                iterator = new AddPageGroupState(hangingProtocol, session);
                ((AddPageGroupState)((Object)iterator)).a(true, false);
            }
            if (rtplanSessionState.getBeamRecords().stream().filter(beamRecord -> !"setup".equalsIgnoreCase(((DicomBeamRecord)beamRecord).getTechnique())).anyMatch(beamRecord -> ((DicomBeamRecord)beamRecord).isUsingDefaultSTC())) {
                String string = MIMFormat.a(Messages.a("PlanReview", "PR_NO_STC_DISTANCE"), Float.valueOf(DicomBeamRecord.getDefaultSTC().inCM().getValue()));
                iterator = new BasicNotification(BasicNotification.NotificationType.b, string, new Notification.a(session));
                ((a)((Object)iterator)).setPriority(100);
                u.b().c((Notification)((Object)iterator));
            }
            HashMap hashMap = Maps.newHashMap();
            for (Object object6 : rtplanSessionState.getBeamRecords()) {
                for (Object object22 : object6.getReferencePoints()) {
                    object = ((ReferencePoint)object22).getLocation().c();
                    z2 = new Point3i((int)((MetricPoint3f)((Object)object)).x * 1000, (int)((MetricPoint3f)((Object)object)).y * 1000, (int)((MetricPoint3f)((Object)object)).z * 1000);
                    hashMap.put(Pair.get(z2, ((ReferencePoint)object22).getId()), object);
                }
            }
            for (Object object6 : hashMap.entrySet()) {
                object3 = (String)((Pair)object6.getKey()).y;
                if (object3 == null || ((String)object3).equals("")) continue;
                object22 = new PointContourOverlay(this.viewController, this.viewController.aw(), (MetricPoint3f)((Object)object6.getValue()));
                ((GhostableOverlay)object22).c(object3);
                this.viewController.ba().a((Overlayish)object22, false);
            }
            if (DcmSecondaryCapturePrefs.autoCaptureViewport.getValue().booleanValue()) {
                for (Object object6 : arrayList) {
                    object3 = ImageCapturer.captureViewPort((ViewController)object6, PresentationType.a, false);
                    SwingUtilities.invokeLater(() -> DicomRTplanReader.lambda$createPlanReviewElements$2(session, (Capture)object3));
                }
            }
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error parsing RtPlanStateObject", throwable, DicomRTplanReader.class);
        }
        finally {
            SwingUtilities.invokeLater(() -> ab.a(this.viewController));
        }
    }

    private ImageVolumeShort createBeamRTImage(DicomBeamRecord dicomBeamRecord) {
        DicomPoint3f dicomPoint3f = dicomBeamRecord.getIsocenter();
        SeriesInfo seriesInfo = this.viewController.bh().cw().getUncopiedMutableInfo().m();
        seriesInfo.modality = "RTIMAGE";
        seriesInfo.presetsFromDICOM = null;
        seriesInfo.e(false);
        float f2 = 1.0f;
        RTImageSeriesInfo rTImageSeriesInfo = new RTImageSeriesInfo(seriesInfo);
        rTImageSeriesInfo.isocenter = dicomPoint3f.f();
        rTImageSeriesInfo.hasIsocenter = true;
        rTImageSeriesInfo.sourceAxisDistance = dicomBeamRecord.getSourceAxisDistance().getValue();
        rTImageSeriesInfo.gantryAngle = dicomBeamRecord.getGantryAngle().getValue();
        rTImageSeriesInfo.referencedBeamNumber = dicomBeamRecord.getRefBeamNumber();
        rTImageSeriesInfo.referencedRTPlanSopInstanceUID = this.dicom.getString(524312);
        seriesInfo.modInfo = rTImageSeriesInfo;
        rTImageSeriesInfo.sourceImageDistance = Float.valueOf(dicomBeamRecord.getSourceAxisDistance().getValue());
        rTImageSeriesInfo.imagePlanePixelSpacing = new float[]{f2, f2};
        rTImageSeriesInfo.rtImageLabel = "MIM DRR for beam " + dicomBeamRecord.getBeamName();
        rTImageSeriesInfo.rtImageName = "MIM DRR " + dicomBeamRecord.getBeamName();
        rTImageSeriesInfo.rtImageDescription = "MIM generated DRR corresponding to beam " + dicomBeamRecord.getBeamName();
        rTImageSeriesInfo.conversionType = "WSD";
        rTImageSeriesInfo.rtImagePlane = "NORMAL";
        seriesInfo.seriesDesc = dicomBeamRecord.getBeamName() + " DRR";
        seriesInfo.imageType = "DERIVED\\SECONDARY\\DRR";
        ImageVolumeShort imageVolumeShort = new ImageVolumeShort();
        imageVolumeShort.b(seriesInfo);
        imageVolumeShort.d(true);
        imageVolumeShort.f(true);
        int[] nArray = this.viewController.bh().ay();
        imageVolumeShort.a(ImageCube.ImageCubeShort.b(new int[]{512, Math.max(512, nArray[2]), 1}));
        AssignRtImageOrientationCommand.assignOrientation(imageVolumeShort, dicomBeamRecord.getGantryAngle().getValue());
        imageVolumeShort.a(new float[]{f2, f2, f2});
        imageVolumeShort.b(dicomPoint3f.f());
        SliceInfo sliceInfo = new SliceInfo();
        sliceInfo.sopInstanceUID = UIDGenerator.generateUID();
        sliceInfo.sliceDicomCenter = dicomPoint3f.f();
        ((SimpleImageVolume)imageVolumeShort).a(Lists.newArrayList((Object[])new SliceInfo[]{sliceInfo}));
        return imageVolumeShort;
    }

    private void createAxialViewOverlays(RtplanSessionState rtplanSessionState, ReportableRtplanState.BeamRecord beamRecord) {
        RTMLCOverlay rTMLCOverlay = new RTMLCOverlay(this.viewController, beamRecord, beamRecord.getFirstMLCIndex());
        this.createWedgeOverlay(beamRecord, this.viewController);
        this.viewController.ba().a((Overlayish)rTMLCOverlay, false);
    }

    private void createWedgeOverlay(ReportableRtplanState.BeamRecord beamRecord, ViewController viewController) {
        for (Wedge wedge : beamRecord.getWedges()) {
            RTWedgeOverlay rTWedgeOverlay = new RTWedgeOverlay(viewController, beamRecord, wedge.getDirection().getValue());
            viewController.ba().a((Overlayish)rTWedgeOverlay, false);
        }
    }

    public static BeamsEyeMLCPoints getBeamsEyeMLCPoints(ReportableRtplanState.BeamRecord beamRecord) {
        return DicomRTplanReader.getBeamsEyeMLCPoints(beamRecord, -1, true);
    }

    public static BeamsEyeMLCPoints getBeamsEyeMLCPoints(ReportableRtplanState.BeamRecord beamRecord, int n2) {
        return DicomRTplanReader.getBeamsEyeMLCPoints(beamRecord, n2, true);
    }

    public static BeamsEyeMLCPoints getBeamsEyeMLCPoints(ReportableRtplanState.BeamRecord beamRecord, boolean bl2) {
        return DicomRTplanReader.getBeamsEyeMLCPoints(beamRecord, -1, bl2);
    }

    public static BeamsEyeMLCPoints getBeamsEyeMLCPoints(ReportableRtplanState.BeamRecord beamRecord, int n2, boolean bl2) {
        if (!beamRecord.hasValidMLC()) {
            return null;
        }
        Collimator.MultiLeafCollimator multiLeafCollimator = beamRecord.getFirstMLC();
        Collimator.CollimatorJaws collimatorJaws = beamRecord.getXJaws();
        Collimator.CollimatorJaws collimatorJaws2 = beamRecord.getYJaws();
        return DicomRTplanReader.getBeamsEyeMLCPoints(beamRecord, collimatorJaws.getTimePointByIndex(n2), collimatorJaws2.getTimePointByIndex(n2), multiLeafCollimator.getTimePointByIndex(n2), bl2);
    }

    public static BeamsEyeMLCPoints getBeamsEyeMLCPoints(ReportableRtplanState.BeamRecord beamRecord, float f2, boolean bl2) {
        if (!beamRecord.hasValidMLC()) {
            return null;
        }
        Collimator.MultiLeafCollimator multiLeafCollimator = beamRecord.getFirstMLC();
        Collimator.CollimatorJaws collimatorJaws = beamRecord.getXJaws();
        Collimator.CollimatorJaws collimatorJaws2 = beamRecord.getYJaws();
        return DicomRTplanReader.getBeamsEyeMLCPoints(beamRecord, collimatorJaws.getTimePointByMeterset(f2), collimatorJaws2.getTimePointByMeterset(f2), multiLeafCollimator.getTimePointByMeterset(f2), bl2);
    }

    private static BeamsEyeMLCPoints getBeamsEyeMLCPoints(ReportableRtplanState.BeamRecord beamRecord, Collimator.CollimatorTimepoint collimatorTimepoint, Collimator.CollimatorTimepoint collimatorTimepoint2, Collimator.CollimatorTimepoint collimatorTimepoint3, boolean bl2) {
        Collimator.MultiLeafCollimator multiLeafCollimator = beamRecord.getFirstMLC();
        if (multiLeafCollimator == null || multiLeafCollimator.getLeafOrientation() == null) {
            return null;
        }
        BeamsEyeMLCPoints beamsEyeMLCPoints = new BeamsEyeMLCPoints();
        Vector3f[] vector3fArray = beamRecord.getCollimatorAxes();
        float[] fArray = collimatorTimepoint3.getLeafJawPositions();
        float[] fArray2 = multiLeafCollimator.getLeafBoundaries();
        float f2 = multiLeafCollimator.getSourceToCollimatorDistance().getValue() / beamRecord.getSourceAxisDistance().getValue();
        int n2 = 0;
        while (n2 < fArray2.length) {
            int n3 = n2++;
            fArray2[n3] = fArray2[n3] * f2;
        }
        n2 = 0;
        while (n2 < fArray.length) {
            int n4 = n2++;
            fArray[n4] = fArray[n4] * f2;
        }
        n2 = multiLeafCollimator.getLeafOrientation() == Collimator.LeafOrientation.X ? 0 : 1;
        Vector3f vector3f = new Vector3f(vector3fArray[n2]);
        Vector3f vector3f2 = new Vector3f(vector3fArray[n2]);
        float[] fArray3 = MathUtils.f(n2 == 0 ? collimatorTimepoint.getLeafJawPositions() : collimatorTimepoint2.getLeafJawPositions(), f2);
        float[] fArray4 = MathUtils.f(n2 == 0 ? collimatorTimepoint2.getLeafJawPositions() : collimatorTimepoint.getLeafJawPositions(), f2);
        vector3f.scale(fArray3[0]);
        vector3f2.scale(fArray3[1]);
        DicomPoint3f dicomPoint3f = null;
        DicomPoint3f dicomPoint3f2 = null;
        int n5 = fArray2.length - 1;
        for (int i2 = 0; i2 < n5; ++i2) {
            Vector3f vector3f3 = new Vector3f(vector3fArray[n2]);
            Vector3f vector3f4 = new Vector3f(vector3fArray[n2]);
            float f3 = fArray[i2];
            float f4 = fArray[i2 + n5];
            if (bl2) {
                f3 = MathUtils.b(f3, fArray3[0], fArray3[1]);
                f4 = MathUtils.b(f4, fArray3[0], fArray3[1]);
            }
            vector3f3.scale(f3);
            vector3f4.scale(f4);
            DicomPoint3f dicomPoint3f3 = beamRecord.getCollimatorPosition();
            dicomPoint3f3.add((Tuple3f)vector3f3);
            DicomPoint3f dicomPoint3f4 = beamRecord.getCollimatorPosition();
            dicomPoint3f4.add((Tuple3f)vector3f4);
            DicomPoint3f dicomPoint3f5 = null;
            DicomPoint3f dicomPoint3f6 = null;
            if (!bl2 || fArray2[i2] <= fArray4[1] && fArray2[i2 + 1] >= fArray4[0]) {
                for (int i3 = 0; i3 < 2; ++i3) {
                    Vector3f vector3f5 = new Vector3f(vector3fArray[1 - n2]);
                    float f5 = fArray2[i2 + i3];
                    if (bl2) {
                        if (f5 < fArray4[0]) {
                            f5 = fArray4[0];
                        } else if (f5 > fArray4[1]) {
                            f5 = fArray4[1];
                        }
                    }
                    vector3f5.scale(f5);
                    dicomPoint3f6 = dicomPoint3f3.a();
                    dicomPoint3f5 = dicomPoint3f4.a();
                    dicomPoint3f6.add((Tuple3f)vector3f5);
                    dicomPoint3f5.add((Tuple3f)vector3f5);
                    if (i2 == 0 && i3 == 0 && !bl2) {
                        dicomPoint3f2 = dicomPoint3f6.a();
                        dicomPoint3f2.sub((Tuple3f)vector3f3);
                        dicomPoint3f2.add((Tuple3f)vector3f);
                        beamsEyeMLCPoints.leafPts.add(dicomPoint3f2.a());
                        dicomPoint3f = dicomPoint3f5.a();
                        dicomPoint3f.sub((Tuple3f)vector3f4);
                        dicomPoint3f.add((Tuple3f)vector3f2);
                        beamsEyeMLCPoints.leafPts.add(dicomPoint3f.a());
                    }
                    beamsEyeMLCPoints.leafPts.add(dicomPoint3f6.a());
                    beamsEyeMLCPoints.leafPts.add(dicomPoint3f5.a());
                }
                beamsEyeMLCPoints.boundaryPts.add(dicomPoint3f6.a());
                dicomPoint3f6.sub((Tuple3f)vector3f3);
                dicomPoint3f6.add((Tuple3f)vector3f);
                beamsEyeMLCPoints.boundaryPts.add(dicomPoint3f6.a());
                beamsEyeMLCPoints.boundaryPts.add(dicomPoint3f5.a());
                dicomPoint3f5.sub((Tuple3f)vector3f4);
                dicomPoint3f5.add((Tuple3f)vector3f2);
                beamsEyeMLCPoints.boundaryPts.add(dicomPoint3f5.a());
            }
            if (i2 != n5 - 1 || bl2) continue;
            beamsEyeMLCPoints.leafPts.add(dicomPoint3f6);
            beamsEyeMLCPoints.leafPts.add(dicomPoint3f5);
            beamsEyeMLCPoints.leafPts.add(dicomPoint3f2);
            beamsEyeMLCPoints.leafPts.add(dicomPoint3f);
        }
        return beamsEyeMLCPoints;
    }

    public static void projectPointsOntoIsocentricPlane(MetricPoint3f[] metricPoint3fArray, DicomBeamRecord dicomBeamRecord) {
        MetricPoint3f metricPoint3f = dicomBeamRecord.getIsocenter().b(metricPoint3fArray[0].i());
        MetricPoint3f metricPoint3f2 = dicomBeamRecord.getSourcePoint().b(metricPoint3fArray[0].i());
        Vector3f vector3f = l.a(metricPoint3f2, (Point3f)metricPoint3f);
        l.b b2 = new l.b(metricPoint3f, vector3f);
        for (MetricPoint3f metricPoint3f3 : metricPoint3fArray) {
            l.a a2 = l.a.a((Point3f)metricPoint3f2, metricPoint3f3);
            Point3f point3f = a2.a(b2);
            metricPoint3f3.set((Tuple3f)point3f);
        }
    }

    private static /* synthetic */ void lambda$createPlanReviewElements$2(Session session, Capture capture) {
        CaptureStorage.a(session, capture);
    }

    public static class BeamsEyeMLCPoints {
        public List<DicomPoint3f> leafPts = Lists.newArrayList();
        public List<DicomPoint3f> boundaryPts = Lists.newArrayList();

        public MetricPoint3f[] getLeafMetricPointsArray(Point3f.PointVolumeInfo pointVolumeInfo) {
            return this.getMetricPointsArray(this.leafPts, pointVolumeInfo);
        }

        public MetricPoint3f[] getBoundaryMetricPointsArray(Point3f.PointVolumeInfo pointVolumeInfo) {
            return this.getMetricPointsArray(this.boundaryPts, pointVolumeInfo);
        }

        private MetricPoint3f[] getMetricPointsArray(List<DicomPoint3f> list, Point3f.PointVolumeInfo pointVolumeInfo) {
            MetricPoint3f[] metricPoint3fArray = new MetricPoint3f[list.size()];
            int n2 = 0;
            for (DicomPoint3f dicomPoint3f : list) {
                metricPoint3fArray[n2++] = dicomPoint3f.b(pointVolumeInfo);
            }
            return metricPoint3fArray;
        }
    }
}

